/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.curseapi.file;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.therandomlabs.curseapi.CurseAPI;
import com.therandomlabs.curseapi.CurseException;
import com.therandomlabs.curseapi.CursePreconditions;
import com.therandomlabs.curseapi.file.CurseFile;
import com.therandomlabs.curseapi.project.CurseProject;
import okhttp3.HttpUrl;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class BasicCurseFile
implements Comparable<BasicCurseFile> {
    public final int hashCode() {
        return this.id();
    }

    public final boolean equals(Object object) {
        return this == object || object instanceof BasicCurseFile && this.id() == ((BasicCurseFile)object).id();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("projectID", this.projectID()).add("id", this.id()).toString();
    }

    @Override
    public final int compareTo(BasicCurseFile file) {
        return Integer.compare(file.id(), this.id());
    }

    public abstract int projectID();

    public abstract @Nullable CurseProject project() throws CurseException;

    public abstract @Nullable CurseProject refreshProject() throws CurseException;

    public boolean sameProject(BasicCurseFile file) {
        Preconditions.checkNotNull((Object)file, (Object)"file should not be null");
        return this.projectID() == file.projectID();
    }

    public abstract int id();

    public @Nullable HttpUrl url() throws CurseException {
        CurseProject project = this.project();
        return project == null ? null : project.fileURL(this.id());
    }

    public final boolean olderThan(BasicCurseFile file) {
        Preconditions.checkNotNull((Object)file, (Object)"file should not be null");
        return this.olderThan(file.id());
    }

    public final boolean olderThan(int fileID) {
        Preconditions.checkArgument((fileID >= 60017 ? 1 : 0) != 0, (Object)"fileID should not be smaller than 60017");
        return this.id() < fileID;
    }

    public final boolean newerThan(BasicCurseFile file) {
        Preconditions.checkNotNull((Object)file, (Object)"file should not be null");
        return this.newerThan(file.id());
    }

    public final boolean newerThan(int fileID) {
        Preconditions.checkArgument((fileID >= 60017 ? 1 : 0) != 0, (Object)"fileID should not be smaller than 60017");
        return this.id() > fileID;
    }

    public @Nullable CurseFile toCurseFile() throws CurseException {
        return CurseAPI.file(this.projectID(), this.id()).orElse(null);
    }

    public static class Immutable
    extends BasicCurseFile {
        private final int projectID;
        private final int fileID;
        private transient @Nullable CurseProject project;
        private transient boolean projectRetrieved;

        public Immutable(int projectID, int fileID) {
            CursePreconditions.checkProjectID(projectID, "projectID");
            CursePreconditions.checkFileID(fileID, "fileID");
            this.projectID = projectID;
            this.fileID = fileID;
        }

        @Override
        public int projectID() {
            return this.projectID;
        }

        @Override
        public @Nullable CurseProject project() throws CurseException {
            if (!this.projectRetrieved) {
                this.project = CurseAPI.project(this.projectID()).orElse(null);
                this.projectRetrieved = true;
            }
            return this.project;
        }

        @Override
        public @Nullable CurseProject refreshProject() throws CurseException {
            this.projectRetrieved = false;
            return this.project();
        }

        @Override
        public int id() {
            return this.fileID;
        }
    }
}

