/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.soter.wrapper.wrap_task;

import com.tencent.soter.core.SoterCore;
import com.tencent.soter.core.model.SLogger;
import com.tencent.soter.core.model.SoterCoreData;
import com.tencent.soter.core.model.SoterPubKeyModel;
import com.tencent.soter.wrapper.wrap_callback.SoterProcessKeyPreparationResult;
import com.tencent.soter.wrapper.wrap_core.SoterDataCenter;
import com.tencent.soter.wrapper.wrap_core.SoterProcessErrCode;
import com.tencent.soter.wrapper.wrap_key.ISoterKeyGenerateCallback;
import com.tencent.soter.wrapper.wrap_key.SoterKeyGenerateEngine;
import com.tencent.soter.wrapper.wrap_net.ISoterNetCallback;
import com.tencent.soter.wrapper.wrap_net.IWrapUploadKeyNet;
import com.tencent.soter.wrapper.wrap_task.BaseSoterPrepareKeyTask;

public class TaskPrepareAppSecureKey
extends BaseSoterPrepareKeyTask
implements SoterProcessErrCode {
    private static final String TAG = "Soter.TaskPrepareAppSecureKey";
    private IWrapUploadKeyNet mAppSecureKeyNetWrapper = null;
    private boolean mIsAutoDeleteWhenAlreadyGenerated = false;

    public TaskPrepareAppSecureKey(IWrapUploadKeyNet appSecureKeyNetWrapper, boolean isAutoDeleteWhenAlreadyGenerated) {
        this.mAppSecureKeyNetWrapper = appSecureKeyNetWrapper;
        this.mIsAutoDeleteWhenAlreadyGenerated = isAutoDeleteWhenAlreadyGenerated;
    }

    @Override
    boolean preExecute() {
        if (!SoterDataCenter.getInstance().isInit()) {
            SLogger.w((String)TAG, (String)"soter: not initialized yet", (Object[])new Object[0]);
            this.callback(new SoterProcessKeyPreparationResult(14));
            return true;
        }
        if (!SoterDataCenter.getInstance().isSupportSoter()) {
            SLogger.w((String)TAG, (String)"soter: not support soter", (Object[])new Object[0]);
            this.callback(new SoterProcessKeyPreparationResult(2));
            return true;
        }
        if (SoterCore.hasAppGlobalSecureKey() && !this.mIsAutoDeleteWhenAlreadyGenerated) {
            SLogger.i((String)TAG, (String)"soter: already has ask. do not need generate again", (Object[])new Object[0]);
            this.callback(new SoterProcessKeyPreparationResult(0, SoterCore.getAppGlobalSecureKeyModel()));
            return true;
        }
        if (this.mAppSecureKeyNetWrapper == null) {
            SLogger.w((String)TAG, (String)"soter: it is strongly recommended that you provide a net wrapper to check and upload ASK validation from server! Please make sure you upload it later", (Object[])new Object[0]);
        }
        return false;
    }

    @Override
    boolean isSingleInstance() {
        return true;
    }

    @Override
    void onRemovedFromTaskPoolActively() {
        SLogger.w((String)TAG, (String)"soter: cancelled prepare ask", (Object[])new Object[0]);
        SoterCore.removeAppGlobalSecureKey();
    }

    @Override
    void execute() {
        this.markKeyStatus(SoterCoreData.getInstance().getAskName(), 1);
        SoterKeyGenerateEngine.SoterKeyGenerateEngineBuilder builder = new SoterKeyGenerateEngine.SoterKeyGenerateEngineBuilder().markGenAppSecureKey(this.mIsAutoDeleteWhenAlreadyGenerated).setKeyGenCallback(new ISoterKeyGenerateCallback(){

            @Override
            public void onError(int errorCode, String errMsg) {
                SLogger.w((String)TaskPrepareAppSecureKey.TAG, (String)"soter: app secure key generate failed. errcode: %d, errmsg: %s", (Object[])new Object[]{errorCode, errMsg});
                TaskPrepareAppSecureKey.this.markKeyStatus(SoterCoreData.getInstance().getAskName(), 0);
                TaskPrepareAppSecureKey.this.callback(new SoterProcessKeyPreparationResult(errorCode, errMsg));
            }

            @Override
            public void onSuccess() {
                SLogger.i((String)TaskPrepareAppSecureKey.TAG, (String)"soter: app secure key generate successfully. start upload ask", (Object[])new Object[0]);
                if (TaskPrepareAppSecureKey.this.mAppSecureKeyNetWrapper != null) {
                    TaskPrepareAppSecureKey.this.markKeyStatus(SoterCoreData.getInstance().getAskName(), 2);
                } else {
                    TaskPrepareAppSecureKey.this.markKeyStatus(SoterCoreData.getInstance().getAskName(), 0);
                }
                TaskPrepareAppSecureKey.this.startUploadASKAfterGenerate();
            }
        });
        builder.build().generate();
    }

    private void startUploadASKAfterGenerate() {
        final SoterPubKeyModel askModel = SoterCore.getAppGlobalSecureKeyModel();
        if (askModel == null) {
            SLogger.e((String)TAG, (String)"soter: ask model is null even after generation. fatal error", (Object[])new Object[0]);
            SoterCore.removeAppGlobalSecureKey();
            this.callback(new SoterProcessKeyPreparationResult(3, "ask model is null even after generation."));
            return;
        }
        if (this.mAppSecureKeyNetWrapper != null) {
            this.mAppSecureKeyNetWrapper.setRequest(new IWrapUploadKeyNet.UploadRequest(askModel.getSignature(), askModel.getRawJson()));
            this.mAppSecureKeyNetWrapper.setCallback(new ISoterNetCallback<IWrapUploadKeyNet.UploadResult>(){

                @Override
                public void onNetEnd(IWrapUploadKeyNet.UploadResult callbackDataModel) {
                    TaskPrepareAppSecureKey.this.markKeyStatus(SoterCoreData.getInstance().getAskName(), 0);
                    boolean isUploadAndVerified = callbackDataModel.mIsUploadAndVerifiedSuccess;
                    SLogger.i((String)TaskPrepareAppSecureKey.TAG, (String)"soter: ask upload result: %b", (Object[])new Object[]{isUploadAndVerified});
                    if (isUploadAndVerified) {
                        TaskPrepareAppSecureKey.this.callback(new SoterProcessKeyPreparationResult(0, askModel));
                    } else {
                        SoterCore.removeAppGlobalSecureKey();
                        TaskPrepareAppSecureKey.this.callback(new SoterProcessKeyPreparationResult(9, "upload app secure key failed"));
                    }
                }
            });
            this.mAppSecureKeyNetWrapper.execute();
        } else {
            SLogger.d((String)TAG, (String)"soter: not provide network wrapper instance. please check if it is what you want. we treat it as normal", (Object[])new Object[0]);
            this.callback(new SoterProcessKeyPreparationResult(0, "treat as normal because you do not provide the net wrapper", askModel));
        }
    }
}

