/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.soter.wrapper;

import android.content.Context;
import android.support.annotation.NonNull;
import com.tencent.soter.core.SoterCore;
import com.tencent.soter.core.model.SLogger;
import com.tencent.soter.core.model.SoterCoreResult;
import com.tencent.soter.core.model.SoterCoreUtil;
import com.tencent.soter.wrapper.wrap_callback.SoterProcessAuthenticationResult;
import com.tencent.soter.wrapper.wrap_callback.SoterProcessCallback;
import com.tencent.soter.wrapper.wrap_callback.SoterProcessKeyPreparationResult;
import com.tencent.soter.wrapper.wrap_callback.SoterProcessNoExtResult;
import com.tencent.soter.wrapper.wrap_core.SoterDataCenter;
import com.tencent.soter.wrapper.wrap_core.SoterProcessErrCode;
import com.tencent.soter.wrapper.wrap_net.IWrapUploadKeyNet;
import com.tencent.soter.wrapper.wrap_task.AuthenticationParam;
import com.tencent.soter.wrapper.wrap_task.InitializeParam;
import com.tencent.soter.wrapper.wrap_task.SoterTaskManager;
import com.tencent.soter.wrapper.wrap_task.TaskAuthentication;
import com.tencent.soter.wrapper.wrap_task.TaskInit;
import com.tencent.soter.wrapper.wrap_task.TaskPrepareAppSecureKey;
import com.tencent.soter.wrapper.wrap_task.TaskPrepareAuthKey;

public class SoterWrapperApi
implements SoterProcessErrCode {
    private static final String TAG = "Soter.SoterWrapperApi";

    public static void init(Context context, SoterProcessCallback<SoterProcessNoExtResult> callback, @NonNull InitializeParam param) {
        TaskInit taskInit = new TaskInit(context, param);
        taskInit.setTaskCallback(callback);
        if (!SoterTaskManager.getInstance().addToTask(taskInit, new SoterProcessNoExtResult())) {
            SLogger.e((String)TAG, (String)"soter: add init task failed.", (Object[])new Object[0]);
        }
    }

    public static void prepareAppSecureKey(SoterProcessCallback<SoterProcessKeyPreparationResult> callback, boolean isAutoDeleteIfAlreadyExists, IWrapUploadKeyNet appSecureKeyNetWrapper) {
        SLogger.i((String)TAG, (String)"soter: starting prepare ask key. ", (Object[])new Object[0]);
        TaskPrepareAppSecureKey taskPrepareAppSecureKey = new TaskPrepareAppSecureKey(appSecureKeyNetWrapper, isAutoDeleteIfAlreadyExists);
        taskPrepareAppSecureKey.setTaskCallback(callback);
        if (!SoterTaskManager.getInstance().addToTask(taskPrepareAppSecureKey, new SoterProcessKeyPreparationResult())) {
            SLogger.d((String)TAG, (String)"soter: add prepareAppSecureKey task failed.", (Object[])new Object[0]);
        }
    }

    public static void prepareAuthKey(SoterProcessCallback<SoterProcessKeyPreparationResult> callback, boolean isAutoDeleteIfAlreadyExists, boolean isAutoPrepareASKWhenNotFound, int scene, IWrapUploadKeyNet authKeyNetWrapper, IWrapUploadKeyNet appSecureKeyNetWrapper) {
        SLogger.i((String)TAG, (String)"soter: starting prepare auth key: %d", (Object[])new Object[]{scene});
        TaskPrepareAuthKey taskPrepareAuthKey = new TaskPrepareAuthKey(scene, authKeyNetWrapper, appSecureKeyNetWrapper, isAutoDeleteIfAlreadyExists, isAutoPrepareASKWhenNotFound);
        taskPrepareAuthKey.setTaskCallback(callback);
        if (!SoterTaskManager.getInstance().addToTask(taskPrepareAuthKey, new SoterProcessKeyPreparationResult())) {
            SLogger.d((String)TAG, (String)"soter: add prepareAuthKey task failed.", (Object[])new Object[0]);
        }
    }

    public static void requestAuthorizeAndSign(SoterProcessCallback<SoterProcessAuthenticationResult> callback, @NonNull AuthenticationParam param) {
        SLogger.i((String)TAG, (String)"soter: request authorize provide challenge. scene: %d", (Object[])new Object[]{param.getScene()});
        TaskAuthentication taskAuthentication = new TaskAuthentication(param);
        taskAuthentication.setTaskCallback(callback);
        if (!SoterTaskManager.getInstance().addToTask(taskAuthentication, new SoterProcessAuthenticationResult())) {
            SLogger.d((String)TAG, (String)"soter: add requestAuthorizeAndSign task failed.", (Object[])new Object[0]);
        }
    }

    public static boolean isSupportSoter() {
        return SoterDataCenter.getInstance().isInit() && SoterDataCenter.getInstance().isSupportSoter();
    }

    public static boolean isInitialized() {
        return SoterDataCenter.getInstance().isInit();
    }

    public static boolean removeAuthKeyByScene(int scene) {
        boolean isInit = SoterDataCenter.getInstance().isInit();
        String authKeyName = (String)SoterDataCenter.getInstance().getAuthKeyNames().get(scene);
        if (isInit && !SoterCoreUtil.isNullOrNil((String)authKeyName)) {
            SoterCoreResult result = SoterCore.removeAuthKey((String)authKeyName, (boolean)false);
            return result.errCode == 0;
        }
        if (!isInit) {
            SLogger.w((String)TAG, (String)"soter: not initialized yet", (Object[])new Object[0]);
            return false;
        }
        SLogger.w((String)TAG, (String)"soter: scene not registered in init. please make sure", (Object[])new Object[0]);
        return false;
    }

    public static void tryStopAllSoterTask() {
        SoterTaskManager.getInstance().cancelAllTask();
    }

    public static void release() {
        SoterWrapperApi.tryStopAllSoterTask();
        SoterDataCenter.getInstance().clearStatus();
    }
}

