/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.soter.wrapper.wrap_task;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import com.tencent.soter.core.SoterCore;
import com.tencent.soter.core.biometric.BiometricManagerCompat;
import com.tencent.soter.core.model.SLogger;
import com.tencent.soter.core.model.SReporter;
import com.tencent.soter.core.model.SoterCoreUtil;
import com.tencent.soter.core.model.SoterSignatureResult;
import com.tencent.soter.soterserver.SoterSessionResult;
import com.tencent.soter.wrapper.SoterWrapperApi;
import com.tencent.soter.wrapper.wrap_biometric.SoterBiometricCanceller;
import com.tencent.soter.wrapper.wrap_biometric.SoterBiometricStateCallback;
import com.tencent.soter.wrapper.wrap_callback.SoterProcessAuthenticationResult;
import com.tencent.soter.wrapper.wrap_callback.SoterProcessResultBase;
import com.tencent.soter.wrapper.wrap_core.RemoveASKStrategy;
import com.tencent.soter.wrapper.wrap_core.SoterDataCenter;
import com.tencent.soter.wrapper.wrap_net.ISoterNetCallback;
import com.tencent.soter.wrapper.wrap_net.IWrapGetChallengeStr;
import com.tencent.soter.wrapper.wrap_net.IWrapUploadSignature;
import com.tencent.soter.wrapper.wrap_task.AuthCancellationCallable;
import com.tencent.soter.wrapper.wrap_task.AuthenticationParam;
import com.tencent.soter.wrapper.wrap_task.BaseSoterTask;
import com.tencent.soter.wrapper.wrap_task.SoterTaskThread;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.security.Signature;
import java.security.SignatureException;

public class TaskBiometricAuthentication
extends BaseSoterTask
implements AuthCancellationCallable {
    private static final String TAG = "Soter.TaskBiometricAuthentication";
    private int mScene = -1;
    private String mAuthKeyName = null;
    private String mChallenge = null;
    private IWrapGetChallengeStr mGetChallengeStrWrapper = null;
    private IWrapUploadSignature mUploadSignatureWrapper = null;
    private int mBiometricType;
    private WeakReference<Context> mContextWeakReference = null;
    private SoterBiometricCanceller mBiometricCancelSignal = null;
    private SoterBiometricStateCallback mBiometricStateCallback = null;
    private String mPromptTitle;
    private String mPromptSubTitle;
    private String mPromptDescription;
    private String mPromptButton;
    private boolean mUseBiometricPrompt;
    private SoterSignatureResult mFinalResult = null;
    private AuthenticationCallbackImpl mAuthenticationCallbackIml = null;
    private boolean mShouldOperateCompatWhenHint = Build.VERSION.SDK_INT < 23 && Build.MANUFACTURER.equalsIgnoreCase("vivo");
    private boolean mShouldOperateCompatWhenDone = Build.VERSION.SDK_INT < 23;
    private boolean mIsAuthenticationAlreadyCancelled = false;

    public TaskBiometricAuthentication(AuthenticationParam param) {
        if (param == null) {
            throw new IllegalArgumentException("param is null!");
        }
        this.mScene = param.getScene();
        this.mGetChallengeStrWrapper = param.getIWrapGetChallengeStr();
        this.mUploadSignatureWrapper = param.getIWrapUploadSignature();
        this.mContextWeakReference = new WeakReference<Context>(param.getContext());
        this.mBiometricStateCallback = param.getSoterBiometricStateCallback();
        this.mBiometricCancelSignal = param.getSoterBiometricCanceller();
        this.mBiometricType = param.getBiometricType();
        this.mChallenge = param.getChallenge();
        this.mPromptTitle = param.getPromptTitle();
        this.mPromptSubTitle = param.getPromptSubTitle();
        this.mPromptDescription = param.getPromptDescription();
        this.mPromptButton = param.getPromptButton();
        this.mUseBiometricPrompt = param.getUseBiometricPrompt();
    }

    @Override
    @SuppressLint(value={"DefaultLocale", "NewApi"})
    boolean preExecute() {
        if (!SoterDataCenter.getInstance().isInit()) {
            SLogger.w((String)TAG, (String)"soter: not initialized yet", (Object[])new Object[0]);
            this.callback(new SoterProcessAuthenticationResult(1008));
            return true;
        }
        if (!SoterDataCenter.getInstance().isSupportSoter()) {
            SLogger.w((String)TAG, (String)"soter: not support soter", (Object[])new Object[0]);
            this.callback(new SoterProcessAuthenticationResult(2));
            return true;
        }
        if (Build.VERSION.SDK_INT < 16) {
            this.callback(new SoterProcessAuthenticationResult(2));
            return true;
        }
        this.mAuthKeyName = (String)SoterDataCenter.getInstance().getAuthKeyNames().get(this.mScene, (Object)"");
        if (SoterCoreUtil.isNullOrNil((String)this.mAuthKeyName)) {
            SLogger.w((String)TAG, (String)"soter: request prepare auth key scene: %d, but key name is not registered. Please make sure you register the scene in init", (Object[])new Object[0]);
            this.callback(new SoterProcessAuthenticationResult(1009, String.format("auth scene %d not initialized in map", this.mScene)));
            return true;
        }
        if (!SoterCore.hasAuthKey((String)this.mAuthKeyName)) {
            SLogger.w((String)TAG, (String)"soter: auth key %s not exists. need re-generate", (Object[])new Object[]{this.mAuthKeyName});
            this.callback(new SoterProcessAuthenticationResult(1006, String.format("the auth key to scene %d not exists. it may because you haven't prepare it, or user removed them already in system settings. please prepare the key again", this.mScene)));
            return true;
        }
        if (this.mGetChallengeStrWrapper == null && SoterCoreUtil.isNullOrNil((String)this.mChallenge)) {
            SLogger.w((String)TAG, (String)"soter: challenge wrapper is null!", (Object[])new Object[0]);
            this.callback(new SoterProcessAuthenticationResult(1010, "neither get challenge wrapper nor challenge str is found in request parameter"));
            return true;
        }
        Context context = (Context)this.mContextWeakReference.get();
        if (context == null) {
            SLogger.w((String)TAG, (String)"soter: context instance released in preExecute", (Object[])new Object[0]);
            this.callback(new SoterProcessAuthenticationResult(1011));
            return true;
        }
        boolean hasBiometric = BiometricManagerCompat.from((Context)context, (Integer)this.mBiometricType).hasEnrolledBiometric();
        if (!hasBiometric) {
            SLogger.w((String)TAG, (String)"soter: user has not enrolled any biometric in system.", (Object[])new Object[0]);
            this.callback(new SoterProcessAuthenticationResult(1013));
            return true;
        }
        if (SoterCore.isCurrentBiometricFrozen((Context)context, (int)this.mBiometricType)) {
            SLogger.w((String)TAG, (String)"soter: biometric sensor frozen", (Object[])new Object[0]);
            this.callback(new SoterProcessAuthenticationResult(1021, "Too many failed times"));
            return true;
        }
        if (this.mBiometricCancelSignal == null) {
            SLogger.w((String)TAG, (String)"soter: did not pass cancellation obj. We suggest you pass one", (Object[])new Object[0]);
            this.mBiometricCancelSignal = new SoterBiometricCanceller();
            return false;
        }
        if (this.mUploadSignatureWrapper == null) {
            SLogger.w((String)TAG, (String)"hy: we strongly recommend you to check the final authentication data in server! Please make sure you upload and check later", (Object[])new Object[0]);
        }
        return false;
    }

    @Override
    boolean isSingleInstance() {
        return true;
    }

    @Override
    @RequiresApi(api=16)
    void onRemovedFromTaskPoolActively() {
        if (this.mBiometricCancelSignal != null) {
            this.mBiometricCancelSignal.asyncCancelBiometricAuthentication();
        }
    }

    @Override
    @RequiresApi(api=16)
    void execute() {
        if (SoterCoreUtil.isNullOrNil((String)this.mChallenge)) {
            SLogger.i((String)TAG, (String)"soter: not provide the challenge. we will do the job", (Object[])new Object[0]);
            this.mGetChallengeStrWrapper.setRequest(new IWrapGetChallengeStr.GetChallengeRequest());
            this.mGetChallengeStrWrapper.setCallback(new ISoterNetCallback<IWrapGetChallengeStr.GetChallengeResult>(){

                @Override
                public void onNetEnd(IWrapGetChallengeStr.GetChallengeResult callbackDataModel) {
                    if (callbackDataModel != null && !SoterCoreUtil.isNullOrNil((String)callbackDataModel.challenge)) {
                        TaskBiometricAuthentication.this.mChallenge = callbackDataModel.challenge;
                        TaskBiometricAuthentication.this.startAuthenticate();
                    } else {
                        SLogger.w((String)TaskBiometricAuthentication.TAG, (String)"soter: get challenge failed", (Object[])new Object[0]);
                        TaskBiometricAuthentication.this.callback(new SoterProcessAuthenticationResult(1014));
                    }
                }
            });
            this.mGetChallengeStrWrapper.execute();
        } else {
            SLogger.i((String)TAG, (String)"soter: already provided the challenge. directly authenticate", (Object[])new Object[0]);
            this.startAuthenticate();
        }
    }

    @Override
    void onExecuteCallback(SoterProcessResultBase result) {
        if ((result.getErrCode() == 1018 || result.getErrCode() == 1007 || result.getErrCode() == 1015) && RemoveASKStrategy.shouldRemoveAllKey(this.getClass(), result)) {
            SLogger.i((String)TAG, (String)"soter: same error happen too much, delete ask", (Object[])new Object[0]);
            SoterWrapperApi.clearAllKey();
        }
    }

    @RequiresApi(api=16)
    private void startAuthenticate() {
        if (SoterCore.getSoterCoreType() == 1) {
            SoterSessionResult soterSessionResult = SoterCore.initSigh((String)this.mAuthKeyName, (String)this.mChallenge);
            if (soterSessionResult == null) {
                SLogger.w((String)TAG, (String)"soter: error occurred when init sign soterSessionResult is null", (Object[])new Object[0]);
                this.callback(new SoterProcessAuthenticationResult(1007));
                return;
            }
            if (soterSessionResult.resultCode != 0) {
                SLogger.w((String)TAG, (String)"soter: error occurred when init sign resultCode error", (Object[])new Object[0]);
                this.callback(new SoterProcessAuthenticationResult(1007));
                return;
            }
            SLogger.d((String)TAG, (String)"soter: session is %d", (Object[])new Object[]{soterSessionResult.session});
            this.mAuthenticationCallbackIml = new AuthenticationCallbackImpl(null);
            this.mAuthenticationCallbackIml.session = soterSessionResult.session;
            this.performStartBiometricLogic(null);
            SoterTaskThread.getInstance().postToMainThread(new Runnable(){

                @Override
                public void run() {
                    if (TaskBiometricAuthentication.this.mBiometricStateCallback != null) {
                        TaskBiometricAuthentication.this.mBiometricStateCallback.onStartAuthentication();
                    }
                }
            });
        } else {
            Signature signatureToAuth = SoterCore.getAuthInitAndSign((String)this.mAuthKeyName);
            if (signatureToAuth == null) {
                SLogger.w((String)TAG, (String)"soter: error occurred when init sign", (Object[])new Object[0]);
                this.callback(new SoterProcessAuthenticationResult(1007));
                return;
            }
            this.mAuthenticationCallbackIml = new AuthenticationCallbackImpl(signatureToAuth);
            this.performStartBiometricLogic(signatureToAuth);
            SoterTaskThread.getInstance().postToMainThread(new Runnable(){

                @Override
                public void run() {
                    if (TaskBiometricAuthentication.this.mBiometricStateCallback != null) {
                        TaskBiometricAuthentication.this.mBiometricStateCallback.onStartAuthentication();
                    }
                }
            });
        }
    }

    @SuppressLint(value={"NewApi"})
    private void performStartBiometricLogic(Signature signatureToAuth) {
        if (this.isFinished()) {
            SLogger.w((String)TAG, (String)"soter: already finished. can not authenticate", (Object[])new Object[0]);
            return;
        }
        Context context = (Context)this.mContextWeakReference.get();
        if (context == null) {
            SLogger.w((String)TAG, (String)"soter: context instance released in startAuthenticate", (Object[])new Object[0]);
            this.callback(new SoterProcessAuthenticationResult(1011));
            return;
        }
        try {
            SLogger.v((String)TAG, (String)"soter: performing start", (Object[])new Object[0]);
            Bundle extra = new Bundle();
            extra.putString("prompt_title", this.mPromptTitle);
            extra.putString("prompt_subtitle", this.mPromptSubTitle);
            extra.putString("prompt_description", this.mPromptDescription);
            extra.putString("prompt_button", this.mPromptButton);
            extra.putBoolean("use_biometric_prompt", this.mUseBiometricPrompt);
            BiometricManagerCompat.from((Context)context, (Integer)this.mBiometricType).authenticate(new BiometricManagerCompat.CryptoObject(signatureToAuth), 0, this.mBiometricCancelSignal != null ? this.mBiometricCancelSignal.getSignalObj() : null, (BiometricManagerCompat.AuthenticationCallback)this.mAuthenticationCallbackIml, null, extra);
        }
        catch (Exception e) {
            String cause = e.getMessage();
            SLogger.e((String)TAG, (String)"soter: caused exception when authenticating: %s", (Object[])new Object[]{cause});
            SLogger.printErrStackTrace((String)TAG, (Throwable)e, (String)"soter: caused exception when authenticating");
            SReporter.reportError((int)200, (String)"TaskBiometric, start authentication failed: performStartBiometricLogic().", (Exception)e);
            this.callback(new SoterProcessAuthenticationResult(1015, String.format("start authentication failed due to %s", cause)));
        }
    }

    private void executeWhenAuthenticatedWithSession(@NonNull Signature signature, long session) {
        try {
            byte[] rawResult = SoterCore.finishSign((long)session);
            this.mFinalResult = SoterCore.convertFromBytesToSignatureResult((byte[])rawResult);
            if (this.mUploadSignatureWrapper != null) {
                this.uploadSignature();
            } else {
                SLogger.i((String)TAG, (String)"soter: no upload wrapper, return directly", (Object[])new Object[0]);
                this.callback(new SoterProcessAuthenticationResult(0, this.mFinalResult));
            }
        }
        catch (Exception e) {
            SLogger.e((String)TAG, (String)"soter: finish sign failed due to exception: %s", (Object[])new Object[]{e.getMessage()});
            SLogger.printErrStackTrace((String)TAG, (Throwable)e, (String)"soter: sign failed due to exception");
            SReporter.reportError((int)200, (String)"TaskBiometric, sign failed: executeWhenAuthenticatedWithSession().", (Exception)e);
            this.callback(new SoterProcessAuthenticationResult(1018, "sign failed even after user authenticated the key."));
        }
    }

    private void executeWhenAuthenticated(@NonNull Signature signature) {
        try {
            this.mFinalResult = SoterCore.convertFromBytesToSignatureResult((byte[])signature.sign());
            if (this.mUploadSignatureWrapper != null) {
                this.uploadSignature();
            } else {
                SLogger.i((String)TAG, (String)"soter: no upload wrapper, return directly", (Object[])new Object[0]);
                this.callback(new SoterProcessAuthenticationResult(0, this.mFinalResult));
            }
        }
        catch (SignatureException e) {
            SLogger.e((String)TAG, (String)"soter: sign failed due to exception: %s", (Object[])new Object[]{e.getMessage()});
            SLogger.printErrStackTrace((String)TAG, (Throwable)e, (String)"soter: sign failed due to exception");
            SReporter.reportError((int)200, (String)"TaskBiometric, sign failed: executeWhenAuthenticated().", (Exception)e);
            this.callback(new SoterProcessAuthenticationResult(1018, "sign failed even after user authenticated the key."));
        }
    }

    private void uploadSignature() {
        if (this.mFinalResult == null) {
            this.callback(new SoterProcessAuthenticationResult(1018, "sign failed even after user authenticated the key."));
            return;
        }
        this.mUploadSignatureWrapper.setRequest(new IWrapUploadSignature.UploadSignatureRequest(this.mFinalResult.getSignature(), this.mFinalResult.getJsonValue(), this.mFinalResult.getSaltLen()));
        this.mUploadSignatureWrapper.setCallback(new ISoterNetCallback<IWrapUploadSignature.UploadSignatureResult>(){

            @Override
            public void onNetEnd(IWrapUploadSignature.UploadSignatureResult callbackDataModel) {
                if (callbackDataModel != null && callbackDataModel.isVerified) {
                    SLogger.i((String)TaskBiometricAuthentication.TAG, (String)"soter: upload and verify succeed", (Object[])new Object[0]);
                    TaskBiometricAuthentication.this.callback(new SoterProcessAuthenticationResult(0, TaskBiometricAuthentication.this.mFinalResult));
                } else {
                    SLogger.w((String)TaskBiometricAuthentication.TAG, (String)"soter: upload or verify failed", (Object[])new Object[0]);
                    TaskBiometricAuthentication.this.callback(new SoterProcessAuthenticationResult(1019));
                }
            }
        });
        this.mUploadSignatureWrapper.execute();
    }

    @Override
    public void callCancellationInternal() {
        SLogger.i((String)TAG, (String)"soter: called from cancellation signal", (Object[])new Object[0]);
        if (this.mAuthenticationCallbackIml != null) {
            this.mAuthenticationCallbackIml.onAuthenticationCancelled();
        }
    }

    @Override
    public boolean isCancelled() {
        return this.mIsAuthenticationAlreadyCancelled;
    }

    private class AuthenticationCallbackImpl
    extends BiometricManagerCompat.AuthenticationCallback {
        private Signature mSignatureToAuth = null;
        private static final long MAGIC_CANCELLATION_WAIT = 1000L;
        private long session;

        private AuthenticationCallbackImpl(Signature signature) {
            this.mSignatureToAuth = signature;
        }

        private String charSequenceToStringNullAsNil(CharSequence sequence) {
            return sequence == null ? "unknown error" : sequence.toString();
        }

        public void onAuthenticationError(final int errMsgId, final CharSequence errString) {
            SLogger.e((String)TaskBiometricAuthentication.TAG, (String)"soter: on authentication fatal error: %d, %s", (Object[])new Object[]{errMsgId, errString});
            SoterTaskThread.getInstance().postToMainThread(new Runnable(){

                @Override
                public void run() {
                    if (TaskBiometricAuthentication.this.mBiometricStateCallback != null) {
                        TaskBiometricAuthentication.this.mBiometricStateCallback.onAuthenticationError(errMsgId, errString);
                    }
                }
            });
            if (errMsgId == 10308) {
                TaskBiometricAuthentication.this.callback(new SoterProcessAuthenticationResult(1022, this.charSequenceToStringNullAsNil(errString)));
            } else if (errMsgId == 10309) {
                TaskBiometricAuthentication.this.callback(new SoterProcessAuthenticationResult(1022, this.charSequenceToStringNullAsNil(errString)));
            } else if (errMsgId == 10310) {
                TaskBiometricAuthentication.this.callback(new SoterProcessAuthenticationResult(1029, this.charSequenceToStringNullAsNil(errString)));
            } else {
                TaskBiometricAuthentication.this.callback(new SoterProcessAuthenticationResult(1017, this.charSequenceToStringNullAsNil(errString)));
            }
            this.authenticationShouldComplete();
            SReporter.reportError((int)401, (String)("on authentication fatal error: " + errMsgId + " " + errString));
        }

        public void onAuthenticationHelp(final int helpMsgId, final CharSequence helpString) {
            SLogger.w((String)TaskBiometricAuthentication.TAG, (String)"soter: on authentication help. you do not need to cancel the authentication: %d, %s", (Object[])new Object[]{helpMsgId, helpString});
            SoterTaskThread.getInstance().postToMainThread(new Runnable(){

                @Override
                public void run() {
                    if (TaskBiometricAuthentication.this.mBiometricStateCallback != null) {
                        TaskBiometricAuthentication.this.mBiometricStateCallback.onAuthenticationHelp(helpMsgId, AuthenticationCallbackImpl.this.charSequenceToStringNullAsNil(helpString));
                    }
                }
            });
        }

        public void onAuthenticationSucceeded(BiometricManagerCompat.AuthenticationResult result) {
            SLogger.i((String)TaskBiometricAuthentication.TAG, (String)"soter: authentication succeed. start sign and upload upload signature", (Object[])new Object[0]);
            SoterTaskThread.getInstance().postToMainThread(new Runnable(){

                @Override
                public void run() {
                    if (TaskBiometricAuthentication.this.mBiometricStateCallback != null) {
                        TaskBiometricAuthentication.this.mBiometricStateCallback.onAuthenticationSucceed();
                    }
                }
            });
            SoterTaskThread.getInstance().postToWorker(new Runnable(){

                @Override
                public void run() {
                    if (!SoterCoreUtil.isNullOrNil((String)TaskBiometricAuthentication.this.mChallenge)) {
                        if (SoterCore.getSoterCoreType() == 1) {
                            TaskBiometricAuthentication.this.executeWhenAuthenticatedWithSession(AuthenticationCallbackImpl.this.mSignatureToAuth, AuthenticationCallbackImpl.this.session);
                        } else {
                            try {
                                AuthenticationCallbackImpl.this.mSignatureToAuth.update(TaskBiometricAuthentication.this.mChallenge.getBytes(Charset.forName("UTF-8")));
                            }
                            catch (Exception e) {
                                SLogger.e((String)TaskBiometricAuthentication.TAG, (String)"soter: exception in update", (Object[])new Object[0]);
                                SLogger.printErrStackTrace((String)TaskBiometricAuthentication.TAG, (Throwable)e, (String)"soter: exception in update");
                                SReporter.reportError((int)200, (String)"TaskBiometric, update signature failed: onAuthenticationSucceeded().", (Exception)e);
                                SLogger.e((String)TaskBiometricAuthentication.TAG, (String)"soter: remove the auth key: %s", (Object[])new Object[]{TaskBiometricAuthentication.this.mAuthKeyName});
                                SoterCore.removeAuthKey((String)TaskBiometricAuthentication.this.mAuthKeyName, (boolean)false);
                                TaskBiometricAuthentication.this.callback(new SoterProcessAuthenticationResult(1027, "update signature failed. authkey removed after this failure, please check"));
                            }
                            try {
                                TaskBiometricAuthentication.this.executeWhenAuthenticated(AuthenticationCallbackImpl.this.mSignatureToAuth);
                            }
                            catch (Exception e) {
                                SLogger.e((String)TaskBiometricAuthentication.TAG, (String)"soter: exception in executeWhenAuthenticated method", (Object[])new Object[0]);
                                SLogger.printErrStackTrace((String)TaskBiometricAuthentication.TAG, (Throwable)e, (String)"soter: exception when execute");
                                AuthenticationCallbackImpl.this.onAuthenticationError(-1000, "execute failed");
                            }
                        }
                    } else {
                        SLogger.e((String)TaskBiometricAuthentication.TAG, (String)"soter: challenge is null. should not happen here", (Object[])new Object[0]);
                        AuthenticationCallbackImpl.this.onAuthenticationError(-1000, "challenge is null");
                    }
                }
            });
            this.authenticationShouldComplete();
        }

        public void onAuthenticationFailed() {
            SLogger.w((String)TaskBiometricAuthentication.TAG, (String)"soter: authentication failed once", (Object[])new Object[0]);
            SoterTaskThread.getInstance().postToMainThread(new Runnable(){

                @Override
                public void run() {
                    if (TaskBiometricAuthentication.this.mBiometricStateCallback != null) {
                        TaskBiometricAuthentication.this.mBiometricStateCallback.onAuthenticationFailed();
                    }
                }
            });
            this.authenticationMaybeContinue();
        }

        public void onAuthenticationCancelled() {
            SLogger.i((String)TaskBiometricAuthentication.TAG, (String)"soter: called onAuthenticationCancelled", (Object[])new Object[0]);
            if (TaskBiometricAuthentication.this.mIsAuthenticationAlreadyCancelled) {
                SLogger.v((String)TaskBiometricAuthentication.TAG, (String)"soter: during ignore cancel period", (Object[])new Object[0]);
                return;
            }
            SoterTaskThread.getInstance().postToMainThread(new Runnable(){

                @Override
                public void run() {
                    if (TaskBiometricAuthentication.this.mBiometricStateCallback != null) {
                        TaskBiometricAuthentication.this.mBiometricStateCallback.onAuthenticationCancelled();
                    }
                }
            });
            TaskBiometricAuthentication.this.callback(new SoterProcessAuthenticationResult(1020, "user cancelled authentication"));
            this.authenticationShouldComplete();
        }

        @SuppressLint(value={"NewApi"})
        private void authenticationMaybeContinue() {
            if (TaskBiometricAuthentication.this.mShouldOperateCompatWhenHint) {
                SLogger.i((String)TaskBiometricAuthentication.TAG, (String)"soter: should compat lower android version logic.", (Object[])new Object[0]);
                TaskBiometricAuthentication.this.mBiometricCancelSignal.asyncCancelBiometricAuthenticationInnerImp(false);
                SoterTaskThread.getInstance().postToWorker(new Runnable(){

                    @Override
                    public void run() {
                        TaskBiometricAuthentication.this.mBiometricCancelSignal.refreshCancellationSignal();
                    }
                });
                SoterTaskThread.getInstance().postToWorkerDelayed(new Runnable(){

                    @Override
                    public void run() {
                        TaskBiometricAuthentication.this.performStartBiometricLogic(AuthenticationCallbackImpl.this.mSignatureToAuth);
                    }
                }, 1000L);
            }
            if (TaskBiometricAuthentication.this.mBiometricType == 2) {
                SLogger.i((String)TaskBiometricAuthentication.TAG, (String)"soter: should compat faceid logic.", (Object[])new Object[0]);
                TaskBiometricAuthentication.this.callback(new SoterProcessAuthenticationResult(1017, "faceid not match"));
            }
        }

        @SuppressLint(value={"NewApi"})
        private void authenticationShouldComplete() {
            if (TaskBiometricAuthentication.this.mShouldOperateCompatWhenDone || TaskBiometricAuthentication.this.mBiometricType == 2) {
                TaskBiometricAuthentication.this.mBiometricCancelSignal.asyncCancelBiometricAuthenticationInnerImp(false);
                TaskBiometricAuthentication.this.mIsAuthenticationAlreadyCancelled = true;
            }
        }
    }
}

