/*
 * Decompiled with CFR 0.152.
 */
package com.swiftsynq.otpcustomview;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.ColorInt;
import android.support.annotation.Px;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import com.swiftsynq.otpcustomview.InitialMovementMethod;
import com.swiftsynq.otpcustomview.R;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b9\u0018\u0000 \u00a2\u00012\u00020\u0001:\u0004\u00a1\u0001\u00a2\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010R\u001a\u00020SH\u0002J\u0010\u0010T\u001a\u00020\u00072\u0006\u0010U\u001a\u00020;H\u0002J\u0010\u0010V\u001a\u00020S2\u0006\u0010W\u001a\u00020XH\u0002J\u0018\u0010Y\u001a\u00020S2\u0006\u0010W\u001a\u00020X2\u0006\u0010Z\u001a\u00020\u0007H\u0002J\u0010\u0010\u0017\u001a\u00020S2\u0006\u0010W\u001a\u00020XH\u0002J\u0018\u0010[\u001a\u00020S2\u0006\u0010W\u001a\u00020X2\u0006\u0010Z\u001a\u00020\u0007H\u0002J\u0018\u0010\\\u001a\u00020S2\u0006\u0010W\u001a\u00020X2\u0006\u0010Z\u001a\u00020\u0007H\u0002J\u0018\u0010]\u001a\u00020S2\u0006\u0010W\u001a\u00020X2\u0006\u0010Z\u001a\u00020\u0007H\u0002J\u0010\u0010^\u001a\u00020S2\u0006\u0010W\u001a\u00020XH\u0002J\u0018\u0010_\u001a\u00020S2\u0006\u0010W\u001a\u00020X2\u0006\u0010Z\u001a\u00020\u0007H\u0002J(\u0010`\u001a\u00020S2\u0006\u0010W\u001a\u00020X2\u0006\u0010a\u001a\u0002062\u0006\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020\u0007H\u0002J\b\u0010e\u001a\u00020SH\u0014J\b\u0010f\u001a\u00020gH\u0014J\u0014\u0010h\u001a\u00020\u00072\n\u0010i\u001a\u00020j\"\u00020\u0007H\u0002J\u0010\u0010k\u001a\u0002062\u0006\u0010Z\u001a\u00020\u0007H\u0002J\u0010\u0010l\u001a\u00020S2\u0006\u0010m\u001a\u00020\u0018H\u0002J\b\u0010\u001a\u001a\u00020\u0018H\u0016J\b\u0010n\u001a\u00020SH\u0002J\b\u0010o\u001a\u00020SH\u0002J\b\u0010p\u001a\u00020SH\u0014J\b\u0010q\u001a\u00020SH\u0014J\u0010\u0010r\u001a\u00020S2\u0006\u0010W\u001a\u00020XH\u0014J\"\u0010s\u001a\u00020S2\u0006\u0010t\u001a\u00020\u00182\u0006\u0010u\u001a\u00020\u00072\b\u0010v\u001a\u0004\u0018\u00010PH\u0014J\u0018\u0010w\u001a\u00020S2\u0006\u0010x\u001a\u00020\u00072\u0006\u0010y\u001a\u00020\u0007H\u0014J\u0010\u0010z\u001a\u00020S2\u0006\u0010{\u001a\u00020\u0007H\u0016J\u0018\u0010|\u001a\u00020S2\u0006\u0010}\u001a\u00020\u00072\u0006\u0010~\u001a\u00020\u0007H\u0014J+\u0010\u007f\u001a\u00020S2\u0006\u0010b\u001a\u00020c2\u0007\u0010\u0080\u0001\u001a\u00020\u00072\u0007\u0010\u0081\u0001\u001a\u00020\u00072\u0007\u0010\u0082\u0001\u001a\u00020\u0007H\u0014J\t\u0010\u0083\u0001\u001a\u00020SH\u0002J\u0010\u0010\u0084\u0001\u001a\u00020S2\u0007\u0010\u0085\u0001\u001a\u00020\u0018J\u0012\u0010\u0086\u0001\u001a\u00020S2\u0007\u0010\u0087\u0001\u001a\u00020\u0018H\u0016J\u0012\u0010\u0088\u0001\u001a\u00020S2\t\u0010\u0089\u0001\u001a\u0004\u0018\u00010+J\u0011\u0010\u0088\u0001\u001a\u00020S2\b\b\u0001\u0010\u000f\u001a\u00020\u0007J\u0012\u0010\u008a\u0001\u001a\u00020S2\u0007\u0010\u008b\u0001\u001a\u00020\u0007H\u0002J\u0012\u0010\u008c\u0001\u001a\u00020S2\u0007\u0010\u008d\u0001\u001a\u00020;H\u0016J\u001b\u0010\u008c\u0001\u001a\u00020S2\u0007\u0010\u008e\u0001\u001a\u00020\u00072\u0007\u0010\u008d\u0001\u001a\u00020;H\u0016J\t\u0010\u008f\u0001\u001a\u00020SH\u0002J\t\u0010\u0090\u0001\u001a\u00020\u0018H\u0002J\t\u0010\u0091\u0001\u001a\u00020SH\u0002J\t\u0010\u0092\u0001\u001a\u00020SH\u0002J\t\u0010\u0093\u0001\u001a\u00020SH\u0002J\t\u0010\u0094\u0001\u001a\u00020SH\u0002J\u0011\u0010\u0095\u0001\u001a\u00020S2\u0006\u0010Z\u001a\u00020\u0007H\u0002J\t\u0010\u0096\u0001\u001a\u00020SH\u0002J6\u0010\u0097\u0001\u001a\u00020S2\u0007\u0010\u0098\u0001\u001a\u00020@2\u0007\u0010\u0099\u0001\u001a\u00020;2\u0007\u0010\u009a\u0001\u001a\u00020;2\u0007\u0010\u009b\u0001\u001a\u00020\u00182\u0007\u0010\u009c\u0001\u001a\u00020\u0018H\u0002JH\u0010\u0097\u0001\u001a\u00020S2\u0007\u0010\u0098\u0001\u001a\u00020@2\u0007\u0010\u0099\u0001\u001a\u00020;2\u0007\u0010\u009a\u0001\u001a\u00020;2\u0007\u0010\u009d\u0001\u001a\u00020\u00182\u0007\u0010\u009e\u0001\u001a\u00020\u00182\u0007\u0010\u009f\u0001\u001a\u00020\u00182\u0007\u0010\u00a0\u0001\u001a\u00020\u0018H\u0002R&\u0010\n\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00078\u0007@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR&\u0010\u0010\u001a\u00020\u00072\b\b\u0001\u0010\u000f\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\f\"\u0004\b\u0012\u0010\u000eR&\u0010\u0014\u001a\u00020\u00072\b\b\u0001\u0010\u0013\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\f\"\u0004\b\u0016\u0010\u000eR\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\f\"\u0004\b\u001e\u0010\u000eR&\u0010\u001f\u001a\u00020\u00072\b\b\u0001\u0010\u001f\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b \u0010\f\"\u0004\b!\u0010\u000eR&\u0010\"\u001a\u00020\u00072\b\b\u0001\u0010\"\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010\f\"\u0004\b$\u0010\u000eR&\u0010%\u001a\u00020\u00072\b\b\u0001\u0010%\u001a\u00020\u00078G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010\f\"\u0004\b'\u0010\u000eR&\u0010(\u001a\u00020\u00072\b\b\u0001\u0010(\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010\f\"\u0004\b*\u0010\u000eR(\u0010,\u001a\u0004\u0018\u00010+2\b\u0010\t\u001a\u0004\u0018\u00010+@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R&\u00102\u001a\u00020\u00072\b\b\u0001\u00101\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b3\u0010\f\"\u0004\b4\u0010\u000eR\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00107\u001a\b\u0018\u000108R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010=\u001a\u0004\u0018\u00010>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020@X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020BX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020@X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010K\u001a\u00020LX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010M\u001a\u00020NX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010O\u001a\u00020PX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010Q\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00a3\u0001"}, d2={"Lcom/swiftsynq/otpcustomview/CustomOtpView;", "Landroid/support/v7/widget/AppCompatEditText;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "<set-?>", "currentLineColor", "getCurrentLineColor", "()I", "setCurrentLineColor", "(I)V", "color", "cursorColor", "getCursorColor", "setCursorColor", "width", "cursorWidth", "getCursorWidth", "setCursorWidth", "drawCursor", "", "isAnimationEnable", "isCursorVisible", "count", "itemCount", "getItemCount", "setItemCount", "itemHeight", "getItemHeight", "setItemHeight", "itemRadius", "getItemRadius", "setItemRadius", "itemSpacing", "getItemSpacing", "setItemSpacing", "itemWidth", "getItemWidth", "setItemWidth", "Landroid/content/res/ColorStateList;", "lineColors", "getLineColors", "()Landroid/content/res/ColorStateList;", "setLineColors", "(Landroid/content/res/ColorStateList;)V", "borderWidth", "lineWidth", "getLineWidth", "setLineWidth", "mAnimatorTextPaint", "Landroid/graphics/Paint;", "mBlink", "Lcom/swiftsynq/otpcustomview/CustomOtpView$Blink;", "mCursorColor", "mCursorHeight", "", "mCursorWidth", "mDefaultAddAnimator", "Landroid/animation/ValueAnimator;", "mItemBorderRect", "Landroid/graphics/RectF;", "mItemCenterPoint", "Landroid/graphics/PointF;", "mItemLineRect", "mLineWidth", "mOtpItemCount", "mOtpItemHeight", "mOtpItemRadius", "mOtpItemSpacing", "mOtpItemWidth", "mPaint", "mPath", "Landroid/graphics/Path;", "mTextPaint", "Landroid/text/TextPaint;", "mTextRect", "Landroid/graphics/Rect;", "mViewType", "checkItemRadius", "", "dpToPx", "dp", "drawAnchorLine", "canvas", "Landroid/graphics/Canvas;", "drawCircle", "i", "drawHint", "drawPinBox", "drawPinLine", "drawPinView", "drawText", "drawTextAtBox", "paint", "text", "", "charAt", "drawableStateChanged", "getDefaultMovementMethod", "Landroid/text/method/MovementMethod;", "getLineColorForState", "states", "", "getPaintByIndex", "invalidateCursor", "showCursor", "makeBlink", "moveSelectionToEnd", "onAttachedToWindow", "onDetachedFromWindow", "onDraw", "onFocusChanged", "focused", "direction", "previouslyFocusedRect", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onScreenStateChanged", "screenState", "onSelectionChanged", "selStart", "selEnd", "onTextChanged", "start", "lengthBefore", "lengthAfter", "resumeBlink", "setAnimationEnable", "enable", "setCursorVisible", "visible", "setLineColor", "colors", "setMaxLength", "maxLength", "setTextSize", "size", "unit", "setupAnimator", "shouldBlink", "suspendBlink", "updateCenterPoint", "updateColors", "updateCursorHeight", "updateItemRectF", "updatePaints", "updateRoundRectPath", "rectF", "rx", "ry", "l", "r", "tl", "tr", "br", "bl", "Blink", "Companion", "otpcustomview_release"})
public final class CustomOtpView
extends AppCompatEditText {
    private final int mViewType;
    private int mOtpItemCount;
    private int mOtpItemWidth;
    private int mOtpItemHeight;
    private int mOtpItemRadius;
    private int mOtpItemSpacing;
    private final Paint mPaint;
    private final TextPaint mTextPaint;
    private final Paint mAnimatorTextPaint;
    @Nullable
    private ColorStateList lineColors;
    private int currentLineColor;
    private int mLineWidth;
    private final Rect mTextRect;
    private final RectF mItemBorderRect;
    private final RectF mItemLineRect;
    private final Path mPath;
    private final PointF mItemCenterPoint;
    private ValueAnimator mDefaultAddAnimator;
    private boolean isAnimationEnable;
    private Blink mBlink;
    private boolean isCursorVisible;
    private boolean drawCursor;
    private float mCursorHeight;
    private int mCursorWidth;
    private int mCursorColor;
    private static final String TAG = "CustomOtpView";
    private static final boolean DBG = false;
    private static final int BLINK = 500;
    private static final int DEFAULT_COUNT = 4;
    private static final InputFilter[] NO_FILTERS;
    private static final int VIEW_TYPE_RECTANGLE = 0;
    private static final int VIEW_TYPE_LINE = 1;
    public static final Companion Companion;

    @Nullable
    public final ColorStateList getLineColors() {
        return this.lineColors;
    }

    private final void setLineColors(ColorStateList colorStateList) {
        this.lineColors = colorStateList;
    }

    @ColorInt
    public final int getCurrentLineColor() {
        return this.currentLineColor;
    }

    private final void setCurrentLineColor(int n) {
        this.currentLineColor = n;
    }

    public final int getLineWidth() {
        return this.mLineWidth;
    }

    public final void setLineWidth(@Px int borderWidth) {
        this.mLineWidth = borderWidth;
        this.checkItemRadius();
        this.requestLayout();
    }

    public final int getItemCount() {
        return this.mOtpItemCount;
    }

    public final void setItemCount(int count) {
        this.mOtpItemCount = count;
        this.setMaxLength(count);
        this.requestLayout();
    }

    public final int getItemRadius() {
        return this.mOtpItemRadius;
    }

    public final void setItemRadius(@Px int itemRadius) {
        this.mOtpItemRadius = itemRadius;
        this.checkItemRadius();
        this.requestLayout();
    }

    @Px
    public final int getItemSpacing() {
        return this.mOtpItemSpacing;
    }

    public final void setItemSpacing(@Px int itemSpacing) {
        this.mOtpItemSpacing = itemSpacing;
        this.requestLayout();
    }

    public final int getItemHeight() {
        return this.mOtpItemHeight;
    }

    public final void setItemHeight(@Px int itemHeight) {
        this.mOtpItemHeight = itemHeight;
        this.updateCursorHeight();
        this.requestLayout();
    }

    public final int getItemWidth() {
        return this.mOtpItemWidth;
    }

    public final void setItemWidth(@Px int itemWidth) {
        this.mOtpItemWidth = itemWidth;
        this.checkItemRadius();
        this.requestLayout();
    }

    public final int getCursorWidth() {
        return this.mCursorWidth;
    }

    public final void setCursorWidth(@Px int width) {
        this.mCursorWidth = width;
        if (this.isCursorVisible()) {
            this.invalidateCursor(true);
        }
    }

    public final int getCursorColor() {
        return this.mCursorColor;
    }

    public final void setCursorColor(@ColorInt int color) {
        this.mCursorColor = color;
        if (this.isCursorVisible()) {
            this.invalidateCursor(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setMaxLength(int maxLength) {
        if (maxLength >= 0) {
            void var2_2;
            Object[] elements$iv = new InputFilter[]{(InputFilter)new InputFilter.LengthFilter(maxLength)};
            CustomOtpView customOtpView = this;
            void var4_4 = var2_2;
            customOtpView.setFilters((InputFilter[])var4_4);
        } else {
            this.setFilters(CustomOtpView.Companion.getNO_FILTERS());
        }
    }

    private final void setupAnimator() {
        ValueAnimator valueAnimator = this.mDefaultAddAnimator = ValueAnimator.ofFloat((float[])new float[]{0.5f, 1.0f});
        if (valueAnimator == null) {
            Intrinsics.throwNpe();
        }
        valueAnimator.setDuration(150L);
        ValueAnimator valueAnimator2 = this.mDefaultAddAnimator;
        if (valueAnimator2 == null) {
            Intrinsics.throwNpe();
        }
        valueAnimator2.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        ValueAnimator valueAnimator3 = this.mDefaultAddAnimator;
        if (valueAnimator3 == null) {
            Intrinsics.throwNpe();
        }
        valueAnimator3.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ CustomOtpView this$0;

            public final void onAnimationUpdate(ValueAnimator animation) {
                Object object = animation.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Float");
                }
                float scale = ((Float)object).floatValue();
                int alpha = (int)((float)255 * scale);
                CustomOtpView.access$getMAnimatorTextPaint$p(this.this$0).setTextSize(this.this$0.getTextSize() * scale);
                CustomOtpView.access$getMAnimatorTextPaint$p(this.this$0).setAlpha(alpha);
                this.this$0.postInvalidate();
            }
            {
                this.this$0 = customOtpView;
            }
        });
    }

    private final void checkItemRadius() {
        float halfOfLineWidth;
        if (this.mViewType == CustomOtpView.Companion.getVIEW_TYPE_LINE() && (float)this.mOtpItemRadius > (halfOfLineWidth = (float)this.mLineWidth / (float)2)) {
            throw (Throwable)new IllegalArgumentException("The itemRadius can not be greater than lineWidth when viewType is line");
        }
        float halfOfItemWidth = (float)this.mOtpItemWidth / (float)2;
        if ((float)this.mOtpItemRadius > halfOfItemWidth) {
            throw (Throwable)new IllegalArgumentException("The itemRadius can not be greater than itemWidth");
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int boxHeight = this.mOtpItemHeight;
        if (widthMode == 0x40000000) {
            width = widthSize;
        } else {
            int boxesWidth = (this.mOtpItemCount - 1) * this.mOtpItemSpacing + this.mOtpItemCount * this.mOtpItemWidth;
            width = boxesWidth + ViewCompat.getPaddingEnd((View)((View)this)) + ViewCompat.getPaddingStart((View)((View)this));
            if (this.mOtpItemSpacing == 0) {
                width -= (this.mOtpItemCount - 1) * this.mLineWidth;
            }
        }
        int height = heightMode == 0x40000000 ? heightSize : boxHeight + this.getPaddingTop() + this.getPaddingBottom();
        this.setMeasuredDimension(width, height);
    }

    protected void onTextChanged(@NotNull CharSequence text, int start, int lengthBefore, int lengthAfter) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        if (start != text.length()) {
            this.moveSelectionToEnd();
        }
        this.makeBlink();
        if (this.isAnimationEnable) {
            boolean isAdd;
            boolean bl = isAdd = lengthAfter - lengthBefore > 0;
            if (isAdd && this.mDefaultAddAnimator != null) {
                ValueAnimator valueAnimator = this.mDefaultAddAnimator;
                if (valueAnimator == null) {
                    Intrinsics.throwNpe();
                }
                valueAnimator.end();
                ValueAnimator valueAnimator2 = this.mDefaultAddAnimator;
                if (valueAnimator2 == null) {
                    Intrinsics.throwNpe();
                }
                valueAnimator2.start();
            }
        }
    }

    protected void onFocusChanged(boolean focused, int direction, @Nullable Rect previouslyFocusedRect) {
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        if (focused) {
            this.moveSelectionToEnd();
            this.makeBlink();
        }
    }

    protected void onSelectionChanged(int selStart, int selEnd) {
        super.onSelectionChanged(selStart, selEnd);
        if (selEnd != this.getText().length()) {
            this.moveSelectionToEnd();
        }
    }

    private final void moveSelectionToEnd() {
        this.setSelection(this.getText().length());
    }

    protected void drawableStateChanged() {
        block5: {
            block4: {
                super.drawableStateChanged();
                if (this.lineColors == null) break block4;
                ColorStateList colorStateList = this.lineColors;
                if (colorStateList == null) {
                    Intrinsics.throwNpe();
                }
                if (!colorStateList.isStateful()) break block5;
            }
            this.updateColors();
        }
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        canvas.save();
        this.updatePaints();
        this.drawPinView(canvas);
        canvas.restore();
    }

    private final void updatePaints() {
        this.mPaint.setColor(this.currentLineColor);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth((float)this.mLineWidth);
        this.mTextPaint.setColor(this.getCurrentTextColor());
    }

    /*
     * WARNING - void declaration
     */
    private final void drawPinView(Canvas canvas) {
        int n = 0;
        int n2 = this.mOtpItemCount;
        while (n < n2) {
            void i;
            this.updateItemRectF((int)i);
            this.updateCenterPoint();
            if (this.mViewType == CustomOtpView.Companion.getVIEW_TYPE_RECTANGLE()) {
                this.drawPinBox(canvas, (int)i);
            } else {
                this.drawPinLine(canvas, (int)i);
            }
            if (CustomOtpView.Companion.getDBG()) {
                this.drawAnchorLine(canvas);
            }
            if (this.getText().length() > i) {
                if (CustomOtpView.Companion.isPasswordInputType(this.getInputType())) {
                    this.drawCircle(canvas, (int)i);
                } else {
                    this.drawText(canvas, (int)i);
                }
            } else if (!TextUtils.isEmpty((CharSequence)this.getHint()) && this.getHint().length() == this.mOtpItemCount) {
                this.drawHint(canvas, (int)i);
            }
            ++i;
        }
        if (this.isFocused() && this.getText().length() != this.mOtpItemCount) {
            int index = this.getText().length();
            this.updateItemRectF(index);
            this.updateCenterPoint();
            this.mPaint.setColor(this.getLineColorForState(0x10100A1));
            this.drawCursor(canvas);
            if (this.mViewType == CustomOtpView.Companion.getVIEW_TYPE_RECTANGLE()) {
                this.drawPinBox(canvas, index);
            } else {
                this.drawPinLine(canvas, index);
            }
        }
    }

    private final int getLineColorForState(int ... states) {
        int n;
        if (this.lineColors != null) {
            ColorStateList colorStateList = this.lineColors;
            if (colorStateList == null) {
                Intrinsics.throwNpe();
            }
            n = colorStateList.getColorForState(states, this.currentLineColor);
        } else {
            n = this.currentLineColor;
        }
        return n;
    }

    private final void drawPinBox(Canvas canvas, int i) {
        boolean drawRightCorner = false;
        boolean drawLeftCorner = false;
        if (this.mOtpItemSpacing != 0) {
            drawLeftCorner = drawRightCorner = true;
        } else {
            if (i == 0 && i != this.mOtpItemCount - 1) {
                drawLeftCorner = true;
            }
            if (i == this.mOtpItemCount - 1 && i != 0) {
                drawRightCorner = true;
            }
        }
        this.updateRoundRectPath(this.mItemBorderRect, this.mOtpItemRadius, this.mOtpItemRadius, drawLeftCorner, drawRightCorner);
        canvas.drawPath(this.mPath, this.mPaint);
    }

    private final void drawPinLine(Canvas canvas, int i) {
        boolean r;
        boolean l = r = true;
        if (this.mOtpItemSpacing == 0 && this.mOtpItemCount > 1) {
            if (i == 0) {
                r = false;
            } else {
                l = i == this.mOtpItemCount - 1 ? false : (r = false);
            }
        }
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setStrokeWidth((float)this.mLineWidth / (float)10);
        float halfLineWidth = (float)this.mLineWidth / (float)2;
        this.mItemLineRect.set(this.mItemBorderRect.left, this.mItemBorderRect.bottom - halfLineWidth, this.mItemBorderRect.right, this.mItemBorderRect.bottom + halfLineWidth);
        this.updateRoundRectPath(this.mItemLineRect, this.mOtpItemRadius, this.mOtpItemRadius, l, r);
        canvas.drawPath(this.mPath, this.mPaint);
    }

    private final void drawCursor(Canvas canvas) {
        if (this.drawCursor) {
            float cx = this.mItemCenterPoint.x;
            float cy = this.mItemCenterPoint.y;
            float y = cy - this.mCursorHeight / (float)2;
            int color = this.mPaint.getColor();
            float width = this.mPaint.getStrokeWidth();
            this.mPaint.setColor(this.mCursorColor);
            this.mPaint.setStrokeWidth((float)this.mCursorWidth);
            canvas.drawLine(cx, y, cx, y + this.mCursorHeight, this.mPaint);
            this.mPaint.setColor(color);
            this.mPaint.setStrokeWidth(width);
        }
    }

    private final void updateRoundRectPath(RectF rectF, float rx, float ry, boolean l, boolean r) {
        this.updateRoundRectPath(rectF, rx, ry, l, r, r, l);
    }

    private final void updateRoundRectPath(RectF rectF, float rx, float ry, boolean tl, boolean tr, boolean br, boolean bl) {
        this.mPath.reset();
        float l = rectF.left;
        float t = rectF.top;
        float r = rectF.right;
        float b = rectF.bottom;
        float w = r - l;
        float h = b - t;
        float lw = w - (float)2 * rx;
        float lh = h - (float)2 * ry;
        this.mPath.moveTo(l, t + ry);
        if (tl) {
            this.mPath.rQuadTo(0.0f, -ry, rx, -ry);
        } else {
            this.mPath.rLineTo(0.0f, -ry);
            this.mPath.rLineTo(rx, 0.0f);
        }
        this.mPath.rLineTo(lw, 0.0f);
        if (tr) {
            this.mPath.rQuadTo(rx, 0.0f, rx, ry);
        } else {
            this.mPath.rLineTo(rx, 0.0f);
            this.mPath.rLineTo(0.0f, ry);
        }
        this.mPath.rLineTo(0.0f, lh);
        if (br) {
            this.mPath.rQuadTo(0.0f, ry, -rx, ry);
        } else {
            this.mPath.rLineTo(0.0f, ry);
            this.mPath.rLineTo(-rx, 0.0f);
        }
        this.mPath.rLineTo(-lw, 0.0f);
        if (bl) {
            this.mPath.rQuadTo(-rx, 0.0f, -rx, -ry);
        } else {
            this.mPath.rLineTo(-rx, 0.0f);
            this.mPath.rLineTo(0.0f, -ry);
        }
        this.mPath.rLineTo(0.0f, -lh);
        this.mPath.close();
    }

    private final void updateItemRectF(int i) {
        float halfLineWidth = (float)this.mLineWidth / (float)2;
        float left = (float)this.getScrollX() + (float)ViewCompat.getPaddingStart((View)((View)this)) + (float)(i * (this.mOtpItemSpacing + this.mOtpItemWidth)) + halfLineWidth;
        if (this.mOtpItemSpacing == 0 && i > 0) {
            left -= (float)(this.mLineWidth * i);
        }
        float right = left + (float)this.mOtpItemWidth - (float)this.mLineWidth;
        float top = (float)this.getScrollY() + (float)this.getPaddingTop() + halfLineWidth;
        float bottom = top + (float)this.mOtpItemHeight - (float)this.mLineWidth;
        this.mItemBorderRect.set(left, top, right, bottom);
    }

    private final void drawText(Canvas canvas, int i) {
        Paint paint = this.getPaintByIndex(i);
        Editable editable = this.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)editable, (String)"text");
        this.drawTextAtBox(canvas, paint, (CharSequence)editable, i);
    }

    private final void drawHint(Canvas canvas, int i) {
        Paint paint = this.getPaintByIndex(i);
        paint.setColor(this.getCurrentHintTextColor());
        CharSequence charSequence = this.getHint();
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"hint");
        this.drawTextAtBox(canvas, paint, charSequence, i);
    }

    private final void drawTextAtBox(Canvas canvas, Paint paint, CharSequence text, int charAt) {
        paint.getTextBounds(((Object)text).toString(), charAt, charAt + 1, this.mTextRect);
        float cx = this.mItemCenterPoint.x;
        float cy = this.mItemCenterPoint.y;
        float x = cx - Math.abs((float)this.mTextRect.width()) / (float)2 - (float)this.mTextRect.left;
        float y = cy + Math.abs((float)this.mTextRect.height()) / (float)2 - (float)this.mTextRect.bottom;
        canvas.drawText(text, charAt, charAt + 1, x, y, paint);
    }

    private final void drawCircle(Canvas canvas, int i) {
        Paint paint = this.getPaintByIndex(i);
        float cx = this.mItemCenterPoint.x;
        float cy = this.mItemCenterPoint.y;
        canvas.drawCircle(cx, cy, paint.getTextSize() / (float)2, paint);
    }

    private final Paint getPaintByIndex(int i) {
        if (this.isAnimationEnable && i == this.getText().length() - 1) {
            this.mAnimatorTextPaint.setColor(this.mTextPaint.getColor());
            return this.mAnimatorTextPaint;
        }
        return (Paint)this.mTextPaint;
    }

    private final void drawAnchorLine(Canvas canvas) {
        float cx = this.mItemCenterPoint.x;
        float cy = this.mItemCenterPoint.y;
        this.mPaint.setStrokeWidth(1.0f);
        cy -= this.mPaint.getStrokeWidth() / (float)2;
        this.mPath.reset();
        this.mPath.moveTo(cx -= this.mPaint.getStrokeWidth() / (float)2, this.mItemBorderRect.top);
        this.mPath.lineTo(cx, this.mItemBorderRect.top + Math.abs(this.mItemBorderRect.height()));
        canvas.drawPath(this.mPath, this.mPaint);
        this.mPath.reset();
        this.mPath.moveTo(this.mItemBorderRect.left, cy);
        this.mPath.lineTo(this.mItemBorderRect.left + Math.abs(this.mItemBorderRect.width()), cy);
        canvas.drawPath(this.mPath, this.mPaint);
        this.mPath.reset();
        this.mPaint.setStrokeWidth((float)this.mLineWidth);
    }

    private final void updateColors() {
        int color;
        boolean inval = false;
        if (this.lineColors != null) {
            ColorStateList colorStateList = this.lineColors;
            if (colorStateList == null) {
                Intrinsics.throwNpe();
            }
            color = colorStateList.getColorForState(this.getDrawableState(), 0);
        } else {
            color = this.getCurrentTextColor();
        }
        if (color != this.currentLineColor) {
            this.currentLineColor = color;
            inval = true;
        }
        if (inval) {
            this.invalidate();
        }
    }

    private final void updateCenterPoint() {
        float cx = this.mItemBorderRect.left + Math.abs(this.mItemBorderRect.width()) / (float)2;
        float cy = this.mItemBorderRect.top + Math.abs(this.mItemBorderRect.height()) / (float)2;
        this.mItemCenterPoint.set(cx, cy);
    }

    @NotNull
    protected MovementMethod getDefaultMovementMethod() {
        return InitialMovementMethod.Companion.getInstance();
    }

    public final void setLineColor(@ColorInt int color) {
        this.lineColors = ColorStateList.valueOf((int)color);
        this.updateColors();
    }

    public final void setLineColor(@Nullable ColorStateList colors) {
        if (colors == null) {
            throw (Throwable)new NullPointerException();
        }
        this.lineColors = colors;
        this.updateColors();
    }

    public final void setAnimationEnable(boolean enable) {
        this.isAnimationEnable = enable;
    }

    public void setTextSize(float size) {
        super.setTextSize(size);
        this.updateCursorHeight();
    }

    public void setTextSize(int unit, float size) {
        super.setTextSize(unit, size);
        this.updateCursorHeight();
    }

    public void setCursorVisible(boolean visible) {
        if (this.isCursorVisible != visible) {
            this.isCursorVisible = visible;
            this.invalidateCursor(this.isCursorVisible);
            this.makeBlink();
        }
    }

    public boolean isCursorVisible() {
        return this.isCursorVisible;
    }

    public void onScreenStateChanged(int screenState) {
        super.onScreenStateChanged(screenState);
        switch (screenState) {
            case 1: {
                this.resumeBlink();
                break;
            }
            case 0: {
                this.suspendBlink();
            }
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.resumeBlink();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.suspendBlink();
    }

    private final boolean shouldBlink() {
        return this.isCursorVisible() && this.isFocused();
    }

    private final void makeBlink() {
        if (this.shouldBlink()) {
            if (this.mBlink == null) {
                this.mBlink = new Blink();
            }
            this.removeCallbacks(this.mBlink);
            this.drawCursor = false;
            this.postDelayed(this.mBlink, CustomOtpView.Companion.getBLINK());
        } else if (this.mBlink != null) {
            this.removeCallbacks(this.mBlink);
        }
    }

    private final void suspendBlink() {
        if (this.mBlink != null) {
            Blink blink = this.mBlink;
            if (blink == null) {
                Intrinsics.throwNpe();
            }
            blink.cancel();
            this.invalidateCursor(false);
        }
    }

    private final void resumeBlink() {
        if (this.mBlink != null) {
            Blink blink = this.mBlink;
            if (blink == null) {
                Intrinsics.throwNpe();
            }
            blink.uncancel$otpcustomview_release();
            this.makeBlink();
        }
    }

    private final void invalidateCursor(boolean showCursor) {
        if (this.drawCursor != showCursor) {
            this.drawCursor = showCursor;
            this.invalidate();
        }
    }

    private final void updateCursorHeight() {
        int delta = 2 * this.dpToPx(2.0f);
        this.mCursorHeight = (float)this.mOtpItemHeight - this.getTextSize() > (float)delta ? this.getTextSize() + (float)delta : this.getTextSize();
    }

    private final int dpToPx(float dp) {
        return (int)(dp * this.getResources().getDisplayMetrics().density + 0.5f);
    }

    @JvmOverloads
    public CustomOtpView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.currentLineColor = -16777216;
        this.mTextRect = new Rect();
        this.mItemBorderRect = new RectF();
        this.mItemLineRect = new RectF();
        this.mPath = new Path();
        this.mItemCenterPoint = new PointF();
        Resources res = this.getResources();
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mTextPaint = new TextPaint(1);
        this.mTextPaint.density = res.getDisplayMetrics().density;
        this.mTextPaint.setStyle(Paint.Style.FILL);
        this.mTextPaint.setTextSize(this.getTextSize());
        this.mAnimatorTextPaint = (Paint)new TextPaint((Paint)this.mTextPaint);
        Resources.Theme theme = context.getTheme();
        TypedArray a = theme.obtainStyledAttributes(attrs, R.styleable.CustomOtpView, defStyleAttr, 0);
        this.mViewType = a.getInt(R.styleable.CustomOtpView_viewType, CustomOtpView.Companion.getVIEW_TYPE_RECTANGLE());
        this.mOtpItemCount = a.getInt(R.styleable.CustomOtpView_itemCount, CustomOtpView.Companion.getDEFAULT_COUNT());
        this.mOtpItemHeight = (int)a.getDimension(R.styleable.CustomOtpView_itemHeight, (float)res.getDimensionPixelSize(R.dimen.otp_customotp_view_item_size));
        this.mOtpItemWidth = (int)a.getDimension(R.styleable.CustomOtpView_itemWidth, (float)res.getDimensionPixelSize(R.dimen.otp_customotp_view_item_size));
        this.mOtpItemSpacing = a.getDimensionPixelSize(R.styleable.CustomOtpView_itemSpacing, res.getDimensionPixelSize(R.dimen.otp_customotp_view_item_spacing));
        this.mOtpItemRadius = (int)a.getDimension(R.styleable.CustomOtpView_itemRadius, 0.0f);
        this.mLineWidth = (int)a.getDimension(R.styleable.CustomOtpView_lineWidth, (float)res.getDimensionPixelSize(R.dimen.otp_customotp_view_item_line_width));
        this.lineColors = a.getColorStateList(R.styleable.CustomOtpView_lineColor);
        this.isCursorVisible = a.getBoolean(R.styleable.CustomOtpView_android_cursorVisible, true);
        this.mCursorColor = a.getColor(R.styleable.CustomOtpView_cursorColor, this.getCurrentTextColor());
        this.mCursorWidth = a.getDimensionPixelSize(R.styleable.CustomOtpView_cursorWidth, res.getDimensionPixelSize(R.dimen.otp_customotp_view_cursor_width));
        a.recycle();
        if (this.lineColors != null) {
            ColorStateList colorStateList = this.lineColors;
            if (colorStateList == null) {
                Intrinsics.throwNpe();
            }
            this.currentLineColor = colorStateList.getDefaultColor();
        }
        this.updateCursorHeight();
        this.checkItemRadius();
        this.setMaxLength(this.mOtpItemCount);
        this.mPaint.setStrokeWidth((float)this.mLineWidth);
        this.setupAnimator();
        super.setCursorVisible(false);
        this.setTextIsSelectable(false);
    }

    @JvmOverloads
    public /* synthetic */ CustomOtpView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.attr.otpViewStyle;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public CustomOtpView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CustomOtpView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    static {
        Companion = new Companion(null);
        TAG = TAG;
        BLINK = 500;
        DEFAULT_COUNT = 4;
        NO_FILTERS = new InputFilter[0];
        VIEW_TYPE_LINE = 1;
    }

    public static final /* synthetic */ void access$setDrawCursor$p(CustomOtpView $this, boolean bl) {
        $this.drawCursor = bl;
    }

    @NotNull
    public static final /* synthetic */ Paint access$getMAnimatorTextPaint$p(CustomOtpView $this) {
        return $this.mAnimatorTextPaint;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\r\u0010\b\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/swiftsynq/otpcustomview/CustomOtpView$Blink;", "Ljava/lang/Runnable;", "(Lcom/swiftsynq/otpcustomview/CustomOtpView;)V", "mCancelled", "", "cancel", "", "run", "uncancel", "uncancel$otpcustomview_release", "otpcustomview_release"})
    private final class Blink
    implements Runnable {
        private boolean mCancelled;

        @Override
        public void run() {
            if (this.mCancelled) {
                return;
            }
            CustomOtpView.this.removeCallbacks(this);
            if (CustomOtpView.this.shouldBlink()) {
                CustomOtpView.this.invalidateCursor(!CustomOtpView.this.drawCursor);
                CustomOtpView.this.postDelayed(this, Companion.getBLINK());
            }
        }

        public final void cancel() {
            if (!this.mCancelled) {
                CustomOtpView.this.removeCallbacks(this);
                this.mCancelled = true;
            }
        }

        public final void uncancel$otpcustomview_release() {
            this.mCancelled = false;
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u001e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eX\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u0014X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0014\u0010\u0019\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lcom/swiftsynq/otpcustomview/CustomOtpView$Companion;", "", "()V", "BLINK", "", "getBLINK", "()I", "DBG", "", "getDBG", "()Z", "DEFAULT_COUNT", "getDEFAULT_COUNT", "NO_FILTERS", "", "Landroid/text/InputFilter;", "getNO_FILTERS", "()[Landroid/text/InputFilter;", "[Landroid/text/InputFilter;", "TAG", "", "getTAG", "()Ljava/lang/String;", "VIEW_TYPE_LINE", "getVIEW_TYPE_LINE", "VIEW_TYPE_RECTANGLE", "getVIEW_TYPE_RECTANGLE", "isPasswordInputType", "inputType", "otpcustomview_release"})
    public static final class Companion {
        private final String getTAG() {
            return TAG;
        }

        private final boolean getDBG() {
            return DBG;
        }

        private final int getBLINK() {
            return BLINK;
        }

        private final int getDEFAULT_COUNT() {
            return DEFAULT_COUNT;
        }

        private final InputFilter[] getNO_FILTERS() {
            return NO_FILTERS;
        }

        private final int getVIEW_TYPE_RECTANGLE() {
            return VIEW_TYPE_RECTANGLE;
        }

        private final int getVIEW_TYPE_LINE() {
            return VIEW_TYPE_LINE;
        }

        private final boolean isPasswordInputType(int inputType) {
            int variation = inputType & 0xFFF;
            return variation == 129 || variation == 225 || variation == 18;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

