/*
 * Decompiled with CFR 0.152.
 */
package com.amaze.trashbin;

import android.os.Build;
import com.amaze.trashbin.TrashBinConfig;
import java.io.File;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00c6\u0003J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\fJB\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001cJ\u0013\u0010\u001d\u001a\u00020\u00052\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001R\u001e\u0010\t\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006%"}, d2={"Lcom/amaze/trashbin/TrashBinFile;", "", "fileName", "", "isDirectory", "", "path", "sizeBytes", "", "deleteTime", "(Ljava/lang/String;ZLjava/lang/String;JLjava/lang/Long;)V", "getDeleteTime", "()Ljava/lang/Long;", "setDeleteTime", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "getFileName", "()Ljava/lang/String;", "()Z", "getPath", "getSizeBytes", "()J", "component1", "component2", "component3", "component4", "component5", "copy", "(Ljava/lang/String;ZLjava/lang/String;JLjava/lang/Long;)Lcom/amaze/trashbin/TrashBinFile;", "equals", "other", "getDeletedPath", "config", "Lcom/amaze/trashbin/TrashBinConfig;", "hashCode", "", "toString", "trashbin_release"})
public final class TrashBinFile {
    @NotNull
    private final String fileName;
    private final boolean isDirectory;
    @NotNull
    private final String path;
    private final long sizeBytes;
    @Nullable
    private Long deleteTime;

    public TrashBinFile(@NotNull String fileName, boolean isDirectory, @NotNull String path, long sizeBytes, @Nullable Long deleteTime) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.fileName = fileName;
        this.isDirectory = isDirectory;
        this.path = path;
        this.sizeBytes = sizeBytes;
        this.deleteTime = deleteTime;
        if (this.deleteTime == null) {
            this.deleteTime = Build.VERSION.SDK_INT >= 26 ? Long.valueOf(LocalDateTime.now().toEpochSecond(ZoneOffset.UTC)) : Long.valueOf(System.currentTimeMillis() / (long)1000);
        }
    }

    public /* synthetic */ TrashBinFile(String string, boolean bl, String string2, long l, Long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            l2 = null;
        }
        this(string, bl, string2, l, l2);
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    public final boolean isDirectory() {
        return this.isDirectory;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public final long getSizeBytes() {
        return this.sizeBytes;
    }

    @Nullable
    public final Long getDeleteTime() {
        return this.deleteTime;
    }

    public final void setDeleteTime(@Nullable Long l) {
        this.deleteTime = l;
    }

    @NotNull
    public final String getDeletedPath(@NotNull TrashBinConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return config.getBasePath() + File.separator + "TrashBinFiles" + File.separator + this.fileName;
    }

    @NotNull
    public final String component1() {
        return this.fileName;
    }

    public final boolean component2() {
        return this.isDirectory;
    }

    @NotNull
    public final String component3() {
        return this.path;
    }

    public final long component4() {
        return this.sizeBytes;
    }

    @Nullable
    public final Long component5() {
        return this.deleteTime;
    }

    @NotNull
    public final TrashBinFile copy(@NotNull String fileName, boolean isDirectory, @NotNull String path, long sizeBytes, @Nullable Long deleteTime) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new TrashBinFile(fileName, isDirectory, path, sizeBytes, deleteTime);
    }

    public static /* synthetic */ TrashBinFile copy$default(TrashBinFile trashBinFile, String string, boolean bl, String string2, long l, Long l2, int n, Object object) {
        if ((n & 1) != 0) {
            string = trashBinFile.fileName;
        }
        if ((n & 2) != 0) {
            bl = trashBinFile.isDirectory;
        }
        if ((n & 4) != 0) {
            string2 = trashBinFile.path;
        }
        if ((n & 8) != 0) {
            l = trashBinFile.sizeBytes;
        }
        if ((n & 0x10) != 0) {
            l2 = trashBinFile.deleteTime;
        }
        return trashBinFile.copy(string, bl, string2, l, l2);
    }

    @NotNull
    public String toString() {
        return "TrashBinFile(fileName=" + this.fileName + ", isDirectory=" + this.isDirectory + ", path=" + this.path + ", sizeBytes=" + this.sizeBytes + ", deleteTime=" + this.deleteTime + ')';
    }

    public int hashCode() {
        int result = this.fileName.hashCode();
        int n = this.isDirectory ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        result = result * 31 + this.path.hashCode();
        result = result * 31 + Long.hashCode(this.sizeBytes);
        result = result * 31 + (this.deleteTime == null ? 0 : ((Object)this.deleteTime).hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TrashBinFile)) {
            return false;
        }
        TrashBinFile trashBinFile = (TrashBinFile)other;
        if (!Intrinsics.areEqual((Object)this.fileName, (Object)trashBinFile.fileName)) {
            return false;
        }
        if (this.isDirectory != trashBinFile.isDirectory) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.path, (Object)trashBinFile.path)) {
            return false;
        }
        if (this.sizeBytes != trashBinFile.sizeBytes) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.deleteTime, (Object)trashBinFile.deleteTime);
    }
}

