/*
 * Decompiled with CFR 0.152.
 */
package com.gapps.library.api;

import android.content.Context;
import android.util.Log;
import com.gapps.library.api.VideoLoadHelper;
import com.gapps.library.api.models.api.CoubVideoInfoModel;
import com.gapps.library.api.models.api.DailymotionVideoInfoModel;
import com.gapps.library.api.models.api.FacebookVideoInfoModel;
import com.gapps.library.api.models.api.HuluVideoInfoModel;
import com.gapps.library.api.models.api.LoomVideoInfoModel;
import com.gapps.library.api.models.api.RutubeVideoInfoModel;
import com.gapps.library.api.models.api.StreamableVideoInfoModel;
import com.gapps.library.api.models.api.TedTalksVideoInfoModel;
import com.gapps.library.api.models.api.UltimediaVideoInfoModel;
import com.gapps.library.api.models.api.UstreamVideoInfoModel;
import com.gapps.library.api.models.api.VimeoVideoInfoModel;
import com.gapps.library.api.models.api.VzaarVideoInfoModel;
import com.gapps.library.api.models.api.WistiaVideoInfoModel;
import com.gapps.library.api.models.api.YoutubeMusicVideoInfoModel;
import com.gapps.library.api.models.api.YoutubeVideoInfoModel;
import com.gapps.library.api.models.api.base.VideoInfoModel;
import com.gapps.library.api.models.api.builder.EmbeddingRequest;
import com.gapps.library.api.models.video.VideoPreviewModel;
import com.gapps.library.api.models.video.base.BaseVideoResponse;
import com.gapps.library.utils.errors.EmbeddingError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 '2\u00020\u0001:\u0002'(BA\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0014\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\n\u00a2\u0006\u0004\b\r\u0010\u000eB\u0011\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\r\u0010\u0011Jm\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172!\u0010\u0018\u001a\u001d\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u00150\u00192:\b\u0002\u0010\u001e\u001a4\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b( \u0012\u0004\u0012\u00020\u0015\u0018\u00010\u001fJm\u0010\u0014\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2!\u0010\u0018\u001a\u001d\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u00150\u00192:\b\u0002\u0010\u001e\u001a4\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b( \u0012\u0004\u0012\u00020\u0015\u0018\u00010\u001fJ\u0016\u0010#\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0017H\u0086@\u00a2\u0006\u0002\u0010$J\u0016\u0010#\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"H\u0086@\u00a2\u0006\u0002\u0010%J\"\u0010&\u001a\u00020\u00132\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/gapps/library/api/VideoService;", "", "context", "Landroid/content/Context;", "client", "Lokhttp3/OkHttpClient;", "isCacheEnabled", "", "isLogEnabled", "customModels", "", "Lcom/gapps/library/api/models/api/base/VideoInfoModel;", "Lcom/gapps/library/api/models/video/base/BaseVideoResponse;", "<init>", "(Landroid/content/Context;Lokhttp3/OkHttpClient;ZZLjava/util/List;)V", "builder", "Lcom/gapps/library/api/VideoService$Builder;", "(Lcom/gapps/library/api/VideoService$Builder;)V", "videoHelper", "Lcom/gapps/library/api/VideoLoadHelper;", "loadVideoPreview", "", "url", "", "onSuccess", "Lkotlin/Function1;", "Lcom/gapps/library/api/models/video/VideoPreviewModel;", "Lkotlin/ParameterName;", "name", "resultModel", "onError", "Lkotlin/Function2;", "message", "request", "Lcom/gapps/library/api/models/api/builder/EmbeddingRequest;", "loadVideoAsync", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Lcom/gapps/library/api/models/api/builder/EmbeddingRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createVideoLoadHelper", "Companion", "Builder", "embedded_video_lib_release"})
@SourceDebugExtension(value={"SMAP\nVideoService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VideoService.kt\ncom/gapps/library/api/VideoService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,168:1\n1869#2,2:169\n295#2,2:171\n426#3,11:173\n1#4:184\n*S KotlinDebug\n*F\n+ 1 VideoService.kt\ncom/gapps/library/api/VideoService\n*L\n57#1:169,2\n102#1:171,2\n121#1:173,11\n*E\n"})
public final class VideoService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isLogEnabled;
    @NotNull
    private final List<VideoInfoModel<? extends BaseVideoResponse>> customModels;
    @NotNull
    private final VideoLoadHelper videoHelper;
    @NotNull
    public static final String TAG = "VideoService";
    @NotNull
    private static final List<VideoInfoModel<? extends BaseVideoResponse>> videoInfoModelsList;

    private VideoService(Context context, OkHttpClient client, boolean isCacheEnabled, boolean isLogEnabled, List<? extends VideoInfoModel<? extends BaseVideoResponse>> customModels) {
        this.isLogEnabled = isLogEnabled;
        this.customModels = customModels;
        this.videoHelper = this.createVideoLoadHelper(context, client, isCacheEnabled);
    }

    public VideoService(@NotNull Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this(builder.getContext(), builder.getOkHttpClient(), builder.isCacheEnabled(), builder.isLogEnabled(), builder.getCustomModels());
        Iterable $this$forEach$iv = this.customModels;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VideoInfoModel custom = (VideoInfoModel)element$iv;
            boolean bl = false;
            CollectionsKt.removeAll(videoInfoModelsList, arg_0 -> VideoService._init_$lambda$0$0(custom, arg_0));
        }
        videoInfoModelsList.addAll((Collection<VideoInfoModel<? extends BaseVideoResponse>>)this.customModels);
    }

    public final void loadVideoPreview(@NotNull String url, @NotNull Function1<? super VideoPreviewModel, Unit> onSuccess, @Nullable Function2<? super String, ? super String, Unit> onError) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        EmbeddingRequest request = new EmbeddingRequest.Builder().setUrl(url).build();
        this.loadVideoPreview(request, onSuccess, onError);
    }

    public static /* synthetic */ void loadVideoPreview$default(VideoService videoService, String string, Function1 function1, Function2 function2, int n, Object object) {
        if ((n & 4) != 0) {
            function2 = null;
        }
        videoService.loadVideoPreview(string, (Function1<? super VideoPreviewModel, Unit>)function1, (Function2<? super String, ? super String, Unit>)function2);
    }

    /*
     * WARNING - void declaration
     */
    public final void loadVideoPreview(@NotNull EmbeddingRequest request, @NotNull Function1<? super VideoPreviewModel, Unit> onSuccess, @Nullable Function2<? super String, ? super String, Unit> onError) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        if (this.isLogEnabled) {
            Log.i((String)TAG, (String)("Loading url: " + request.getOriginalUrl()));
        }
        Function1 callback = arg_0 -> VideoService.loadVideoPreview$lambda$0(onSuccess, arg_0);
        Function2 callbackError = (arg_0, arg_1) -> VideoService.loadVideoPreview$lambda$1(onError, arg_0, arg_1);
        if (request.getVideoInfoModel() == null) {
            Object v0;
            EmbeddingRequest embeddingRequest;
            block3: {
                void $this$firstOrNull$iv;
                Iterable iterable = videoInfoModelsList;
                embeddingRequest = request;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    VideoInfoModel it = (VideoInfoModel)element$iv;
                    boolean bl = false;
                    if (!it.checkHostAffiliation(request.getOriginalUrl())) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            embeddingRequest.setVideoInfoModel(v0);
        }
        this.videoHelper.getVideoInfo(request, (Function1<? super VideoPreviewModel, Unit>)callback, (Function2<? super String, ? super String, Unit>)callbackError);
    }

    public static /* synthetic */ void loadVideoPreview$default(VideoService videoService, EmbeddingRequest embeddingRequest, Function1 function1, Function2 function2, int n, Object object) {
        if ((n & 4) != 0) {
            function2 = null;
        }
        videoService.loadVideoPreview(embeddingRequest, (Function1<? super VideoPreviewModel, Unit>)function1, (Function2<? super String, ? super String, Unit>)function2);
    }

    @Nullable
    public final Object loadVideoAsync(@NotNull String url, @NotNull Continuation<? super VideoPreviewModel> $completion) {
        EmbeddingRequest request = new EmbeddingRequest.Builder().setUrl(url).build();
        return this.loadVideoAsync(request, $completion);
    }

    @Nullable
    public final Object loadVideoAsync(@NotNull EmbeddingRequest request, @NotNull Continuation<? super VideoPreviewModel> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super VideoPreviewModel> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        this.loadVideoPreview(request, (Function1<? super VideoPreviewModel, Unit>)((Function1)new Function1<VideoPreviewModel, Unit>((CancellableContinuation<? super VideoPreviewModel>)continuation){
            final /* synthetic */ CancellableContinuation<VideoPreviewModel> $continuation;
            {
                this.$continuation = $continuation;
            }

            public final void invoke(VideoPreviewModel videoPreviewModel) {
                Intrinsics.checkNotNullParameter((Object)videoPreviewModel, (String)"videoPreviewModel");
                this.$continuation.resumeWith(Result.constructor-impl((Object)videoPreviewModel));
            }
        }), (Function2<? super String, ? super String, Unit>)((Function2)new Function2<String, String, Unit>((CancellableContinuation<? super VideoPreviewModel>)continuation){
            final /* synthetic */ CancellableContinuation<VideoPreviewModel> $continuation;
            {
                this.$continuation = $continuation;
            }

            public final void invoke(String url, String errorMessage) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                ((Continuation)this.$continuation).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new EmbeddingError(url, errorMessage))));
            }
        }));
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    private final VideoLoadHelper createVideoLoadHelper(Context context, OkHttpClient client, boolean isCacheEnabled) {
        return new VideoLoadHelper(context, client, isCacheEnabled, this.isLogEnabled);
    }

    private static final boolean _init_$lambda$0$0(VideoInfoModel $custom, VideoInfoModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getHostingName(), (Object)$custom.getHostingName());
    }

    private static final Unit loadVideoPreview$lambda$0(Function1 $onSuccess, VideoPreviewModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        $onSuccess.invoke((Object)model);
        return Unit.INSTANCE;
    }

    private static final Unit loadVideoPreview$lambda$1(Function2 $onError, String url, String errorMessage) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
            Function2 function2 = $onError;
            if (function2 == null) break block0;
            Function2 $this$loadVideoPreview_u24lambda_u241_u240 = function2;
            boolean bl = false;
            $this$loadVideoPreview_u24lambda_u241_u240.invoke((Object)url, (Object)errorMessage);
        }
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new VideoInfoModel[]{new LoomVideoInfoModel(), new CoubVideoInfoModel(), new DailymotionVideoInfoModel(), new FacebookVideoInfoModel(), new HuluVideoInfoModel(), new RutubeVideoInfoModel(), new TedTalksVideoInfoModel(), new UstreamVideoInfoModel(), new VimeoVideoInfoModel(), new VzaarVideoInfoModel(), new WistiaVideoInfoModel(), new YoutubeMusicVideoInfoModel(), new YoutubeVideoInfoModel(), new UltimediaVideoInfoModel(), new StreamableVideoInfoModel()};
        videoInfoModelsList = CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\rJ\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0005J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\tJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\tJ1\u0010\u001d\u001a\u00020\u0000\"\u0010\b\u0000\u0010\u001e*\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u00132\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u001e0 \"\u0002H\u001e\u00a2\u0006\u0002\u0010!J\u0006\u0010\"\u001a\u00020#R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\"\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\u0004\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001f\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006$"}, d2={"Lcom/gapps/library/api/VideoService$Builder;", "", "<init>", "()V", "value", "Lokhttp3/OkHttpClient;", "okHttpClient", "getOkHttpClient", "()Lokhttp3/OkHttpClient;", "", "isLogEnabled", "()Z", "isCacheEnabled", "Landroid/content/Context;", "context", "getContext", "()Landroid/content/Context;", "customModels", "", "Lcom/gapps/library/api/models/api/base/VideoInfoModel;", "Lcom/gapps/library/api/models/video/base/BaseVideoResponse;", "getCustomModels", "()Ljava/util/List;", "with", "httpClient", "client", "enableLog", "isEnabled", "enableCache", "withCustomVideoInfoModels", "T", "models", "", "([Lcom/gapps/library/api/models/api/base/VideoInfoModel;)Lcom/gapps/library/api/VideoService$Builder;", "build", "Lcom/gapps/library/api/VideoService;", "embedded_video_lib_release"})
    @SourceDebugExtension(value={"SMAP\nVideoService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VideoService.kt\ncom/gapps/library/api/VideoService$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,168:1\n1#2:169\n*E\n"})
    public static final class Builder {
        @NotNull
        private OkHttpClient okHttpClient = new OkHttpClient();
        private boolean isLogEnabled;
        private boolean isCacheEnabled;
        @Nullable
        private Context context;
        @NotNull
        private final List<VideoInfoModel<? extends BaseVideoResponse>> customModels = new ArrayList();

        @NotNull
        public final OkHttpClient getOkHttpClient() {
            return this.okHttpClient;
        }

        public final boolean isLogEnabled() {
            return this.isLogEnabled;
        }

        public final boolean isCacheEnabled() {
            return this.isCacheEnabled;
        }

        @Nullable
        public final Context getContext() {
            return this.context;
        }

        @NotNull
        public final List<VideoInfoModel<? extends BaseVideoResponse>> getCustomModels() {
            return this.customModels;
        }

        @NotNull
        public final Builder with(@NotNull Context context) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Builder $this$with_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$with_u24lambda_u240.context = context;
            return builder;
        }

        @NotNull
        public final Builder httpClient(@NotNull OkHttpClient client) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Builder $this$httpClient_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$httpClient_u24lambda_u240.okHttpClient = client;
            return builder;
        }

        @NotNull
        public final Builder enableLog(boolean isEnabled) {
            Builder builder;
            Builder $this$enableLog_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$enableLog_u24lambda_u240.isLogEnabled = isEnabled;
            return builder;
        }

        @NotNull
        public final Builder enableCache(boolean isEnabled) {
            Builder builder;
            Builder $this$enableCache_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$enableCache_u24lambda_u240.isCacheEnabled = isEnabled;
            return builder;
        }

        @NotNull
        public final <T extends VideoInfoModel<? extends BaseVideoResponse>> Builder withCustomVideoInfoModels(T ... models) {
            Builder builder;
            Intrinsics.checkNotNullParameter(models, (String)"models");
            Builder $this$withCustomVideoInfoModels_u24lambda_u240 = builder = this;
            boolean bl = false;
            CollectionsKt.addAll((Collection)$this$withCustomVideoInfoModels_u24lambda_u240.customModels, (Object[])models);
            return builder;
        }

        @NotNull
        public final VideoService build() {
            return new VideoService(this);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u000f\u001a\u00020\u00102\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012\u00a2\u0006\u0002\b\u0015H\u0086\b\u00f8\u0001\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0016"}, d2={"Lcom/gapps/library/api/VideoService$Companion;", "", "<init>", "()V", "TAG", "", "videoInfoModelsList", "", "Lcom/gapps/library/api/models/api/base/VideoInfoModel;", "Lcom/gapps/library/api/models/video/base/BaseVideoResponse;", "getVideoInfoModelsList", "()Ljava/util/List;", "videoPatterns", "", "getVideoPatterns", "build", "Lcom/gapps/library/api/VideoService;", "block", "Lkotlin/Function1;", "Lcom/gapps/library/api/VideoService$Builder;", "", "Lkotlin/ExtensionFunctionType;", "embedded_video_lib_release"})
    @SourceDebugExtension(value={"SMAP\nVideoService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VideoService.kt\ncom/gapps/library/api/VideoService$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,168:1\n1563#2:169\n1634#2,3:170\n*S KotlinDebug\n*F\n+ 1 VideoService.kt\ncom/gapps/library/api/VideoService$Companion\n*L\n45#1:169\n45#1:170,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<VideoInfoModel<? extends BaseVideoResponse>> getVideoInfoModelsList() {
            return videoInfoModelsList;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> getVideoPatterns() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.getVideoInfoModelsList();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VideoInfoModel videoInfoModel = (VideoInfoModel)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getPattern());
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final VideoService build(@NotNull Function1<? super Builder, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean $i$f$build = false;
            Builder builder = new Builder();
            block.invoke((Object)builder);
            return builder.build();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

