/*
 * Decompiled with CFR 0.152.
 */
package com.gapps.library.api;

import android.content.Context;
import android.util.Log;
import com.gapps.library.api.models.api.base.VideoInfoModel;
import com.gapps.library.api.models.api.builder.EmbeddingRequest;
import com.gapps.library.api.models.video.VideoPreviewModel;
import com.gapps.library.api.models.video.base.BaseVideoResponse;
import com.gapps.library.cache.VideoModelORMKt;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.lang.reflect.Type;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJi\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152!\u0010\u0016\u001a\u001d\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u00130\u001726\u0010\u001c\u001a2\u0012\u0013\u0012\u00110\u001e\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001f\u0012\u0013\u0012\u00110\u001e\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b( \u0012\u0004\u0012\u00020\u00130\u001dJ.\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u001e2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0$H\u0002J\u001c\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\"2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/gapps/library/api/VideoLoadHelper;", "Lkotlinx/coroutines/CoroutineScope;", "context", "Landroid/content/Context;", "client", "Lokhttp3/OkHttpClient;", "isCacheEnabled", "", "isLogEnabled", "<init>", "(Landroid/content/Context;Lokhttp3/OkHttpClient;ZZ)V", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "getVideoInfo", "", "requestModel", "Lcom/gapps/library/api/models/api/builder/EmbeddingRequest;", "onSuccess", "Lkotlin/Function1;", "Lcom/gapps/library/api/models/video/VideoPreviewModel;", "Lkotlin/ParameterName;", "name", "resultModel", "onError", "Lkotlin/Function2;", "", "url", "message", "makeCallGetBody", "Lcom/google/gson/JsonElement;", "headers", "", "fromJson", "Lcom/gapps/library/api/models/video/base/BaseVideoResponse;", "json", "type", "Ljava/lang/reflect/Type;", "embedded_video_lib_release"})
public final class VideoLoadHelper
implements CoroutineScope {
    @Nullable
    private final Context context;
    @NotNull
    private final OkHttpClient client;
    private final boolean isCacheEnabled;
    private final boolean isLogEnabled;
    private final Gson gson;

    public VideoLoadHelper(@Nullable Context context, @NotNull OkHttpClient client, boolean isCacheEnabled, boolean isLogEnabled) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.context = context;
        this.client = client;
        this.isCacheEnabled = isCacheEnabled;
        this.isLogEnabled = isLogEnabled;
        this.gson = new GsonBuilder().setLenient().setPrettyPrinting().create();
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)Dispatchers.getMain());
    }

    public final void getVideoInfo(@NotNull EmbeddingRequest requestModel, @NotNull Function1<? super VideoPreviewModel, Unit> onSuccess, @NotNull Function2<? super String, ? super String, Unit> onError) {
        Intrinsics.checkNotNullParameter((Object)requestModel, (String)"requestModel");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        VideoInfoModel<?> videoInfoModel = requestModel.getVideoInfoModel();
        String originalUrl = requestModel.getOriginalUrl();
        Map<String, String> headers = requestModel.getRequestHeaders();
        if (videoInfoModel == null) {
            onError.invoke((Object)originalUrl, (Object)"Err 1. Unknown video service. \nPlease, visit https://github.com/TalbotGooday/Android-Oembed-Video for more information about available services");
            return;
        }
        String finalUrl = videoInfoModel.getInfoUrl(originalUrl);
        String videoId = videoInfoModel.parseVideoId(originalUrl);
        if (finalUrl == null || videoId == null) {
            onError.invoke((Object)originalUrl, (Object)"Err 3. Can't get oEmbed url");
            return;
        }
        String playLink = videoInfoModel.getPlayLink(videoId);
        BuildersKt.launch$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, playLink, onSuccess, originalUrl, onError, videoInfoModel, videoId, finalUrl, headers, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ VideoLoadHelper this$0;
            final /* synthetic */ String $playLink;
            final /* synthetic */ Function1<VideoPreviewModel, Unit> $onSuccess;
            final /* synthetic */ String $originalUrl;
            final /* synthetic */ Function2<String, String, Unit> $onError;
            final /* synthetic */ VideoInfoModel<?> $videoInfoModel;
            final /* synthetic */ String $videoId;
            final /* synthetic */ String $finalUrl;
            final /* synthetic */ Map<String, String> $headers;
            {
                this.this$0 = $receiver;
                this.$playLink = $playLink;
                this.$onSuccess = $onSuccess;
                this.$originalUrl = $originalUrl;
                this.$onError = $onError;
                this.$videoInfoModel = $videoInfoModel;
                this.$videoId = $videoId;
                this.$finalUrl = $finalUrl;
                this.$headers = $headers;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (!VideoLoadHelper.access$isCacheEnabled$p(this.this$0) || VideoLoadHelper.access$getContext$p(this.this$0) == null) ** GOTO lbl22
                        this.label = 1;
                        v0 = VideoModelORMKt.getCachedVideoModel(VideoLoadHelper.access$getContext$p(this.this$0), this.$playLink, (Continuation<? super VideoPreviewModel>)((Continuation)this));
                        ** if (v0 != var5_2) goto lbl12
lbl11:
                        // 1 sources

                        return var5_2;
lbl12:
                        // 1 sources

                        ** GOTO lbl18
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl18:
                        // 2 sources

                        if ((model = (VideoPreviewModel)v0) != null) {
                            this.$onSuccess.invoke((Object)model);
                            return Unit.INSTANCE;
                        }
lbl22:
                        // 3 sources

                        this.label = 2;
                        v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super JsonElement>, Object>(this.this$0, this.$finalUrl, this.$headers, null){
                            int label;
                            final /* synthetic */ VideoLoadHelper this$0;
                            final /* synthetic */ String $finalUrl;
                            final /* synthetic */ Map<String, String> $headers;
                            {
                                this.this$0 = $receiver;
                                this.$finalUrl = $finalUrl;
                                this.$headers = $headers;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        return VideoLoadHelper.access$makeCallGetBody(this.this$0, VideoLoadHelper.access$getClient$p(this.this$0), this.$finalUrl, this.$headers);
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super JsonElement> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        ** if (v1 != var5_2) goto lbl26
lbl25:
                        // 1 sources

                        return var5_2;
lbl26:
                        // 1 sources

                        ** GOTO lbl32
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl32:
                        // 2 sources

                        jsonBody = (JsonElement)v1;
                        if (VideoLoadHelper.access$isLogEnabled$p(this.this$0)) {
                            Log.i((String)"VideoService", (String)("a response from " + this.$originalUrl + ":\n" + VideoLoadHelper.access$getGson$p(this.this$0).toJson(jsonBody)));
                        }
                        if (jsonBody == null) {
                            this.$onError.invoke((Object)this.$originalUrl, (Object)"Err 2. Can't parse response \n---> Response is null");
                            return Unit.INSTANCE;
                        }
                        result = VideoLoadHelper.access$fromJson(this.this$0, jsonBody, this.$videoInfoModel.getType()).toPreview(this.$originalUrl, this.$playLink, this.$videoInfoModel.getHostingName(), this.$videoId);
                        this.$onSuccess.invoke((Object)result);
                        if (VideoLoadHelper.access$getContext$p(this.this$0) == null || !VideoLoadHelper.access$isCacheEnabled$p(this.this$0)) ** GOTO lbl69
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)jsonBody);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)result);
                        this.label = 3;
                        v2 = VideoModelORMKt.insertModel(VideoLoadHelper.access$getContext$p(this.this$0), result, (Continuation<? super Unit>)((Continuation)this));
                        ** if (v2 != var5_2) goto lbl52
lbl51:
                        // 1 sources

                        return var5_2;
lbl52:
                        // 1 sources

                        ** GOTO lbl69
                    }
                    case 3: {
                        result = (VideoPreviewModel)this.L$1;
                        jsonBody = (JsonElement)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
                            {
                                catch (Exception e) {
                                    this.$onError.invoke((Object)this.$originalUrl, (Object)("Err 2. Can't parse response\n---> " + e.getLocalizedMessage()));
                                }
                            }
                        }
                        catch (Exception e) {
                            this.$onError.invoke((Object)this.$originalUrl, (Object)"Err 3. Can't get oEmbed url");
                        }
lbl69:
                        // 5 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final JsonElement makeCallGetBody(OkHttpClient client, String url, Map<String, String> headers) {
        return (JsonElement)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super JsonElement>, Object>(url, headers, client, null){
            int label;
            final /* synthetic */ String $url;
            final /* synthetic */ Map<String, String> $headers;
            final /* synthetic */ OkHttpClient $client;
            {
                this.$url = $url;
                this.$headers = $headers;
                this.$client = $client;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Request.Builder requestBuilder = new Request.Builder().url(this.$url);
                        Iterable $this$forEach$iv = this.$headers.entrySet();
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            Map.Entry header = (Map.Entry)element$iv;
                            boolean bl = false;
                            requestBuilder.addHeader((String)header.getKey(), (String)header.getValue());
                        }
                        Response response = this.$client.newCall(requestBuilder.build()).execute();
                        Object object = response.body();
                        if (object == null || (object = object.string()) == null) {
                            return null;
                        }
                        Object stringBody = object;
                        JsonElement jsonObject = JsonParser.parseString((String)stringBody);
                        return jsonObject.isJsonArray() ? jsonObject.getAsJsonArray().get(0) : jsonObject;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super JsonElement> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private final BaseVideoResponse fromJson(JsonElement json, Type type) {
        Object object = this.gson.fromJson(json, type);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
        return (BaseVideoResponse)object;
    }

    public static final /* synthetic */ boolean access$isCacheEnabled$p(VideoLoadHelper $this) {
        return $this.isCacheEnabled;
    }

    public static final /* synthetic */ Context access$getContext$p(VideoLoadHelper $this) {
        return $this.context;
    }

    public static final /* synthetic */ JsonElement access$makeCallGetBody(VideoLoadHelper $this, OkHttpClient client, String url, Map headers) {
        return $this.makeCallGetBody(client, url, headers);
    }

    public static final /* synthetic */ OkHttpClient access$getClient$p(VideoLoadHelper $this) {
        return $this.client;
    }

    public static final /* synthetic */ boolean access$isLogEnabled$p(VideoLoadHelper $this) {
        return $this.isLogEnabled;
    }

    public static final /* synthetic */ Gson access$getGson$p(VideoLoadHelper $this) {
        return $this.gson;
    }

    public static final /* synthetic */ BaseVideoResponse access$fromJson(VideoLoadHelper $this, JsonElement json, Type type) {
        return $this.fromJson(json, type);
    }
}

