/*
 * Decompiled with CFR 0.152.
 */
package com.tr4android.support.extension.widget;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.support.v4.view.ViewCompat;
import android.view.View;
import android.view.animation.Interpolator;
import com.tr4android.support.extension.animation.AnimationUtils;

public class CollapsingDrawableHelper {
    private final View mView;
    private boolean mDrawIcon;
    private float mExpandedFraction;
    private final Rect mExpandedBounds;
    private final Rect mCollapsedBounds;
    private final RectF mCurrentBounds;
    private float mExpandedIconSize;
    private float mCollapsedIconSize;
    private Drawable mDrawable;
    private Interpolator mIconSizeInterpolator;
    private Interpolator mPositionInterpolator;

    public CollapsingDrawableHelper(View view) {
        this.mView = view;
        this.mCollapsedBounds = new Rect();
        this.mExpandedBounds = new Rect();
        this.mCurrentBounds = new RectF();
    }

    void setIconSizeInterpolator(Interpolator interpolator) {
        this.mIconSizeInterpolator = interpolator;
        this.recalculate();
    }

    void setExpandedIconSize(float iconSize) {
        if (this.mExpandedIconSize != iconSize) {
            this.mExpandedIconSize = iconSize;
            this.recalculate();
        }
    }

    void setCollapsedIconSize(float iconSize) {
        if (this.mCollapsedIconSize != iconSize) {
            this.mCollapsedIconSize = iconSize;
            this.recalculate();
        }
    }

    void setExpandedBounds(int left, int top, int right, int bottom) {
        if (!CollapsingDrawableHelper.rectEquals(this.mExpandedBounds, left, top, right, bottom)) {
            this.mExpandedBounds.set(left, top, right, bottom);
            this.onBoundsChanged();
        }
    }

    void setCollapsedBounds(int left, int top, int right, int bottom) {
        if (!CollapsingDrawableHelper.rectEquals(this.mCollapsedBounds, left, top, right, bottom)) {
            this.mCollapsedBounds.set(left, top, right, bottom);
            this.onBoundsChanged();
        }
    }

    void onBoundsChanged() {
        this.mDrawIcon = this.mCollapsedBounds.width() > 0 && this.mCollapsedBounds.height() > 0 && this.mExpandedBounds.width() > 0 && this.mExpandedBounds.height() > 0;
    }

    void setExpansionFraction(float fraction) {
        if ((fraction = CollapsingDrawableHelper.constrain(fraction, 0.0f, 1.0f)) != this.mExpandedFraction) {
            this.mExpandedFraction = fraction;
            this.calculateCurrentOffsets();
        }
    }

    float getExpansionFraction() {
        return this.mExpandedFraction;
    }

    float getCollapsedIconSize() {
        return this.mCollapsedIconSize;
    }

    float getExpandedIconSize() {
        return this.mExpandedIconSize;
    }

    private void calculateCurrentOffsets() {
        this.calculateOffsets(this.mExpandedFraction);
    }

    private void calculateOffsets(float fraction) {
        this.interpolateBounds(fraction);
        if (this.mDrawable != null) {
            this.mDrawable.setBounds(Math.round(this.mCurrentBounds.left), Math.round(this.mCurrentBounds.top), Math.round(this.mCurrentBounds.right), Math.round(this.mCurrentBounds.bottom));
        }
        ViewCompat.postInvalidateOnAnimation((View)this.mView);
    }

    private void interpolateBounds(float fraction) {
        this.mCurrentBounds.left = CollapsingDrawableHelper.lerp(this.mExpandedBounds.left, this.mCollapsedBounds.left, fraction, this.mPositionInterpolator);
        this.mCurrentBounds.top = CollapsingDrawableHelper.lerp(this.mExpandedBounds.top, this.mCollapsedBounds.top, fraction, this.mPositionInterpolator);
        this.mCurrentBounds.right = CollapsingDrawableHelper.lerp(this.mExpandedBounds.right, this.mCollapsedBounds.right, fraction, this.mPositionInterpolator);
        this.mCurrentBounds.bottom = CollapsingDrawableHelper.lerp(this.mExpandedBounds.bottom, this.mCollapsedBounds.bottom, fraction, this.mPositionInterpolator);
    }

    public void draw(Canvas canvas) {
        int saveCount = canvas.save();
        if (this.mDrawable != null && this.mDrawIcon) {
            this.mDrawable.draw(canvas);
        }
        canvas.restoreToCount(saveCount);
    }

    public void recalculate() {
        if (this.mView.getHeight() > 0 && this.mView.getWidth() > 0) {
            this.calculateCurrentOffsets();
        }
    }

    void setDrawable(Drawable drawable2) {
        if (drawable2 == null || !drawable2.equals(this.mDrawable)) {
            this.mDrawable = drawable2;
            this.recalculate();
        }
    }

    Drawable getDrawable() {
        return this.mDrawable;
    }

    private static float lerp(float startValue, float endValue, float fraction, Interpolator interpolator) {
        if (interpolator != null) {
            fraction = interpolator.getInterpolation(fraction);
        }
        return AnimationUtils.lerp(startValue, endValue, fraction);
    }

    private static boolean rectEquals(Rect r, int left, int top, int right, int bottom) {
        return r.left == left && r.top == top && r.right == right && r.bottom == bottom;
    }

    private static float constrain(float amount, float low, float high) {
        return amount < low ? low : (amount > high ? high : amount);
    }
}

