/*
 * Decompiled with CFR 0.152.
 */
package com.tr4android.support.extension.utils;

import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.view.ViewCompat;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;

public class ViewCompatUtils {
    public static int getPaddingStart(View view) {
        if (Build.VERSION.SDK_INT >= 17) {
            return view.getPaddingStart();
        }
        return view.getPaddingLeft();
    }

    public static int getPaddingEnd(View view) {
        if (Build.VERSION.SDK_INT >= 17) {
            return view.getPaddingEnd();
        }
        return view.getPaddingRight();
    }

    public static void setBackground(View view, Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground(drawable2);
        } else {
            view.setBackgroundDrawable(drawable2);
        }
    }

    public static void setTextAppearance(TextView view, int textAppearanceResId) {
        if (Build.VERSION.SDK_INT >= 23) {
            view.setTextAppearance(textAppearanceResId);
        } else {
            view.setTextAppearance(view.getContext(), textAppearanceResId);
        }
    }

    public static void announceForAccessibility(View view, CharSequence text) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.announceForAccessibility(text);
        }
    }

    public static boolean isLayoutRtl(View view) {
        return ViewCompat.getLayoutDirection((View)view) == 1;
    }

    public static int getRule(RelativeLayout.LayoutParams params, int verb) {
        if (Build.VERSION.SDK_INT >= 23) {
            return params.getRule(verb);
        }
        return params.getRules()[verb];
    }

    public static void removeRule(RelativeLayout.LayoutParams params, int verb) {
        if (Build.VERSION.SDK_INT >= 17) {
            params.removeRule(verb);
        } else {
            params.addRule(verb, 0);
        }
    }
}

