/*
 * Decompiled with CFR 0.152.
 */
package com.tr4android.support.extension.picker.date;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.TextView;
import android.widget.ViewAnimator;
import com.tr4android.appcompat.extension.R;
import com.tr4android.support.extension.picker.DateFormatUtils;
import com.tr4android.support.extension.picker.PickerThemeUtils;
import com.tr4android.support.extension.picker.date.AppCompatDatePicker;
import com.tr4android.support.extension.picker.date.DayPickerView;
import com.tr4android.support.extension.picker.date.YearPickerView;
import com.tr4android.support.extension.utils.ThemeUtils;
import com.tr4android.support.extension.utils.ViewCompatUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

class AppCompatDatePickerDelegate
extends AppCompatDatePicker.AbstractDatePickerDelegate {
    private static final int USE_LOCALE = 0;
    private static final int UNINITIALIZED = -1;
    private static final int VIEW_MONTH_DAY = 0;
    private static final int VIEW_YEAR = 1;
    private static final int DEFAULT_START_YEAR = 1900;
    private static final int DEFAULT_END_YEAR = 2100;
    private SimpleDateFormat mYearFormat;
    private SimpleDateFormat mMonthDayFormat;
    private ViewGroup mContainer;
    private TextView mHeaderYear;
    private TextView mHeaderMonthDay;
    private ViewAnimator mAnimator;
    private DayPickerView mDayPickerView;
    private YearPickerView mYearPickerView;
    private String mSelectDay;
    private String mSelectYear;
    private AppCompatDatePicker.OnDateChangedListener mDateChangedListener;
    private int mCurrentView = -1;
    private final Calendar mCurrentDate;
    private final Calendar mTempDate;
    private final Calendar mMinDate;
    private final Calendar mMaxDate;
    private int mFirstDayOfWeek = 0;
    private final DayPickerView.OnDaySelectedListener mOnDaySelectedListener = new DayPickerView.OnDaySelectedListener(){

        @Override
        public void onDaySelected(DayPickerView view, Calendar day) {
            AppCompatDatePickerDelegate.this.mCurrentDate.setTimeInMillis(day.getTimeInMillis());
            AppCompatDatePickerDelegate.this.onDateChanged(true, true);
        }
    };
    private final YearPickerView.OnYearSelectedListener mOnYearSelectedListener = new YearPickerView.OnYearSelectedListener(){

        @Override
        public void onYearChanged(YearPickerView view, int year) {
            int month;
            int daysInMonth;
            int day = AppCompatDatePickerDelegate.this.mCurrentDate.get(5);
            if (day > (daysInMonth = AppCompatDatePickerDelegate.getDaysInMonth(month = AppCompatDatePickerDelegate.this.mCurrentDate.get(2), year))) {
                AppCompatDatePickerDelegate.this.mCurrentDate.set(5, daysInMonth);
            }
            AppCompatDatePickerDelegate.this.mCurrentDate.set(1, year);
            AppCompatDatePickerDelegate.this.onDateChanged(true, true);
            AppCompatDatePickerDelegate.this.setCurrentView(0);
        }
    };
    private final View.OnClickListener mOnHeaderClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            AppCompatDatePickerDelegate.this.tryVibrate();
            int i = v.getId();
            if (i == R.id.date_picker_header_year) {
                AppCompatDatePickerDelegate.this.setCurrentView(1);
            } else if (i == R.id.date_picker_header_date) {
                AppCompatDatePickerDelegate.this.setCurrentView(0);
            }
        }
    };

    public AppCompatDatePickerDelegate(AppCompatDatePicker delegator, Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(delegator, context);
        Locale locale = this.mCurrentLocale;
        this.mCurrentDate = Calendar.getInstance(locale);
        this.mTempDate = Calendar.getInstance(locale);
        this.mMinDate = Calendar.getInstance(locale);
        this.mMaxDate = Calendar.getInstance(locale);
        this.mMinDate.set(1900, 0, 1);
        this.mMaxDate.set(2100, 11, 31);
        Resources res = this.mDelegator.getResources();
        TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.DatePickerDialog, defStyleAttr, defStyleRes);
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        this.mContainer = (ViewGroup)inflater.inflate(R.layout.date_picker_material, (ViewGroup)this.mDelegator, false);
        this.mDelegator.addView((View)this.mContainer);
        ViewGroup header = (ViewGroup)this.mContainer.findViewById(R.id.date_picker_header);
        this.mHeaderYear = (TextView)header.findViewById(R.id.date_picker_header_year);
        this.mHeaderYear.setOnClickListener(this.mOnHeaderClickListener);
        this.mHeaderMonthDay = (TextView)header.findViewById(R.id.date_picker_header_date);
        this.mHeaderMonthDay.setOnClickListener(this.mOnHeaderClickListener);
        ColorStateList headerTextColor = a.hasValue(R.styleable.DatePickerDialog_headerTextColor) ? a.getColorStateList(R.styleable.DatePickerDialog_headerTextColor) : PickerThemeUtils.getHeaderTextColorStateList(this.mContext);
        this.mHeaderYear.setTextColor(headerTextColor);
        this.mHeaderMonthDay.setTextColor(headerTextColor);
        ViewCompatUtils.setBackground((View)header, PickerThemeUtils.getHeaderBackground(this.mContext, a.getColor(R.styleable.DatePickerDialog_headerBackground, ThemeUtils.getThemeAttrColor(this.mContext, R.attr.colorAccent))));
        a.recycle();
        this.mAnimator = (ViewAnimator)this.mContainer.findViewById(R.id.animator);
        this.mDayPickerView = (DayPickerView)this.mAnimator.findViewById(R.id.date_picker_day_picker);
        this.mDayPickerView.setFirstDayOfWeek(this.mFirstDayOfWeek);
        this.mDayPickerView.setMinDate(this.mMinDate.getTimeInMillis());
        this.mDayPickerView.setMaxDate(this.mMaxDate.getTimeInMillis());
        this.mDayPickerView.setDate(this.mCurrentDate.getTimeInMillis());
        this.mDayPickerView.setOnDaySelectedListener(this.mOnDaySelectedListener);
        this.mYearPickerView = (YearPickerView)this.mAnimator.findViewById(R.id.date_picker_year_picker);
        this.mYearPickerView.setRange(this.mMinDate, this.mMaxDate);
        this.mYearPickerView.setDate(this.mCurrentDate.getTimeInMillis());
        this.mYearPickerView.setOnYearSelectedListener(this.mOnYearSelectedListener);
        this.mSelectDay = res.getString(R.string.select_day);
        this.mSelectYear = res.getString(R.string.select_year);
        this.onLocaleChanged(this.mCurrentLocale);
        this.setCurrentView(0);
    }

    @Override
    protected void onLocaleChanged(Locale locale) {
        TextView headerYear = this.mHeaderYear;
        if (headerYear == null) {
            return;
        }
        String datePattern = DateFormatUtils.getBestDateTimePattern(locale, "EMMMd");
        this.mMonthDayFormat = new SimpleDateFormat(datePattern, locale);
        this.mYearFormat = new SimpleDateFormat("y", locale);
        this.onCurrentDateChanged(false);
    }

    private void onCurrentDateChanged(boolean announce) {
        if (this.mHeaderYear == null) {
            return;
        }
        String year = this.mYearFormat.format(this.mCurrentDate.getTime());
        this.mHeaderYear.setText((CharSequence)year);
        String monthDay = DateFormatUtils.format(this.mMonthDayFormat, this.mCurrentDate);
        this.mHeaderMonthDay.setText((CharSequence)monthDay);
        if (announce) {
            long millis = this.mCurrentDate.getTimeInMillis();
            int flags = 20;
            String fullDateText = DateUtils.formatDateTime((Context)this.mContext, (long)millis, (int)20);
            ViewCompatUtils.announceForAccessibility((View)this.mAnimator, fullDateText);
        }
    }

    private void setCurrentView(int viewIndex) {
        switch (viewIndex) {
            case 0: {
                this.mDayPickerView.setDate(this.mCurrentDate.getTimeInMillis());
                if (this.mCurrentView != viewIndex) {
                    this.mHeaderMonthDay.setSelected(true);
                    this.mHeaderYear.setSelected(false);
                    this.mAnimator.setDisplayedChild(0);
                    this.mCurrentView = viewIndex;
                }
                ViewCompatUtils.announceForAccessibility((View)this.mAnimator, this.mSelectDay);
                break;
            }
            case 1: {
                this.mYearPickerView.setDate(this.mCurrentDate.getTimeInMillis());
                if (this.mCurrentView != viewIndex) {
                    this.mHeaderMonthDay.setSelected(false);
                    this.mHeaderYear.setSelected(true);
                    this.mAnimator.setDisplayedChild(1);
                    this.mCurrentView = viewIndex;
                }
                ViewCompatUtils.announceForAccessibility((View)this.mAnimator, this.mSelectYear);
            }
        }
    }

    @Override
    public void init(int year, int monthOfYear, int dayOfMonth, AppCompatDatePicker.OnDateChangedListener callBack) {
        this.mCurrentDate.set(1, year);
        this.mCurrentDate.set(2, monthOfYear);
        this.mCurrentDate.set(5, dayOfMonth);
        this.mDateChangedListener = callBack;
        this.onDateChanged(false, false);
    }

    @Override
    public void updateDate(int year, int month, int dayOfMonth) {
        this.mCurrentDate.set(1, year);
        this.mCurrentDate.set(2, month);
        this.mCurrentDate.set(5, dayOfMonth);
        this.onDateChanged(false, true);
    }

    private void onDateChanged(boolean fromUser, boolean callbackToClient) {
        int year = this.mCurrentDate.get(1);
        if (callbackToClient && this.mDateChangedListener != null) {
            int monthOfYear = this.mCurrentDate.get(2);
            int dayOfMonth = this.mCurrentDate.get(5);
            this.mDateChangedListener.onDateChanged(this.mDelegator, year, monthOfYear, dayOfMonth);
        }
        this.mDayPickerView.setDate(this.mCurrentDate.getTimeInMillis());
        this.mYearPickerView.setYear(year);
        this.onCurrentDateChanged(fromUser);
        if (fromUser) {
            this.tryVibrate();
        }
    }

    @Override
    public int getYear() {
        return this.mCurrentDate.get(1);
    }

    @Override
    public int getMonth() {
        return this.mCurrentDate.get(2);
    }

    @Override
    public int getDayOfMonth() {
        return this.mCurrentDate.get(5);
    }

    @Override
    public void setMinDate(long minDate) {
        this.mTempDate.setTimeInMillis(minDate);
        if (this.mTempDate.get(1) == this.mMinDate.get(1) && this.mTempDate.get(6) != this.mMinDate.get(6)) {
            return;
        }
        if (this.mCurrentDate.before(this.mTempDate)) {
            this.mCurrentDate.setTimeInMillis(minDate);
            this.onDateChanged(false, true);
        }
        this.mMinDate.setTimeInMillis(minDate);
        this.mDayPickerView.setMinDate(minDate);
        this.mYearPickerView.setRange(this.mMinDate, this.mMaxDate);
    }

    @Override
    public Calendar getMinDate() {
        return this.mMinDate;
    }

    @Override
    public void setMaxDate(long maxDate) {
        this.mTempDate.setTimeInMillis(maxDate);
        if (this.mTempDate.get(1) == this.mMaxDate.get(1) && this.mTempDate.get(6) != this.mMaxDate.get(6)) {
            return;
        }
        if (this.mCurrentDate.after(this.mTempDate)) {
            this.mCurrentDate.setTimeInMillis(maxDate);
            this.onDateChanged(false, true);
        }
        this.mMaxDate.setTimeInMillis(maxDate);
        this.mDayPickerView.setMaxDate(maxDate);
        this.mYearPickerView.setRange(this.mMinDate, this.mMaxDate);
    }

    @Override
    public Calendar getMaxDate() {
        return this.mMaxDate;
    }

    @Override
    public void setFirstDayOfWeek(int firstDayOfWeek) {
        this.mFirstDayOfWeek = firstDayOfWeek;
        this.mDayPickerView.setFirstDayOfWeek(firstDayOfWeek);
    }

    @Override
    public int getFirstDayOfWeek() {
        if (this.mFirstDayOfWeek != 0) {
            return this.mFirstDayOfWeek;
        }
        return this.mCurrentDate.getFirstDayOfWeek();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.mContainer.setEnabled(enabled);
        this.mDayPickerView.setEnabled(enabled);
        this.mYearPickerView.setEnabled(enabled);
        this.mHeaderYear.setEnabled(enabled);
        this.mHeaderMonthDay.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.mContainer.isEnabled();
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        this.setCurrentLocale(newConfig.locale);
    }

    @Override
    public Parcelable onSaveInstanceState(Parcelable superState) {
        int year = this.mCurrentDate.get(1);
        int month = this.mCurrentDate.get(2);
        int day = this.mCurrentDate.get(5);
        int listPosition = -1;
        int listPositionOffset = -1;
        if (this.mCurrentView == 0) {
            listPosition = this.mDayPickerView.getMostVisiblePosition();
        } else if (this.mCurrentView == 1) {
            listPosition = this.mYearPickerView.getFirstVisiblePosition();
            listPositionOffset = this.mYearPickerView.getFirstPositionOffset();
        }
        return new SavedState(superState, year, month, day, this.mMinDate.getTimeInMillis(), this.mMaxDate.getTimeInMillis(), this.mCurrentView, listPosition, listPositionOffset);
    }

    @Override
    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        this.mCurrentDate.set(ss.getSelectedYear(), ss.getSelectedMonth(), ss.getSelectedDay());
        this.mMinDate.setTimeInMillis(ss.getMinDate());
        this.mMaxDate.setTimeInMillis(ss.getMaxDate());
        this.onCurrentDateChanged(false);
        int currentView = ss.getCurrentView();
        this.setCurrentView(currentView);
        int listPosition = ss.getListPosition();
        if (listPosition != -1) {
            if (currentView == 0) {
                this.mDayPickerView.setPosition(listPosition);
            } else if (currentView == 1) {
                int listPositionOffset = ss.getListPositionOffset();
                this.mYearPickerView.setSelectionFromTop(listPosition, listPositionOffset);
            }
        }
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        this.onPopulateAccessibilityEvent(event);
        return true;
    }

    @Override
    public void onPopulateAccessibilityEvent(AccessibilityEvent event) {
        event.getText().add(this.mCurrentDate.getTime().toString());
    }

    public CharSequence getAccessibilityClassName() {
        return AppCompatDatePicker.class.getName();
    }

    public static int getDaysInMonth(int month, int year) {
        switch (month) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                return 31;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
            case 1: {
                return year % 4 == 0 ? 29 : 28;
            }
        }
        throw new IllegalArgumentException("Invalid Month");
    }

    private void tryVibrate() {
        this.mDelegator.performHapticFeedback(1);
    }

    private static class SavedState
    extends View.BaseSavedState {
        private final int mSelectedYear;
        private final int mSelectedMonth;
        private final int mSelectedDay;
        private final long mMinDate;
        private final long mMaxDate;
        private final int mCurrentView;
        private final int mListPosition;
        private final int mListPositionOffset;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        private SavedState(Parcelable superState, int year, int month, int day, long minDate, long maxDate, int currentView, int listPosition, int listPositionOffset) {
            super(superState);
            this.mSelectedYear = year;
            this.mSelectedMonth = month;
            this.mSelectedDay = day;
            this.mMinDate = minDate;
            this.mMaxDate = maxDate;
            this.mCurrentView = currentView;
            this.mListPosition = listPosition;
            this.mListPositionOffset = listPositionOffset;
        }

        private SavedState(Parcel in) {
            super(in);
            this.mSelectedYear = in.readInt();
            this.mSelectedMonth = in.readInt();
            this.mSelectedDay = in.readInt();
            this.mMinDate = in.readLong();
            this.mMaxDate = in.readLong();
            this.mCurrentView = in.readInt();
            this.mListPosition = in.readInt();
            this.mListPositionOffset = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mSelectedYear);
            dest.writeInt(this.mSelectedMonth);
            dest.writeInt(this.mSelectedDay);
            dest.writeLong(this.mMinDate);
            dest.writeLong(this.mMaxDate);
            dest.writeInt(this.mCurrentView);
            dest.writeInt(this.mListPosition);
            dest.writeInt(this.mListPositionOffset);
        }

        public int getSelectedDay() {
            return this.mSelectedDay;
        }

        public int getSelectedMonth() {
            return this.mSelectedMonth;
        }

        public int getSelectedYear() {
            return this.mSelectedYear;
        }

        public long getMinDate() {
            return this.mMinDate;
        }

        public long getMaxDate() {
            return this.mMaxDate;
        }

        public int getCurrentView() {
            return this.mCurrentView;
        }

        public int getListPosition() {
            return this.mListPosition;
        }

        public int getListPositionOffset() {
            return this.mListPositionOffset;
        }
    }
}

