/*
 * Decompiled with CFR 0.152.
 */
package com.tr4android.support.extension.picker;

import android.os.Build;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public class DateFormatUtils {
    public static String getBestDateTimePattern(Locale locale, String skeleton) {
        if (Build.VERSION.SDK_INT >= 18) {
            return DateFormat.getBestDateTimePattern((Locale)locale, (String)skeleton);
        }
        if (skeleton.equals("EMMMd")) {
            return "E, MMM d";
        }
        if (skeleton.equals("MMMMy")) {
            return "MMMM yyyy";
        }
        if (skeleton.equals("Hm")) {
            return "H:m";
        }
        if (skeleton.equals("hm")) {
            return "h:m";
        }
        return skeleton;
    }

    public static String formatDayOfWeek(SimpleDateFormat formatter, Calendar calendar) {
        if (Build.VERSION.SDK_INT >= 18) {
            return formatter.format(calendar.getTime());
        }
        int dayOfWeek = calendar.get(7);
        return DateUtils.getDayOfWeekString((int)(dayOfWeek == 0 ? 7 : dayOfWeek), (int)50);
    }

    public static String format(SimpleDateFormat formatter, Calendar calendar) {
        if (Build.VERSION.SDK_INT >= 18) {
            return formatter.format(calendar.getTime());
        }
        return DateFormat.format((CharSequence)formatter.toLocalizedPattern(), (Calendar)calendar).toString();
    }
}

