/*
 * Decompiled with CFR 0.152.
 */
package com.tr4android.support.extension.internal;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.widget.AppCompatDrawableManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.tr4android.appcompat.extension.R;
import com.tr4android.support.extension.internal.AccountUtils;
import com.tr4android.support.extension.internal.IAccount;
import com.tr4android.support.extension.utils.ThemeUtils;
import com.tr4android.support.extension.utils.ViewCompatUtils;
import com.tr4android.support.extension.widget.AccountHeaderView;
import com.tr4android.support.extension.widget.CircleImageView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AccountAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final int VIEW_TYPE_ACCOUNT = 0;
    private static final int VIEW_TYPE_HEADER = 1;
    private List<IAccount> mAccounts;
    private AccountHeaderView mHeader;
    private boolean mShowAccountAdd;
    private boolean mShowAccountManage;
    private boolean mShowCheckBoxes;
    private final View.OnClickListener mAccountClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            AccountAdapter.this.mHeader.handleAccountClick((Integer)view.getTag());
        }
    };
    private final CompoundButton.OnCheckedChangeListener mAccountCheckListener = new CompoundButton.OnCheckedChangeListener(){

        public void onCheckedChanged(CompoundButton view, boolean isChecked) {
            int position = (Integer)((View)view.getParent()).getTag();
            ((IAccount)AccountAdapter.this.mAccounts.get(position)).setChecked(isChecked);
            AccountAdapter.this.mHeader.handleAccountCheck(position, isChecked);
        }
    };

    public AccountAdapter(ArrayList<IAccount> accounts, AccountHeaderView header, boolean showAccountAdd, boolean showAccountManage, boolean showCheckBoxes) {
        this.mAccounts = accounts;
        this.mHeader = header;
        this.mShowAccountAdd = showAccountAdd;
        this.mShowAccountManage = showAccountManage;
        this.mShowCheckBoxes = showCheckBoxes;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        switch (viewType) {
            case 0: {
                AccountViewHolder holder = new AccountViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.appcompat_extension_account_list_item, parent, false));
                holder.itemView.setOnClickListener(this.mAccountClickListener);
                return holder;
            }
            case 1: {
                return new HeaderViewHolder((View)this.mHeader);
            }
        }
        return null;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (holder instanceof AccountViewHolder) {
            final AccountViewHolder accountViewHolder = (AccountViewHolder)holder;
            holder.itemView.setTag((Object)position);
            if (position < this.getAccountCount()) {
                IAccount account = this.mAccounts.get(position);
                if (this.mShowCheckBoxes) {
                    accountViewHolder.checkView.setOnCheckedChangeListener(null);
                    accountViewHolder.checkView.setChecked(account.isChecked());
                    accountViewHolder.checkView.setOnCheckedChangeListener(this.mAccountCheckListener);
                    accountViewHolder.checkView.setVisibility(0);
                    accountViewHolder.iconView.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            accountViewHolder.checkView.toggle();
                        }
                    });
                }
                AccountUtils.applyAccountIcon(account, accountViewHolder.iconView);
                AccountUtils.applyAccountListTitle(account, accountViewHolder.nameView);
                AccountUtils.applyAccountInfo(account, (ViewGroup)accountViewHolder.infoLayout, accountViewHolder.infoIconView, accountViewHolder.infoTextView);
            } else if (position == this.getItemCount() - 1 && this.mShowAccountManage) {
                accountViewHolder.iconView.setCircleImageEnabled(false);
                accountViewHolder.checkView.setVisibility(8);
                accountViewHolder.iconView.setImageResource(R.drawable.ic_settings_black_24dp);
                accountViewHolder.nameView.setText(R.string.account_header_list_item_manage_accounts);
                accountViewHolder.infoLayout.setVisibility(8);
            } else {
                accountViewHolder.iconView.setCircleImageEnabled(false);
                accountViewHolder.checkView.setVisibility(8);
                accountViewHolder.iconView.setImageResource(R.drawable.ic_add_black_24dp);
                accountViewHolder.nameView.setText(R.string.account_header_list_item_add_account);
                accountViewHolder.infoLayout.setVisibility(8);
            }
        }
    }

    public int getItemCount() {
        return this.mAccounts.size() + (this.mShowAccountAdd ? 1 : 0) + (this.mShowAccountManage ? 1 : 0);
    }

    public int getItemViewType(int position) {
        return position == 0 ? 1 : 0;
    }

    private static void setupCheckBox(CheckBox checkBox) {
        if (Build.VERSION.SDK_INT >= 21) {
            checkBox.setButtonDrawable(R.drawable.btn_checkbox_circle);
            checkBox.setBackgroundResource(R.drawable.btn_checkbox_circle_background);
        } else {
            Context context = checkBox.getContext();
            AppCompatDrawableManager dm = AppCompatDrawableManager.get();
            StateListDrawable button = new StateListDrawable();
            button.addState(new int[]{0x10100A0}, dm.getDrawable(context, R.drawable.ic_checkbox_circle_checked));
            button.addState(new int[0], dm.getDrawable(context, R.drawable.ic_checkbox_circle_unchecked));
            ColorStateList buttonTint = new ColorStateList((int[][])new int[][]{{0x10100A0}, new int[0]}, new int[]{ThemeUtils.getThemeAttrColor(context, R.attr.colorControlActivated), ThemeUtils.getThemeAttrColor(context, R.attr.colorControlNormal)});
            Drawable buttonCompat = DrawableCompat.wrap((Drawable)button);
            DrawableCompat.setTintList((Drawable)buttonCompat, (ColorStateList)buttonTint);
            checkBox.setButtonDrawable(buttonCompat);
            ShapeDrawable background = new ShapeDrawable((Shape)new OvalShape());
            int backgroundTint = ThemeUtils.getThemeAttrColor(context, 0x1010031);
            Drawable backgroundCompat = DrawableCompat.wrap((Drawable)background);
            DrawableCompat.setTint((Drawable)backgroundCompat, (int)backgroundTint);
            ViewCompatUtils.setBackground((View)checkBox, backgroundCompat);
        }
    }

    public int getAccountCount() {
        return this.mAccounts.size();
    }

    public boolean isAccountAddEnabled() {
        return this.mShowAccountAdd;
    }

    public boolean isAccountManageEnabled() {
        return this.mShowAccountManage;
    }

    public void add(IAccount account) {
        this.mAccounts.add(account);
    }

    public void addAll(IAccount ... accounts) {
        this.mAccounts.addAll(Arrays.asList(accounts));
    }

    public void remove(IAccount account) {
        int index = this.indexOf(account);
        this.mAccounts.remove(index);
    }

    public void insert(IAccount account, int position) {
        this.mAccounts.add(position, account);
    }

    public void clear() {
        this.mAccounts.clear();
    }

    public void move(IAccount account, int position) {
        int index = this.indexOf(account);
        this.mAccounts.remove(index);
        this.mAccounts.add(position, account);
    }

    public int indexOf(IAccount account) {
        return this.mAccounts.indexOf(account);
    }

    public IAccount get(int position) {
        return this.mAccounts.get(position);
    }

    @Deprecated
    public List<IAccount> getAll() {
        return this.getAccounts();
    }

    public List<IAccount> getAccounts() {
        return this.mAccounts;
    }

    public void setAccounts(List<IAccount> accounts) {
        this.mAccounts = accounts;
    }

    public void setChecked(int position, boolean checked) {
        this.mAccounts.get(position).setChecked(checked);
    }

    public boolean isChecked(int position) {
        return position == 0 || this.mAccounts.get(position).isChecked();
    }

    public ArrayList<IAccount> getChecked() {
        int size = this.mAccounts.size();
        ArrayList<IAccount> checked = new ArrayList<IAccount>(size);
        for (int i = 0; i < size; ++i) {
            if (!this.isChecked(i)) continue;
            checked.add(this.mAccounts.get(i));
        }
        return checked;
    }

    private static class HeaderViewHolder
    extends RecyclerView.ViewHolder {
        public HeaderViewHolder(View itemView) {
            super(itemView);
        }
    }

    private static class AccountViewHolder
    extends RecyclerView.ViewHolder {
        CircleImageView iconView;
        CheckBox checkView;
        TextView nameView;
        LinearLayout infoLayout;
        ImageView infoIconView;
        TextView infoTextView;

        public AccountViewHolder(View itemView) {
            super(itemView);
            this.iconView = (CircleImageView)itemView.findViewById(R.id.icon);
            this.checkView = (CheckBox)itemView.findViewById(R.id.checkbox);
            this.nameView = (TextView)itemView.findViewById(R.id.name);
            this.infoLayout = (LinearLayout)itemView.findViewById(R.id.info_layout);
            this.infoIconView = (ImageView)itemView.findViewById(R.id.info_icon);
            this.infoTextView = (TextView)itemView.findViewById(R.id.info_text);
            AccountAdapter.setupCheckBox(this.checkView);
        }
    }
}

