/*
 * Decompiled with CFR 0.152.
 */
package com.tr4android.support.extension.drawable;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.StringRes;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.widget.AppCompatDrawableManager;
import com.tr4android.appcompat.extension.R;
import com.tr4android.support.extension.utils.ThemeUtils;

public class PlaceholderDrawable
extends Drawable {
    private Paint mPlaceholderCirclePaint;
    private Paint mPlaceholderTextPaint;
    private int mPlaceholderImageSize;
    private int mPlaceholderImageColor;
    private Drawable mPlaceholderImage;
    private String mPlaceholderText = "";

    public PlaceholderDrawable(int placeholderTextSize, int placeholderTextColor, int placeholderImageSize, int placeholerImageColor) {
        this.mPlaceholderImageSize = placeholderImageSize;
        this.mPlaceholderImageColor = placeholerImageColor;
        this.mPlaceholderCirclePaint = new Paint(1);
        this.mPlaceholderTextPaint = new Paint(1);
        this.mPlaceholderTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mPlaceholderTextPaint.setTextSize((float)placeholderTextSize);
        this.mPlaceholderTextPaint.setColor(placeholderTextColor);
    }

    public void setPlaceholder(String placeholderText, @ColorInt int circleColor) {
        this.mPlaceholderImage = null;
        this.mPlaceholderText = placeholderText;
        this.mPlaceholderCirclePaint.setColor(circleColor);
    }

    public void setPlaceholder(Drawable drawable, @ColorInt int circleColor) {
        this.mPlaceholderImage = this.tintDrawable(drawable, this.mPlaceholderImageColor);
        this.mPlaceholderText = "";
        this.mPlaceholderCirclePaint.setColor(circleColor);
    }

    public void draw(Canvas canvas) {
        Rect bounds = this.getBounds();
        float radius = (float)Math.min(bounds.width(), bounds.height()) / 2.0f;
        float xPos = (float)bounds.left + (float)bounds.width() / 2.0f;
        canvas.drawCircle(xPos, (float)bounds.top + (float)bounds.height() / 2.0f, radius, this.mPlaceholderCirclePaint);
        if (this.mPlaceholderImage == null) {
            float yPos = (float)bounds.top + (float)bounds.height() / 2.0f - (this.mPlaceholderTextPaint.descent() + this.mPlaceholderTextPaint.ascent()) / 2.0f;
            canvas.drawText(this.mPlaceholderText, xPos, yPos, this.mPlaceholderTextPaint);
        } else {
            int horizontalPadding = (bounds.width() - this.mPlaceholderImageSize) / 2;
            int verticalPadding = (bounds.height() - this.mPlaceholderImageSize) / 2;
            this.mPlaceholderImage.setBounds(bounds.left + horizontalPadding, bounds.top + verticalPadding, bounds.right - horizontalPadding, bounds.bottom - verticalPadding);
            this.mPlaceholderImage.draw(canvas);
        }
    }

    public void setAlpha(int i) {
        this.mPlaceholderCirclePaint.setAlpha(i);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.mPlaceholderCirclePaint.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return -3;
    }

    private Drawable tintDrawable(Drawable drawable, @ColorInt int color) {
        Drawable tintDrawable = DrawableCompat.wrap((Drawable)drawable.mutate());
        DrawableCompat.setTint((Drawable)tintDrawable, (int)color);
        return tintDrawable;
    }

    public static class Builder {
        Context mContext;
        int mPlaceholderTextSize;
        int mPlaceholderTextColor;
        int mPlaceholderImageSize;
        int mPlaceholderImageColor;
        int mPlaceholderCircleColor;
        String mPlaceholderString = "";
        Drawable mPlaceholderDrawable = null;

        public Builder(Context context) {
            this.mContext = context;
            this.mPlaceholderTextSize = context.getResources().getDimensionPixelSize(R.dimen.defaultPlaceholderTextSize);
            this.mPlaceholderTextColor = ThemeUtils.getThemeAttrColor(context, 16842809);
            this.mPlaceholderImageSize = context.getResources().getDimensionPixelSize(R.dimen.defaultPlaceholderImageSize);
            this.mPlaceholderImageColor = ThemeUtils.getThemeAttrColor(context, 16842809);
            this.mPlaceholderCircleColor = ThemeUtils.getThemeAttrColor(context, R.attr.colorAccent);
        }

        public Builder setPlaceholderTextSize(int textSize) {
            this.mPlaceholderTextSize = textSize;
            return this;
        }

        public Builder setPlaceholderTextColor(@ColorInt int color) {
            this.mPlaceholderTextColor = color;
            return this;
        }

        public Builder setPlaceholderImageSize(int imageSize) {
            this.mPlaceholderImageSize = imageSize;
            return this;
        }

        public Builder setPlaceholderImageColor(@ColorInt int color) {
            this.mPlaceholderImageColor = color;
            return this;
        }

        public Builder setPlaceholderCircleColor(@ColorInt int color) {
            this.mPlaceholderCircleColor = color;
            return this;
        }

        public Builder setPlaceholderText(@StringRes int resid) {
            return this.setPlaceholderText(this.mContext.getResources().getString(resid));
        }

        public Builder setPlaceholderText(String string) {
            this.mPlaceholderString = string;
            this.mPlaceholderDrawable = null;
            return this;
        }

        public Builder setPlaceholderImage(@DrawableRes int resId) {
            return this.setPlaceholderImage(AppCompatDrawableManager.get().getDrawable(this.mContext, resId));
        }

        public Builder setPlaceholderImage(Drawable drawable) {
            this.mPlaceholderDrawable = drawable;
            this.mPlaceholderString = "";
            return this;
        }

        public PlaceholderDrawable build() {
            PlaceholderDrawable drawable = new PlaceholderDrawable(this.mPlaceholderTextSize, this.mPlaceholderTextColor, this.mPlaceholderImageSize, this.mPlaceholderImageColor);
            if (this.mPlaceholderDrawable == null) {
                drawable.setPlaceholder(this.mPlaceholderString, this.mPlaceholderCircleColor);
            } else {
                drawable.setPlaceholder(this.mPlaceholderDrawable, this.mPlaceholderCircleColor);
            }
            return drawable;
        }
    }
}

