/*
 * Decompiled with CFR 0.152.
 */
package com.tr4android.support.extension.drawable;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.view.animation.Interpolator;
import com.tr4android.support.extension.animation.AnimationUtils;
import com.tr4android.support.extension.animation.ValueAnimatorCompat;

public class MediaControlDrawable
extends Drawable {
    private static final String TAG = "Media Control";
    private State mCurrentState = State.PLAY;
    private State mTargetState = State.PLAY;
    private Paint mPaint = new Paint(1);
    private float mPadding = 0.0f;
    private RectF mInternalBounds = new RectF();
    private float mRotation;
    private Path mPrimaryPath = new Path();
    private Path mSecondaryPath = new Path();
    private float mCenter;
    private float mSize;
    private float mPlayTipOffset;
    private float mPlayBaseOffset;
    private ValueAnimatorCompat mAnimator;

    public MediaControlDrawable(Context context, @ColorInt int color, float padding, State state, Interpolator interpolator, int duration) {
        this.mPadding = padding;
        this.mCurrentState = state;
        this.mTargetState = state;
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(color);
        this.mAnimator = AnimationUtils.createAnimator();
        this.mAnimator.setFloatValues(0.0f, 90.0f);
        this.mAnimator.setDuration(duration);
        this.mAnimator.setInterpolator(interpolator);
        this.mAnimator.setUpdateListener(new ValueAnimatorCompat.AnimatorUpdateListener(){

            @Override
            public void onAnimationUpdate(ValueAnimatorCompat animator) {
                MediaControlDrawable.this.setTransitionState(animator.getAnimatedFloatValue(), animator.getAnimatedFraction());
            }
        });
        this.mAnimator.setListener(new ValueAnimatorCompat.AnimatorListener(){

            @Override
            public void onAnimationStart(ValueAnimatorCompat animator) {
            }

            @Override
            public void onAnimationEnd(ValueAnimatorCompat animator) {
                MediaControlDrawable.this.mCurrentState = MediaControlDrawable.this.mTargetState;
                MediaControlDrawable.this.setTransitionState(0.0f, 0.0f);
            }

            @Override
            public void onAnimationCancel(ValueAnimatorCompat animator) {
            }

            @Override
            public void onAnimationRepeat(ValueAnimatorCompat animator) {
            }
        });
    }

    public void draw(Canvas canvas) {
        Rect bounds = this.getBounds();
        int saveCount = canvas.save();
        canvas.rotate(this.mRotation, (float)bounds.centerX(), (float)bounds.centerY());
        canvas.drawPath(this.mPrimaryPath, this.mPaint);
        canvas.drawPath(this.mSecondaryPath, this.mPaint);
        canvas.restoreToCount(saveCount);
    }

    public void setBounds(Rect bounds) {
        this.calculateTrimArea(bounds);
        super.setBounds(bounds);
    }

    public void setBounds(int left, int top, int right, int bottom) {
        this.calculateTrimArea(new Rect(left, top, right, bottom));
        super.setBounds(left, top, right, bottom);
    }

    public void setAlpha(int i) {
        this.mPaint.setAlpha(i);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return -3;
    }

    private void setTransitionState(float rotation, float fraction) {
        if (this.mCurrentState == this.mTargetState) {
            fraction = 0.0f;
            rotation = 0.0f;
        }
        this.mRotation = rotation;
        this.mPrimaryPath.reset();
        this.mSecondaryPath.reset();
        if (this.mCurrentState == State.PLAY && (this.mTargetState == State.STOP || this.mTargetState == State.PLAY)) {
            float offset = (1.0f - fraction) * this.mPlayTipOffset;
            float offsetBase = (1.0f - fraction) * this.mPlayBaseOffset;
            this.mPrimaryPath.moveTo(this.mInternalBounds.right + offset, this.interpolate(this.mCenter, this.mInternalBounds.bottom, fraction));
            this.mPrimaryPath.lineTo(this.mInternalBounds.left + offset, this.mInternalBounds.bottom + offsetBase);
            this.mPrimaryPath.lineTo(this.mInternalBounds.left + offset, this.interpolate(this.mCenter, this.mInternalBounds.top, fraction));
            this.mPrimaryPath.lineTo(this.interpolate(this.mInternalBounds.left, this.mInternalBounds.right, fraction) + offset, this.mInternalBounds.top - offsetBase);
        } else if (this.mCurrentState == State.STOP && this.mTargetState == State.PAUSE) {
            float primaryBottom = this.mCenter - fraction * 3.0f / 20.0f * this.mSize;
            float secondaryTop = this.mCenter + fraction * 3.0f / 20.0f * this.mSize;
            this.mPrimaryPath.moveTo(this.mInternalBounds.right, this.mInternalBounds.top);
            this.mPrimaryPath.lineTo(this.mInternalBounds.right, primaryBottom);
            this.mPrimaryPath.lineTo(this.mInternalBounds.left, primaryBottom);
            this.mPrimaryPath.lineTo(this.mInternalBounds.left, this.mInternalBounds.top);
            this.mSecondaryPath.moveTo(this.mInternalBounds.right, this.mInternalBounds.bottom);
            this.mSecondaryPath.lineTo(this.mInternalBounds.right, secondaryTop);
            this.mSecondaryPath.lineTo(this.mInternalBounds.left, secondaryTop);
            this.mSecondaryPath.lineTo(this.mInternalBounds.left, this.mInternalBounds.bottom);
        } else if (this.mCurrentState == State.PAUSE && this.mTargetState == State.PLAY) {
            float offset = fraction * this.mPlayTipOffset;
            float offsetBase = fraction * this.mPlayBaseOffset;
            if (fraction < 0.5f) {
                float primaryRight = this.mCenter - (-2.0f * fraction + 1.0f) * 3.0f / 20.0f * this.mSize;
                float primaryBottomLeft = this.mInternalBounds.left + fraction * (this.mSize / 2.0f);
                float secondaryLeft = this.mCenter + (-2.0f * fraction + 1.0f) * 3.0f / 20.0f * this.mSize;
                float secondaryBottomRight = this.mInternalBounds.right - fraction * (this.mSize / 2.0f);
                this.mPrimaryPath.moveTo(this.mInternalBounds.left - offsetBase, this.mInternalBounds.bottom - offset);
                this.mPrimaryPath.lineTo(primaryRight, this.mInternalBounds.bottom - offset);
                this.mPrimaryPath.lineTo(primaryRight, this.mInternalBounds.top - offset);
                this.mPrimaryPath.lineTo(primaryBottomLeft, this.mInternalBounds.top - offset);
                this.mSecondaryPath.moveTo(this.mInternalBounds.right + offsetBase, this.mInternalBounds.bottom - offset);
                this.mSecondaryPath.lineTo(secondaryLeft, this.mInternalBounds.bottom - offset);
                this.mSecondaryPath.lineTo(secondaryLeft, this.mInternalBounds.top - offset);
                this.mSecondaryPath.lineTo(secondaryBottomRight, this.mInternalBounds.top - offset);
            } else {
                float primaryBottomLeft = this.mInternalBounds.left + fraction * (this.mSize / 2.0f);
                float secondaryBottomRight = this.mInternalBounds.right - fraction * (this.mSize / 2.0f);
                this.mPrimaryPath.moveTo(this.mInternalBounds.left - offsetBase, this.mInternalBounds.bottom - offset);
                this.mPrimaryPath.lineTo(primaryBottomLeft, this.mInternalBounds.top - offset);
                this.mPrimaryPath.lineTo(secondaryBottomRight, this.mInternalBounds.top - offset);
                this.mPrimaryPath.lineTo(this.mInternalBounds.right + offsetBase, this.mInternalBounds.bottom - offset);
            }
        } else if (this.mCurrentState == State.PLAY && this.mTargetState == State.PAUSE) {
            float offset = (1.0f - fraction) * this.mPlayTipOffset;
            float offsetBase = (1.0f - fraction) * this.mPlayBaseOffset;
            if (fraction > 0.5f) {
                float primaryBottom = this.mCenter - (2.0f * fraction - 1.0f) * 3.0f / 20.0f * this.mSize;
                float primaryLeftTop = this.mInternalBounds.left + (1.0f - fraction) * (this.mSize / 2.0f);
                float secondaryTop = this.mCenter + (2.0f * fraction - 1.0f) * 3.0f / 20.0f * this.mSize;
                float secondaryLeftBottom = this.mInternalBounds.right - (1.0f - fraction) * (this.mSize / 2.0f);
                this.mPrimaryPath.moveTo(this.mInternalBounds.left + offset, this.mInternalBounds.top - offsetBase);
                this.mPrimaryPath.lineTo(this.mInternalBounds.left + offset, primaryBottom);
                this.mPrimaryPath.lineTo(this.mInternalBounds.right + offset, primaryBottom);
                this.mPrimaryPath.lineTo(this.mInternalBounds.right + offset, primaryLeftTop);
                this.mSecondaryPath.moveTo(this.mInternalBounds.left + offset, this.mInternalBounds.bottom + offsetBase);
                this.mSecondaryPath.lineTo(this.mInternalBounds.left + offset, secondaryTop);
                this.mSecondaryPath.lineTo(this.mInternalBounds.right + offset, secondaryTop);
                this.mSecondaryPath.lineTo(this.mInternalBounds.right + offset, secondaryLeftBottom);
            } else {
                float primaryLeftTop = this.mInternalBounds.left + (1.0f - fraction) * (this.mSize / 2.0f);
                float secondaryLeftBottom = this.mInternalBounds.right - (1.0f - fraction) * (this.mSize / 2.0f);
                this.mPrimaryPath.moveTo(this.mInternalBounds.left + offset, this.mInternalBounds.top - offsetBase);
                this.mPrimaryPath.lineTo(this.mInternalBounds.right + offset, primaryLeftTop);
                this.mPrimaryPath.lineTo(this.mInternalBounds.right + offset, secondaryLeftBottom);
                this.mPrimaryPath.lineTo(this.mInternalBounds.left + offset, this.mInternalBounds.bottom + offsetBase);
            }
        } else if (this.mCurrentState == State.PAUSE && (this.mTargetState == State.STOP || this.mTargetState == State.PAUSE)) {
            float primaryRight = this.mCenter - (1.0f - fraction) * 3.0f / 20.0f * this.mSize;
            float secondaryLeft = this.mCenter + (1.0f - fraction) * 3.0f / 20.0f * this.mSize;
            this.mPrimaryPath.moveTo(this.mInternalBounds.left, this.mInternalBounds.top);
            this.mPrimaryPath.lineTo(primaryRight, this.mInternalBounds.top);
            this.mPrimaryPath.lineTo(primaryRight, this.mInternalBounds.bottom);
            this.mPrimaryPath.lineTo(this.mInternalBounds.left, this.mInternalBounds.bottom);
            this.mSecondaryPath.moveTo(this.mInternalBounds.right, this.mInternalBounds.top);
            this.mSecondaryPath.lineTo(secondaryLeft, this.mInternalBounds.top);
            this.mSecondaryPath.lineTo(secondaryLeft, this.mInternalBounds.bottom);
            this.mSecondaryPath.lineTo(this.mInternalBounds.right, this.mInternalBounds.bottom);
        } else if (this.mCurrentState == State.STOP && (this.mTargetState == State.PLAY || this.mTargetState == State.STOP)) {
            float offset = fraction * this.mPlayTipOffset;
            float offsetBase = fraction * this.mPlayBaseOffset;
            this.mPrimaryPath.moveTo(this.interpolate(this.mInternalBounds.left, this.mCenter, fraction), this.mInternalBounds.top - offset);
            this.mPrimaryPath.lineTo(this.mInternalBounds.left - offsetBase, this.mInternalBounds.bottom - offset);
            this.mPrimaryPath.lineTo(this.interpolate(this.mInternalBounds.right, this.mCenter, fraction), this.mInternalBounds.bottom - offset);
            this.mPrimaryPath.lineTo(this.mInternalBounds.right + offsetBase, this.interpolate(this.mInternalBounds.top, this.mInternalBounds.bottom, fraction) - offset);
        }
        this.invalidateSelf();
    }

    private void calculateTrimArea(Rect bounds) {
        float size = Math.min(bounds.height(), bounds.width());
        float yOffset = ((float)bounds.height() - size) / 2.0f;
        float xOffset = ((float)bounds.width() - size) / 2.0f;
        float padding = this.mPadding + ((float)bounds.height() - 2.0f * this.mPadding) * 1.0f / 6.0f;
        this.mInternalBounds.set((float)bounds.left + padding + xOffset, (float)bounds.top + padding + yOffset, (float)bounds.right - padding - xOffset, (float)bounds.bottom - padding - yOffset);
        this.mCenter = this.mInternalBounds.centerX();
        this.mSize = this.mInternalBounds.width();
        this.mPlayTipOffset = 0.16666667f * this.mSize;
        this.mPlayBaseOffset = 0.07735f * this.mSize;
        this.setTransitionState(0.0f, 0.0f);
    }

    private float interpolate(float start, float end, float fraction) {
        return (1.0f - fraction) * start + fraction * end;
    }

    public void setMediaControlState(State state) {
        if (this.mAnimator.isRunning()) {
            this.mAnimator.end();
        }
        this.mTargetState = state;
        this.mAnimator.start();
    }

    public State getMediaControlState() {
        return this.mCurrentState;
    }

    public static class Builder {
        private Context mContext;
        private int mColor;
        private float mPadding;
        private State mInitialState;
        private Interpolator mAnimationInterpolator;
        private int mAnimationDuration;

        public Builder(Context context) {
            this.mContext = context;
            this.mColor = -1;
            this.mPadding = 0.0f;
            this.mInitialState = State.PLAY;
            this.mAnimationInterpolator = AnimationUtils.ACCELERATE_DECELERATE_INTERPOLATOR;
            this.mAnimationDuration = 500;
        }

        public Builder setColor(@ColorInt int color) {
            this.mColor = color;
            return this;
        }

        public Builder setPadding(float padding) {
            this.mPadding = padding;
            return this;
        }

        public Builder setInitialState(State initialState) {
            this.mInitialState = initialState;
            return this;
        }

        public Builder setAnimationInterpolator(Interpolator interpolator) {
            this.mAnimationInterpolator = interpolator;
            return this;
        }

        public Builder setAnimationDuration(int duration) {
            this.mAnimationDuration = duration;
            return this;
        }

        public MediaControlDrawable build() {
            return new MediaControlDrawable(this.mContext, this.mColor, this.mPadding, this.mInitialState, this.mAnimationInterpolator, this.mAnimationDuration);
        }
    }

    public static enum State {
        PLAY,
        PAUSE,
        STOP;

    }
}

