/*
 * Decompiled with CFR 0.152.
 */
package com.github.sumimakito.awesomeqr;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.Encoder;
import com.google.zxing.qrcode.encoder.QRCode;
import java.util.Hashtable;

public class AwesomeQRCode {
    private static final int BYTE_EPT = 0;
    private static final int BYTE_DTA = 1;
    private static final int BYTE_POS = 2;
    private static final int BYTE_AGN = 3;
    private static final int BYTE_TMG = 4;
    private static final int BYTE_PTC = 5;
    private static float DEFAULT_DTA_DOT_SCALE = 0.3f;
    private static float DEFAULT_LOGO_SCALE = 0.2f;
    private static int DEFAULT_SIZE = 800;
    private static int DEFAULT_MARGIN = 20;
    private static int DEFAULT_LOGO_MARGIN = 10;
    private static int DEFAULT_LOGO_RADIUS = 8;
    private static int DEFAULT_BINARIZING_THRESHOLD = 128;

    private static Bitmap create(String contents, int size, int margin, float dataDotScale, int colorDark, int colorLight, Bitmap backgroundImage, boolean whiteMargin, boolean autoColor, boolean binarize, int binarizeThreshold, boolean roundedDataDots, Bitmap logoImage, int logoMargin, int logoCornerRadius, float logoScale) throws IllegalArgumentException {
        if (contents.isEmpty()) {
            throw new IllegalArgumentException("Error: contents is empty. (contents.isEmpty())");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Error: a negative size is given. (size < 0)");
        }
        if (margin < 0) {
            throw new IllegalArgumentException("Error: a negative margin is given. (margin < 0)");
        }
        if (size - 2 * margin <= 0) {
            throw new IllegalArgumentException("Error: there is no space left for the QRCode. (size - 2 * margin <= 0)");
        }
        ByteMatrix byteMatrix = AwesomeQRCode.getBitMatrix(contents);
        if (size - 2 * margin < byteMatrix.getWidth()) {
            throw new IllegalArgumentException("Error: there is no space left for the QRCode. (size - 2 * margin < " + byteMatrix.getWidth() + ")");
        }
        if (dataDotScale < 0.0f || dataDotScale > 1.0f) {
            throw new IllegalArgumentException("Error: an illegal data dot scale is given. (dataDotScale < 0 || dataDotScale > 1)");
        }
        return AwesomeQRCode.render(byteMatrix, size - 2 * margin, margin, dataDotScale, colorDark, colorLight, backgroundImage, whiteMargin, autoColor, binarize, binarizeThreshold, roundedDataDots, logoImage, logoMargin, logoCornerRadius, logoScale);
    }

    private static Bitmap render(ByteMatrix byteMatrix, int innerRenderedSize, int margin, float dataDotScale, int colorDark, int colorLight, Bitmap backgroundImage, boolean whiteMargin, boolean autoColor, boolean binarize, int binarizeThreshold, boolean roundedDataDots, Bitmap logoImage, int logoMargin, int logoCornerRadius, float logoScale) {
        int nCount = byteMatrix.getWidth();
        float nWidth = (float)innerRenderedSize / (float)nCount;
        float nHeight = (float)innerRenderedSize / (float)nCount;
        Bitmap backgroundImageScaled = Bitmap.createBitmap((int)(innerRenderedSize + (whiteMargin ? 0 : margin * 2)), (int)(innerRenderedSize + (whiteMargin ? 0 : margin * 2)), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (backgroundImage != null) {
            AwesomeQRCode.scaleBitmap(backgroundImage, backgroundImageScaled);
        }
        Bitmap renderedBitmap = Bitmap.createBitmap((int)(innerRenderedSize + margin * 2), (int)(innerRenderedSize + margin * 2), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (autoColor && backgroundImage != null) {
            colorDark = AwesomeQRCode.getDominantColor(backgroundImage);
        }
        int binThreshold = DEFAULT_BINARIZING_THRESHOLD;
        if (binarize) {
            if (binarizeThreshold > 0 && binarizeThreshold < 255) {
                binThreshold = binarizeThreshold;
            }
            colorDark = -16777216;
            colorLight = -1;
            if (backgroundImage != null) {
                AwesomeQRCode.binarize(backgroundImageScaled, binThreshold);
            }
        }
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        Paint paintDark = new Paint();
        paintDark.setColor(colorDark);
        paintDark.setAntiAlias(true);
        paintDark.setStyle(Paint.Style.FILL);
        Paint paintLight = new Paint();
        paintLight.setColor(colorLight);
        paintLight.setAntiAlias(true);
        paintLight.setStyle(Paint.Style.FILL);
        Paint paintProtector = new Paint();
        paintProtector.setColor(Color.argb((int)120, (int)255, (int)255, (int)255));
        paintProtector.setAntiAlias(true);
        paintProtector.setStyle(Paint.Style.FILL);
        Canvas canvas = new Canvas(renderedBitmap);
        canvas.drawColor(-1);
        canvas.drawBitmap(backgroundImageScaled, whiteMargin ? (float)margin : 0.0f, whiteMargin ? (float)margin : 0.0f, paint);
        for (int row = 0; row < byteMatrix.getHeight(); ++row) {
            block7: for (int col = 0; col < byteMatrix.getWidth(); ++col) {
                switch (byteMatrix.get(col, row)) {
                    case 2: 
                    case 3: 
                    case 4: {
                        canvas.drawRect((float)margin + (float)col * nWidth, (float)margin + (float)row * nHeight, (float)margin + ((float)col + 1.0f) * nWidth, (float)margin + ((float)row + 1.0f) * nHeight, paintDark);
                        continue block7;
                    }
                    case 1: {
                        if (roundedDataDots) {
                            canvas.drawCircle((float)margin + ((float)col + 0.5f) * nWidth, (float)margin + ((float)row + 0.5f) * nHeight, dataDotScale * nHeight * 0.5f, paintDark);
                            continue block7;
                        }
                        canvas.drawRect((float)margin + ((float)col + 0.5f * (1.0f - dataDotScale)) * nWidth, (float)margin + ((float)row + 0.5f * (1.0f - dataDotScale)) * nHeight, (float)margin + ((float)col + 0.5f * (1.0f + dataDotScale)) * nWidth, (float)margin + ((float)row + 0.5f * (1.0f + dataDotScale)) * nHeight, paintDark);
                        continue block7;
                    }
                    case 5: {
                        canvas.drawRect((float)margin + (float)col * nWidth, (float)margin + (float)row * nHeight, (float)margin + ((float)col + 1.0f) * nWidth, (float)margin + ((float)row + 1.0f) * nHeight, paintProtector);
                        continue block7;
                    }
                    case 0: {
                        if (roundedDataDots) {
                            canvas.drawCircle((float)margin + ((float)col + 0.5f) * nWidth, (float)margin + ((float)row + 0.5f) * nHeight, dataDotScale * nHeight * 0.5f, paintLight);
                            continue block7;
                        }
                        canvas.drawRect((float)margin + ((float)col + 0.5f * (1.0f - dataDotScale)) * nWidth, (float)margin + ((float)row + 0.5f * (1.0f - dataDotScale)) * nHeight, (float)margin + ((float)col + 0.5f * (1.0f + dataDotScale)) * nWidth, (float)margin + ((float)row + 0.5f * (1.0f + dataDotScale)) * nHeight, paintLight);
                    }
                }
            }
        }
        if (logoImage != null) {
            if (logoScale <= 0.0f || logoScale >= 1.0f) {
                logoScale = DEFAULT_LOGO_SCALE;
            }
            if (logoMargin < 0 || logoMargin * 2 >= innerRenderedSize) {
                logoMargin = DEFAULT_LOGO_MARGIN;
            }
            int logoScaledSize = (int)((float)innerRenderedSize * logoScale);
            if (logoCornerRadius < 0) {
                logoCornerRadius = 0;
            }
            if (logoCornerRadius * 2 > logoScaledSize) {
                logoCornerRadius = (int)((double)logoScaledSize * 0.5);
            }
            Bitmap logoScaled = Bitmap.createScaledBitmap((Bitmap)logoImage, (int)logoScaledSize, (int)logoScaledSize, (boolean)true);
            Bitmap logoOpt = Bitmap.createBitmap((int)logoScaled.getWidth(), (int)logoScaled.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas logoCanvas = new Canvas(logoOpt);
            Rect logoRect = new Rect(0, 0, logoScaled.getWidth(), logoScaled.getHeight());
            RectF logoRectF = new RectF(logoRect);
            Paint logoPaint = new Paint();
            logoPaint.setAntiAlias(true);
            logoPaint.setColor(-1);
            logoPaint.setStyle(Paint.Style.FILL);
            logoCanvas.drawARGB(0, 0, 0, 0);
            logoCanvas.drawRoundRect(logoRectF, (float)logoCornerRadius, (float)logoCornerRadius, logoPaint);
            logoPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
            logoCanvas.drawBitmap(logoScaled, logoRect, logoRect, logoPaint);
            logoPaint.setColor(colorLight);
            logoPaint.setStyle(Paint.Style.STROKE);
            logoPaint.setStrokeWidth((float)logoMargin);
            logoCanvas.drawRoundRect(logoRectF, (float)logoCornerRadius, (float)logoCornerRadius, logoPaint);
            if (binarize) {
                AwesomeQRCode.binarize(logoOpt, binThreshold);
            }
            canvas.drawBitmap(logoOpt, (float)((int)(0.5 * (double)(renderedBitmap.getWidth() - logoOpt.getWidth()))), (float)((int)(0.5 * (double)(renderedBitmap.getHeight() - logoOpt.getHeight()))), paint);
        }
        return renderedBitmap;
    }

    private static ByteMatrix getBitMatrix(String contents) {
        try {
            QRCode qrCode = AwesomeQRCode.getProtoQRCode(contents, ErrorCorrectionLevel.H);
            int[] agnCenter = qrCode.getVersion().getAlignmentPatternCenters();
            ByteMatrix byteMatrix = qrCode.getMatrix();
            int matSize = byteMatrix.getWidth();
            for (int row = 0; row < matSize; ++row) {
                for (int col = 0; col < matSize; ++col) {
                    if (AwesomeQRCode.isTypeAGN(col, row, agnCenter, true)) {
                        if (byteMatrix.get(col, row) != 0) {
                            byteMatrix.set(col, row, 3);
                        } else {
                            byteMatrix.set(col, row, 5);
                        }
                    } else if (AwesomeQRCode.isTypePOS(col, row, matSize, true)) {
                        if (byteMatrix.get(col, row) != 0) {
                            byteMatrix.set(col, row, 2);
                        } else {
                            byteMatrix.set(col, row, 5);
                        }
                    } else if (AwesomeQRCode.isTypeTMG(col, row, matSize)) {
                        if (byteMatrix.get(col, row) != 0) {
                            byteMatrix.set(col, row, 4);
                        } else {
                            byteMatrix.set(col, row, 5);
                        }
                    }
                    if (!AwesomeQRCode.isTypePOS(col, row, matSize, false) || byteMatrix.get(col, row) != 0) continue;
                    byteMatrix.set(col, row, 5);
                }
            }
            return byteMatrix;
        }
        catch (WriterException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static QRCode getProtoQRCode(String contents, ErrorCorrectionLevel errorCorrectionLevel) throws WriterException {
        if (contents.isEmpty()) {
            throw new IllegalArgumentException("Found empty contents");
        }
        Hashtable<EncodeHintType, String> hintMap = new Hashtable<EncodeHintType, String>();
        hintMap.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        hintMap.put(EncodeHintType.ERROR_CORRECTION, (String)errorCorrectionLevel);
        return Encoder.encode((String)contents, (ErrorCorrectionLevel)errorCorrectionLevel, hintMap);
    }

    private static boolean isTypeAGN(int x, int y, int[] agnCenter, boolean edgeOnly) {
        if (agnCenter.length == 0) {
            return false;
        }
        int edgeCenter = agnCenter[agnCenter.length - 1];
        for (int agnY : agnCenter) {
            for (int agnX : agnCenter) {
                if (edgeOnly && agnX != 6 && agnY != 6 && agnX != edgeCenter && agnY != edgeCenter || agnX == 6 && agnY == 6 || agnX == 6 && agnY == edgeCenter || agnY == 6 && agnX == edgeCenter || x < agnX - 2 || x > agnX + 2 || y < agnY - 2 || y > agnY + 2) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isTypePOS(int x, int y, int size, boolean inner) {
        if (inner) {
            return x < 7 && (y < 7 || y >= size - 7) || x >= size - 7 && y < 7;
        }
        return x <= 7 && (y <= 7 || y >= size - 8) || x >= size - 8 && y <= 7;
    }

    private static boolean isTypeTMG(int x, int y, int size) {
        return y == 6 && x >= 8 && x < size - 8 || x == 6 && y >= 8 && y < size - 8;
    }

    private static void scaleBitmap(Bitmap src, Bitmap dst) {
        Paint cPaint = new Paint();
        cPaint.setAntiAlias(true);
        cPaint.setDither(true);
        cPaint.setFilterBitmap(true);
        float ratioX = (float)dst.getWidth() / (float)src.getWidth();
        float ratioY = (float)dst.getHeight() / (float)src.getHeight();
        float middleX = (float)dst.getWidth() * 0.5f;
        float middleY = (float)dst.getHeight() * 0.5f;
        Matrix scaleMatrix = new Matrix();
        scaleMatrix.setScale(ratioX, ratioY, middleX, middleY);
        Canvas canvas = new Canvas(dst);
        canvas.setMatrix(scaleMatrix);
        canvas.drawBitmap(src, middleX - (float)(src.getWidth() / 2), middleY - (float)(src.getHeight() / 2), cPaint);
    }

    private static int getDominantColor(Bitmap bitmap) {
        Bitmap newBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)8, (int)8, (boolean)true);
        int red = 0;
        int green = 0;
        int blue = 0;
        int c = 0;
        for (int y = 0; y < newBitmap.getHeight(); ++y) {
            for (int x = 0; x < newBitmap.getHeight(); ++x) {
                int color = newBitmap.getPixel(x, y);
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                if (r > 200 || g > 200 || b > 200) continue;
                red += r;
                green += g;
                blue += b;
                ++c;
            }
        }
        newBitmap.recycle();
        if (c == 0) {
            return -16777216;
        }
        red = Math.max(0, Math.min(255, red / c));
        green = Math.max(0, Math.min(255, green / c));
        blue = Math.max(0, Math.min(255, blue / c));
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    private static void binarize(Bitmap bitmap, int threshold) {
        for (int y = 0; y < bitmap.getHeight(); ++y) {
            for (int x = 0; x < bitmap.getHeight(); ++x) {
                int b;
                int g;
                int color = bitmap.getPixel(x, y);
                int r = color >> 16 & 0xFF;
                float sum = 0.3f * (float)r + 0.59f * (float)(g = color >> 8 & 0xFF) + 0.11f * (float)(b = color & 0xFF);
                bitmap.setPixel(x, y, sum > (float)threshold ? -1 : -16777216);
            }
        }
    }

    static /* synthetic */ int access$000() {
        return DEFAULT_SIZE;
    }

    static /* synthetic */ int access$100() {
        return DEFAULT_MARGIN;
    }

    static /* synthetic */ float access$200() {
        return DEFAULT_DTA_DOT_SCALE;
    }

    static /* synthetic */ int access$300() {
        return DEFAULT_BINARIZING_THRESHOLD;
    }

    static /* synthetic */ int access$400() {
        return DEFAULT_LOGO_MARGIN;
    }

    static /* synthetic */ int access$500() {
        return DEFAULT_LOGO_RADIUS;
    }

    static /* synthetic */ float access$600() {
        return DEFAULT_LOGO_SCALE;
    }

    public static interface Callback {
        public void onRendered(Renderer var1, Bitmap var2);

        public void onError(Renderer var1, Exception var2);
    }

    public static class Renderer {
        private String contents;
        private int size = AwesomeQRCode.access$000();
        private int margin = AwesomeQRCode.access$100();
        private float dataDotScale = AwesomeQRCode.access$200();
        private int colorDark = -16777216;
        private int colorLight = -1;
        private Bitmap backgroundImage;
        private boolean whiteMargin = true;
        private boolean autoColor = true;
        private boolean binarize = false;
        private int binarizeThreshold = AwesomeQRCode.access$300();
        private boolean roundedDataDots = false;
        private Bitmap logoImage;
        private int logoMargin = AwesomeQRCode.access$400();
        private int logoCornerRadius = AwesomeQRCode.access$500();
        private float logoScale = AwesomeQRCode.access$600();

        public Renderer autoColor(boolean autoColor) {
            this.autoColor = autoColor;
            return this;
        }

        public Renderer background(Bitmap backgroundImage) {
            this.backgroundImage = backgroundImage;
            return this;
        }

        public Renderer binarize(boolean binarize) {
            this.binarize = binarize;
            return this;
        }

        public Renderer binarizeThreshold(int binarizeThreshold) {
            this.binarizeThreshold = binarizeThreshold;
            return this;
        }

        public Renderer colorDark(int colorDark) {
            this.colorDark = colorDark;
            return this;
        }

        public Renderer colorLight(int colorLight) {
            this.colorLight = colorLight;
            return this;
        }

        public Renderer contents(String contents) {
            this.contents = contents;
            return this;
        }

        public Renderer dotScale(float dataDotScale) {
            this.dataDotScale = dataDotScale;
            return this;
        }

        public Renderer logo(Bitmap logoImage) {
            this.logoImage = logoImage;
            return this;
        }

        public Renderer logoRadius(int logoCornerRadius) {
            this.logoCornerRadius = logoCornerRadius;
            return this;
        }

        public Renderer logoMargin(int logoMargin) {
            this.logoMargin = logoMargin;
            return this;
        }

        public Renderer logoScale(float logoScale) {
            this.logoScale = logoScale;
            return this;
        }

        public Renderer margin(int margin) {
            this.margin = margin;
            return this;
        }

        public Renderer roundedDots(boolean roundedDataDots) {
            this.roundedDataDots = roundedDataDots;
            return this;
        }

        public Renderer size(int size) {
            this.size = size;
            return this;
        }

        public Renderer whiteMargin(boolean whiteMargin) {
            this.whiteMargin = whiteMargin;
            return this;
        }

        public Bitmap render() throws IllegalArgumentException {
            return AwesomeQRCode.create(this.contents, this.size, this.margin, this.dataDotScale, this.colorDark, this.colorLight, this.backgroundImage, this.whiteMargin, this.autoColor, this.binarize, this.binarizeThreshold, this.roundedDataDots, this.logoImage, this.logoMargin, this.logoCornerRadius, this.logoScale);
        }

        public void renderAsync(final Callback callback) throws IllegalArgumentException {
            new Thread(){

                @Override
                public void run() {
                    block3: {
                        super.run();
                        try {
                            Bitmap bitmap = AwesomeQRCode.create(Renderer.this.contents, Renderer.this.size, Renderer.this.margin, Renderer.this.dataDotScale, Renderer.this.colorDark, Renderer.this.colorLight, Renderer.this.backgroundImage, Renderer.this.whiteMargin, Renderer.this.autoColor, Renderer.this.binarize, Renderer.this.binarizeThreshold, Renderer.this.roundedDataDots, Renderer.this.logoImage, Renderer.this.logoMargin, Renderer.this.logoCornerRadius, Renderer.this.logoScale);
                            if (callback != null) {
                                callback.onRendered(Renderer.this, bitmap);
                            }
                        }
                        catch (Exception e) {
                            if (callback == null) break block3;
                            callback.onError(Renderer.this, e);
                        }
                    }
                }
            }.start();
        }
    }
}

