/*
 * Decompiled with CFR 0.152.
 */
package com.stomhong.library;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.inputmethodservice.Keyboard;
import android.inputmethodservice.KeyboardView;
import android.util.AttributeSet;
import com.stomhong.library.KeyboardUtil;
import com.stomhong.library.R;
import java.util.List;

public class PpKeyBoardView
extends KeyboardView {
    private Context mContext;
    private int rightType = 1;
    private int heightPixels;
    private float density;
    private static Keyboard mKeyBoard;

    public PpKeyBoardView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.heightPixels = this.mContext.getResources().getDisplayMetrics().heightPixels;
        this.density = this.mContext.getResources().getDisplayMetrics().density;
    }

    public PpKeyBoardView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mContext = context;
        this.heightPixels = this.mContext.getResources().getDisplayMetrics().heightPixels;
        this.density = this.mContext.getResources().getDisplayMetrics().density;
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        mKeyBoard = KeyboardUtil.getKeyBoardType();
        List keys = mKeyBoard.getKeys();
        for (Keyboard.Key key : keys) {
            if (mKeyBoard.equals(KeyboardUtil.numKeyboard)) {
                this.initRightType(key);
                this.drawNumSpecialKey(key, canvas);
                continue;
            }
            if (mKeyBoard.equals(KeyboardUtil.abcKeyboard)) {
                this.drawABCSpecialKey(key, canvas);
                continue;
            }
            if (!mKeyBoard.equals(KeyboardUtil.symbolKeyboard)) continue;
            this.drawSymbolSpecialKey(key, canvas);
        }
    }

    private void drawNumSpecialKey(Keyboard.Key key, Canvas canvas) {
        if (key.codes[0] == -5) {
            this.drawKeyBackground(R.drawable.btn_keyboard_key_num_delete, canvas, key);
        }
        if (key.codes[0] == -3 && key.label == null) {
            this.drawKeyBackground(R.drawable.btn_keyboard_key_pull, canvas, key);
            this.drawText(canvas, key);
        }
        if (key.codes[0] == 0 || key.codes[0] == 741741 || key.codes[0] == 88 || key.codes[0] == -4 && key.label != null || key.codes[0] == 46) {
            this.drawKeyBackground(R.drawable.btn_keyboard_key2, canvas, key);
            this.drawText(canvas, key);
        }
    }

    private void drawABCSpecialKey(Keyboard.Key key, Canvas canvas) {
        if (key.codes[0] == -5) {
            this.drawKeyBackground(R.drawable.btn_keyboard_key_delete, canvas, key);
            this.drawText(canvas, key);
        }
        if (key.codes[0] == -1) {
            this.drawKeyBackground(R.drawable.btn_keyboard_key_shift, canvas, key);
            this.drawText(canvas, key);
        }
        if (key.codes[0] == 123123 || key.codes[0] == 789789) {
            this.drawKeyBackground(R.drawable.btn_keyboard_key_123, canvas, key);
            this.drawText(canvas, key);
        }
        if (key.codes[0] == 32) {
            this.drawKeyBackground(R.drawable.btn_keyboard_key_space, canvas, key);
        }
    }

    private void drawSymbolSpecialKey(Keyboard.Key key, Canvas canvas) {
        if (key.codes[0] == 123123 || key.codes[0] == 456456) {
            this.drawKeyBackground(R.drawable.btn_keyboard_key_change, canvas, key);
            this.drawText(canvas, key);
        }
        if (key.codes[0] == -5) {
            this.drawKeyBackground(R.drawable.btn_keyboard_key_delete, canvas, key);
        }
    }

    private void drawKeyBackground(int drawableId, Canvas canvas, Keyboard.Key key) {
        Drawable npd = this.mContext.getResources().getDrawable(drawableId);
        int[] drawableState = key.getCurrentDrawableState();
        if (key.codes[0] != 0) {
            npd.setState(drawableState);
        }
        npd.setBounds(key.x, key.y, key.x + key.width, key.y + key.height);
        npd.draw(canvas);
    }

    private void initRightType(Keyboard.Key key) {
        if (key.codes[0] == 0) {
            this.rightType = 1;
        } else if (key.codes[0] == 88) {
            this.rightType = 2;
        } else if (key.codes[0] == 46) {
            this.rightType = 3;
        } else if (key.codes[0] == -4 && key.label.equals("\u5b8c\u6210")) {
            this.rightType = 4;
        } else if (key.codes[0] == -4 && key.label.equals("\u4e0b\u4e00\u9879")) {
            this.rightType = 5;
        }
    }

    public int getRightType() {
        return this.rightType;
    }

    private void drawText(Canvas canvas, Keyboard.Key key) {
        Rect bounds = new Rect();
        Paint paint = new Paint();
        paint.setTextAlign(Paint.Align.CENTER);
        if (key.codes[0] == 46) {
            paint.setTextSize(70.0f);
        } else {
            paint.setTextSize(40.0f);
        }
        paint.setAntiAlias(true);
        paint.setColor(-16777216);
        if (mKeyBoard.equals(KeyboardUtil.numKeyboard)) {
            if (key.label != null) {
                paint.getTextBounds(key.label.toString(), 0, key.label.toString().length(), bounds);
                canvas.drawText(key.label.toString(), (float)(key.x + key.width / 2), (float)(key.y + key.height / 2 + bounds.height() / 2), paint);
            } else if (key.codes[0] == -3) {
                key.icon.setBounds(key.x + 9 * key.width / 20, key.y + 3 * key.height / 8, key.x + 11 * key.width / 20, key.y + 5 * key.height / 8);
                key.icon.draw(canvas);
            } else if (key.codes[0] == -5) {
                key.icon.setBounds(key.x + (int)(0.4 * (double)key.width), key.y + (int)(0.328 * (double)key.height), key.x + (int)(0.6 * (double)key.width), key.y + (int)(0.672 * (double)key.height));
                key.icon.draw(canvas);
            }
        } else if (mKeyBoard.equals(KeyboardUtil.abcKeyboard)) {
            if (key.label != null) {
                paint.setColor(this.mContext.getResources().getColor(R.color.color_3c3c3c));
                paint.getTextBounds(key.label.toString(), 0, key.label.toString().length(), bounds);
                canvas.drawText(key.label.toString(), (float)(key.x + key.width / 2), (float)(key.y + key.height / 2 + bounds.height() / 2), paint);
            }
        } else if (mKeyBoard.equals(KeyboardUtil.symbolKeyboard)) {
            paint.setColor(this.mContext.getResources().getColor(R.color.color_3c3c3c));
            paint.getTextBounds(key.label.toString(), 0, key.label.toString().length(), bounds);
            canvas.drawText(key.label.toString(), (float)(key.x + key.width / 2), (float)(key.y + key.height / 2 + bounds.height() / 2), paint);
        }
    }
}

