/*
 * Decompiled with CFR 0.152.
 */
package com.stericson.RootShell.execution;

import android.content.Context;
import android.os.Build;
import com.stericson.RootShell.RootShell;
import com.stericson.RootShell.exceptions.RootDeniedException;
import com.stericson.RootShell.execution.Command;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class Shell {
    private static final String token = "F*D^W@#FGF";
    private static Shell rootShell = null;
    private static Shell shell = null;
    private static Shell customShell = null;
    private static String[] suVersion = new String[]{null, null};
    public static ShellContext defaultContext = ShellContext.NORMAL;
    private int shellTimeout = 25000;
    private ShellType shellType = null;
    private ShellContext shellContext = ShellContext.NORMAL;
    private String error = "";
    private final Process proc;
    private final BufferedReader inputStream;
    private final BufferedReader errorStream;
    private final OutputStreamWriter outputStream;
    private final List<Command> commands = new ArrayList<Command>();
    private boolean close = false;
    private Boolean isSELinuxEnforcing = null;
    public boolean isExecuting = false;
    public boolean isReading = false;
    public boolean isClosed = false;
    private int maxCommands = 5000;
    private int read = 0;
    private int write = 0;
    private int totalExecuted = 0;
    private int totalRead = 0;
    private boolean isCleaning = false;
    private Runnable input = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (true) {
                    List list = Shell.this.commands;
                    synchronized (list) {
                        while (!Shell.this.close && Shell.this.write >= Shell.this.commands.size()) {
                            Shell.this.isExecuting = false;
                            Shell.this.commands.wait();
                        }
                    }
                    if (Shell.this.write >= Shell.this.maxCommands) {
                        while (Shell.this.read != Shell.this.write) {
                            RootShell.log("Waiting for read and write to catch up before cleanup.");
                        }
                        Shell.this.cleanCommands();
                    }
                    if (Shell.this.write < Shell.this.commands.size()) {
                        Shell.this.isExecuting = true;
                        Command cmd = (Command)Shell.this.commands.get(Shell.this.write);
                        cmd.startExecution();
                        RootShell.log("Executing: " + cmd.getCommand() + " with context: " + (Object)((Object)Shell.this.shellContext));
                        Shell.this.outputStream.write(cmd.getCommand());
                        Shell.this.outputStream.flush();
                        String line = "\necho F*D^W@#FGF " + Shell.this.totalExecuted + " $?\n";
                        Shell.this.outputStream.write(line);
                        Shell.this.outputStream.flush();
                        Shell.this.write++;
                        Shell.this.totalExecuted++;
                        continue;
                    }
                    if (Shell.this.close) break;
                }
                Shell.this.isExecuting = false;
                Shell.this.outputStream.write("\nexit 0\n");
                Shell.this.outputStream.flush();
                RootShell.log("Closing shell");
                return;
            }
            catch (IOException | InterruptedException e) {
                RootShell.log(e.getMessage(), RootShell.LogLevel.ERROR, e);
            }
            finally {
                Shell.this.write = 0;
                Shell.this.closeQuietly(Shell.this.outputStream);
            }
        }
    };
    private Runnable output = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Command command = null;
                while (!Shell.this.close || Shell.this.inputStream.ready() || Shell.this.read < Shell.this.commands.size()) {
                    String[] fields;
                    Shell.this.isReading = false;
                    String outputLine = Shell.this.inputStream.readLine();
                    Shell.this.isReading = true;
                    if (outputLine == null) break;
                    if (command == null) {
                        if (Shell.this.read >= Shell.this.commands.size()) {
                            if (!Shell.this.close) continue;
                            break;
                        }
                        command = (Command)Shell.this.commands.get(Shell.this.read);
                    }
                    int pos = -1;
                    pos = outputLine.indexOf(Shell.token);
                    if (pos == -1) {
                        command.output(command.id, outputLine);
                    } else if (pos > 0) {
                        RootShell.log("Found token, line: " + outputLine);
                        command.output(command.id, outputLine.substring(0, pos));
                    }
                    if (pos < 0 || (fields = (outputLine = outputLine.substring(pos)).split(" ")).length < 2 || fields[1] == null) continue;
                    int id = 0;
                    try {
                        id = Integer.parseInt(fields[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    int exitCode = -1;
                    try {
                        exitCode = Integer.parseInt(fields[2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (id != Shell.this.totalRead) continue;
                    Shell.this.processErrors(command);
                    int iterations = 0;
                    while (command.totalOutput > command.totalOutputProcessed) {
                        if (iterations == 0) {
                            ++iterations;
                            RootShell.log("Waiting for output to be processed. " + command.totalOutputProcessed + " Of " + command.totalOutput);
                        }
                        try {
                            3 var8_12 = this;
                            synchronized (var8_12) {
                                this.wait(2000L);
                            }
                        }
                        catch (Exception e) {
                            RootShell.log(e.getMessage());
                        }
                    }
                    RootShell.log("Read all output");
                    command.setExitCode(exitCode);
                    command.commandFinished();
                    command = null;
                    Shell.this.read++;
                    Shell.this.totalRead++;
                }
                try {
                    Shell.this.proc.waitFor();
                    Shell.this.proc.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                while (Shell.this.read < Shell.this.commands.size()) {
                    if (command == null) {
                        command = (Command)Shell.this.commands.get(Shell.this.read);
                    }
                    if (command.totalOutput < command.totalOutputProcessed) {
                        command.terminated("All output not processed!");
                        command.terminated("Did you forget the super.commandOutput call or are you waiting on the command object?");
                    } else {
                        command.terminated("Unexpected Termination.");
                    }
                    command = null;
                    Shell.this.read++;
                }
                Shell.this.read = 0;
            }
            catch (IOException e) {
                RootShell.log(e.getMessage(), RootShell.LogLevel.ERROR, e);
            }
            finally {
                Shell.this.closeQuietly(Shell.this.outputStream);
                Shell.this.closeQuietly(Shell.this.errorStream);
                Shell.this.closeQuietly(Shell.this.inputStream);
                RootShell.log("Shell destroyed");
                Shell.this.isClosed = true;
                Shell.this.isReading = false;
            }
        }
    };

    private Shell(String cmd, ShellType shellType, ShellContext shellContext, int shellTimeout) throws IOException, TimeoutException, RootDeniedException {
        RootShell.log("Starting shell: " + cmd);
        RootShell.log("Context: " + shellContext.getValue());
        RootShell.log("Timeout: " + shellTimeout);
        this.shellType = shellType;
        this.shellTimeout = shellTimeout > 0 ? shellTimeout : this.shellTimeout;
        this.shellContext = shellContext;
        if (this.shellContext == ShellContext.NORMAL) {
            this.proc = Runtime.getRuntime().exec(cmd);
        } else {
            String display = this.getSuVersion(false);
            String internal = this.getSuVersion(true);
            if (this.isSELinuxEnforcing() && display != null && internal != null && display.endsWith("SUPERSU") && Integer.valueOf(internal) >= 190) {
                cmd = cmd + " --context " + this.shellContext.getValue();
            } else {
                RootShell.log("Su binary --context switch not supported!");
                RootShell.log("Su binary display version: " + display);
                RootShell.log("Su binary internal version: " + internal);
                RootShell.log("SELinuxEnforcing: " + this.isSELinuxEnforcing());
            }
            this.proc = Runtime.getRuntime().exec(cmd);
        }
        this.inputStream = new BufferedReader(new InputStreamReader(this.proc.getInputStream(), "UTF-8"));
        this.errorStream = new BufferedReader(new InputStreamReader(this.proc.getErrorStream(), "UTF-8"));
        this.outputStream = new OutputStreamWriter(this.proc.getOutputStream(), "UTF-8");
        Worker worker = new Worker(this);
        worker.start();
        try {
            worker.join(this.shellTimeout);
            if (worker.exit == -911) {
                try {
                    this.proc.destroy();
                }
                catch (Exception internal) {
                    // empty catch block
                }
                this.closeQuietly(this.inputStream);
                this.closeQuietly(this.errorStream);
                this.closeQuietly(this.outputStream);
                throw new TimeoutException(this.error);
            }
            if (worker.exit == -42) {
                try {
                    this.proc.destroy();
                }
                catch (Exception internal) {
                    // empty catch block
                }
                this.closeQuietly(this.inputStream);
                this.closeQuietly(this.errorStream);
                this.closeQuietly(this.outputStream);
                throw new RootDeniedException("Root Access Denied");
            }
            Thread si = new Thread(this.input, "Shell Input");
            si.setPriority(5);
            si.start();
            Thread so = new Thread(this.output, "Shell Output");
            so.setPriority(5);
            so.start();
        }
        catch (InterruptedException ex) {
            worker.interrupt();
            Thread.currentThread().interrupt();
            throw new TimeoutException();
        }
    }

    public Command add(Command command) throws IOException {
        if (this.close) {
            throw new IllegalStateException("Unable to add commands to a closed shell");
        }
        if (command.used) {
            throw new IllegalStateException("This command has already been executed. (Don't re-use command instances.)");
        }
        while (this.isCleaning) {
        }
        this.commands.add(command);
        this.notifyThreads();
        return command;
    }

    public final void useCWD(Context context) throws IOException, TimeoutException, RootDeniedException {
        this.add(new Command(-1, false, "cd " + context.getApplicationInfo().dataDir));
    }

    private void cleanCommands() {
        this.isCleaning = true;
        int toClean = Math.abs(this.maxCommands - this.maxCommands / 4);
        RootShell.log("Cleaning up: " + toClean);
        for (int i = 0; i < toClean; ++i) {
            this.commands.remove(0);
        }
        this.read = this.commands.size() - 1;
        this.write = this.commands.size() - 1;
        this.isCleaning = false;
    }

    private void closeQuietly(Reader input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeQuietly(Writer output) {
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        RootShell.log("Request to close shell!");
        int count = 0;
        while (this.isExecuting) {
            RootShell.log("Waiting on shell to finish executing before closing...");
            if (++count <= 10000) continue;
        }
        List<Command> list = this.commands;
        synchronized (list) {
            this.close = true;
            this.notifyThreads();
        }
        RootShell.log("Shell Closed!");
        if (this == rootShell) {
            rootShell = null;
        } else if (this == shell) {
            shell = null;
        } else if (this == customShell) {
            customShell = null;
        }
    }

    public static void closeCustomShell() throws IOException {
        RootShell.log("Request to close custom shell!");
        if (customShell == null) {
            return;
        }
        customShell.close();
    }

    public static void closeRootShell() throws IOException {
        RootShell.log("Request to close root shell!");
        if (rootShell == null) {
            return;
        }
        rootShell.close();
    }

    public static void closeShell() throws IOException {
        RootShell.log("Request to close normal shell!");
        if (shell == null) {
            return;
        }
        shell.close();
    }

    public static void closeAll() throws IOException {
        RootShell.log("Request to close all shells!");
        Shell.closeShell();
        Shell.closeRootShell();
        Shell.closeCustomShell();
    }

    public int getCommandQueuePosition(Command cmd) {
        return this.commands.indexOf(cmd);
    }

    public String getCommandQueuePositionString(Command cmd) {
        return "Command is in position " + this.getCommandQueuePosition(cmd) + " currently executing command at position " + this.write + " and the number of commands is " + this.commands.size();
    }

    public static Shell getOpenShell() {
        if (customShell != null) {
            return customShell;
        }
        if (rootShell != null) {
            return rootShell;
        }
        return shell;
    }

    private synchronized String getSuVersion(boolean internal) {
        int idx;
        int n = idx = internal ? 0 : 1;
        if (suVersion[idx] == null) {
            Process process;
            String version = null;
            try {
                process = Runtime.getRuntime().exec(internal ? "su -V" : "su -v", null);
                process.waitFor();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return null;
            }
            ArrayList<String> stdout = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            try {
                String line = null;
                while ((line = reader.readLine()) != null) {
                    stdout.add(line);
                }
            }
            catch (IOException line) {
                // empty catch block
            }
            try {
                reader.close();
            }
            catch (IOException line) {
                // empty catch block
            }
            process.destroy();
            ArrayList<String> ret = stdout;
            if (ret != null) {
                for (String line : ret) {
                    if (!internal) {
                        if (!line.contains(".")) continue;
                        version = line;
                        break;
                    }
                    try {
                        if (Integer.parseInt(line) <= 0) continue;
                        version = line;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                }
            }
            Shell.suVersion[idx] = version;
        }
        return suVersion[idx];
    }

    public static boolean isShellOpen() {
        return shell == null;
    }

    public static boolean isCustomShellOpen() {
        return customShell == null;
    }

    public static boolean isRootShellOpen() {
        return rootShell == null;
    }

    public static boolean isAnyShellOpen() {
        return shell != null || rootShell != null || customShell != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isSELinuxEnforcing() {
        if (this.isSELinuxEnforcing == null) {
            Boolean enforcing = null;
            if (Build.VERSION.SDK_INT >= 17) {
                File f = new File("/sys/fs/selinux/enforce");
                if (f.exists()) {
                    try (FileInputStream is = new FileInputStream("/sys/fs/selinux/enforce");){
                        enforcing = ((InputStream)is).read() == 49;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (enforcing == null) {
                    enforcing = Build.VERSION.SDK_INT >= 19;
                }
            }
            if (enforcing == null) {
                enforcing = false;
            }
            this.isSELinuxEnforcing = enforcing;
        }
        return this.isSELinuxEnforcing;
    }

    protected void notifyThreads() {
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = Shell.this.commands;
                synchronized (list) {
                    Shell.this.commands.notifyAll();
                }
            }
        };
        t.start();
    }

    public void processErrors(Command command) {
        try {
            String line;
            while (this.errorStream.ready() && command != null && (line = this.errorStream.readLine()) != null) {
                command.output(command.id, line);
            }
        }
        catch (Exception e) {
            RootShell.log(e.getMessage(), RootShell.LogLevel.ERROR, e);
        }
    }

    public static Command runRootCommand(Command command) throws IOException, TimeoutException, RootDeniedException {
        return Shell.startRootShell().add(command);
    }

    public static Command runCommand(Command command) throws IOException, TimeoutException {
        return Shell.startShell().add(command);
    }

    public static Shell startRootShell() throws IOException, TimeoutException, RootDeniedException {
        return Shell.startRootShell(0, 3);
    }

    public static Shell startRootShell(int timeout) throws IOException, TimeoutException, RootDeniedException {
        return Shell.startRootShell(timeout, 3);
    }

    public static Shell startRootShell(int timeout, int retry) throws IOException, TimeoutException, RootDeniedException {
        return Shell.startRootShell(timeout, defaultContext, retry);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Shell startRootShell(int timeout, ShellContext shellContext, int retry) throws IOException, TimeoutException, RootDeniedException {
        int retries = 0;
        if (rootShell == null) {
            RootShell.log("Starting Root Shell!");
            String cmd = "su";
            while (rootShell == null) {
                try {
                    RootShell.log("Trying to open Root Shell, attempt #" + retries);
                    rootShell = new Shell(cmd, ShellType.ROOT, shellContext, timeout);
                }
                catch (IOException e) {
                    if (retries++ < retry) continue;
                    RootShell.log("IOException, could not start shell");
                    throw e;
                }
                catch (RootDeniedException e) {
                    if (retries++ < retry) continue;
                    RootShell.log("RootDeniedException, could not start shell");
                    throw e;
                }
                catch (TimeoutException e) {
                    if (retries++ < retry) continue;
                    RootShell.log("TimeoutException, could not start shell");
                    throw e;
                }
            }
            return rootShell;
        } else if (Shell.rootShell.shellContext != shellContext) {
            try {
                RootShell.log("Context is different than open shell, switching context... " + (Object)((Object)Shell.rootShell.shellContext) + " VS " + (Object)((Object)shellContext));
                rootShell.switchRootShellContext(shellContext);
                return rootShell;
            }
            catch (IOException e) {
                if (retries++ < retry) return rootShell;
                RootShell.log("IOException, could not switch context!");
                throw e;
            }
            catch (RootDeniedException e) {
                if (retries++ < retry) return rootShell;
                RootShell.log("RootDeniedException, could not switch context!");
                throw e;
            }
            catch (TimeoutException e) {
                if (retries++ < retry) return rootShell;
                RootShell.log("TimeoutException, could not switch context!");
                throw e;
            }
        } else {
            RootShell.log("Using Existing Root Shell!");
        }
        return rootShell;
    }

    public static Shell startCustomShell(String shellPath) throws IOException, TimeoutException, RootDeniedException {
        return Shell.startCustomShell(shellPath, 0);
    }

    public static Shell startCustomShell(String shellPath, int timeout) throws IOException, TimeoutException, RootDeniedException {
        if (customShell == null) {
            RootShell.log("Starting Custom Shell!");
            customShell = new Shell(shellPath, ShellType.CUSTOM, ShellContext.NORMAL, timeout);
        } else {
            RootShell.log("Using Existing Custom Shell!");
        }
        return customShell;
    }

    public static Shell startShell() throws IOException, TimeoutException {
        return Shell.startShell(0);
    }

    public static Shell startShell(int timeout) throws IOException, TimeoutException {
        try {
            if (shell == null) {
                RootShell.log("Starting Shell!");
                shell = new Shell("/system/bin/sh", ShellType.NORMAL, ShellContext.NORMAL, timeout);
            } else {
                RootShell.log("Using Existing Shell!");
            }
            return shell;
        }
        catch (RootDeniedException e) {
            throw new IOException();
        }
    }

    public Shell switchRootShellContext(ShellContext shellContext) throws IOException, TimeoutException, RootDeniedException {
        if (this.shellType == ShellType.ROOT) {
            try {
                Shell.closeRootShell();
            }
            catch (Exception e) {
                RootShell.log("Problem closing shell while trying to switch context...");
            }
            return Shell.startRootShell(this.shellTimeout, shellContext, 3);
        }
        RootShell.log("Can only switch context on a root shell!");
        return this;
    }

    protected static class Worker
    extends Thread {
        public int exit = -911;
        public Shell shell;

        private Worker(Shell shell) {
            this.shell = shell;
        }

        @Override
        public void run() {
            try {
                this.shell.outputStream.write("echo Started\n");
                this.shell.outputStream.flush();
                while (true) {
                    String line;
                    if ((line = this.shell.inputStream.readLine()) == null) {
                        throw new EOFException();
                    }
                    if ("".equals(line)) continue;
                    if ("Started".equals(line)) {
                        this.exit = 1;
                        this.setShellOom();
                        break;
                    }
                    this.shell.error = "unknown error occurred.";
                }
            }
            catch (IOException e) {
                this.exit = -42;
                if (e.getMessage() != null) {
                    this.shell.error = e.getMessage();
                }
                this.shell.error = "RootAccess denied?.";
            }
        }

        private void setShellOom() {
            try {
                Field field;
                Class<?> processClass = this.shell.proc.getClass();
                try {
                    field = processClass.getDeclaredField("pid");
                }
                catch (NoSuchFieldException e) {
                    field = processClass.getDeclaredField("id");
                }
                field.setAccessible(true);
                int pid = (Integer)field.get(this.shell.proc);
                this.shell.outputStream.write("(echo -17 > /proc/" + pid + "/oom_adj) &> /dev/null\n");
                this.shell.outputStream.write("(echo -17 > /proc/$$/oom_adj) &> /dev/null\n");
                this.shell.outputStream.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static enum ShellContext {
        NORMAL("normal"),
        SHELL("u:r:shell:s0"),
        SYSTEM_SERVER("u:r:system_server:s0"),
        SYSTEM_APP("u:r:system_app:s0"),
        PLATFORM_APP("u:r:platform_app:s0"),
        UNTRUSTED_APP("u:r:untrusted_app:s0"),
        RECOVERY("u:r:recovery:s0");

        private String value;

        private ShellContext(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum ShellType {
        NORMAL,
        ROOT,
        CUSTOM;

    }
}

