/*
 * Decompiled with CFR 0.152.
 */
package com.sunzn.banner.library;

import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.LinearSmoothScroller;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.DisplayMetrics;

class BannerLayoutManager
extends LinearLayoutManager {
    private static float MILLISECONDS_PER_INCH = 100.0f;
    private Context mContext;

    public BannerLayoutManager(Context context) {
        super(context);
        this.mContext = context;
    }

    public BannerLayoutManager(Context context, int orientation, boolean reverseLayout) {
        super(context, orientation, reverseLayout);
        this.mContext = context;
    }

    BannerLayoutManager(Context context, int orientation, boolean reverseLayout, float inch) {
        super(context, orientation, reverseLayout);
        MILLISECONDS_PER_INCH = inch;
        this.mContext = context;
    }

    public BannerLayoutManager(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mContext = context;
    }

    public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
        LinearSmoothScroller mScroller = new LinearSmoothScroller(this.mContext){

            protected float calculateSpeedPerPixel(DisplayMetrics displayMetrics) {
                return MILLISECONDS_PER_INCH / (float)displayMetrics.densityDpi;
            }
        };
        mScroller.setTargetPosition(position);
        this.startSmoothScroll((RecyclerView.SmoothScroller)mScroller);
    }
}

