/*
 * Decompiled with CFR 0.152.
 */
package cc.shinichi.library;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.DrawableRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import cc.shinichi.library.R;
import cc.shinichi.library.bean.ImageInfo;
import cc.shinichi.library.view.ImagePreviewActivity;
import cc.shinichi.library.view.listener.OnBigImageClickListener;
import cc.shinichi.library.view.listener.OnBigImageLongClickListener;
import cc.shinichi.library.view.listener.OnBigImagePageChangeListener;
import cc.shinichi.library.view.listener.OnDownloadClickListener;
import cc.shinichi.library.view.listener.OnOriginProgressListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class ImagePreview {
    @LayoutRes
    public static final int PROGRESS_THEME_CIRCLE_TEXT = R.layout.sh_default_progress_layout;
    private static final int MIN_DOUBLE_CLICK_TIME = 1500;
    private WeakReference<Context> contextWeakReference;
    private List<ImageInfo> imageInfoList;
    private int index = 0;
    private String folderName = "";
    private float minScale = 1.0f;
    private float mediumScale = 3.0f;
    private float maxScale = 5.0f;
    private boolean isShowIndicator = true;
    private boolean isShowCloseButton = false;
    private boolean isShowDownButton = true;
    private int zoomTransitionDuration = 200;
    private boolean isEnableDragClose = false;
    private boolean isEnableUpDragClose = false;
    private boolean isEnableDragCloseIgnoreScale = false;
    private boolean isEnableClickClose = true;
    private boolean isShowErrorToast = false;
    private LoadStrategy loadStrategy = LoadStrategy.Default;
    @DrawableRes
    private int indicatorShapeResId = R.drawable.shape_indicator_bg;
    @DrawableRes
    private int closeIconResId = R.drawable.ic_action_close;
    @DrawableRes
    private int downIconResId = R.drawable.icon_download_new;
    @DrawableRes
    private int errorPlaceHolder = R.drawable.load_failed;
    private OnBigImageClickListener bigImageClickListener;
    private OnBigImageLongClickListener bigImageLongClickListener;
    private OnBigImagePageChangeListener bigImagePageChangeListener;
    private OnDownloadClickListener downloadClickListener;
    private OnOriginProgressListener onOriginProgressListener;
    @LayoutRes
    private int progressLayoutId = -1;
    private long lastClickTime = 0L;

    public static ImagePreview getInstance() {
        return InnerClass.instance;
    }

    public ImagePreview setContext(@NonNull Context context) {
        this.contextWeakReference = new WeakReference<Context>(context);
        return this;
    }

    public List<ImageInfo> getImageInfoList() {
        return this.imageInfoList;
    }

    public ImagePreview setImageInfoList(@NonNull List<ImageInfo> imageInfoList) {
        this.imageInfoList = imageInfoList;
        return this;
    }

    public ImagePreview setImageList(@NonNull List<String> imageList) {
        this.imageInfoList = new ArrayList<ImageInfo>();
        for (int i = 0; i < imageList.size(); ++i) {
            ImageInfo imageInfo = new ImageInfo();
            imageInfo.setThumbnailUrl(imageList.get(i));
            imageInfo.setOriginUrl(imageList.get(i));
            this.imageInfoList.add(imageInfo);
        }
        return this;
    }

    public ImagePreview setImage(@NonNull String image) {
        this.imageInfoList = new ArrayList<ImageInfo>();
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setThumbnailUrl(image);
        imageInfo.setOriginUrl(image);
        this.imageInfoList.add(imageInfo);
        return this;
    }

    public int getIndex() {
        return this.index;
    }

    public ImagePreview setIndex(int index) {
        this.index = index;
        return this;
    }

    public boolean isShowDownButton() {
        return this.isShowDownButton;
    }

    public ImagePreview setShowDownButton(boolean showDownButton) {
        this.isShowDownButton = showDownButton;
        return this;
    }

    public boolean isShowCloseButton() {
        return this.isShowCloseButton;
    }

    public ImagePreview setShowCloseButton(boolean showCloseButton) {
        this.isShowCloseButton = showCloseButton;
        return this;
    }

    public boolean isShowOriginButton(int index) {
        String thumbUrl;
        List<ImageInfo> imageInfoList = this.getImageInfoList();
        if (null == imageInfoList || imageInfoList.size() == 0) {
            return false;
        }
        String originUrl = imageInfoList.get(index).getOriginUrl();
        if (originUrl.equalsIgnoreCase(thumbUrl = imageInfoList.get(index).getThumbnailUrl())) {
            return false;
        }
        if (this.loadStrategy == LoadStrategy.Default) {
            return true;
        }
        if (this.loadStrategy == LoadStrategy.NetworkAuto) {
            return false;
        }
        if (this.loadStrategy == LoadStrategy.AlwaysThumb) {
            return false;
        }
        if (this.loadStrategy == LoadStrategy.AlwaysOrigin) {
            return false;
        }
        return false;
    }

    @Deprecated
    public ImagePreview setShowOriginButton(boolean showOriginButton) {
        return this;
    }

    public String getFolderName() {
        if (TextUtils.isEmpty((CharSequence)this.folderName)) {
            this.folderName = "Download";
        }
        return this.folderName;
    }

    public ImagePreview setFolderName(@NonNull String folderName) {
        this.folderName = folderName;
        return this;
    }

    @Deprecated
    public ImagePreview setScaleMode(int scaleMode) {
        return this;
    }

    @Deprecated
    public ImagePreview setScaleLevel(int min, int medium, int max) {
        if (max <= medium || medium <= min || min <= 0) {
            throw new IllegalArgumentException("max must greater to medium, medium must greater to min!");
        }
        this.minScale = min;
        this.mediumScale = medium;
        this.maxScale = max;
        return this;
    }

    public float getMinScale() {
        return this.minScale;
    }

    public float getMediumScale() {
        return this.mediumScale;
    }

    public float getMaxScale() {
        return this.maxScale;
    }

    public int getZoomTransitionDuration() {
        return this.zoomTransitionDuration;
    }

    public ImagePreview setZoomTransitionDuration(int zoomTransitionDuration) {
        if (zoomTransitionDuration < 0) {
            throw new IllegalArgumentException("zoomTransitionDuration must greater 0");
        }
        this.zoomTransitionDuration = zoomTransitionDuration;
        return this;
    }

    public LoadStrategy getLoadStrategy() {
        return this.loadStrategy;
    }

    public ImagePreview setLoadStrategy(LoadStrategy loadStrategy) {
        this.loadStrategy = loadStrategy;
        return this;
    }

    public boolean isEnableDragClose() {
        return this.isEnableDragClose;
    }

    public ImagePreview setEnableDragClose(boolean enableDragClose) {
        this.isEnableDragClose = enableDragClose;
        return this;
    }

    public boolean isEnableUpDragClose() {
        return this.isEnableUpDragClose;
    }

    public ImagePreview setEnableUpDragClose(boolean enableUpDragClose) {
        this.isEnableUpDragClose = enableUpDragClose;
        return this;
    }

    public boolean isEnableDragCloseIgnoreScale() {
        return this.isEnableDragCloseIgnoreScale;
    }

    public ImagePreview setEnableDragCloseIgnoreScale(boolean enableDragCloseIgnoreScale) {
        this.isEnableDragCloseIgnoreScale = enableDragCloseIgnoreScale;
        return this;
    }

    public boolean isEnableClickClose() {
        return this.isEnableClickClose;
    }

    public ImagePreview setEnableClickClose(boolean enableClickClose) {
        this.isEnableClickClose = enableClickClose;
        return this;
    }

    public boolean isShowErrorToast() {
        return this.isShowErrorToast;
    }

    public ImagePreview setShowErrorToast(boolean showErrorToast) {
        this.isShowErrorToast = showErrorToast;
        return this;
    }

    public int getIndicatorShapeResId() {
        return this.indicatorShapeResId;
    }

    public ImagePreview setIndicatorShapeResId(int indicatorShapeResId) {
        this.indicatorShapeResId = indicatorShapeResId;
        return this;
    }

    public int getCloseIconResId() {
        return this.closeIconResId;
    }

    public ImagePreview setCloseIconResId(@DrawableRes int closeIconResId) {
        this.closeIconResId = closeIconResId;
        return this;
    }

    public int getDownIconResId() {
        return this.downIconResId;
    }

    public ImagePreview setDownIconResId(@DrawableRes int downIconResId) {
        this.downIconResId = downIconResId;
        return this;
    }

    public boolean isShowIndicator() {
        return this.isShowIndicator;
    }

    public ImagePreview setShowIndicator(boolean showIndicator) {
        this.isShowIndicator = showIndicator;
        return this;
    }

    public int getErrorPlaceHolder() {
        return this.errorPlaceHolder;
    }

    public ImagePreview setErrorPlaceHolder(int errorPlaceHolderResId) {
        this.errorPlaceHolder = errorPlaceHolderResId;
        return this;
    }

    public OnBigImageClickListener getBigImageClickListener() {
        return this.bigImageClickListener;
    }

    public ImagePreview setBigImageClickListener(OnBigImageClickListener bigImageClickListener) {
        this.bigImageClickListener = bigImageClickListener;
        return this;
    }

    public OnBigImageLongClickListener getBigImageLongClickListener() {
        return this.bigImageLongClickListener;
    }

    public ImagePreview setBigImageLongClickListener(OnBigImageLongClickListener bigImageLongClickListener) {
        this.bigImageLongClickListener = bigImageLongClickListener;
        return this;
    }

    public OnBigImagePageChangeListener getBigImagePageChangeListener() {
        return this.bigImagePageChangeListener;
    }

    public ImagePreview setBigImagePageChangeListener(OnBigImagePageChangeListener bigImagePageChangeListener) {
        this.bigImagePageChangeListener = bigImagePageChangeListener;
        return this;
    }

    public ImagePreview setDownloadClickListener(OnDownloadClickListener downloadClickListener) {
        this.downloadClickListener = downloadClickListener;
        return this;
    }

    public OnDownloadClickListener getDownloadClickListener() {
        return this.downloadClickListener;
    }

    public OnOriginProgressListener getOnOriginProgressListener() {
        return this.onOriginProgressListener;
    }

    private ImagePreview setOnOriginProgressListener(OnOriginProgressListener onOriginProgressListener) {
        this.onOriginProgressListener = onOriginProgressListener;
        return this;
    }

    public int getProgressLayoutId() {
        return this.progressLayoutId;
    }

    public ImagePreview setProgressLayoutId(int progressLayoutId, OnOriginProgressListener onOriginProgressListener) {
        this.setOnOriginProgressListener(onOriginProgressListener);
        this.progressLayoutId = progressLayoutId;
        return this;
    }

    public void reset() {
        this.imageInfoList = null;
        this.index = 0;
        this.minScale = 1.0f;
        this.mediumScale = 3.0f;
        this.maxScale = 5.0f;
        this.zoomTransitionDuration = 200;
        this.isShowDownButton = true;
        this.isShowCloseButton = false;
        this.isEnableDragClose = false;
        this.isEnableClickClose = true;
        this.isShowIndicator = true;
        this.isShowErrorToast = false;
        this.closeIconResId = R.drawable.ic_action_close;
        this.downIconResId = R.drawable.icon_download_new;
        this.errorPlaceHolder = R.drawable.load_failed;
        this.loadStrategy = LoadStrategy.Default;
        this.folderName = "Download";
        if (this.contextWeakReference != null) {
            this.contextWeakReference.clear();
            this.contextWeakReference = null;
        }
        this.bigImageClickListener = null;
        this.bigImageLongClickListener = null;
        this.bigImagePageChangeListener = null;
        this.progressLayoutId = -1;
        this.lastClickTime = 0L;
    }

    public void start() {
        if (System.currentTimeMillis() - this.lastClickTime <= 1500L) {
            Log.e((String)"ImagePreview", (String)"---\u5ffd\u7565\u591a\u6b21\u5feb\u901f\u70b9\u51fb---");
            return;
        }
        if (this.contextWeakReference == null) {
            throw new IllegalArgumentException("You must call 'setContext(Context context)' first!");
        }
        Context context = (Context)this.contextWeakReference.get();
        if (context == null) {
            throw new IllegalArgumentException("You must call 'setContext(Context context)' first!");
        }
        if (!(context instanceof Activity)) {
            throw new IllegalArgumentException("context must be a Activity!");
        }
        if (Build.VERSION.SDK_INT >= 17) {
            if (((Activity)context).isFinishing() || ((Activity)context).isDestroyed()) {
                this.reset();
                return;
            }
        } else if (((Activity)context).isFinishing()) {
            this.reset();
            return;
        }
        if (this.imageInfoList == null || this.imageInfoList.size() == 0) {
            throw new IllegalArgumentException("Do you forget to call 'setImageInfoList(List<ImageInfo> imageInfoList)' ?");
        }
        if (this.index >= this.imageInfoList.size()) {
            throw new IllegalArgumentException("index out of range!");
        }
        this.lastClickTime = System.currentTimeMillis();
        ImagePreviewActivity.activityStart(context);
    }

    private static class InnerClass {
        private static final ImagePreview instance = new ImagePreview();

        private InnerClass() {
        }
    }

    public static enum LoadStrategy {
        AlwaysOrigin,
        AlwaysThumb,
        NetworkAuto,
        Default;

    }
}

