/*
 * Decompiled with CFR 0.152.
 */
package com.shashank.sony.fancywalkthroughlib.views;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.ColorRes;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import com.shashank.sony.fancywalkthroughlib.R;

public class CircleIndicatorView
extends View {
    private Context context;
    private Paint activeIndicatorPaint;
    private Paint inactiveIndicatorPaint;
    private int radius;
    private int size;
    private int position;
    private int indicatorsCount;

    public CircleIndicatorView(Context context) {
        super(context);
        this.init(context);
    }

    public CircleIndicatorView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public CircleIndicatorView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
        this.activeIndicatorPaint = new Paint();
        this.activeIndicatorPaint.setColor(ContextCompat.getColor((Context)context, (int)R.color.active_indicator));
        this.activeIndicatorPaint.setAntiAlias(true);
        this.inactiveIndicatorPaint = new Paint();
        this.inactiveIndicatorPaint.setColor(ContextCompat.getColor((Context)context, (int)R.color.inactive_indicator));
        this.inactiveIndicatorPaint.setAntiAlias(true);
        this.radius = this.getResources().getDimensionPixelSize(R.dimen.indicator_size);
        this.size = this.radius * 2;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        for (int i = 0; i < this.indicatorsCount; ++i) {
            canvas.drawCircle((float)(this.radius + this.size * i), (float)this.radius, (float)(this.radius / 2), this.inactiveIndicatorPaint);
        }
        canvas.drawCircle((float)(this.radius + this.size * this.position), (float)this.radius, (float)(this.radius / 2), this.activeIndicatorPaint);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.measureWidth(widthMeasureSpec), this.measureHeight(heightMeasureSpec));
    }

    public void setCurrentPage(int position) {
        this.position = position;
        this.invalidate();
    }

    public void setPageIndicators(int size) {
        this.indicatorsCount = size;
        this.invalidate();
    }

    private int measureWidth(int measureSpec) {
        int result = 0;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000) {
            result = specSize;
        } else {
            result = this.size * this.indicatorsCount;
            if (specMode == Integer.MIN_VALUE) {
                result = Math.min(result, specSize);
            }
        }
        return result;
    }

    private int measureHeight(int measureSpec) {
        int result = 0;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000) {
            result = specSize;
        } else {
            result = 2 * this.radius + this.getPaddingTop() + this.getPaddingBottom();
            if (specMode == Integer.MIN_VALUE) {
                result = Math.min(result, specSize);
            }
        }
        return result;
    }

    public void setInactiveIndicatorColor(@ColorRes int color2) {
        this.inactiveIndicatorPaint.setColor(ContextCompat.getColor((Context)this.context, (int)color2));
        this.invalidate();
    }

    public void setActiveIndicatorColor(@ColorRes int color2) {
        this.activeIndicatorPaint.setColor(ContextCompat.getColor((Context)this.context, (int)color2));
        this.invalidate();
    }
}

