/*
 * Decompiled with CFR 0.152.
 */
package com.wanjian.cockroach;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.wanjian.cockroach.ExceptionHandler;
import com.wanjian.cockroach.UnableHandleError;
import com.wanjian.cockroach.compat.ActivityKillerV15_V20;
import com.wanjian.cockroach.compat.ActivityKillerV21_V23;
import com.wanjian.cockroach.compat.ActivityKillerV24_V25;
import com.wanjian.cockroach.compat.ActivityKillerV26;
import com.wanjian.cockroach.compat.ActivityKillerV28;
import com.wanjian.cockroach.compat.IActivityKiller;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import me.weishu.reflection.Reflection;

public final class Cockroach {
    private static IActivityKiller sActivityKiller;
    private static ExceptionHandler sExceptionHandler;
    private static boolean sInstalled;
    private static boolean sIsSafeMode;
    public static List<UnableHandleError> unableHandleError;

    private Cockroach() {
    }

    public static void install(Context ctx, ExceptionHandler exceptionHandler) {
        if (sInstalled) {
            return;
        }
        try {
            Reflection.unseal((Context)ctx);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        sInstalled = true;
        sExceptionHandler = exceptionHandler;
        Cockroach.initActivityKiller();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                if (sExceptionHandler != null) {
                    sExceptionHandler.uncaughtExceptionHappened(t, e);
                }
                if (t == Looper.getMainLooper().getThread()) {
                    Cockroach.isChoreographerException(e);
                    Cockroach.safeMode();
                }
            }
        });
    }

    private static void initActivityKiller() {
        if (Build.VERSION.SDK_INT >= 28) {
            sActivityKiller = new ActivityKillerV28();
        } else if (Build.VERSION.SDK_INT >= 26) {
            sActivityKiller = new ActivityKillerV26();
        } else if (Build.VERSION.SDK_INT == 25 || Build.VERSION.SDK_INT == 24) {
            sActivityKiller = new ActivityKillerV24_V25();
        } else if (Build.VERSION.SDK_INT >= 21 && Build.VERSION.SDK_INT <= 23) {
            sActivityKiller = new ActivityKillerV21_V23();
        } else if (Build.VERSION.SDK_INT >= 15 && Build.VERSION.SDK_INT <= 20) {
            sActivityKiller = new ActivityKillerV15_V20();
        } else if (Build.VERSION.SDK_INT < 15) {
            sActivityKiller = new ActivityKillerV15_V20();
        }
        try {
            Cockroach.hookmH();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void hookmH() throws Exception {
        int LAUNCH_ACTIVITY = 100;
        int PAUSE_ACTIVITY = 101;
        int PAUSE_ACTIVITY_FINISHING = 102;
        int STOP_ACTIVITY_HIDE = 104;
        int RESUME_ACTIVITY = 107;
        int DESTROY_ACTIVITY = 109;
        int NEW_INTENT = 112;
        int RELAUNCH_ACTIVITY = 126;
        Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
        Object activityThread = activityThreadClass.getDeclaredMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
        Field mhField = activityThreadClass.getDeclaredField("mH");
        mhField.setAccessible(true);
        final Handler mhHandler = (Handler)mhField.get(activityThread);
        Field callbackField = Handler.class.getDeclaredField("mCallback");
        callbackField.setAccessible(true);
        callbackField.set(mhHandler, new Handler.Callback(){

            public boolean handleMessage(Message msg) {
                if (Build.VERSION.SDK_INT >= 28) {
                    int EXECUTE_TRANSACTION = 159;
                    if (msg.what == 159) {
                        try {
                            mhHandler.handleMessage(msg);
                        }
                        catch (Throwable throwable) {
                            sActivityKiller.finishLaunchActivity(msg);
                            Cockroach.notifyException(throwable);
                        }
                        return true;
                    }
                    return false;
                }
                switch (msg.what) {
                    case 100: {
                        try {
                            mhHandler.handleMessage(msg);
                        }
                        catch (Throwable throwable) {
                            sActivityKiller.finishLaunchActivity(msg);
                            Cockroach.notifyException(throwable);
                        }
                        return true;
                    }
                    case 107: {
                        try {
                            mhHandler.handleMessage(msg);
                        }
                        catch (Throwable throwable) {
                            sActivityKiller.finishResumeActivity(msg);
                            Cockroach.notifyException(throwable);
                        }
                        return true;
                    }
                    case 102: {
                        try {
                            mhHandler.handleMessage(msg);
                        }
                        catch (Throwable throwable) {
                            sActivityKiller.finishPauseActivity(msg);
                            Cockroach.notifyException(throwable);
                        }
                        return true;
                    }
                    case 101: {
                        try {
                            mhHandler.handleMessage(msg);
                        }
                        catch (Throwable throwable) {
                            sActivityKiller.finishPauseActivity(msg);
                            Cockroach.notifyException(throwable);
                        }
                        return true;
                    }
                    case 104: {
                        try {
                            mhHandler.handleMessage(msg);
                        }
                        catch (Throwable throwable) {
                            sActivityKiller.finishStopActivity(msg);
                            Cockroach.notifyException(throwable);
                        }
                        return true;
                    }
                    case 109: {
                        try {
                            mhHandler.handleMessage(msg);
                        }
                        catch (Throwable throwable) {
                            Cockroach.notifyException(throwable);
                        }
                        return true;
                    }
                }
                return false;
            }
        });
    }

    private static void notifyException(Throwable throwable) {
        if (sExceptionHandler == null) {
            return;
        }
        if (Cockroach.isSafeMode()) {
            sExceptionHandler.bandageExceptionHappened(throwable);
        } else {
            sExceptionHandler.uncaughtExceptionHappened(Looper.getMainLooper().getThread(), throwable);
            Cockroach.safeMode();
        }
    }

    public static boolean isSafeMode() {
        return sIsSafeMode;
    }

    private static void safeMode() {
        sIsSafeMode = true;
        if (sExceptionHandler != null) {
            sExceptionHandler.enterSafeMode();
        }
        while (true) {
            try {
                while (true) {
                    Looper.loop();
                }
            }
            catch (Throwable e) {
                Cockroach.isChoreographerException(e);
                if (sExceptionHandler == null) continue;
                sExceptionHandler.bandageExceptionHappened(e);
                continue;
            }
            break;
        }
    }

    private static void isChoreographerException(Throwable e) {
        if (e == null || sExceptionHandler == null) {
            return;
        }
        StackTraceElement[] elements = e.getStackTrace();
        if (elements == null) {
            return;
        }
        for (int i = elements.length - 1; i > -1; --i) {
            if (elements.length - i > 20) {
                return;
            }
            StackTraceElement element = elements[i];
            for (UnableHandleError unableHandleError : Cockroach.unableHandleError) {
                if (unableHandleError.className != null && !unableHandleError.className.matcher(element.getClassName()).matches() || unableHandleError.fileName != null && !unableHandleError.fileName.matcher(element.getFileName()).matches() || unableHandleError.methodName != null && !unableHandleError.methodName.matcher(element.getMethodName()).matches()) continue;
                sExceptionHandler.mayBeBlackScreen(e);
                return;
            }
        }
    }

    static {
        sInstalled = false;
        unableHandleError = new ArrayList<UnableHandleError>();
        unableHandleError.add(new UnableHandleError("android\\.view\\.Choreographer", "Choreographer\\.java", "doFrame"));
        unableHandleError.add(new UnableHandleError("android\\.view\\.inputmethod\\.InputMethodManager", "InputMethodManager\\.java", null));
    }
}

