/*
 * Decompiled with CFR 0.152.
 */
package com.gigya.android.sdk.biometric.v23;

import android.app.Activity;
import android.content.Context;
import android.security.keystore.KeyPermanentlyInvalidatedException;
import androidx.annotation.NonNull;
import androidx.core.hardware.fingerprint.FingerprintManagerCompat;
import androidx.core.os.CancellationSignal;
import com.gigya.android.sdk.Config;
import com.gigya.android.sdk.GigyaLogger;
import com.gigya.android.sdk.biometric.BiometricImpl;
import com.gigya.android.sdk.biometric.GigyaBiometric;
import com.gigya.android.sdk.biometric.GigyaPromptInfo;
import com.gigya.android.sdk.biometric.IGigyaBiometricCallback;
import com.gigya.android.sdk.biometric.R;
import com.gigya.android.sdk.biometric.v23.GigyaBiometricPromptV23;
import com.gigya.android.sdk.persistence.IPersistenceService;
import com.gigya.android.sdk.session.ISessionService;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class BiometricImplV23
extends BiometricImpl {
    private static final String LOG_TAG = "BiometricImplV23";
    private boolean _animate = true;

    public BiometricImplV23(Context context, Config config, ISessionService sessionService, IPersistenceService persistenceService) {
        super(context, config, sessionService, persistenceService);
    }

    @Override
    public void updateAnimationState(boolean animate) {
        this._animate = animate;
    }

    @Override
    public synchronized void showPrompt(Activity activity, final GigyaBiometric.Action action, @NonNull GigyaPromptInfo gigyaPromptInfo, int encryptionMode, final @NonNull IGigyaBiometricCallback callback) {
        SecretKey key = this._biometricKey.getKey();
        if (key == null) {
            GigyaLogger.error((String)LOG_TAG, (String)"Unable to generate secret key from KeyStore API");
            return;
        }
        if (activity == null) {
            GigyaLogger.error((String)LOG_TAG, (String)"Null Activity context provided.");
            callback.onBiometricOperationFailed("Null Activity context provided");
            return;
        }
        if (activity.isFinishing() || activity.isDestroyed()) {
            GigyaLogger.error((String)LOG_TAG, (String)"Activity state is invalid");
            callback.onBiometricOperationFailed("Activity state is invalid");
            return;
        }
        try {
            final Cipher cipher = encryptionMode == 2 ? this._biometricKey.getDecryptionCipher((Key)key) : this._biometricKey.getEncryptionCipher((Key)key);
            if (cipher != null) {
                FingerprintManagerCompat.CryptoObject cryptoObject = new FingerprintManagerCompat.CryptoObject(cipher);
                FingerprintManagerCompat fingerprintManagerCompat = FingerprintManagerCompat.from((Context)activity);
                final GigyaBiometricPromptV23 dialog = new GigyaBiometricPromptV23((Context)activity, callback);
                dialog.setTitle(gigyaPromptInfo.getTitle() != null ? gigyaPromptInfo.getTitle() : this._context.getString(R.string.bio_prompt_default_title));
                dialog.setSubtitle(gigyaPromptInfo.getSubtitle() != null ? gigyaPromptInfo.getSubtitle() : this._context.getString(R.string.bio_prompt_default_subtitle));
                dialog.setDescription(gigyaPromptInfo.getDescription() != null ? gigyaPromptInfo.getDescription() : this._context.getString(R.string.bio_prompt_default_description));
                dialog.setAnimate(this._animate);
                CancellationSignal signal = new CancellationSignal();
                dialog.setCancellationSignal(signal);
                fingerprintManagerCompat.authenticate(cryptoObject, 0, signal, new FingerprintManagerCompat.AuthenticationCallback(){

                    public void onAuthenticationError(int errMsgId, CharSequence errString) {
                        GigyaLogger.error((String)BiometricImplV23.LOG_TAG, (String)("onAuthenticationError: " + errString));
                        dialog.onAuthenticationError(errMsgId, errString.toString());
                    }

                    public void onAuthenticationHelp(int helpMsgId, CharSequence helpString) {
                        GigyaLogger.debug((String)BiometricImplV23.LOG_TAG, (String)("onAuthenticationHelp: " + helpString));
                        dialog.onAuthenticationHelp(helpString.toString());
                    }

                    public void onAuthenticationSucceeded(FingerprintManagerCompat.AuthenticationResult result) {
                        GigyaLogger.debug((String)BiometricImplV23.LOG_TAG, (String)"onAuthenticationSucceeded: ");
                        BiometricImplV23.this.onSuccessfulAuthentication(cipher, action, callback);
                        dialog.dismiss();
                    }

                    public void onAuthenticationFailed() {
                        GigyaLogger.debug((String)BiometricImplV23.LOG_TAG, (String)"onAuthenticationFailed: ");
                        dialog.onAuthenticationFailed();
                    }
                }, null);
                dialog.show();
            } else {
                GigyaLogger.error((String)LOG_TAG, (String)"Failed to initialize cipher");
                callback.onBiometricOperationFailed("Failed to initialize cipher");
            }
        }
        catch (Exception encryptionException) {
            Exception ex = (Exception)encryptionException.getCause();
            if (ex instanceof KeyPermanentlyInvalidatedException) {
                GigyaLogger.error((String)LOG_TAG, (String)ex.getMessage());
                this.onInvalidKey();
                callback.onBiometricOperationFailed("Key Invalidated");
                return;
            }
            GigyaLogger.error((String)LOG_TAG, (String)"Failed to initialize cipher");
            callback.onBiometricOperationFailed("Failed to initialize cipher");
        }
    }
}

