/*
 * Decompiled with CFR 0.152.
 */
package com.gigya.android.sdk.biometric;

import android.security.keystore.KeyGenParameterSpec;
import android.util.Base64;
import com.gigya.android.sdk.GigyaLogger;
import com.gigya.android.sdk.encryption.EncryptionException;
import com.gigya.android.sdk.encryption.ISecureKey;
import com.gigya.android.sdk.persistence.IPersistenceService;
import com.gigya.android.sdk.reporting.ReportingManager;
import java.security.Key;
import java.security.KeyStore;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Enumeration;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class BiometricKey
implements ISecureKey {
    private static final String LOG_TAG = "BiometricKey";
    private final IPersistenceService _psService;

    BiometricKey(IPersistenceService pService) {
        this._psService = pService;
    }

    public String getAlias() {
        return "fingerprint";
    }

    public String getTransformation() {
        return "AES/CBC/PKCS7Padding";
    }

    public Cipher getEncryptionCipher(Key key) throws EncryptionException {
        try {
            Cipher cipher = Cipher.getInstance(this.getTransformation());
            cipher.init(1, key);
            return cipher;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new EncryptionException("getEncryptionCipher: exception" + ex.getMessage(), (Throwable)ex);
        }
    }

    public Cipher getDecryptionCipher(Key key) throws EncryptionException {
        try {
            Cipher cipher = Cipher.getInstance(this.getTransformation());
            String ivSpec = this._psService.getString("IV_fingerprint", null);
            if (ivSpec != null) {
                IvParameterSpec spec = new IvParameterSpec(Base64.decode((String)ivSpec, (int)0));
                cipher.init(2, key, spec);
                return cipher;
            }
            GigyaLogger.error((String)LOG_TAG, (String)"createCipherFor: getIVSpec null");
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new EncryptionException("getDecryptionCipher: exception" + ex.getMessage(), (Throwable)ex);
        }
    }

    public SecretKey getKey() throws EncryptionException {
        try {
            KeyStore keyStore = KeyStore.getInstance("AndroidKeyStore");
            keyStore.load(null);
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                if (!this.getAlias().equals(aliases.nextElement())) continue;
                try {
                    return (SecretKey)keyStore.getKey(this.getAlias(), null);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.deleteKey();
                }
            }
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", "AndroidKeyStore");
            keyGenerator.init((AlgorithmParameterSpec)new KeyGenParameterSpec.Builder(this.getAlias(), 3).setBlockModes(new String[]{"CBC"}).setEncryptionPaddings(new String[]{"PKCS7Padding"}).setUserAuthenticationRequired(true).setKeySize(256).build());
            return keyGenerator.generateKey();
        }
        catch (Exception ex) {
            ReportingManager.get().error("2.1.2", "biometric", "Failed to initialize biometric key");
            ex.printStackTrace();
            return null;
        }
    }

    public void deleteKey() {
        try {
            KeyStore keyStore = KeyStore.getInstance("AndroidKeyStore");
            keyStore.load(null);
            keyStore.deleteEntry(this.getAlias());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

