/*
 * Decompiled with CFR 0.152.
 */
package com.ruffian.library.widget.shadow;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import androidx.annotation.Nullable;

public class ShadowDrawable
extends Drawable {
    private int mShadowColor;
    private float mShadowRadius;
    private float[] mRoundRadii;
    private int mShadowDx;
    private int mShadowDy;
    private Path mPath = new Path();
    private Paint mPaint;
    private RectF mBoundsF = new RectF();

    public ShadowDrawable() {
        this.mPaint = new Paint(5);
    }

    public void updateParameter(int shadowColor, float shadowRadius, int shadowDx, int shadowDy, float[] roundRadii) {
        this.mShadowColor = shadowColor;
        this.mRoundRadii = roundRadii;
        this.mShadowRadius = shadowRadius;
        this.mShadowDx = shadowDx;
        this.mShadowDy = shadowDy;
        this.mPaint.setColor(this.mShadowColor);
        this.mPaint.setShadowLayer(this.mShadowRadius, (float)this.mShadowDx, (float)this.mShadowDy, this.mShadowColor);
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        if (bounds.right - bounds.left > 0 && bounds.bottom - bounds.top > 0) {
            this.updateBounds(bounds);
        }
    }

    private void updateBounds(Rect bounds) {
        if (bounds == null) {
            bounds = this.getBounds();
        }
        float left = (float)bounds.left + this.getShadowOffset() + (float)Math.abs(this.mShadowDx);
        float right = (float)bounds.right - this.getShadowOffset() - (float)Math.abs(this.mShadowDx);
        float top = (float)bounds.top + this.getShadowOffset() + (float)Math.abs(this.mShadowDy);
        float bottom = (float)bounds.bottom - this.getShadowOffset() - (float)Math.abs(this.mShadowDy);
        this.mBoundsF.set(left, top, right, bottom);
        this.mPath.reset();
        this.mPath.addRoundRect(this.mBoundsF, this.mRoundRadii, Path.Direction.CW);
    }

    public void draw(Canvas canvas) {
        canvas.drawPath(this.mPath, this.mPaint);
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return -3;
    }

    public float getShadowOffset() {
        return this.mShadowRadius;
    }
}

