/*
 * Decompiled with CFR 0.152.
 */
package com.ruffian.library.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.ImageView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import com.ruffian.library.widget.R;
import com.ruffian.library.widget.rounded.RoundDrawable;

public class RImageView
extends AppCompatImageView {
    private float mCorner = -1.0f;
    private float mCornerTopLeft = 0.0f;
    private float mCornerTopRight = 0.0f;
    private float mCornerBottomLeft = 0.0f;
    private float mCornerBottomRight = 0.0f;
    private float mBorderWidth = 0.0f;
    private int mBorderColor = -16777216;
    private boolean mIsCircle = false;
    private Drawable mDrawable;
    private ImageView.ScaleType mScaleType;
    private int mResource;
    private ColorFilter mColorFilter;
    private PorterDuff.Mode mTintMode = PorterDuff.Mode.SRC_ATOP;

    public RImageView(Context context) {
        this(context, null);
    }

    public RImageView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initAttributeSet(context, attrs);
    }

    private void initAttributeSet(Context context, AttributeSet attrs) {
        if (context == null || attrs == null) {
            return;
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RImageView);
        this.mIsCircle = a.getBoolean(R.styleable.RImageView_is_circle, false);
        this.mCorner = a.getDimensionPixelSize(R.styleable.RImageView_corner_radius, -1);
        this.mCornerTopLeft = a.getDimensionPixelSize(R.styleable.RImageView_corner_radius_top_left, 0);
        this.mCornerTopRight = a.getDimensionPixelSize(R.styleable.RImageView_corner_radius_top_right, 0);
        this.mCornerBottomLeft = a.getDimensionPixelSize(R.styleable.RImageView_corner_radius_bottom_left, 0);
        this.mCornerBottomRight = a.getDimensionPixelSize(R.styleable.RImageView_corner_radius_bottom_right, 0);
        this.mBorderWidth = a.getDimensionPixelSize(R.styleable.RImageView_border_width, 0);
        this.mBorderColor = a.getColor(R.styleable.RImageView_border_color, -16777216);
        String namespace = "http://schemas.android.com/apk/res/android";
        int tintColor = attrs.getAttributeResourceValue(namespace, "tint", 0);
        int tintMode = attrs.getAttributeIntValue(namespace, "tintMode", 0);
        if (tintMode != 0) {
            this.mTintMode = this.wrapTintMode(tintMode);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.setImageTintList(this.getImageTintList());
        } else if (tintColor != 0) {
            this.mColorFilter = new PorterDuffColorFilter(this.getResources().getColor(tintColor), this.mTintMode);
        }
        a.recycle();
        this.updateDrawableAttrs();
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.invalidate();
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        super.setScaleType(scaleType);
        if (this.mScaleType != scaleType) {
            this.mScaleType = scaleType;
            this.updateDrawableAttrs();
            this.invalidate();
        }
    }

    public void setImageBitmap(Bitmap bm) {
        this.mResource = 0;
        this.mDrawable = RoundDrawable.fromBitmap(bm);
        this.updateDrawableAttrs();
        super.setImageDrawable(this.mDrawable);
    }

    public void setImageDrawable(Drawable drawable) {
        this.mResource = 0;
        this.mDrawable = RoundDrawable.fromDrawable(drawable);
        this.updateDrawableAttrs();
        super.setImageDrawable(this.mDrawable);
    }

    public void setImageResource(@DrawableRes int resId) {
        if (this.mResource != resId) {
            this.mResource = resId;
            this.mDrawable = this.resolveResource();
            this.updateDrawableAttrs();
            super.setImageDrawable(this.mDrawable);
        }
    }

    public void setImageTintList(@Nullable ColorStateList tint) {
        super.setImageTintList(tint);
        if (tint != null) {
            this.mColorFilter = new PorterDuffColorFilter(tint.getDefaultColor(), this.mTintMode);
        }
        this.setColorFilter();
    }

    public void setImageTintMode(@Nullable PorterDuff.Mode tintMode) {
        super.setImageTintMode(tintMode);
        this.mTintMode = tintMode;
        this.setColorFilter();
    }

    public void setColorFilter() {
        if (this.mColorFilter != null && this.mDrawable != null) {
            this.mDrawable.setColorFilter(this.mColorFilter);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawEmptyBitmap();
    }

    private Drawable resolveResource() {
        Resources resources = this.getResources();
        if (resources == null) {
            return null;
        }
        Drawable d = null;
        if (this.mResource != 0) {
            try {
                d = resources.getDrawable(this.mResource);
            }
            catch (Exception e) {
                this.mResource = 0;
            }
        }
        return RoundDrawable.fromDrawable(d);
    }

    private void updateDrawableAttrs() {
        this.updateAttrs(this.mDrawable, this.mScaleType);
        this.setColorFilter();
    }

    private void updateAttrs(Drawable drawable, ImageView.ScaleType scaleType) {
        if (drawable == null) {
            return;
        }
        if (drawable instanceof RoundDrawable) {
            ((RoundDrawable)drawable).setParams(scaleType, this.mBorderWidth, this.mBorderColor, this.mIsCircle, this.mCorner, this.mCornerTopLeft, this.mCornerTopRight, this.mCornerBottomLeft, this.mCornerBottomRight);
        } else if (drawable instanceof LayerDrawable) {
            LayerDrawable ld = (LayerDrawable)drawable;
            int layers = ld.getNumberOfLayers();
            for (int i = 0; i < layers; ++i) {
                this.updateAttrs(ld.getDrawable(i), scaleType);
            }
        }
    }

    private void drawEmptyBitmap() {
        if (this.mDrawable == null) {
            int width = this.getMeasuredWidth();
            int height = this.getMeasuredHeight();
            if (width > 0 && height > 0) {
                Drawable background = this.getBackground();
                if (background != null) {
                    background.setBounds(0, 0, width, height);
                    this.setImageDrawable(background);
                } else {
                    this.setImageBitmap(Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ALPHA_8));
                }
            }
        }
    }

    public RImageView isCircle(boolean isCircle) {
        this.mIsCircle = isCircle;
        this.updateDrawableAttrs();
        return this;
    }

    public float getBorderWidth() {
        return this.mBorderWidth;
    }

    public RImageView setBorderWidth(int borderWidth) {
        this.mBorderWidth = borderWidth;
        this.updateDrawableAttrs();
        return this;
    }

    public int getBorderColor() {
        return this.mBorderColor;
    }

    public RImageView setBorderColor(@ColorInt int borderColor) {
        this.mBorderColor = borderColor;
        this.updateDrawableAttrs();
        return this;
    }

    public float getCorner() {
        return this.mCorner;
    }

    public RImageView setCorner(float corner) {
        this.mCorner = corner;
        this.updateDrawableAttrs();
        return this;
    }

    public float getCornerTopLeft() {
        return this.mCornerTopLeft;
    }

    public RImageView setCornerTopLeft(float cornerTopLeft) {
        this.mCorner = -1.0f;
        this.mCornerTopLeft = cornerTopLeft;
        this.updateDrawableAttrs();
        return this;
    }

    public float getCornerTopRight() {
        return this.mCornerTopRight;
    }

    public RImageView setCornerTopRight(float cornerTopRight) {
        this.mCorner = -1.0f;
        this.mCornerTopRight = cornerTopRight;
        this.updateDrawableAttrs();
        return this;
    }

    public float getCornerBottomLeft() {
        return this.mCornerBottomLeft;
    }

    public RImageView setCornerBottomLeft(float cornerBottomLeft) {
        this.mCorner = -1.0f;
        this.mCornerBottomLeft = cornerBottomLeft;
        this.updateDrawableAttrs();
        return this;
    }

    public float getCornerBottomRight() {
        return this.mCornerBottomRight;
    }

    public RImageView setCornerBottomRight(float cornerBottomRight) {
        this.mCorner = -1.0f;
        this.mCornerBottomRight = cornerBottomRight;
        this.updateDrawableAttrs();
        return this;
    }

    public RImageView setCorner(float topLeft, float topRight, float bottomRight, float bottomLeft) {
        this.mCorner = -1.0f;
        this.mCornerTopLeft = topLeft;
        this.mCornerTopRight = topRight;
        this.mCornerBottomRight = bottomRight;
        this.mCornerBottomLeft = bottomLeft;
        this.updateDrawableAttrs();
        return this;
    }

    private PorterDuff.Mode wrapTintMode(int tintMode) {
        switch (tintMode) {
            case 3: {
                return PorterDuff.Mode.SRC_OVER;
            }
            case 5: {
                return PorterDuff.Mode.SRC_IN;
            }
            case 14: {
                return PorterDuff.Mode.MULTIPLY;
            }
            case 15: {
                return PorterDuff.Mode.SCREEN;
            }
            case 16: {
                return PorterDuff.Mode.ADD;
            }
        }
        return PorterDuff.Mode.SRC_ATOP;
    }
}

