/*
 * Decompiled with CFR 0.152.
 */
package com.github.hiteshsondhi88.libffmpeg;

import android.content.Context;
import com.github.hiteshsondhi88.libffmpeg.Log;
import com.github.hiteshsondhi88.libffmpeg.Util;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;
import java.util.Map;

class FileUtils {
    static final String ffmpegFileName = "ffmpeg";
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int EOF = -1;

    FileUtils() {
    }

    static boolean copyBinaryFromAssetsToData(Context context, String fileNameFromAssets, String outputFileName) {
        File filesDirectory = FileUtils.getFilesDirectory(context);
        try {
            int n;
            InputStream is = context.getAssets().open(fileNameFromAssets);
            FileOutputStream os = new FileOutputStream(new File(filesDirectory, outputFileName));
            byte[] buffer = new byte[4096];
            while (-1 != (n = is.read(buffer))) {
                os.write(buffer, 0, n);
            }
            Util.close(os);
            Util.close(is);
            return true;
        }
        catch (IOException e) {
            Log.e("issue in coping binary from assets to data. ", e);
            return false;
        }
    }

    static File getFilesDirectory(Context context) {
        return context.getFilesDir();
    }

    static String getFFmpeg(Context context) {
        return FileUtils.getFilesDirectory(context).getAbsolutePath() + File.separator + ffmpegFileName;
    }

    static String getFFmpeg(Context context, Map<String, String> environmentVars) {
        String ffmpegCommand = "";
        if (environmentVars != null) {
            for (Map.Entry<String, String> var : environmentVars.entrySet()) {
                ffmpegCommand = ffmpegCommand + var.getKey() + "=" + var.getValue() + " ";
            }
        }
        ffmpegCommand = ffmpegCommand + FileUtils.getFFmpeg(context);
        return ffmpegCommand;
    }

    static String SHA1(String file) {
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            String string2 = FileUtils.SHA1(is);
            Util.close(is);
            return string2;
        }
        catch (IOException e) {
            Log.e(e);
        }
        finally {
            Util.close(is);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String SHA1(InputStream is) {
        try {
            int read;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            byte[] buffer = new byte[4096];
            while ((read = is.read(buffer)) != -1) {
                messageDigest.update(buffer, 0, read);
            }
            Formatter formatter = new Formatter();
            for (byte b : messageDigest.digest()) {
                formatter.format("%02x", b);
            }
            String string2 = formatter.toString();
            return string2;
        }
        catch (NoSuchAlgorithmException e) {
            Log.e(e);
        }
        catch (IOException e) {
            Log.e(e);
        }
        finally {
            Util.close(is);
        }
        return null;
    }
}

