/*
 * Decompiled with CFR 0.152.
 */
package com.github.hiteshsondhi88.libffmpeg;

import android.content.Context;
import android.os.AsyncTask;
import com.github.hiteshsondhi88.libffmpeg.CpuArch;
import com.github.hiteshsondhi88.libffmpeg.FFmpegLoadBinaryResponseHandler;
import com.github.hiteshsondhi88.libffmpeg.FileUtils;
import com.github.hiteshsondhi88.libffmpeg.Log;
import java.io.File;

class FFmpegLoadLibraryAsyncTask
extends AsyncTask<Void, Void, Boolean> {
    private final String cpuArchNameFromAssets;
    private final FFmpegLoadBinaryResponseHandler ffmpegLoadBinaryResponseHandler;
    private final Context context;

    FFmpegLoadLibraryAsyncTask(Context context, String cpuArchNameFromAssets, FFmpegLoadBinaryResponseHandler ffmpegLoadBinaryResponseHandler) {
        this.context = context;
        this.cpuArchNameFromAssets = cpuArchNameFromAssets;
        this.ffmpegLoadBinaryResponseHandler = ffmpegLoadBinaryResponseHandler;
    }

    protected Boolean doInBackground(Void ... params) {
        boolean isFileCopied;
        File ffmpegFile = new File(FileUtils.getFFmpeg(this.context));
        if (ffmpegFile.exists() && this.isDeviceFFmpegVersionOld() && !ffmpegFile.delete()) {
            return false;
        }
        if (!ffmpegFile.exists() && (isFileCopied = FileUtils.copyBinaryFromAssetsToData(this.context, this.cpuArchNameFromAssets + File.separator + "ffmpeg", "ffmpeg"))) {
            if (!ffmpegFile.canExecute()) {
                Log.d("FFmpeg is not executable, trying to make it executable ...");
                if (ffmpegFile.setExecutable(true)) {
                    return true;
                }
            } else {
                Log.d("FFmpeg is executable");
                return true;
            }
        }
        return ffmpegFile.exists() && ffmpegFile.canExecute();
    }

    protected void onPostExecute(Boolean isSuccess) {
        super.onPostExecute((Object)isSuccess);
        if (this.ffmpegLoadBinaryResponseHandler != null) {
            if (isSuccess.booleanValue()) {
                this.ffmpegLoadBinaryResponseHandler.onSuccess();
            } else {
                this.ffmpegLoadBinaryResponseHandler.onFailure();
            }
            this.ffmpegLoadBinaryResponseHandler.onFinish();
        }
    }

    private boolean isDeviceFFmpegVersionOld() {
        return CpuArch.fromString(FileUtils.SHA1(FileUtils.getFFmpeg(this.context))).equals((Object)CpuArch.NONE);
    }
}

