/*
 * Decompiled with CFR 0.152.
 */
package com.maple.recorder.recording;

import com.maple.recorder.recording.AudioRecordConfig;
import com.maple.recorder.recording.BaseDataRecorder;
import com.maple.recorder.recording.PullTransport;
import com.maple.recorder.recording.WavHeader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class WavRecorder
extends BaseDataRecorder {
    public WavRecorder(File file, AudioRecordConfig config, PullTransport pullTransport) {
        super(file, config, pullTransport);
    }

    @Override
    public void stopRecording() {
        try {
            super.stopRecording();
            this.writeWavHeader();
        }
        catch (IOException e) {
            throw new RuntimeException("Error in applying wav header", e);
        }
    }

    private void writeWavHeader() throws IOException {
        RandomAccessFile wavFile = this.randomAccessFile(this.file);
        wavFile.seek(0L);
        wavFile.write(new WavHeader(this.config, this.file.length()).toBytes());
        wavFile.close();
    }

    private RandomAccessFile randomAccessFile(File file) {
        RandomAccessFile randomAccessFile;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return randomAccessFile;
    }
}

