/*
 * Decompiled with CFR 0.152.
 */
package com.maple.recorder.player;

import android.media.MediaPlayer;

public class PlayUtils {
    PlayStateChangeListener playStateChangeListener;
    MediaPlayer player;

    public void setPlayStateChangeListener(PlayStateChangeListener listener) {
        this.playStateChangeListener = listener;
        this.playStateChangeListener.onPlayStateChange(false);
    }

    public void startPlaying(String filePath) {
        try {
            this.player = new MediaPlayer();
            this.player.setDataSource(filePath);
            this.player.prepareAsync();
            this.player.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                public void onPrepared(MediaPlayer mp) {
                    PlayUtils.this.player.start();
                }
            });
            if (this.playStateChangeListener != null) {
                this.playStateChangeListener.onPlayStateChange(true);
            }
            this.player.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                public void onCompletion(MediaPlayer mp) {
                    PlayUtils.this.stopPlaying();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void pausePlay() {
        try {
            if (this.player != null) {
                this.player.pause();
                if (this.playStateChangeListener != null) {
                    this.playStateChangeListener.onPlayStateChange(false);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopPlaying() {
        try {
            if (this.player != null) {
                this.player.stop();
                this.player.reset();
                if (this.playStateChangeListener != null) {
                    this.playStateChangeListener.onPlayStateChange(false);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isPlaying() {
        try {
            return this.player != null && this.player.isPlaying();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static interface PlayStateChangeListener {
        public void onPlayStateChange(boolean var1);
    }
}

