/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.core.http;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.github.mkopylec.charon.configuration.CharonProperties;
import com.github.mkopylec.charon.configuration.MappingProperties;
import com.github.mkopylec.charon.core.balancer.LoadBalancer;
import com.github.mkopylec.charon.core.http.ForwardDestination;
import com.github.mkopylec.charon.core.http.ForwardedRequestInterceptor;
import com.github.mkopylec.charon.core.http.HttpClientProvider;
import com.github.mkopylec.charon.core.http.ReceivedResponseInterceptor;
import com.github.mkopylec.charon.core.http.RequestData;
import com.github.mkopylec.charon.core.http.ResponseData;
import com.github.mkopylec.charon.core.mappings.MappingsProvider;
import com.github.mkopylec.charon.core.trace.ProxyingTraceInterceptor;
import com.github.mkopylec.charon.core.utils.UriCorrector;
import com.github.mkopylec.charon.exceptions.CharonException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.RetryContext;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;

public class RequestForwarder {
    private static final Logger log = LoggerFactory.getLogger(RequestForwarder.class);
    protected final ServerProperties server;
    protected final CharonProperties charon;
    protected final HttpClientProvider httpClientProvider;
    protected final MappingsProvider mappingsProvider;
    protected final LoadBalancer loadBalancer;
    protected final MetricRegistry metricRegistry;
    protected final ProxyingTraceInterceptor traceInterceptor;
    protected final ForwardedRequestInterceptor forwardedRequestInterceptor;
    protected final ReceivedResponseInterceptor receivedResponseInterceptor;

    public RequestForwarder(ServerProperties server, CharonProperties charon, HttpClientProvider httpClientProvider, MappingsProvider mappingsProvider, LoadBalancer loadBalancer, MetricRegistry metricRegistry, ProxyingTraceInterceptor traceInterceptor, ForwardedRequestInterceptor forwardedRequestInterceptor, ReceivedResponseInterceptor receivedResponseInterceptor) {
        this.server = server;
        this.charon = charon;
        this.httpClientProvider = httpClientProvider;
        this.mappingsProvider = mappingsProvider;
        this.loadBalancer = loadBalancer;
        this.metricRegistry = metricRegistry;
        this.traceInterceptor = traceInterceptor;
        this.forwardedRequestInterceptor = forwardedRequestInterceptor;
        this.receivedResponseInterceptor = receivedResponseInterceptor;
    }

    public ResponseEntity<byte[]> forwardHttpRequest(RequestData data, String traceId, RetryContext context, MappingProperties mapping) {
        this.forwardedRequestInterceptor.intercept(data);
        ForwardDestination destination = this.resolveForwardDestination(data.getUri(), mapping);
        this.prepareForwardedRequestHeaders(data, destination);
        this.traceInterceptor.onForwardStart(traceId, destination.getMappingName(), data.getMethod(), destination.getUri().toString(), data.getBody(), data.getHeaders());
        context.setAttribute("mapping-name", (Object)destination.getMappingName());
        RequestEntity request = new RequestEntity((Object)data.getBody(), (MultiValueMap)data.getHeaders(), data.getMethod(), destination.getUri());
        ResponseData response = this.sendRequest(traceId, (RequestEntity<byte[]>)request, mapping, destination.getMappingMetricsName());
        log.info("Forwarding: {} {} -> {} {}", new Object[]{data.getMethod(), data.getUri(), destination.getUri(), response.getStatus().value()});
        this.traceInterceptor.onForwardComplete(traceId, response.getStatus(), response.getBody(), response.getHeaders());
        this.receivedResponseInterceptor.intercept(response);
        this.prepareForwardedResponseHeaders(response);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)response.getStatus()).headers(response.getHeaders())).body((Object)response.getBody());
    }

    private void prepareForwardedResponseHeaders(ResponseData response) {
        HttpHeaders headers = new HttpHeaders();
        headers.putAll((Map)response.getHeaders());
        response.setHeaders(headers);
        headers.remove((Object)"Transfer-Encoding");
        headers.remove((Object)"Connection");
        headers.remove((Object)"Public-Key-Pins");
        headers.remove((Object)"Server");
        headers.remove((Object)"Strict-Transport-Security");
    }

    private void prepareForwardedRequestHeaders(RequestData request, ForwardDestination destination) {
        request.getHeaders().set("Host", destination.uri.getAuthority());
        request.getHeaders().remove((Object)"TE");
    }

    protected ForwardDestination resolveForwardDestination(String originUri, MappingProperties mapping) {
        return new ForwardDestination(this.createDestinationUrl(originUri, mapping), mapping.getName(), this.resolveMetricsName(mapping));
    }

    protected URI createDestinationUrl(String uri, MappingProperties mapping) {
        if (mapping.isStripPath()) {
            uri = this.stripMappingPath(uri, mapping);
        }
        String host = this.loadBalancer.chooseDestination(mapping.getDestinations());
        try {
            return new URI(host + uri);
        }
        catch (URISyntaxException e) {
            throw new CharonException("Error creating destination URL from HTTP request URI: " + uri + " using mapping " + mapping, e);
        }
    }

    protected ResponseData sendRequest(String traceId, RequestEntity<byte[]> request, MappingProperties mapping, String mappingMetricsName) {
        ResponseEntity response;
        Timer.Context context = null;
        if (this.charon.getMetrics().isEnabled()) {
            context = this.metricRegistry.timer(mappingMetricsName).time();
        }
        try {
            response = this.httpClientProvider.getHttpClient(mapping.getName()).exchange(request, byte[].class);
            this.stopTimerContext(context);
        }
        catch (HttpStatusCodeException e) {
            this.stopTimerContext(context);
            if (this.charon.getRetrying().getRetryOn().getExceptions().contains(((Object)((Object)e)).getClass())) {
                this.traceInterceptor.onForwardFailed(traceId, e);
                throw e;
            }
            response = ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)e.getStatusCode()).headers(e.getResponseHeaders())).body((Object)e.getResponseBodyAsByteArray());
        }
        catch (Exception e) {
            this.stopTimerContext(context);
            this.traceInterceptor.onForwardFailed(traceId, e);
            throw e;
        }
        return new ResponseData(response.getStatusCode(), response.getHeaders(), (byte[])response.getBody());
    }

    protected void stopTimerContext(Timer.Context context) {
        if (context != null) {
            context.stop();
        }
    }

    protected String resolveMetricsName(MappingProperties mapping) {
        return MetricRegistry.name((String)this.charon.getMetrics().getNamesPrefix(), (String[])new String[]{mapping.getName()});
    }

    protected String stripMappingPath(String uri, MappingProperties mapping) {
        return StringUtils.prependIfMissing((String)StringUtils.removeStart((String)uri, (String)this.concatContextAndMappingPaths(mapping)), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }

    protected String concatContextAndMappingPaths(MappingProperties mapping) {
        return UriCorrector.correctUri(this.server.getContextPath()) + mapping.getPath();
    }
}

