/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.configuration;

import com.github.mkopylec.charon.exceptions.CharonException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;

public class RetryingProperties {
    public static final String MAPPING_NAME_RETRY_ATTRIBUTE = "mapping-name";
    private int maxAttempts = 3;
    private RetryOnProperties retryOn = new RetryOnProperties();

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public RetryOnProperties getRetryOn() {
        return this.retryOn;
    }

    public void setRetryOn(RetryOnProperties retryOn) {
        this.retryOn = retryOn;
    }

    public static class RetryOnProperties {
        private boolean clientHttpError = false;
        private boolean serverHttpError = true;
        private String exceptions = "java.lang.Exception";
        private List<Class<? extends Throwable>> retryableExceptions = new ArrayList<Class<? extends Throwable>>();

        public boolean isClientHttpError() {
            return this.clientHttpError;
        }

        public void setClientHttpError(boolean clientHttpError) {
            this.clientHttpError = clientHttpError;
        }

        public boolean isServerHttpError() {
            return this.serverHttpError;
        }

        public void setServerHttpError(boolean serverHttpError) {
            this.serverHttpError = serverHttpError;
        }

        public List<Class<? extends Throwable>> getExceptions() {
            if (StringUtils.isBlank((CharSequence)this.exceptions)) {
                return Collections.emptyList();
            }
            if (this.retryableExceptions.isEmpty()) {
                this.retryableExceptions = Stream.of(this.exceptions.split(",")).map(exceptionType -> {
                    try {
                        return Class.forName(exceptionType.trim());
                    }
                    catch (ClassNotFoundException e) {
                        throw new CharonException("Invalid retryable exception: " + exceptionType, e);
                    }
                }).collect(Collectors.toList());
                if (this.clientHttpError) {
                    this.retryableExceptions.add(HttpClientErrorException.class);
                }
                if (this.serverHttpError) {
                    this.retryableExceptions.add(HttpServerErrorException.class);
                }
            }
            return this.retryableExceptions;
        }

        public void setExceptions(String exceptions) {
            this.exceptions = exceptions;
        }
    }
}

