/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import com.raizlabs.android.dbflow.StringUtils;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.language.SQLCondition;

public class UnSafeStringCondition
implements SQLCondition {
    private final String conditionString;
    private String separator = "";

    public UnSafeStringCondition(String selection, String[] selectionArgs) {
        String newSelection = selection;
        if (newSelection != null) {
            for (String selectionArg : selectionArgs) {
                newSelection = newSelection.replaceFirst("\\?", selectionArg);
            }
        }
        this.conditionString = newSelection;
    }

    @Override
    public void appendConditionToQuery(QueryBuilder queryBuilder) {
        queryBuilder.append((Object)this.conditionString);
    }

    @Override
    public String columnName() {
        return "";
    }

    @Override
    public String separator() {
        return this.separator;
    }

    @Override
    public SQLCondition separator(String separator) {
        this.separator = separator;
        return this;
    }

    @Override
    public boolean hasSeparator() {
        return StringUtils.isNotNullOrEmpty((String)this.separator);
    }

    @Override
    public String operation() {
        return "";
    }

    @Override
    public Object value() {
        return "";
    }
}

