/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectmapk.jackson.module.kogera.ser.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.github.projectmapk.jackson.module.kogera.ValueClassUnboxConverter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J%\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/github/projectmapk/jackson/module/kogera/ser/serializers/ValueClassUnboxKeySerializer;", "T", "", "Lcom/fasterxml/jackson/databind/ser/std/StdSerializer;", "converter", "Lio/github/projectmapk/jackson/module/kogera/ValueClassUnboxConverter;", "(Lio/github/projectmapk/jackson/module/kogera/ValueClassUnboxConverter;)V", "serialize", "", "value", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "(Ljava/lang/Object;Lcom/fasterxml/jackson/core/JsonGenerator;Lcom/fasterxml/jackson/databind/SerializerProvider;)V", "jackson-module-kogera"})
public final class ValueClassUnboxKeySerializer<T>
extends StdSerializer<T> {
    @NotNull
    private final ValueClassUnboxConverter<T> converter;

    public ValueClassUnboxKeySerializer(@NotNull ValueClassUnboxConverter<T> converter) {
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        super(converter.getValueClass());
        this.converter = converter;
    }

    public void serialize(@NotNull T value, @NotNull JsonGenerator gen, @NotNull SerializerProvider provider) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Object unboxed = this.converter.convert(value);
        if (unboxed == null) {
            TypeFactory typeFactory = provider.getTypeFactory();
            Intrinsics.checkNotNullExpressionValue((Object)typeFactory, (String)"provider.typeFactory");
            JavaType javaType = this.converter.getOutputType(typeFactory);
            provider.findNullKeySerializer(javaType, null).serialize(null, gen, provider);
            return;
        }
        provider.findKeySerializer(unboxed.getClass(), null).serialize(unboxed, gen, provider);
    }
}

