/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.multiplatformbleadapter.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import rx.Subscription;

public class DisposableMap {
    private final Map<String, Subscription> subscriptions = new HashMap<String, Subscription>();

    public synchronized void replaceSubscription(String key, Subscription subscription) {
        Subscription oldSubscription = this.subscriptions.put(key, subscription);
        if (oldSubscription != null && !oldSubscription.isUnsubscribed()) {
            oldSubscription.unsubscribe();
        }
    }

    public synchronized boolean removeSubscription(String key) {
        Subscription subscription = this.subscriptions.remove(key);
        if (subscription == null) {
            return false;
        }
        if (!subscription.isUnsubscribed()) {
            subscription.unsubscribe();
        }
        return true;
    }

    public synchronized void removeAllSubscriptions() {
        Iterator<Map.Entry<String, Subscription>> it = this.subscriptions.entrySet().iterator();
        while (it.hasNext()) {
            Subscription subscription = it.next().getValue();
            it.remove();
            if (subscription.isUnsubscribed()) continue;
            subscription.unsubscribe();
        }
    }
}

