/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.multiplatformbleadapter;

import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.polidea.multiplatformbleadapter.Characteristic;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class Service {
    private final int id;
    private final String deviceID;
    private final BluetoothGattService btGattService;

    public Service(int id, String deviceID, BluetoothGattService btGattService) {
        this.id = id;
        this.deviceID = deviceID;
        this.btGattService = btGattService;
    }

    public int getId() {
        return this.id;
    }

    public UUID getUuid() {
        return this.btGattService.getUuid();
    }

    public String getDeviceID() {
        return this.deviceID;
    }

    public boolean isPrimary() {
        return this.btGattService.getType() == 0;
    }

    @Nullable
    public Characteristic getCharacteristicByUUID(@NonNull UUID uuid) {
        BluetoothGattCharacteristic characteristic = this.btGattService.getCharacteristic(uuid);
        if (characteristic == null) {
            return null;
        }
        return new Characteristic(this, characteristic);
    }

    public List<Characteristic> getCharacteristics() {
        ArrayList<Characteristic> characteristics = new ArrayList<Characteristic>(this.btGattService.getCharacteristics().size());
        for (BluetoothGattCharacteristic gattCharacteristic : this.btGattService.getCharacteristics()) {
            characteristics.add(new Characteristic(this, gattCharacteristic));
        }
        return characteristics;
    }
}

