/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.multiplatformbleadapter;

import android.bluetooth.BluetoothGattDescriptor;
import android.support.annotation.NonNull;
import com.polidea.multiplatformbleadapter.Characteristic;
import com.polidea.multiplatformbleadapter.utils.ByteUtils;
import com.polidea.multiplatformbleadapter.utils.IdGenerator;
import com.polidea.multiplatformbleadapter.utils.IdGeneratorKey;
import com.polidea.rxandroidble.internal.RxBleLog;
import java.util.UUID;

public class Descriptor {
    private final int characteristicId;
    private final int serviceId;
    private final UUID characteristicUuid;
    private final UUID serviceUuid;
    private final String deviceId;
    private final BluetoothGattDescriptor descriptor;
    private final int id;
    private final UUID uuid;
    private byte[] value = null;

    public Descriptor(@NonNull Characteristic characteristic, @NonNull BluetoothGattDescriptor gattDescriptor) {
        this.characteristicId = characteristic.getId();
        this.characteristicUuid = characteristic.getUuid();
        this.serviceId = characteristic.getServiceID();
        this.serviceUuid = characteristic.getServiceUUID();
        this.descriptor = gattDescriptor;
        this.deviceId = characteristic.getDeviceId();
        this.id = IdGenerator.getIdForKey(new IdGeneratorKey(this.deviceId, this.descriptor.getUuid(), this.characteristicId));
        this.uuid = gattDescriptor.getUuid();
    }

    public Descriptor(int characteristicId, int serviceId, UUID characteristicUuid, UUID serviceUuid, String deviceId, BluetoothGattDescriptor descriptor, int id, UUID uuid) {
        this.characteristicId = characteristicId;
        this.serviceId = serviceId;
        this.characteristicUuid = characteristicUuid;
        this.serviceUuid = serviceUuid;
        this.deviceId = deviceId;
        this.descriptor = descriptor;
        this.id = id;
        this.uuid = uuid;
    }

    public Descriptor(Descriptor other) {
        this.characteristicUuid = other.characteristicUuid;
        this.characteristicId = other.characteristicId;
        this.serviceUuid = other.serviceUuid;
        this.serviceId = other.serviceId;
        this.deviceId = other.deviceId;
        this.descriptor = other.descriptor;
        this.id = other.id;
        this.uuid = other.uuid;
        if (other.value != null) {
            this.value = (byte[])other.value.clone();
        }
    }

    public int getId() {
        return this.id;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public int getCharacteristicId() {
        return this.characteristicId;
    }

    public int getServiceId() {
        return this.serviceId;
    }

    public UUID getCharacteristicUuid() {
        return this.characteristicUuid;
    }

    public UUID getServiceUuid() {
        return this.serviceUuid;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public void setValueFromCache() {
        this.value = this.descriptor.getValue();
    }

    public BluetoothGattDescriptor getNativeDescriptor() {
        return this.descriptor;
    }

    public void logValue(String message, byte[] value) {
        if (value == null) {
            value = this.descriptor.getValue();
        }
        String hexValue = value != null ? ByteUtils.bytesToHex(value) : "(null)";
        RxBleLog.v((String)(message + " Descriptor(uuid: " + this.descriptor.getUuid().toString() + ", id: " + this.id + ", value: " + hexValue + ")"), (Object[])new Object[0]);
    }
}

