/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.multiplatformbleadapter;

import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.polidea.multiplatformbleadapter.Descriptor;
import com.polidea.multiplatformbleadapter.Service;
import com.polidea.multiplatformbleadapter.utils.ByteUtils;
import com.polidea.multiplatformbleadapter.utils.Constants;
import com.polidea.multiplatformbleadapter.utils.IdGenerator;
import com.polidea.multiplatformbleadapter.utils.IdGeneratorKey;
import com.polidea.rxandroidble.internal.RxBleLog;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class Characteristic {
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    private final int id;
    private final int serviceID;
    private final UUID serviceUUID;
    private final String deviceID;
    private byte[] value;
    final BluetoothGattCharacteristic gattCharacteristic;

    public void setValue(byte[] value) {
        this.value = value;
    }

    public Characteristic(@NonNull Service service, @NonNull BluetoothGattCharacteristic gattCharacteristic) {
        this.deviceID = service.getDeviceID();
        this.serviceUUID = service.getUuid();
        this.serviceID = service.getId();
        this.gattCharacteristic = gattCharacteristic;
        this.id = IdGenerator.getIdForKey(new IdGeneratorKey(this.deviceID, gattCharacteristic.getUuid(), gattCharacteristic.getInstanceId()));
    }

    public Characteristic(int id, @NonNull Service service, BluetoothGattCharacteristic gattCharacteristic) {
        this.id = id;
        this.deviceID = service.getDeviceID();
        this.serviceUUID = service.getUuid();
        this.serviceID = service.getId();
        this.gattCharacteristic = gattCharacteristic;
    }

    public Characteristic(Characteristic other) {
        this.id = other.id;
        this.serviceID = other.serviceID;
        this.serviceUUID = other.serviceUUID;
        this.deviceID = other.deviceID;
        if (other.value != null) {
            this.value = (byte[])other.value.clone();
        }
        this.gattCharacteristic = other.gattCharacteristic;
    }

    public int getId() {
        return this.id;
    }

    public UUID getUuid() {
        return this.gattCharacteristic.getUuid();
    }

    public int getServiceID() {
        return this.serviceID;
    }

    public UUID getServiceUUID() {
        return this.serviceUUID;
    }

    public String getDeviceId() {
        return this.deviceID;
    }

    public int getInstanceId() {
        return this.gattCharacteristic.getInstanceId();
    }

    public BluetoothGattDescriptor getGattDescriptor(UUID uuid) {
        return this.gattCharacteristic.getDescriptor(uuid);
    }

    public void setWriteType(int writeType) {
        this.gattCharacteristic.setWriteType(writeType);
    }

    public boolean isReadable() {
        return (this.gattCharacteristic.getProperties() & 2) != 0;
    }

    public boolean isWritableWithResponse() {
        return (this.gattCharacteristic.getProperties() & 8) != 0;
    }

    public boolean isWritableWithoutResponse() {
        return (this.gattCharacteristic.getProperties() & 4) != 0;
    }

    public boolean isNotifiable() {
        return (this.gattCharacteristic.getProperties() & 0x10) != 0;
    }

    public List<Descriptor> getDescriptors() {
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>(this.gattCharacteristic.getDescriptors().size());
        for (BluetoothGattDescriptor gattDescriptor : this.gattCharacteristic.getDescriptors()) {
            descriptors.add(new Descriptor(this, gattDescriptor));
        }
        return descriptors;
    }

    public boolean isNotifying() {
        byte[] descriptorValue;
        BluetoothGattDescriptor descriptor = this.gattCharacteristic.getDescriptor(Constants.CLIENT_CHARACTERISTIC_CONFIG_UUID);
        boolean isNotifying = false;
        if (descriptor != null && (descriptorValue = descriptor.getValue()) != null) {
            isNotifying = (descriptorValue[0] & 1) != 0;
        }
        return isNotifying;
    }

    public boolean isIndicatable() {
        return (this.gattCharacteristic.getProperties() & 0x20) != 0;
    }

    public byte[] getValue() {
        return this.value;
    }

    @Nullable
    public Descriptor getDescriptorByUUID(@NonNull UUID uuid) {
        BluetoothGattDescriptor descriptor = this.gattCharacteristic.getDescriptor(uuid);
        if (descriptor == null) {
            return null;
        }
        return new Descriptor(this, descriptor);
    }

    void logValue(String message, byte[] value) {
        if (value == null) {
            value = this.gattCharacteristic.getValue();
        }
        String hexValue = value != null ? ByteUtils.bytesToHex(value) : "(null)";
        RxBleLog.v((String)(message + " Characteristic(uuid: " + this.gattCharacteristic.getUuid().toString() + ", id: " + this.id + ", value: " + hexValue + ")"), (Object[])new Object[0]);
    }
}

