/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.multiplatformbleadapter;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.os.Build;
import android.os.ParcelUuid;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.SparseArray;
import com.polidea.multiplatformbleadapter.BleAdapter;
import com.polidea.multiplatformbleadapter.Characteristic;
import com.polidea.multiplatformbleadapter.ConnectionOptions;
import com.polidea.multiplatformbleadapter.ConnectionState;
import com.polidea.multiplatformbleadapter.Descriptor;
import com.polidea.multiplatformbleadapter.Device;
import com.polidea.multiplatformbleadapter.OnErrorCallback;
import com.polidea.multiplatformbleadapter.OnEventCallback;
import com.polidea.multiplatformbleadapter.OnSuccessCallback;
import com.polidea.multiplatformbleadapter.RefreshGattMoment;
import com.polidea.multiplatformbleadapter.ScanResult;
import com.polidea.multiplatformbleadapter.Service;
import com.polidea.multiplatformbleadapter.errors.BleError;
import com.polidea.multiplatformbleadapter.errors.BleErrorCode;
import com.polidea.multiplatformbleadapter.errors.BleErrorUtils;
import com.polidea.multiplatformbleadapter.errors.ErrorConverter;
import com.polidea.multiplatformbleadapter.exceptions.CannotMonitorCharacteristicException;
import com.polidea.multiplatformbleadapter.utils.Base64Converter;
import com.polidea.multiplatformbleadapter.utils.Constants;
import com.polidea.multiplatformbleadapter.utils.DisposableMap;
import com.polidea.multiplatformbleadapter.utils.IdGenerator;
import com.polidea.multiplatformbleadapter.utils.LogLevel;
import com.polidea.multiplatformbleadapter.utils.RefreshGattCustomOperation;
import com.polidea.multiplatformbleadapter.utils.SafeExecutor;
import com.polidea.multiplatformbleadapter.utils.ServiceFactory;
import com.polidea.multiplatformbleadapter.utils.UUIDConverter;
import com.polidea.multiplatformbleadapter.utils.mapper.RxBleDeviceToDeviceMapper;
import com.polidea.multiplatformbleadapter.utils.mapper.RxScanResultToScanResultMapper;
import com.polidea.rxandroidble.NotificationSetupMode;
import com.polidea.rxandroidble.RxBleAdapterStateObservable;
import com.polidea.rxandroidble.RxBleClient;
import com.polidea.rxandroidble.RxBleConnection;
import com.polidea.rxandroidble.RxBleCustomOperation;
import com.polidea.rxandroidble.RxBleDevice;
import com.polidea.rxandroidble.RxBleDeviceServices;
import com.polidea.rxandroidble.internal.RxBleLog;
import com.polidea.rxandroidble.scan.ScanFilter;
import com.polidea.rxandroidble.scan.ScanSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public class BleModule
implements BleAdapter {
    private final ErrorConverter errorConverter = new ErrorConverter();
    @Nullable
    private RxBleClient rxBleClient;
    private HashMap<String, Device> discoveredDevices = new HashMap();
    private HashMap<String, Device> connectedDevices = new HashMap();
    private HashMap<String, RxBleConnection> activeConnections = new HashMap();
    private SparseArray<Service> discoveredServices = new SparseArray();
    private SparseArray<Characteristic> discoveredCharacteristics = new SparseArray();
    private SparseArray<Descriptor> discoveredDescriptors = new SparseArray();
    private final DisposableMap pendingTransactions = new DisposableMap();
    private final DisposableMap connectingDevices = new DisposableMap();
    private BluetoothManager bluetoothManager;
    private BluetoothAdapter bluetoothAdapter;
    private Context context;
    @Nullable
    private Subscription scanSubscription;
    @Nullable
    private Subscription adapterStateChangesSubscription;
    private RxBleDeviceToDeviceMapper rxBleDeviceToDeviceMapper = new RxBleDeviceToDeviceMapper();
    private RxScanResultToScanResultMapper rxScanResultToScanResultMapper = new RxScanResultToScanResultMapper();
    private ServiceFactory serviceFactory = new ServiceFactory();
    private int currentLogLevel = Integer.MAX_VALUE;

    public BleModule(Context context) {
        this.context = context;
        this.bluetoothManager = (BluetoothManager)context.getSystemService("bluetooth");
        this.bluetoothAdapter = this.bluetoothManager.getAdapter();
    }

    @Override
    public void createClient(String restoreStateIdentifier, OnEventCallback<String> onAdapterStateChangeCallback, OnEventCallback<Integer> onStateRestored) {
        this.rxBleClient = RxBleClient.create((Context)this.context);
        this.adapterStateChangesSubscription = this.monitorAdapterStateChanges(this.context, onAdapterStateChangeCallback);
        if (restoreStateIdentifier != null) {
            onStateRestored.onEvent(null);
        }
    }

    @Override
    public void destroyClient() {
        if (this.adapterStateChangesSubscription != null) {
            this.adapterStateChangesSubscription.unsubscribe();
            this.adapterStateChangesSubscription = null;
        }
        if (this.scanSubscription != null && !this.scanSubscription.isUnsubscribed()) {
            this.scanSubscription.unsubscribe();
            this.scanSubscription = null;
        }
        this.pendingTransactions.removeAllSubscriptions();
        this.connectingDevices.removeAllSubscriptions();
        this.discoveredServices.clear();
        this.discoveredCharacteristics.clear();
        this.discoveredDescriptors.clear();
        this.connectedDevices.clear();
        this.activeConnections.clear();
        this.discoveredDevices.clear();
        this.rxBleClient = null;
        IdGenerator.clear();
    }

    @Override
    public void enable(String transactionId, OnSuccessCallback<Void> onSuccessCallback, OnErrorCallback onErrorCallback) {
        this.changeAdapterState(RxBleAdapterStateObservable.BleAdapterState.STATE_ON, transactionId, onSuccessCallback, onErrorCallback);
    }

    @Override
    public void disable(String transactionId, OnSuccessCallback<Void> onSuccessCallback, OnErrorCallback onErrorCallback) {
        this.changeAdapterState(RxBleAdapterStateObservable.BleAdapterState.STATE_OFF, transactionId, onSuccessCallback, onErrorCallback);
    }

    @Override
    public String getCurrentState() {
        if (!this.supportsBluetoothLowEnergy()) {
            return "Unsupported";
        }
        if (this.bluetoothManager == null) {
            return "PoweredOff";
        }
        return this.mapNativeAdapterStateToLocalBluetoothState(this.bluetoothAdapter.getState());
    }

    @Override
    public void startDeviceScan(String[] filteredUUIDs, int scanMode, int callbackType, OnEventCallback<ScanResult> onEventCallback, OnErrorCallback onErrorCallback) {
        UUID[] uuids = null;
        if (filteredUUIDs != null && (uuids = UUIDConverter.convert(filteredUUIDs)) == null) {
            onErrorCallback.onError(BleErrorUtils.invalidIdentifiers(filteredUUIDs));
            return;
        }
        this.safeStartDeviceScan(uuids, scanMode, callbackType, onEventCallback, onErrorCallback);
    }

    @Override
    public void stopDeviceScan() {
        if (this.scanSubscription != null) {
            this.scanSubscription.unsubscribe();
            this.scanSubscription = null;
        }
    }

    @Override
    public void requestConnectionPriorityForDevice(String deviceIdentifier, int connectionPriority, final String transactionId, OnSuccessCallback<Device> onSuccessCallback, OnErrorCallback onErrorCallback) {
        Device device;
        try {
            device = this.getDeviceById(deviceIdentifier);
        }
        catch (BleError error) {
            onErrorCallback.onError(error);
            return;
        }
        RxBleConnection connection = this.getConnectionOrEmitError(device.getId(), onErrorCallback);
        if (connection == null) {
            return;
        }
        final SafeExecutor<Device> safeExecutor = new SafeExecutor<Device>(onSuccessCallback, onErrorCallback);
        if (Build.VERSION.SDK_INT >= 21) {
            Subscription subscription = connection.requestConnectionPriority(connectionPriority, 1L, TimeUnit.MILLISECONDS).doOnUnsubscribe(new Action0(){

                public void call() {
                    safeExecutor.error(BleErrorUtils.cancelled());
                    BleModule.this.pendingTransactions.removeSubscription(transactionId);
                }
            }).subscribe(new Action0(){

                public void call() {
                    safeExecutor.success(device);
                    BleModule.this.pendingTransactions.removeSubscription(transactionId);
                }
            }, (Action1)new Action1<Throwable>(){

                public void call(Throwable error) {
                    safeExecutor.error(BleModule.this.errorConverter.toError(error));
                    BleModule.this.pendingTransactions.removeSubscription(transactionId);
                }
            });
            this.pendingTransactions.replaceSubscription(transactionId, subscription);
        } else {
            onSuccessCallback.onSuccess(device);
        }
    }

    @Override
    public void readRSSIForDevice(String deviceIdentifier, final String transactionId, OnSuccessCallback<Device> onSuccessCallback, OnErrorCallback onErrorCallback) {
        Device device;
        try {
            device = this.getDeviceById(deviceIdentifier);
        }
        catch (BleError error) {
            onErrorCallback.onError(error);
            return;
        }
        RxBleConnection connection = this.getConnectionOrEmitError(device.getId(), onErrorCallback);
        if (connection == null) {
            return;
        }
        final SafeExecutor<Device> safeExecutor = new SafeExecutor<Device>(onSuccessCallback, onErrorCallback);
        Subscription subscription = connection.readRssi().doOnUnsubscribe(new Action0(){

            public void call() {
                safeExecutor.error(BleErrorUtils.cancelled());
                BleModule.this.pendingTransactions.removeSubscription(transactionId);
            }
        }).subscribe((Observer)new Observer<Integer>(){

            public void onCompleted() {
                BleModule.this.pendingTransactions.removeSubscription(transactionId);
            }

            public void onError(Throwable error) {
                safeExecutor.error(BleModule.this.errorConverter.toError(error));
                BleModule.this.pendingTransactions.removeSubscription(transactionId);
            }

            public void onNext(Integer rssi) {
                device.setRssi(rssi);
                safeExecutor.success(device);
            }
        });
        this.pendingTransactions.replaceSubscription(transactionId, subscription);
    }

    @Override
    public void requestMTUForDevice(String deviceIdentifier, int mtu, final String transactionId, OnSuccessCallback<Device> onSuccessCallback, OnErrorCallback onErrorCallback) {
        Device device;
        try {
            device = this.getDeviceById(deviceIdentifier);
        }
        catch (BleError error) {
            onErrorCallback.onError(error);
            return;
        }
        RxBleConnection connection = this.getConnectionOrEmitError(device.getId(), onErrorCallback);
        if (connection == null) {
            return;
        }
        final SafeExecutor<Device> safeExecutor = new SafeExecutor<Device>(onSuccessCallback, onErrorCallback);
        if (Build.VERSION.SDK_INT >= 21) {
            Subscription subscription = connection.requestMtu(mtu).doOnUnsubscribe(new Action0(){

                public void call() {
                    safeExecutor.error(BleErrorUtils.cancelled());
                    BleModule.this.pendingTransactions.removeSubscription(transactionId);
                }
            }).subscribe((Observer)new Observer<Integer>(){

                public void onCompleted() {
                    BleModule.this.pendingTransactions.removeSubscription(transactionId);
                }

                public void onError(Throwable error) {
                    safeExecutor.error(BleModule.this.errorConverter.toError(error));
                    BleModule.this.pendingTransactions.removeSubscription(transactionId);
                }

                public void onNext(Integer mtu) {
                    device.setMtu(mtu);
                    safeExecutor.success(device);
                }
            });
            this.pendingTransactions.replaceSubscription(transactionId, subscription);
        } else {
            onSuccessCallback.onSuccess(device);
        }
    }

    @Override
    public void getKnownDevices(String[] deviceIdentifiers, OnSuccessCallback<Device[]> onSuccessCallback, OnErrorCallback onErrorCallback) {
        if (this.rxBleClient == null) {
            onErrorCallback.onError(new BleError(BleErrorCode.BluetoothManagerDestroyed, "BleManager not created when tried to get known devices", null));
            return;
        }
        ArrayList<Device> knownDevices = new ArrayList<Device>();
        for (String deviceId : deviceIdentifiers) {
            if (deviceId == null) {
                onErrorCallback.onError(BleErrorUtils.invalidIdentifiers(deviceIdentifiers));
                return;
            }
            Device device = this.discoveredDevices.get(deviceId);
            if (device == null) continue;
            knownDevices.add(device);
        }
        onSuccessCallback.onSuccess(knownDevices.toArray(new Device[knownDevices.size()]));
    }

    @Override
    public void getConnectedDevices(String[] serviceUUIDs, OnSuccessCallback<Device[]> onSuccessCallback, OnErrorCallback onErrorCallback) {
        if (this.rxBleClient == null) {
            onErrorCallback.onError(new BleError(BleErrorCode.BluetoothManagerDestroyed, "BleManager not created when tried to get connected devices", null));
            return;
        }
        if (serviceUUIDs.length == 0) {
            onSuccessCallback.onSuccess(new Device[0]);
            return;
        }
        UUID[] uuids = new UUID[serviceUUIDs.length];
        for (int i = 0; i < serviceUUIDs.length; ++i) {
            UUID uuid = UUIDConverter.convert(serviceUUIDs[i]);
            if (uuid == null) {
                onErrorCallback.onError(BleErrorUtils.invalidIdentifiers(serviceUUIDs));
                return;
            }
            uuids[i] = uuid;
        }
        ArrayList<Device> localConnectedDevices = new ArrayList<Device>();
        block1: for (Device device : this.connectedDevices.values()) {
            for (UUID uuid : uuids) {
                if (device.getServiceByUUID(uuid) == null) continue;
                localConnectedDevices.add(device);
                continue block1;
            }
        }
        onSuccessCallback.onSuccess(localConnectedDevices.toArray(new Device[localConnectedDevices.size()]));
    }

    @Override
    public void connectToDevice(String deviceIdentifier, ConnectionOptions connectionOptions, OnSuccessCallback<Device> onSuccessCallback, OnEventCallback<ConnectionState> onConnectionStateChangedCallback, OnErrorCallback onErrorCallback) {
        if (this.rxBleClient == null) {
            onErrorCallback.onError(new BleError(BleErrorCode.BluetoothManagerDestroyed, "BleManager not created when tried to connect to device", null));
            return;
        }
        RxBleDevice device = this.rxBleClient.getBleDevice(deviceIdentifier);
        if (device == null) {
            onErrorCallback.onError(BleErrorUtils.deviceNotFound(deviceIdentifier));
            return;
        }
        this.safeConnectToDevice(device, connectionOptions.getAutoConnect(), connectionOptions.getRequestMTU(), connectionOptions.getRefreshGattMoment(), connectionOptions.getTimeoutInMillis(), connectionOptions.getConnectionPriority(), onSuccessCallback, onConnectionStateChangedCallback, onErrorCallback);
    }

    @Override
    public void cancelDeviceConnection(String deviceIdentifier, OnSuccessCallback<Device> onSuccessCallback, OnErrorCallback onErrorCallback) {
        if (this.rxBleClient == null) {
            onErrorCallback.onError(new BleError(BleErrorCode.BluetoothManagerDestroyed, "BleManager not created when tried to cancel device connection", null));
            return;
        }
        RxBleDevice device = this.rxBleClient.getBleDevice(deviceIdentifier);
        if (this.connectingDevices.removeSubscription(deviceIdentifier) && device != null) {
            onSuccessCallback.onSuccess(this.rxBleDeviceToDeviceMapper.map(device, null));
        } else if (device == null) {
            onErrorCallback.onError(BleErrorUtils.deviceNotFound(deviceIdentifier));
        } else {
            onErrorCallback.onError(BleErrorUtils.deviceNotConnected(deviceIdentifier));
        }
    }

    @Override
    public void isDeviceConnected(String deviceIdentifier, OnSuccessCallback<Boolean> onSuccessCallback, OnErrorCallback onErrorCallback) {
        if (this.rxBleClient == null) {
            onErrorCallback.onError(new BleError(BleErrorCode.BluetoothManagerDestroyed, "BleManager not created when tried to check if device is connected", null));
            return;
        }
        RxBleDevice device = this.rxBleClient.getBleDevice(deviceIdentifier);
        if (device == null) {
            onErrorCallback.onError(BleErrorUtils.deviceNotFound(deviceIdentifier));
            return;
        }
        boolean connected = device.getConnectionState().equals((Object)RxBleConnection.RxBleConnectionState.CONNECTED);
        onSuccessCallback.onSuccess(connected);
    }

    @Override
    public void discoverAllServicesAndCharacteristicsForDevice(String deviceIdentifier, String transactionId, OnSuccessCallback<Device> onSuccessCallback, OnErrorCallback onErrorCallback) {
        Device device;
        try {
            device = this.getDeviceById(deviceIdentifier);
        }
        catch (BleError error) {
            onErrorCallback.onError(error);
            return;
        }
        this.safeDiscoverAllServicesAndCharacteristicsForDevice(device, transactionId, onSuccessCallback, onErrorCallback);
    }

    @Override
    public List<Service> getServicesForDevice(String deviceIdentifier) throws BleError {
        Device device = this.getDeviceById(deviceIdentifier);
        List<Service> services = device.getServices();
        if (services == null) {
            throw BleErrorUtils.deviceServicesNotDiscovered(device.getId());
        }
        return services;
    }

    @Override
    public List<Characteristic> getCharacteristicsForDevice(String deviceIdentifier, String serviceUUID) throws BleError {
        UUID convertedServiceUUID = UUIDConverter.convert(serviceUUID);
        if (convertedServiceUUID == null) {
            throw BleErrorUtils.invalidIdentifiers(serviceUUID);
        }
        Device device = this.getDeviceById(deviceIdentifier);
        Service service = device.getServiceByUUID(convertedServiceUUID);
        if (service == null) {
            throw BleErrorUtils.serviceNotFound(serviceUUID);
        }
        return service.getCharacteristics();
    }

    @Override
    public List<Characteristic> getCharacteristicsForService(int serviceIdentifier) throws BleError {
        Service service = (Service)this.discoveredServices.get(serviceIdentifier);
        if (service == null) {
            throw BleErrorUtils.serviceNotFound(Integer.toString(serviceIdentifier));
        }
        return service.getCharacteristics();
    }

    @Override
    public List<Descriptor> descriptorsForDevice(String deviceIdentifier, String serviceUUID, String characteristicUUID) throws BleError {
        UUID[] uuids = UUIDConverter.convert(serviceUUID, characteristicUUID);
        if (uuids == null) {
            throw BleErrorUtils.invalidIdentifiers(serviceUUID, characteristicUUID);
        }
        Device device = this.getDeviceById(deviceIdentifier);
        Service service = device.getServiceByUUID(uuids[0]);
        if (service == null) {
            throw BleErrorUtils.serviceNotFound(serviceUUID);
        }
        Characteristic characteristic = service.getCharacteristicByUUID(uuids[1]);
        if (characteristic == null) {
            throw BleErrorUtils.characteristicNotFound(characteristicUUID);
        }
        return characteristic.getDescriptors();
    }

    @Override
    public List<Descriptor> descriptorsForService(int serviceIdentifier, String characteristicUUID) throws BleError {
        UUID uuid = UUIDConverter.convert(characteristicUUID);
        if (uuid == null) {
            throw BleErrorUtils.invalidIdentifiers(characteristicUUID);
        }
        Service service = (Service)this.discoveredServices.get(serviceIdentifier);
        if (service == null) {
            throw BleErrorUtils.serviceNotFound(Integer.toString(serviceIdentifier));
        }
        Characteristic characteristic = service.getCharacteristicByUUID(uuid);
        if (characteristic == null) {
            throw BleErrorUtils.characteristicNotFound(characteristicUUID);
        }
        return characteristic.getDescriptors();
    }

    @Override
    public List<Descriptor> descriptorsForCharacteristic(int characteristicIdentifier) throws BleError {
        Characteristic characteristic = (Characteristic)this.discoveredCharacteristics.get(characteristicIdentifier);
        if (characteristic == null) {
            throw BleErrorUtils.characteristicNotFound(Integer.toString(characteristicIdentifier));
        }
        return characteristic.getDescriptors();
    }

    @Override
    public void readCharacteristicForDevice(String deviceIdentifier, String serviceUUID, String characteristicUUID, String transactionId, OnSuccessCallback<Characteristic> onSuccessCallback, OnErrorCallback onErrorCallback) {
        Characteristic characteristic = this.getCharacteristicOrEmitError(deviceIdentifier, serviceUUID, characteristicUUID, onErrorCallback);
        if (characteristic == null) {
            return;
        }
        this.safeReadCharacteristicForDevice(characteristic, transactionId, onSuccessCallback, onErrorCallback);
    }

    @Override
    public void readCharacteristicForService(int serviceIdentifier, String characteristicUUID, String transactionId, OnSuccessCallback<Characteristic> onSuccessCallback, OnErrorCallback onErrorCallback) {
        Characteristic characteristic = this.getCharacteristicOrEmitError(serviceIdentifier, characteristicUUID, onErrorCallback);
        if (characteristic == null) {
            return;
        }
        this.safeReadCharacteristicForDevice(characteristic, transactionId, onSuccessCallback, onErrorCallback);
    }

    @Override
    public void readCharacteristic(int characteristicIdentifier, String transactionId, OnSuccessCallback<Characteristic> onSuccessCallback, OnErrorCallback onErrorCallback) {
        Characteristic characteristic = this.getCharacteristicOrEmitError(characteristicIdentifier, onErrorCallback);
        if (characteristic == null) {
            return;
        }
        this.safeReadCharacteristicForDevice(characteristic, transactionId, onSuccessCallback, onErrorCallback);
    }

    @Override
    public void writeCharacteristicForDevice(String deviceIdentifier, String serviceUUID, String characteristicUUID, String valueBase64, boolean withResponse, String transactionId, OnSuccessCallback<Characteristic> onSuccessCallback, OnErrorCallback onErrorCallback) {
        Characteristic characteristic = this.getCharacteristicOrEmitError(deviceIdentifier, serviceUUID, characteristicUUID, onErrorCallback);
        if (characteristic == null) {
            return;
        }
        this.writeCharacteristicWithValue(characteristic, valueBase64, withResponse, transactionId, onSuccessCallback, onErrorCallback);
    }

    @Override
    public void writeCharacteristicForService(int serviceIdentifier, String characteristicUUID, String valueBase64, boolean withResponse, String transactionId, OnSuccessCallback<Characteristic> onSuccessCallback, OnErrorCallback onErrorCallback) {
        Characteristic characteristic = this.getCharacteristicOrEmitError(serviceIdentifier, characteristicUUID, onErrorCallback);
        if (characteristic == null) {
            return;
        }
        this.writeCharacteristicWithValue(characteristic, valueBase64, withResponse, transactionId, onSuccessCallback, onErrorCallback);
    }

    @Override
    public void writeCharacteristic(int characteristicIdentifier, String valueBase64, boolean withResponse, String transactionId, OnSuccessCallback<Characteristic> onSuccessCallback, OnErrorCallback onErrorCallback) {
        Characteristic characteristic = this.getCharacteristicOrEmitError(characteristicIdentifier, onErrorCallback);
        if (characteristic == null) {
            return;
        }
        this.writeCharacteristicWithValue(characteristic, valueBase64, withResponse, transactionId, onSuccessCallback, onErrorCallback);
    }

    @Override
    public void monitorCharacteristicForDevice(String deviceIdentifier, String serviceUUID, String characteristicUUID, String transactionId, OnEventCallback<Characteristic> onEventCallback, OnErrorCallback onErrorCallback) {
        Characteristic characteristic = this.getCharacteristicOrEmitError(deviceIdentifier, serviceUUID, characteristicUUID, onErrorCallback);
        if (characteristic == null) {
            return;
        }
        this.safeMonitorCharacteristicForDevice(characteristic, transactionId, onEventCallback, onErrorCallback);
    }

    @Override
    public void monitorCharacteristicForService(int serviceIdentifier, String characteristicUUID, String transactionId, OnEventCallback<Characteristic> onEventCallback, OnErrorCallback onErrorCallback) {
        Characteristic characteristic = this.getCharacteristicOrEmitError(serviceIdentifier, characteristicUUID, onErrorCallback);
        if (characteristic == null) {
            return;
        }
        this.safeMonitorCharacteristicForDevice(characteristic, transactionId, onEventCallback, onErrorCallback);
    }

    @Override
    public void monitorCharacteristic(int characteristicIdentifier, String transactionId, OnEventCallback<Characteristic> onEventCallback, OnErrorCallback onErrorCallback) {
        Characteristic characteristic = this.getCharacteristicOrEmitError(characteristicIdentifier, onErrorCallback);
        if (characteristic == null) {
            return;
        }
        this.safeMonitorCharacteristicForDevice(characteristic, transactionId, onEventCallback, onErrorCallback);
    }

    @Override
    public void readDescriptorForDevice(String deviceId, String serviceUUID, String characteristicUUID, String descriptorUUID, String transactionId, OnSuccessCallback<Descriptor> successCallback, OnErrorCallback errorCallback) {
        try {
            Descriptor descriptor = this.getDescriptor(deviceId, serviceUUID, characteristicUUID, descriptorUUID);
            this.safeReadDescriptorForDevice(descriptor, transactionId, successCallback, errorCallback);
        }
        catch (BleError error) {
            errorCallback.onError(error);
        }
    }

    @Override
    public void readDescriptorForService(int serviceIdentifier, String characteristicUUID, String descriptorUUID, String transactionId, OnSuccessCallback<Descriptor> successCallback, OnErrorCallback errorCallback) {
        try {
            Descriptor descriptor = this.getDescriptor(serviceIdentifier, characteristicUUID, descriptorUUID);
            this.safeReadDescriptorForDevice(descriptor, transactionId, successCallback, errorCallback);
        }
        catch (BleError error) {
            errorCallback.onError(error);
        }
    }

    @Override
    public void readDescriptorForCharacteristic(int characteristicIdentifier, String descriptorUUID, String transactionId, OnSuccessCallback<Descriptor> successCallback, OnErrorCallback errorCallback) {
        try {
            Descriptor descriptor = this.getDescriptor(characteristicIdentifier, descriptorUUID);
            this.safeReadDescriptorForDevice(descriptor, transactionId, successCallback, errorCallback);
        }
        catch (BleError error) {
            errorCallback.onError(error);
        }
    }

    @Override
    public void readDescriptor(int descriptorIdentifier, String transactionId, OnSuccessCallback<Descriptor> onSuccessCallback, OnErrorCallback onErrorCallback) {
        try {
            Descriptor descriptor = this.getDescriptor(descriptorIdentifier);
            this.safeReadDescriptorForDevice(descriptor, transactionId, onSuccessCallback, onErrorCallback);
        }
        catch (BleError error) {
            onErrorCallback.onError(error);
        }
    }

    private void safeReadDescriptorForDevice(final Descriptor descriptor, final String transactionId, OnSuccessCallback<Descriptor> onSuccessCallback, OnErrorCallback onErrorCallback) {
        RxBleConnection connection = this.getConnectionOrEmitError(descriptor.getDeviceId(), onErrorCallback);
        if (connection == null) {
            return;
        }
        final SafeExecutor<Descriptor> safeExecutor = new SafeExecutor<Descriptor>(onSuccessCallback, onErrorCallback);
        Subscription subscription = connection.readDescriptor(descriptor.getNativeDescriptor()).doOnUnsubscribe(new Action0(){

            public void call() {
                safeExecutor.error(BleErrorUtils.cancelled());
                BleModule.this.pendingTransactions.removeSubscription(transactionId);
            }
        }).subscribe((Observer)new Observer<byte[]>(){

            public void onCompleted() {
                BleModule.this.pendingTransactions.removeSubscription(transactionId);
            }

            public void onError(Throwable e) {
                safeExecutor.error(BleModule.this.errorConverter.toError(e));
                BleModule.this.pendingTransactions.removeSubscription(transactionId);
            }

            public void onNext(byte[] bytes) {
                descriptor.logValue("Read from", bytes);
                descriptor.setValue(bytes);
                safeExecutor.success(new Descriptor(descriptor));
            }
        });
        this.pendingTransactions.replaceSubscription(transactionId, subscription);
    }

    @Override
    public void writeDescriptorForDevice(String deviceId, String serviceUUID, String characteristicUUID, String descriptorUUID, String valueBase64, String transactionId, OnSuccessCallback<Descriptor> successCallback, OnErrorCallback errorCallback) {
        try {
            Descriptor descriptor = this.getDescriptor(deviceId, serviceUUID, characteristicUUID, descriptorUUID);
            this.safeWriteDescriptorForDevice(descriptor, valueBase64, transactionId, successCallback, errorCallback);
        }
        catch (BleError error) {
            errorCallback.onError(error);
        }
    }

    @Override
    public void writeDescriptorForService(int serviceIdentifier, String characteristicUUID, String descriptorUUID, String valueBase64, String transactionId, OnSuccessCallback<Descriptor> successCallback, OnErrorCallback errorCallback) {
        try {
            Descriptor descriptor = this.getDescriptor(serviceIdentifier, characteristicUUID, descriptorUUID);
            this.safeWriteDescriptorForDevice(descriptor, valueBase64, transactionId, successCallback, errorCallback);
        }
        catch (BleError error) {
            errorCallback.onError(error);
        }
    }

    @Override
    public void writeDescriptorForCharacteristic(int characteristicIdentifier, String descriptorUUID, String valueBase64, String transactionId, OnSuccessCallback<Descriptor> successCallback, OnErrorCallback errorCallback) {
        try {
            Descriptor descriptor = this.getDescriptor(characteristicIdentifier, descriptorUUID);
            this.safeWriteDescriptorForDevice(descriptor, valueBase64, transactionId, successCallback, errorCallback);
        }
        catch (BleError error) {
            errorCallback.onError(error);
        }
    }

    @Override
    public void writeDescriptor(int descriptorIdentifier, String valueBase64, String transactionId, OnSuccessCallback<Descriptor> successCallback, OnErrorCallback errorCallback) {
        try {
            Descriptor descriptor = this.getDescriptor(descriptorIdentifier);
            this.safeWriteDescriptorForDevice(descriptor, valueBase64, transactionId, successCallback, errorCallback);
        }
        catch (BleError error) {
            errorCallback.onError(error);
        }
    }

    private void safeWriteDescriptorForDevice(final Descriptor descriptor, String valueBase64, final String transactionId, OnSuccessCallback<Descriptor> successCallback, OnErrorCallback errorCallback) {
        byte[] value;
        BluetoothGattDescriptor nativeDescriptor = descriptor.getNativeDescriptor();
        if (nativeDescriptor.getUuid().equals(Constants.CLIENT_CHARACTERISTIC_CONFIG_UUID)) {
            errorCallback.onError(BleErrorUtils.descriptorWriteNotAllowed(UUIDConverter.fromUUID(nativeDescriptor.getUuid())));
            return;
        }
        RxBleConnection connection = this.getConnectionOrEmitError(descriptor.getDeviceId(), errorCallback);
        if (connection == null) {
            return;
        }
        try {
            value = Base64Converter.decode(valueBase64);
        }
        catch (Throwable e) {
            String uuid = UUIDConverter.fromUUID(nativeDescriptor.getUuid());
            errorCallback.onError(BleErrorUtils.invalidWriteDataForDescriptor(valueBase64, uuid));
            return;
        }
        final SafeExecutor<Descriptor> safeExecutor = new SafeExecutor<Descriptor>(successCallback, errorCallback);
        Subscription subscription = connection.writeDescriptor(nativeDescriptor, value).doOnUnsubscribe(new Action0(){

            public void call() {
                safeExecutor.error(BleErrorUtils.cancelled());
                BleModule.this.pendingTransactions.removeSubscription(transactionId);
            }
        }).subscribe((Observer)new Observer<byte[]>(){

            public void onCompleted() {
                BleModule.this.pendingTransactions.removeSubscription(transactionId);
            }

            public void onError(Throwable e) {
                safeExecutor.error(BleModule.this.errorConverter.toError(e));
                BleModule.this.pendingTransactions.removeSubscription(transactionId);
            }

            public void onNext(byte[] bytes) {
                descriptor.logValue("Write to", bytes);
                descriptor.setValue(bytes);
                safeExecutor.success(new Descriptor(descriptor));
            }
        });
        this.pendingTransactions.replaceSubscription(transactionId, subscription);
    }

    private Descriptor getDescriptor(@NonNull String deviceId, @NonNull String serviceUUID, @NonNull String characteristicUUID, @NonNull String descriptorUUID) throws BleError {
        UUID[] UUIDs = UUIDConverter.convert(serviceUUID, characteristicUUID, descriptorUUID);
        if (UUIDs == null) {
            throw BleErrorUtils.invalidIdentifiers(serviceUUID, characteristicUUID, descriptorUUID);
        }
        Device device = this.connectedDevices.get(deviceId);
        if (device == null) {
            throw BleErrorUtils.deviceNotConnected(deviceId);
        }
        Service service = device.getServiceByUUID(UUIDs[0]);
        if (service == null) {
            throw BleErrorUtils.serviceNotFound(serviceUUID);
        }
        Characteristic characteristic = service.getCharacteristicByUUID(UUIDs[1]);
        if (characteristic == null) {
            throw BleErrorUtils.characteristicNotFound(characteristicUUID);
        }
        Descriptor descriptor = characteristic.getDescriptorByUUID(UUIDs[2]);
        if (descriptor == null) {
            throw BleErrorUtils.descriptorNotFound(descriptorUUID);
        }
        return descriptor;
    }

    private Descriptor getDescriptor(int serviceIdentifier, @NonNull String characteristicUUID, @NonNull String descriptorUUID) throws BleError {
        UUID[] UUIDs = UUIDConverter.convert(characteristicUUID, descriptorUUID);
        if (UUIDs == null) {
            throw BleErrorUtils.invalidIdentifiers(characteristicUUID, descriptorUUID);
        }
        Service service = (Service)this.discoveredServices.get(serviceIdentifier);
        if (service == null) {
            throw BleErrorUtils.serviceNotFound(Integer.toString(serviceIdentifier));
        }
        Characteristic characteristic = service.getCharacteristicByUUID(UUIDs[0]);
        if (characteristic == null) {
            throw BleErrorUtils.characteristicNotFound(characteristicUUID);
        }
        Descriptor descriptor = characteristic.getDescriptorByUUID(UUIDs[1]);
        if (descriptor == null) {
            throw BleErrorUtils.descriptorNotFound(descriptorUUID);
        }
        return descriptor;
    }

    private Descriptor getDescriptor(int characteristicIdentifier, @NonNull String descriptorUUID) throws BleError {
        UUID uuid = UUIDConverter.convert(descriptorUUID);
        if (uuid == null) {
            throw BleErrorUtils.invalidIdentifiers(descriptorUUID);
        }
        Characteristic characteristic = (Characteristic)this.discoveredCharacteristics.get(characteristicIdentifier);
        if (characteristic == null) {
            throw BleErrorUtils.characteristicNotFound(Integer.toString(characteristicIdentifier));
        }
        Descriptor descriptor = characteristic.getDescriptorByUUID(uuid);
        if (descriptor == null) {
            throw BleErrorUtils.descriptorNotFound(descriptorUUID);
        }
        return descriptor;
    }

    private Descriptor getDescriptor(int descriptorIdentifier) throws BleError {
        Descriptor descriptor = (Descriptor)this.discoveredDescriptors.get(descriptorIdentifier);
        if (descriptor == null) {
            throw BleErrorUtils.descriptorNotFound(Integer.toString(descriptorIdentifier));
        }
        return descriptor;
    }

    @Override
    public void cancelTransaction(String transactionId) {
        this.pendingTransactions.removeSubscription(transactionId);
    }

    @Override
    public void setLogLevel(String logLevel) {
        this.currentLogLevel = LogLevel.toLogLevel(logLevel);
        RxBleLog.setLogLevel((int)this.currentLogLevel);
    }

    @Override
    public String getLogLevel() {
        return LogLevel.fromLogLevel(this.currentLogLevel);
    }

    private Subscription monitorAdapterStateChanges(Context context, final OnEventCallback<String> onAdapterStateChangeCallback) {
        if (!this.supportsBluetoothLowEnergy()) {
            return null;
        }
        return new RxBleAdapterStateObservable(context).map((Func1)new Func1<RxBleAdapterStateObservable.BleAdapterState, String>(){

            public String call(RxBleAdapterStateObservable.BleAdapterState bleAdapterState) {
                return BleModule.this.mapRxBleAdapterStateToLocalBluetoothState(bleAdapterState);
            }
        }).subscribe((Action1)new Action1<String>(){

            public void call(String state) {
                onAdapterStateChangeCallback.onEvent(state);
            }
        });
    }

    private boolean supportsBluetoothLowEnergy() {
        return this.context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le");
    }

    private String mapRxBleAdapterStateToLocalBluetoothState(RxBleAdapterStateObservable.BleAdapterState rxBleAdapterState) {
        if (rxBleAdapterState == RxBleAdapterStateObservable.BleAdapterState.STATE_ON) {
            return "PoweredOn";
        }
        if (rxBleAdapterState == RxBleAdapterStateObservable.BleAdapterState.STATE_OFF) {
            return "PoweredOff";
        }
        return "Resetting";
    }

    private void changeAdapterState(final RxBleAdapterStateObservable.BleAdapterState desiredAdapterState, final String transactionId, OnSuccessCallback<Void> onSuccessCallback, OnErrorCallback onErrorCallback) {
        boolean desiredAndInitialStateAreSame;
        if (this.bluetoothManager == null) {
            onErrorCallback.onError(new BleError(BleErrorCode.BluetoothStateChangeFailed, "BluetoothManager is null", null));
            return;
        }
        final SafeExecutor<Void> safeExecutor = new SafeExecutor<Void>(onSuccessCallback, onErrorCallback);
        Subscription subscription = new RxBleAdapterStateObservable(this.context).takeUntil((Func1)new Func1<RxBleAdapterStateObservable.BleAdapterState, Boolean>(){

            public Boolean call(RxBleAdapterStateObservable.BleAdapterState actualAdapterState) {
                return desiredAdapterState == actualAdapterState;
            }
        }).toCompletable().doOnUnsubscribe(new Action0(){

            public void call() {
                safeExecutor.error(BleErrorUtils.cancelled());
                BleModule.this.pendingTransactions.removeSubscription(transactionId);
            }
        }).subscribe(new Action0(){

            public void call() {
                safeExecutor.success(null);
                BleModule.this.pendingTransactions.removeSubscription(transactionId);
            }
        }, (Action1)new Action1<Throwable>(){

            public void call(Throwable error) {
                safeExecutor.error(BleModule.this.errorConverter.toError(error));
                BleModule.this.pendingTransactions.removeSubscription(transactionId);
            }
        });
        if (desiredAdapterState == RxBleAdapterStateObservable.BleAdapterState.STATE_ON) {
            desiredAndInitialStateAreSame = !this.bluetoothAdapter.enable();
        } else {
            boolean bl = desiredAndInitialStateAreSame = !this.bluetoothAdapter.disable();
        }
        if (desiredAndInitialStateAreSame) {
            subscription.unsubscribe();
            onErrorCallback.onError(new BleError(BleErrorCode.BluetoothStateChangeFailed, String.format("Couldn't set bluetooth adapter state to %s", desiredAdapterState.toString()), null));
        } else {
            this.pendingTransactions.replaceSubscription(transactionId, subscription);
        }
    }

    private String mapNativeAdapterStateToLocalBluetoothState(int adapterState) {
        switch (adapterState) {
            case 10: {
                return "PoweredOff";
            }
            case 12: {
                return "PoweredOn";
            }
            case 11: 
            case 13: {
                return "Resetting";
            }
        }
        return "Unknown";
    }

    private void safeStartDeviceScan(UUID[] uuids, int scanMode, int callbackType, final OnEventCallback<ScanResult> onEventCallback, final OnErrorCallback onErrorCallback) {
        if (this.rxBleClient == null) {
            onErrorCallback.onError(new BleError(BleErrorCode.BluetoothManagerDestroyed, "BleManager not created when tried to start device scan", null));
            return;
        }
        ScanSettings scanSettings = new ScanSettings.Builder().setScanMode(scanMode).setCallbackType(callbackType).build();
        int length = uuids == null ? 0 : uuids.length;
        ScanFilter[] filters = new ScanFilter[length];
        for (int i = 0; i < length; ++i) {
            filters[i] = new ScanFilter.Builder().setServiceUuid(ParcelUuid.fromString((String)uuids[i].toString())).build();
        }
        this.scanSubscription = this.rxBleClient.scanBleDevices(scanSettings, filters).subscribe((Action1)new Action1<com.polidea.rxandroidble.scan.ScanResult>(){

            public void call(com.polidea.rxandroidble.scan.ScanResult scanResult) {
                String deviceId = scanResult.getBleDevice().getMacAddress();
                if (!BleModule.this.discoveredDevices.containsKey(deviceId)) {
                    BleModule.this.discoveredDevices.put(deviceId, BleModule.this.rxBleDeviceToDeviceMapper.map(scanResult.getBleDevice(), null));
                }
                onEventCallback.onEvent(BleModule.this.rxScanResultToScanResultMapper.map(scanResult));
            }
        }, (Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                onErrorCallback.onError(BleModule.this.errorConverter.toError(throwable));
            }
        });
    }

    @NonNull
    private Device getDeviceById(@NonNull String deviceId) throws BleError {
        Device device = this.connectedDevices.get(deviceId);
        if (device == null) {
            throw BleErrorUtils.deviceNotConnected(deviceId);
        }
        return device;
    }

    @Nullable
    private RxBleConnection getConnectionOrEmitError(@NonNull String deviceId, @NonNull OnErrorCallback onErrorCallback) {
        RxBleConnection connection = this.activeConnections.get(deviceId);
        if (connection == null) {
            onErrorCallback.onError(BleErrorUtils.deviceNotConnected(deviceId));
            return null;
        }
        return connection;
    }

    private void safeConnectToDevice(final RxBleDevice device, boolean autoConnect, final int requestMtu, RefreshGattMoment refreshGattMoment, final Long timeout, final int connectionPriority, OnSuccessCallback<Device> onSuccessCallback, final OnEventCallback<ConnectionState> onConnectionStateChangedCallback, OnErrorCallback onErrorCallback) {
        final SafeExecutor<Device> safeExecutor = new SafeExecutor<Device>(onSuccessCallback, onErrorCallback);
        Observable connect = device.establishConnection(autoConnect).doOnSubscribe(new Action0(){

            public void call() {
                onConnectionStateChangedCallback.onEvent(ConnectionState.CONNECTING);
            }
        }).doOnUnsubscribe(new Action0(){

            public void call() {
                safeExecutor.error(BleErrorUtils.cancelled());
                BleModule.this.onDeviceDisconnected(device);
                onConnectionStateChangedCallback.onEvent(ConnectionState.DISCONNECTED);
            }
        });
        if (refreshGattMoment == RefreshGattMoment.ON_CONNECTED) {
            connect = connect.flatMap((Func1)new Func1<RxBleConnection, Observable<RxBleConnection>>(){

                public Observable<RxBleConnection> call(final RxBleConnection rxBleConnection) {
                    return rxBleConnection.queue((RxBleCustomOperation)new RefreshGattCustomOperation()).map((Func1)new Func1<Boolean, RxBleConnection>(){

                        public RxBleConnection call(Boolean refreshGattSuccess) {
                            return rxBleConnection;
                        }
                    });
                }
            });
        }
        if (connectionPriority > 0 && Build.VERSION.SDK_INT >= 21) {
            connect = connect.flatMap((Func1)new Func1<RxBleConnection, Observable<RxBleConnection>>(){

                @RequiresApi(api=21)
                public Observable<RxBleConnection> call(RxBleConnection rxBleConnection) {
                    return rxBleConnection.requestConnectionPriority(connectionPriority, 1L, TimeUnit.MILLISECONDS).andThen(Observable.just((Object)rxBleConnection));
                }
            });
        }
        if (requestMtu > 0 && Build.VERSION.SDK_INT >= 21) {
            connect = connect.flatMap((Func1)new Func1<RxBleConnection, Observable<RxBleConnection>>(){

                @RequiresApi(api=21)
                public Observable<RxBleConnection> call(final RxBleConnection rxBleConnection) {
                    return rxBleConnection.requestMtu(requestMtu).map((Func1)new Func1<Integer, RxBleConnection>(){

                        public RxBleConnection call(Integer integer) {
                            return rxBleConnection;
                        }
                    });
                }
            });
        }
        if (timeout != null) {
            connect = connect.timeout((Func0)new Func0<Observable<Long>>(){

                public Observable<Long> call() {
                    return Observable.timer((long)timeout, (TimeUnit)TimeUnit.MILLISECONDS);
                }
            }, (Func1)new Func1<RxBleConnection, Observable<Long>>(){

                public Observable<Long> call(RxBleConnection rxBleConnection) {
                    return Observable.never();
                }
            });
        }
        Subscription subscription = connect.subscribe((Observer)new Observer<RxBleConnection>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                BleError bleError = BleModule.this.errorConverter.toError(e);
                safeExecutor.error(bleError);
                BleModule.this.onDeviceDisconnected(device);
            }

            public void onNext(RxBleConnection connection) {
                Device localDevice = BleModule.this.rxBleDeviceToDeviceMapper.map(device, connection);
                onConnectionStateChangedCallback.onEvent(ConnectionState.CONNECTED);
                BleModule.this.cleanServicesAndCharacteristicsForDevice(localDevice);
                BleModule.this.connectedDevices.put(device.getMacAddress(), localDevice);
                BleModule.this.activeConnections.put(device.getMacAddress(), connection);
                safeExecutor.success(localDevice);
            }
        });
        this.connectingDevices.replaceSubscription(device.getMacAddress(), subscription);
    }

    private void onDeviceDisconnected(RxBleDevice rxDevice) {
        this.activeConnections.remove(rxDevice.getMacAddress());
        Device device = this.connectedDevices.remove(rxDevice.getMacAddress());
        if (device == null) {
            return;
        }
        this.cleanServicesAndCharacteristicsForDevice(device);
        this.connectingDevices.removeSubscription(device.getId());
    }

    private void safeDiscoverAllServicesAndCharacteristicsForDevice(final Device device, final String transactionId, OnSuccessCallback<Device> onSuccessCallback, OnErrorCallback onErrorCallback) {
        RxBleConnection connection = this.getConnectionOrEmitError(device.getId(), onErrorCallback);
        if (connection == null) {
            return;
        }
        final SafeExecutor<Device> safeExecutor = new SafeExecutor<Device>(onSuccessCallback, onErrorCallback);
        Subscription subscription = connection.discoverServices().doOnUnsubscribe(new Action0(){

            public void call() {
                safeExecutor.error(BleErrorUtils.cancelled());
                BleModule.this.pendingTransactions.removeSubscription(transactionId);
            }
        }).subscribe((Observer)new Observer<RxBleDeviceServices>(){

            public void onCompleted() {
                safeExecutor.success(device);
                BleModule.this.pendingTransactions.removeSubscription(transactionId);
            }

            public void onError(Throwable error) {
                safeExecutor.error(BleModule.this.errorConverter.toError(error));
                BleModule.this.pendingTransactions.removeSubscription(transactionId);
            }

            public void onNext(RxBleDeviceServices rxBleDeviceServices) {
                ArrayList<Service> services = new ArrayList<Service>();
                for (BluetoothGattService gattService : rxBleDeviceServices.getBluetoothGattServices()) {
                    Service service = BleModule.this.serviceFactory.create(device.getId(), gattService);
                    BleModule.this.discoveredServices.put(service.getId(), (Object)service);
                    services.add(service);
                    for (BluetoothGattCharacteristic gattCharacteristic : gattService.getCharacteristics()) {
                        Characteristic characteristic = new Characteristic(service, gattCharacteristic);
                        BleModule.this.discoveredCharacteristics.put(characteristic.getId(), (Object)characteristic);
                        for (BluetoothGattDescriptor gattDescriptor : gattCharacteristic.getDescriptors()) {
                            Descriptor descriptor = new Descriptor(characteristic, gattDescriptor);
                            BleModule.this.discoveredDescriptors.put(descriptor.getId(), (Object)descriptor);
                        }
                    }
                }
                device.setServices(services);
            }
        });
        this.pendingTransactions.replaceSubscription(transactionId, subscription);
    }

    private void safeReadCharacteristicForDevice(final Characteristic characteristic, final String transactionId, OnSuccessCallback<Characteristic> onSuccessCallback, OnErrorCallback onErrorCallback) {
        RxBleConnection connection = this.getConnectionOrEmitError(characteristic.getDeviceId(), onErrorCallback);
        if (connection == null) {
            return;
        }
        final SafeExecutor<Characteristic> safeExecutor = new SafeExecutor<Characteristic>(onSuccessCallback, onErrorCallback);
        Subscription subscription = connection.readCharacteristic(characteristic.gattCharacteristic).doOnUnsubscribe(new Action0(){

            public void call() {
                safeExecutor.error(BleErrorUtils.cancelled());
                BleModule.this.pendingTransactions.removeSubscription(transactionId);
            }
        }).subscribe((Observer)new Observer<byte[]>(){

            public void onCompleted() {
                BleModule.this.pendingTransactions.removeSubscription(transactionId);
            }

            public void onError(Throwable error) {
                safeExecutor.error(BleModule.this.errorConverter.toError(error));
                BleModule.this.pendingTransactions.removeSubscription(transactionId);
            }

            public void onNext(byte[] bytes) {
                characteristic.logValue("Read from", bytes);
                characteristic.setValue(bytes);
                safeExecutor.success(new Characteristic(characteristic));
            }
        });
        this.pendingTransactions.replaceSubscription(transactionId, subscription);
    }

    private void writeCharacteristicWithValue(Characteristic characteristic, String valueBase64, Boolean response, String transactionId, OnSuccessCallback<Characteristic> onSuccessCallback, OnErrorCallback onErrorCallback) {
        byte[] value;
        try {
            value = Base64Converter.decode(valueBase64);
        }
        catch (Throwable error) {
            onErrorCallback.onError(BleErrorUtils.invalidWriteDataForCharacteristic(valueBase64, UUIDConverter.fromUUID(characteristic.getUuid())));
            return;
        }
        characteristic.setWriteType(response != false ? 2 : 1);
        this.safeWriteCharacteristicForDevice(characteristic, value, transactionId, onSuccessCallback, onErrorCallback);
    }

    private void safeWriteCharacteristicForDevice(final Characteristic characteristic, byte[] value, final String transactionId, OnSuccessCallback<Characteristic> onSuccessCallback, OnErrorCallback onErrorCallback) {
        RxBleConnection connection = this.getConnectionOrEmitError(characteristic.getDeviceId(), onErrorCallback);
        if (connection == null) {
            return;
        }
        final SafeExecutor<Characteristic> safeExecutor = new SafeExecutor<Characteristic>(onSuccessCallback, onErrorCallback);
        Subscription subscription = connection.writeCharacteristic(characteristic.gattCharacteristic, value).doOnUnsubscribe(new Action0(){

            public void call() {
                safeExecutor.error(BleErrorUtils.cancelled());
                BleModule.this.pendingTransactions.removeSubscription(transactionId);
            }
        }).subscribe((Observer)new Observer<byte[]>(){

            public void onCompleted() {
                BleModule.this.pendingTransactions.removeSubscription(transactionId);
            }

            public void onError(Throwable e) {
                safeExecutor.error(BleModule.this.errorConverter.toError(e));
                BleModule.this.pendingTransactions.removeSubscription(transactionId);
            }

            public void onNext(byte[] bytes) {
                characteristic.logValue("Write to", bytes);
                characteristic.setValue(bytes);
                safeExecutor.success(new Characteristic(characteristic));
            }
        });
        this.pendingTransactions.replaceSubscription(transactionId, subscription);
    }

    private void safeMonitorCharacteristicForDevice(final Characteristic characteristic, final String transactionId, final OnEventCallback<Characteristic> onEventCallback, OnErrorCallback onErrorCallback) {
        final RxBleConnection connection = this.getConnectionOrEmitError(characteristic.getDeviceId(), onErrorCallback);
        if (connection == null) {
            return;
        }
        final SafeExecutor safeExecutor = new SafeExecutor(null, onErrorCallback);
        Subscription subscription = Observable.defer((Func0)new Func0<Observable<Observable<byte[]>>>(){

            public Observable<Observable<byte[]>> call() {
                NotificationSetupMode setupMode;
                BluetoothGattDescriptor cccDescriptor = characteristic.getGattDescriptor(Constants.CLIENT_CHARACTERISTIC_CONFIG_UUID);
                NotificationSetupMode notificationSetupMode = setupMode = cccDescriptor != null ? NotificationSetupMode.QUICK_SETUP : NotificationSetupMode.COMPAT;
                if (characteristic.isNotifiable()) {
                    return connection.setupNotification(characteristic.gattCharacteristic, setupMode);
                }
                if (characteristic.isIndicatable()) {
                    return connection.setupIndication(characteristic.gattCharacteristic, setupMode);
                }
                return Observable.error((Throwable)new CannotMonitorCharacteristicException(characteristic));
            }
        }).flatMap((Func1)new Func1<Observable<byte[]>, Observable<byte[]>>(){

            public Observable<byte[]> call(Observable<byte[]> observable) {
                return observable;
            }
        }).onBackpressureBuffer().observeOn(Schedulers.computation()).doOnUnsubscribe(new Action0(){

            public void call() {
                safeExecutor.error(BleErrorUtils.cancelled());
                BleModule.this.pendingTransactions.removeSubscription(transactionId);
            }
        }).subscribe((Observer)new Observer<byte[]>(){

            public void onCompleted() {
                BleModule.this.pendingTransactions.removeSubscription(transactionId);
            }

            public void onError(Throwable error) {
                safeExecutor.error(BleModule.this.errorConverter.toError(error));
                BleModule.this.pendingTransactions.removeSubscription(transactionId);
            }

            public void onNext(byte[] bytes) {
                characteristic.logValue("Notification from", bytes);
                characteristic.setValue(bytes);
                onEventCallback.onEvent(new Characteristic(characteristic));
            }
        });
        this.pendingTransactions.replaceSubscription(transactionId, subscription);
    }

    @Nullable
    private Characteristic getCharacteristicOrEmitError(@NonNull String deviceId, @NonNull String serviceUUID, @NonNull String characteristicUUID, @NonNull OnErrorCallback onErrorCallback) {
        UUID[] UUIDs = UUIDConverter.convert(serviceUUID, characteristicUUID);
        if (UUIDs == null) {
            onErrorCallback.onError(BleErrorUtils.invalidIdentifiers(serviceUUID, characteristicUUID));
            return null;
        }
        Device device = this.connectedDevices.get(deviceId);
        if (device == null) {
            onErrorCallback.onError(BleErrorUtils.deviceNotConnected(deviceId));
            return null;
        }
        Service service = device.getServiceByUUID(UUIDs[0]);
        if (service == null) {
            onErrorCallback.onError(BleErrorUtils.serviceNotFound(serviceUUID));
            return null;
        }
        Characteristic characteristic = service.getCharacteristicByUUID(UUIDs[1]);
        if (characteristic == null) {
            onErrorCallback.onError(BleErrorUtils.characteristicNotFound(characteristicUUID));
            return null;
        }
        return characteristic;
    }

    @Nullable
    private Characteristic getCharacteristicOrEmitError(int serviceIdentifier, @NonNull String characteristicUUID, @NonNull OnErrorCallback onErrorCallback) {
        UUID uuid = UUIDConverter.convert(characteristicUUID);
        if (uuid == null) {
            onErrorCallback.onError(BleErrorUtils.invalidIdentifiers(characteristicUUID));
            return null;
        }
        Service service = (Service)this.discoveredServices.get(serviceIdentifier);
        if (service == null) {
            onErrorCallback.onError(BleErrorUtils.serviceNotFound(Integer.toString(serviceIdentifier)));
            return null;
        }
        Characteristic characteristic = service.getCharacteristicByUUID(uuid);
        if (characteristic == null) {
            onErrorCallback.onError(BleErrorUtils.characteristicNotFound(characteristicUUID));
            return null;
        }
        return characteristic;
    }

    @Nullable
    private Characteristic getCharacteristicOrEmitError(int characteristicIdentifier, @NonNull OnErrorCallback onErrorCallback) {
        Characteristic characteristic = (Characteristic)this.discoveredCharacteristics.get(characteristicIdentifier);
        if (characteristic == null) {
            onErrorCallback.onError(BleErrorUtils.characteristicNotFound(Integer.toString(characteristicIdentifier)));
            return null;
        }
        return characteristic;
    }

    private void cleanServicesAndCharacteristicsForDevice(@NonNull Device device) {
        int key;
        int i;
        for (i = this.discoveredServices.size() - 1; i >= 0; --i) {
            key = this.discoveredServices.keyAt(i);
            Service service = (Service)this.discoveredServices.get(key);
            if (!service.getDeviceID().equals(device.getId())) continue;
            this.discoveredServices.remove(key);
        }
        for (i = this.discoveredCharacteristics.size() - 1; i >= 0; --i) {
            key = this.discoveredCharacteristics.keyAt(i);
            Characteristic characteristic = (Characteristic)this.discoveredCharacteristics.get(key);
            if (!characteristic.getDeviceId().equals(device.getId())) continue;
            this.discoveredCharacteristics.remove(key);
        }
        for (i = this.discoveredDescriptors.size() - 1; i >= 0; --i) {
            key = this.discoveredDescriptors.keyAt(i);
            Descriptor descriptor = (Descriptor)this.discoveredDescriptors.get(key);
            if (!descriptor.getDeviceId().equals(device.getId())) continue;
            this.discoveredDescriptors.remove(key);
        }
    }
}

