/*
 * Decompiled with CFR 0.152.
 */
package com.pierfrancescosoffritti.youtubeplayer.player;

import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.OnLifecycleEvent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.pierfrancescosoffritti.youtubeplayer.player.AbstractYouTubePlayerListener;
import com.pierfrancescosoffritti.youtubeplayer.player.WebViewYouTubePlayer;
import com.pierfrancescosoffritti.youtubeplayer.player.YouTubePlayer;
import com.pierfrancescosoffritti.youtubeplayer.player.YouTubePlayerFullScreenListener;
import com.pierfrancescosoffritti.youtubeplayer.player.YouTubePlayerInitListener;
import com.pierfrancescosoffritti.youtubeplayer.player.playerUtils.FullScreenHelper;
import com.pierfrancescosoffritti.youtubeplayer.player.playerUtils.PlaybackResumer;
import com.pierfrancescosoffritti.youtubeplayer.ui.DefaultPlayerUIController;
import com.pierfrancescosoffritti.youtubeplayer.ui.PlayerUIController;
import com.pierfrancescosoffritti.youtubeplayer.utils.Callable;
import com.pierfrancescosoffritti.youtubeplayer.utils.NetworkReceiver;
import com.pierfrancescosoffritti.youtubeplayer.utils.Utils;

public class YouTubePlayerView
extends FrameLayout
implements NetworkReceiver.NetworkListener,
LifecycleObserver {
    @NonNull
    private final WebViewYouTubePlayer youTubePlayer;
    @Nullable
    private DefaultPlayerUIController defaultPlayerUIController;
    @NonNull
    private final NetworkReceiver networkReceiver;
    @NonNull
    private final PlaybackResumer playbackResumer;
    @NonNull
    private final FullScreenHelper fullScreenHelper;
    @Nullable
    private Callable asyncInitialization;

    public YouTubePlayerView(Context context) {
        this(context, null);
    }

    public YouTubePlayerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public YouTubePlayerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.youTubePlayer = new WebViewYouTubePlayer(context);
        this.addView((View)this.youTubePlayer, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.defaultPlayerUIController = new DefaultPlayerUIController(this, this.youTubePlayer);
        this.playbackResumer = new PlaybackResumer();
        this.networkReceiver = new NetworkReceiver(this);
        this.fullScreenHelper = new FullScreenHelper();
        this.fullScreenHelper.addFullScreenListener(this.defaultPlayerUIController);
        this.addYouTubePlayerListeners(this.youTubePlayer);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.getLayoutParams().height == -2) {
            int sixteenNineHeight = View.MeasureSpec.makeMeasureSpec((int)(View.MeasureSpec.getSize((int)widthMeasureSpec) * 9 / 16), (int)0x40000000);
            super.onMeasure(widthMeasureSpec, sixteenNineHeight);
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    public void initialize(final @NonNull YouTubePlayerInitListener youTubePlayerInitListener, boolean handleNetworkEvents) {
        if (handleNetworkEvents) {
            this.getContext().registerReceiver((BroadcastReceiver)this.networkReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
        this.asyncInitialization = new Callable(){

            @Override
            public void call() {
                YouTubePlayerView.this.youTubePlayer.initialize(new YouTubePlayerInitListener(){

                    @Override
                    public void onInitSuccess(YouTubePlayer youTubePlayer) {
                        youTubePlayerInitListener.onInitSuccess(youTubePlayer);
                    }
                });
            }
        };
        if (Utils.isOnline(this.getContext())) {
            this.asyncInitialization.call();
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public void release() {
        this.youTubePlayer.destroy();
        try {
            this.getContext().unregisterReceiver((BroadcastReceiver)this.networkReceiver);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    void onStop() {
        this.youTubePlayer.pause();
    }

    @Override
    public void onNetworkAvailable() {
        if (this.asyncInitialization != null) {
            this.asyncInitialization.call();
        } else {
            this.playbackResumer.resume(this.youTubePlayer);
        }
    }

    @Override
    public void onNetworkUnavailable() {
    }

    @NonNull
    public PlayerUIController getPlayerUIController() {
        if (this.defaultPlayerUIController == null) {
            throw new RuntimeException("You have inflated a custom player UI. You must manage it with your own controller.");
        }
        return this.defaultPlayerUIController;
    }

    public View inflateCustomPlayerUI(@LayoutRes int customPlayerUILayoutID) {
        this.removeViews(1, this.getChildCount() - 1);
        if (this.defaultPlayerUIController != null) {
            this.youTubePlayer.removeListener(this.defaultPlayerUIController);
            this.fullScreenHelper.removeFullScreenListener(this.defaultPlayerUIController);
        }
        this.defaultPlayerUIController = null;
        return View.inflate((Context)this.getContext(), (int)customPlayerUILayoutID, (ViewGroup)this);
    }

    public void enterFullScreen() {
        this.fullScreenHelper.enterFullScreen((View)this);
    }

    public void exitFullScreen() {
        this.fullScreenHelper.exitFullScreen((View)this);
    }

    public boolean isFullScreen() {
        return this.fullScreenHelper.isFullScreen();
    }

    public void toggleFullScreen() {
        this.fullScreenHelper.toggleFullScreen((View)this);
    }

    public boolean addFullScreenListener(@NonNull YouTubePlayerFullScreenListener fullScreenListener) {
        return this.fullScreenHelper.addFullScreenListener(fullScreenListener);
    }

    public boolean removeFullScreenListener(@NonNull YouTubePlayerFullScreenListener fullScreenListener) {
        return this.fullScreenHelper.removeFullScreenListener(fullScreenListener);
    }

    private void addYouTubePlayerListeners(YouTubePlayer youTubePlayer) {
        if (this.defaultPlayerUIController != null) {
            youTubePlayer.addListener(this.defaultPlayerUIController);
        }
        youTubePlayer.addListener(this.playbackResumer);
        youTubePlayer.addListener(new AbstractYouTubePlayerListener(){

            @Override
            public void onReady() {
                YouTubePlayerView.this.asyncInitialization = null;
            }
        });
    }
}

