/*
 * Decompiled with CFR 0.152.
 */
package com.pierfrancescosoffritti.youtubeplayer;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.pierfrancescosoffritti.youtubeplayer.Callable;
import com.pierfrancescosoffritti.youtubeplayer.NetworkReceiver;
import com.pierfrancescosoffritti.youtubeplayer.PlaybackResumer;
import com.pierfrancescosoffritti.youtubeplayer.PlayerControlsWrapper;
import com.pierfrancescosoffritti.youtubeplayer.R;
import com.pierfrancescosoffritti.youtubeplayer.Utils;
import com.pierfrancescosoffritti.youtubeplayer.YouTubePlayer;
import com.pierfrancescosoffritti.youtubeplayer.YouTubePlayerFullScreenListener;
import java.util.HashSet;
import java.util.Set;

public class YouTubePlayerView
extends FrameLayout
implements NetworkReceiver.NetworkListener {
    @NonNull
    private final NetworkReceiver networkReceiver;
    @NonNull
    private final YouTubePlayer youTubePlayer;
    @NonNull
    private final View playerControls;
    @NonNull
    private final PlayerControlsWrapper playerControlsWrapper;
    @NonNull
    private final PlaybackResumer playbackResumer;
    private final Set<YouTubePlayerFullScreenListener> fullScreenListeners;
    private boolean isFullScreen = false;
    private boolean initialized = false;
    private Callable onNetworkAvailableCallback;

    public YouTubePlayerView(Context context) {
        this(context, null);
    }

    public YouTubePlayerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public YouTubePlayerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.youTubePlayer = new YouTubePlayer(context);
        this.addView((View)this.youTubePlayer, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.playerControls = YouTubePlayerView.inflate((Context)context, (int)R.layout.player_controls, (ViewGroup)this);
        this.playerControlsWrapper = new PlayerControlsWrapper(this, this.playerControls);
        this.playbackResumer = new PlaybackResumer(this);
        this.fullScreenListeners = new HashSet<YouTubePlayerFullScreenListener>();
        this.fullScreenListeners.add(this.playerControlsWrapper);
        this.youTubePlayer.addListener(this.playerControlsWrapper);
        this.youTubePlayer.addListener(this.playbackResumer);
        this.networkReceiver = new NetworkReceiver(this);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.getLayoutParams().height == -2) {
            int sixteenNineHeight = View.MeasureSpec.makeMeasureSpec((int)(View.MeasureSpec.getSize((int)widthMeasureSpec) * 9 / 16), (int)0x40000000);
            super.onMeasure(widthMeasureSpec, sixteenNineHeight);
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    public void onFullScreenButtonListener(View.OnClickListener listener) {
        this.playerControlsWrapper.setOnFullScreenButtonListener(listener);
    }

    public boolean isFullScreen() {
        return this.isFullScreen;
    }

    public void enterFullScreen() {
        if (this.isFullScreen) {
            return;
        }
        ViewGroup.LayoutParams viewParams = this.getLayoutParams();
        viewParams.height = -1;
        viewParams.width = -1;
        this.setLayoutParams(viewParams);
        this.isFullScreen = true;
        for (YouTubePlayerFullScreenListener fullScreenListener : this.fullScreenListeners) {
            fullScreenListener.onYouTubePlayerEnterFullScreen();
        }
    }

    public void exitFullScreen() {
        if (!this.isFullScreen) {
            return;
        }
        ViewGroup.LayoutParams viewParams = this.getLayoutParams();
        viewParams.height = -2;
        viewParams.width = -1;
        this.setLayoutParams(viewParams);
        this.isFullScreen = false;
        for (YouTubePlayerFullScreenListener fullScreenListener : this.fullScreenListeners) {
            fullScreenListener.onYouTubePlayerExitFullScreen();
        }
    }

    public void toggleFullScreen() {
        if (this.isFullScreen) {
            this.exitFullScreen();
        } else {
            this.enterFullScreen();
        }
    }

    public boolean addFullScreenListener(@NonNull YouTubePlayerFullScreenListener fullScreenListener) {
        return this.fullScreenListeners.add(fullScreenListener);
    }

    public boolean removeFullScreenListener(@NonNull YouTubePlayerFullScreenListener fullScreenListener) {
        return this.fullScreenListeners.remove(fullScreenListener);
    }

    public void initialize(final @Nullable YouTubePlayer.YouTubeListener youTubeListener, boolean handleNetworkEvents) {
        if (handleNetworkEvents) {
            this.getContext().registerReceiver((BroadcastReceiver)this.networkReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
        if (!Utils.isOnline(this.getContext())) {
            Log.e((String)"YouTubePlayerView", (String)"Can't initialize because device is not connected to the internet.");
            this.onNetworkAvailableCallback = new Callable(){

                @Override
                public void call() {
                    Log.d((String)"YouTubePlayerView", (String)"Network available. Initializing player.");
                    YouTubePlayerView.this.youTubePlayer.initialize(youTubeListener);
                    YouTubePlayerView.this.initialized = true;
                    YouTubePlayerView.this.onNetworkAvailableCallback = null;
                }
            };
            return;
        }
        this.youTubePlayer.initialize(youTubeListener);
        this.initialized = true;
    }

    public void loadVideo(String videoId, float startSecond) {
        if (!this.initialized) {
            Log.e((String)"YouTubePlayerView", (String)"the player has not been initialized");
            return;
        }
        this.youTubePlayer.loadVideo(videoId, startSecond);
        this.playerControlsWrapper.onNewVideo();
    }

    public void cueVideo(String videoId, float startSeconds) {
        if (!this.initialized) {
            Log.e((String)"YouTubePlayerView", (String)"the player has not been initialized");
            return;
        }
        this.youTubePlayer.cueVideo(videoId, startSeconds);
        this.playerControlsWrapper.onNewVideo();
    }

    public void release() {
        if (!this.initialized) {
            Log.e((String)"YouTubePlayerView", (String)"the player has not been initialized");
            return;
        }
        this.youTubePlayer.destroy();
        try {
            this.getContext().unregisterReceiver((BroadcastReceiver)this.networkReceiver);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void seekTo(int time) {
        if (!this.initialized) {
            Log.e((String)"YouTubePlayerView", (String)"the player has not been initialized");
            return;
        }
        this.youTubePlayer.seekTo(time);
    }

    public void playVideo() {
        if (!this.initialized) {
            Log.e((String)"YouTubePlayerView", (String)"the player has not been initialized");
            return;
        }
        this.youTubePlayer.play();
    }

    public void pauseVideo() {
        if (!this.initialized) {
            Log.e((String)"YouTubePlayerView", (String)"the player has not been initialized");
            return;
        }
        this.youTubePlayer.pause();
    }

    @Override
    public void onNetworkAvailable() {
        Log.d((String)"YouTubePlayerView", (String)"Network available.");
        if (!this.initialized && this.onNetworkAvailableCallback != null) {
            this.onNetworkAvailableCallback.call();
        } else {
            this.playbackResumer.resume();
        }
    }

    @Override
    public void onNetworkUnavailable() {
    }

    public void showTitle(boolean show) {
        this.playerControlsWrapper.showTitle(show);
    }

    public void setCustomActionRight(Drawable icon, View.OnClickListener clickListener) {
        this.playerControlsWrapper.setCustomActionRight(icon, clickListener);
    }

    public void setCustomActionLeft(Drawable icon, View.OnClickListener clickListener) {
        this.playerControlsWrapper.setCustomActionLeft(icon, clickListener);
    }
}

