/*
 * Decompiled with CFR 0.152.
 */
package com.pierfrancescosoffritti.youtubeplayer;

import android.animation.Animator;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import com.pierfrancescosoffritti.youtubeplayer.R;
import com.pierfrancescosoffritti.youtubeplayer.Utils;
import com.pierfrancescosoffritti.youtubeplayer.YouTubePlayer;
import com.pierfrancescosoffritti.youtubeplayer.YouTubePlayerFullScreenListener;
import com.pierfrancescosoffritti.youtubeplayer.YouTubePlayerView;

class PlayerControlsWrapper
implements View.OnClickListener,
YouTubePlayerFullScreenListener,
YouTubePlayer.YouTubeListener,
SeekBar.OnSeekBarChangeListener {
    @NonNull
    private final YouTubePlayerView youTubePlayerView;
    @NonNull
    private final View panel;
    @NonNull
    private final View controlsRoot;
    @NonNull
    private final TextView videoTitle;
    @NonNull
    private final TextView videoCurrentTime;
    @NonNull
    private final TextView videoDuration;
    @NonNull
    private final ProgressBar progressBar;
    @NonNull
    private final ImageView playButton;
    @NonNull
    private final ImageView youTubeButton;
    @NonNull
    private final ImageView fullScreenButton;
    @NonNull
    private final ImageView customActionLeft;
    @NonNull
    private final ImageView customActionRight;
    @NonNull
    private final SeekBar seekBar;
    private View.OnClickListener onFullScreenButtonListener;
    private boolean isPlaying = false;
    private boolean isVisible = true;
    private boolean canFadeControls = false;
    private final Handler handler = new Handler(Looper.getMainLooper());
    private final Runnable fadeOutRunnable = new Runnable(){

        @Override
        public void run() {
            PlayerControlsWrapper.this.fadeControls(0.0f);
        }
    };
    private boolean seekBarTouchStarted = false;
    private int newSeekBarProgress = -1;

    protected PlayerControlsWrapper(@NonNull YouTubePlayerView youTubePlayerView, @NonNull View controlsView) {
        this.youTubePlayerView = youTubePlayerView;
        this.panel = controlsView.findViewById(R.id.panel);
        this.controlsRoot = controlsView.findViewById(R.id.controls_root);
        this.videoTitle = (TextView)controlsView.findViewById(R.id.video_title);
        this.videoCurrentTime = (TextView)controlsView.findViewById(R.id.video_current_time);
        this.videoDuration = (TextView)controlsView.findViewById(R.id.video_duration);
        this.progressBar = (ProgressBar)controlsView.findViewById(R.id.progress);
        this.playButton = (ImageView)controlsView.findViewById(R.id.play_button);
        this.youTubeButton = (ImageView)controlsView.findViewById(R.id.youtube_button);
        this.fullScreenButton = (ImageView)controlsView.findViewById(R.id.fullscreen_button);
        this.customActionLeft = (ImageView)controlsView.findViewById(R.id.custom_action_left_button);
        this.customActionRight = (ImageView)controlsView.findViewById(R.id.custom_action_right_button);
        this.seekBar = (SeekBar)controlsView.findViewById(R.id.seek_bar);
        this.seekBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.panel.setOnClickListener((View.OnClickListener)this);
        this.playButton.setOnClickListener((View.OnClickListener)this);
        this.fullScreenButton.setOnClickListener((View.OnClickListener)this);
    }

    public void setOnFullScreenButtonListener(View.OnClickListener onFullScreenButtonListener) {
        this.onFullScreenButtonListener = onFullScreenButtonListener;
    }

    protected void setCustomActionRight(Drawable icon, View.OnClickListener clickListener) {
        this.customActionRight.setImageDrawable(icon);
        this.customActionRight.setOnClickListener(clickListener);
        if (clickListener != null) {
            this.customActionRight.setVisibility(0);
        } else {
            this.customActionRight.setVisibility(8);
        }
    }

    protected void setCustomActionLeft(Drawable icon, View.OnClickListener clickListener) {
        this.customActionLeft.setImageDrawable(icon);
        this.customActionLeft.setOnClickListener(clickListener);
        if (clickListener != null) {
            this.customActionLeft.setVisibility(0);
        } else {
            this.customActionRight.setVisibility(8);
        }
    }

    public void onClick(View view) {
        if (view == this.panel) {
            this.toggleControlsVisibility();
        } else if (view == this.playButton) {
            this.onPlayButtonPressed();
        } else if (view == this.fullScreenButton) {
            this.onFullScreenPressed();
        }
    }

    private void onFullScreenPressed() {
        if (this.onFullScreenButtonListener == null) {
            this.youTubePlayerView.toggleFullScreen();
        } else {
            this.onFullScreenButtonListener.onClick((View)this.fullScreenButton);
        }
    }

    private void onPlayButtonPressed() {
        this.updateViewPlaybackState(!this.isPlaying);
        if (this.isPlaying) {
            this.youTubePlayerView.playVideo();
        } else {
            this.youTubePlayerView.pauseVideo();
        }
    }

    private void updateViewPlaybackState(boolean playing) {
        this.isPlaying = playing;
        int img = playing ? R.drawable.ic_pause_36dp : R.drawable.ic_play_36dp;
        this.playButton.setImageResource(img);
    }

    private void toggleControlsVisibility() {
        float finalAlpha = this.isVisible ? 0.0f : 1.0f;
        this.fadeControls(finalAlpha);
    }

    private void fadeControls(final float finalAlpha) {
        if (!this.canFadeControls) {
            return;
        }
        boolean bl = this.isVisible = finalAlpha != 0.0f;
        if (finalAlpha == 1.0f && this.isPlaying) {
            this.startFadeOutViewTimer();
        } else {
            this.handler.removeCallbacks(this.fadeOutRunnable);
        }
        this.controlsRoot.animate().alpha(finalAlpha).setDuration(300L).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
                if (finalAlpha == 1.0f) {
                    PlayerControlsWrapper.this.controlsRoot.setVisibility(0);
                }
            }

            public void onAnimationEnd(Animator animator) {
                if (finalAlpha == 0.0f) {
                    PlayerControlsWrapper.this.controlsRoot.setVisibility(8);
                }
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        }).start();
    }

    private void startFadeOutViewTimer() {
        this.handler.postDelayed(this.fadeOutRunnable, 2500L);
    }

    @Override
    public void onYouTubePlayerEnterFullScreen() {
        this.fullScreenButton.setImageResource(R.drawable.ic_fullscreen_exit_24dp);
    }

    @Override
    public void onYouTubePlayerExitFullScreen() {
        this.fullScreenButton.setImageResource(R.drawable.ic_fullscreen_24dp);
    }

    @Override
    public void onStateChange(int state) {
        this.newSeekBarProgress = -1;
        if (state == 1 || state == 2 || state == 5) {
            this.panel.setBackgroundColor(ContextCompat.getColor((Context)this.youTubePlayerView.getContext(), (int)17170445));
            this.progressBar.setVisibility(8);
            this.playButton.setVisibility(0);
            if (this.customActionLeft.hasOnClickListeners()) {
                this.customActionLeft.setVisibility(0);
            } else {
                this.customActionLeft.setVisibility(8);
            }
            if (this.customActionRight.hasOnClickListeners()) {
                this.customActionRight.setVisibility(0);
            } else {
                this.customActionRight.setVisibility(8);
            }
            this.canFadeControls = true;
            boolean playing = state == 1;
            this.updateViewPlaybackState(playing);
            if (playing) {
                this.startFadeOutViewTimer();
            } else {
                this.handler.removeCallbacks(this.fadeOutRunnable);
            }
        } else {
            this.updateViewPlaybackState(false);
            this.fadeControls(1.0f);
            if (state == 3) {
                this.playButton.setVisibility(4);
                this.customActionLeft.setVisibility(8);
                this.customActionRight.setVisibility(8);
                this.progressBar.setVisibility(0);
                this.canFadeControls = false;
            }
            if (state == -1) {
                this.panel.setBackgroundColor(ContextCompat.getColor((Context)this.youTubePlayerView.getContext(), (int)17170444));
                this.canFadeControls = false;
                this.progressBar.setVisibility(8);
                this.playButton.setVisibility(0);
            }
        }
    }

    @Override
    public void onCurrentSecond(float second) {
        if (this.seekBarTouchStarted) {
            return;
        }
        if (this.newSeekBarProgress > 0 && !Utils.formatTime(second).equals(Utils.formatTime(this.newSeekBarProgress))) {
            return;
        }
        this.newSeekBarProgress = -1;
        this.seekBar.setProgress((int)second);
    }

    @Override
    public void onVideoDuration(float duration) {
        this.videoDuration.setText((CharSequence)Utils.formatTime(duration));
        this.seekBar.setMax((int)duration);
    }

    @Override
    public void onVideoTitle(String title) {
        this.videoTitle.setText((CharSequence)title);
    }

    @Override
    public void onVideoId(final String videoId) {
        this.youTubeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("http://www.youtube.com/watch?v=" + videoId)));
                PlayerControlsWrapper.this.controlsRoot.getContext().startActivity(intent);
            }
        });
    }

    @Override
    public void onReady() {
    }

    @Override
    public void onLog(String log) {
    }

    @Override
    public void onPlaybackQualityChange(int playbackQuality) {
    }

    @Override
    public void onPlaybackRateChange(double rate) {
    }

    @Override
    public void onError(int error) {
    }

    @Override
    public void onApiChange() {
    }

    public void onProgressChanged(SeekBar seekBar, int i, boolean b) {
        this.videoCurrentTime.setText((CharSequence)Utils.formatTime(i));
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
        this.seekBarTouchStarted = true;
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        if (this.isPlaying) {
            this.newSeekBarProgress = seekBar.getProgress();
        }
        this.youTubePlayerView.seekTo(seekBar.getProgress());
        this.seekBarTouchStarted = false;
    }

    public void onNewVideo() {
        this.seekBar.setProgress(0);
        this.seekBar.setMax(0);
        this.videoDuration.post(new Runnable(){

            @Override
            public void run() {
                PlayerControlsWrapper.this.videoDuration.setText((CharSequence)"");
            }
        });
        this.videoTitle.post(new Runnable(){

            @Override
            public void run() {
                PlayerControlsWrapper.this.videoTitle.setText((CharSequence)"");
            }
        });
        this.youTubeButton.setOnClickListener(null);
    }

    public void showTitle(boolean show) {
        this.videoTitle.setVisibility(show ? 0 : 8);
    }
}

