/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksigner.core.internal.apk.v1;

import com.android.apksigner.core.internal.apk.v1.DigestAlgorithm;
import com.android.apksigner.core.internal.jar.ManifestWriter;
import com.android.apksigner.core.internal.jar.SignatureFileWriter;
import com.android.apksigner.core.internal.util.Pair;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.gradle.internal.impldep.org.bouncycastle.asn1.ASN1InputStream;
import org.gradle.internal.impldep.org.bouncycastle.asn1.ASN1OutputStream;
import org.gradle.internal.impldep.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.gradle.internal.impldep.org.bouncycastle.cert.X509CertificateHolder;
import org.gradle.internal.impldep.org.bouncycastle.cert.jcajce.JcaCertStore;
import org.gradle.internal.impldep.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.gradle.internal.impldep.org.bouncycastle.cms.CMSException;
import org.gradle.internal.impldep.org.bouncycastle.cms.CMSProcessableByteArray;
import org.gradle.internal.impldep.org.bouncycastle.cms.CMSSignatureEncryptionAlgorithmFinder;
import org.gradle.internal.impldep.org.bouncycastle.cms.CMSSignedData;
import org.gradle.internal.impldep.org.bouncycastle.cms.CMSSignedDataGenerator;
import org.gradle.internal.impldep.org.bouncycastle.cms.CMSTypedData;
import org.gradle.internal.impldep.org.bouncycastle.cms.DefaultCMSSignatureEncryptionAlgorithmFinder;
import org.gradle.internal.impldep.org.bouncycastle.cms.SignerInfoGeneratorBuilder;
import org.gradle.internal.impldep.org.bouncycastle.operator.ContentSigner;
import org.gradle.internal.impldep.org.bouncycastle.operator.OperatorCreationException;
import org.gradle.internal.impldep.org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.gradle.internal.impldep.org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.gradle.internal.impldep.org.bouncycastle.util.Store;

public abstract class V1SchemeSigner {
    public static final String MANIFEST_ENTRY_NAME = "META-INF/MANIFEST.MF";
    private static final Attributes.Name ATTRIBUTE_NAME_CREATED_BY = new Attributes.Name("Created-By");
    private static final String ATTRIBUTE_DEFALT_VALUE_CREATED_BY = "1.0 (Android apksigner)";
    private static final String ATTRIBUTE_VALUE_MANIFEST_VERSION = "1.0";
    private static final String ATTRIBUTE_VALUE_SIGNATURE_VERSION = "1.0";
    private static final Attributes.Name SF_ATTRIBUTE_NAME_ANDROID_APK_SIGNED_NAME = new Attributes.Name("X-Android-APK-Signed");

    private V1SchemeSigner() {
    }

    public static DigestAlgorithm getSuggestedSignatureDigestAlgorithm(PublicKey signingKey, int minSdkVersion) throws InvalidKeyException {
        String keyAlgorithm = signingKey.getAlgorithm();
        if ("RSA".equalsIgnoreCase(keyAlgorithm)) {
            if (minSdkVersion < 18) {
                return DigestAlgorithm.SHA1;
            }
            return DigestAlgorithm.SHA256;
        }
        if ("DSA".equalsIgnoreCase(keyAlgorithm)) {
            if (minSdkVersion < 21) {
                return DigestAlgorithm.SHA1;
            }
            return DigestAlgorithm.SHA256;
        }
        if ("EC".equalsIgnoreCase(keyAlgorithm)) {
            if (minSdkVersion < 18) {
                throw new InvalidKeyException("ECDSA signatures only supported for minSdkVersion 18 and higher");
            }
            if (minSdkVersion < 21) {
                return DigestAlgorithm.SHA1;
            }
            return DigestAlgorithm.SHA256;
        }
        throw new InvalidKeyException("Unsupported key algorithm: " + keyAlgorithm);
    }

    public static DigestAlgorithm getSuggestedContentDigestAlgorithm(int minSdkVersion) {
        return minSdkVersion >= 18 ? DigestAlgorithm.SHA256 : DigestAlgorithm.SHA1;
    }

    public static MessageDigest getMessageDigestInstance(DigestAlgorithm digestAlgorithm) {
        String jcaAlgorithm = digestAlgorithm.getJcaMessageDigestAlgorithm();
        try {
            return MessageDigest.getInstance(jcaAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to obtain " + jcaAlgorithm + " MessageDigest", e);
        }
    }

    public static String getJcaMessageDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        return digestAlgorithm.getJcaMessageDigestAlgorithm();
    }

    public static boolean isJarEntryDigestNeededInManifest(String entryName) {
        if (!entryName.startsWith("META-INF/")) {
            return true;
        }
        if (entryName.indexOf(47, "META-INF/".length()) != -1) {
            return true;
        }
        String fileNameLowerCase = entryName.substring("META-INF/".length()).toLowerCase(Locale.US);
        return !"manifest.mf".equals(fileNameLowerCase) && !fileNameLowerCase.endsWith(".sf") && !fileNameLowerCase.endsWith(".rsa") && !fileNameLowerCase.endsWith(".dsa") && !fileNameLowerCase.endsWith(".ec") && !fileNameLowerCase.startsWith("sig-");
    }

    public static List<Pair<String, byte[]>> sign(List<SignerConfig> signerConfigs, DigestAlgorithm jarEntryDigestAlgorithm, Map<String, byte[]> jarEntryDigests, List<Integer> apkSigningSchemeIds, byte[] sourceManifestBytes) throws InvalidKeyException, CertificateEncodingException, SignatureException {
        if (signerConfigs.isEmpty()) {
            throw new IllegalArgumentException("At least one signer config must be provided");
        }
        OutputManifestFile manifest = V1SchemeSigner.generateManifestFile(jarEntryDigestAlgorithm, jarEntryDigests, sourceManifestBytes);
        return V1SchemeSigner.signManifest(signerConfigs, jarEntryDigestAlgorithm, apkSigningSchemeIds, manifest);
    }

    public static List<Pair<String, byte[]>> signManifest(List<SignerConfig> signerConfigs, DigestAlgorithm digestAlgorithm, List<Integer> apkSigningSchemeIds, OutputManifestFile manifest) throws InvalidKeyException, CertificateEncodingException, SignatureException {
        if (signerConfigs.isEmpty()) {
            throw new IllegalArgumentException("At least one signer config must be provided");
        }
        ArrayList<Pair<String, byte[]>> signatureJarEntries = new ArrayList<Pair<String, byte[]>>(2 * signerConfigs.size() + 1);
        byte[] sfBytes = V1SchemeSigner.generateSignatureFile(apkSigningSchemeIds, digestAlgorithm, manifest);
        for (SignerConfig signerConfig : signerConfigs) {
            byte[] signatureBlock;
            String signerName = signerConfig.name;
            try {
                signatureBlock = V1SchemeSigner.generateSignatureBlock(signerConfig, sfBytes);
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeyException("Failed to sign using signer \"" + signerName + "\"", e);
            }
            catch (CertificateEncodingException e) {
                throw new CertificateEncodingException("Failed to sign using signer \"" + signerName + "\"", e);
            }
            catch (SignatureException e) {
                throw new SignatureException("Failed to sign using signer \"" + signerName + "\"", e);
            }
            signatureJarEntries.add(Pair.of("META-INF/" + signerName + ".SF", sfBytes));
            PublicKey publicKey = signerConfig.certificates.get(0).getPublicKey();
            String signatureBlockFileName = "META-INF/" + signerName + "." + publicKey.getAlgorithm().toUpperCase(Locale.US);
            signatureJarEntries.add(Pair.of(signatureBlockFileName, signatureBlock));
        }
        signatureJarEntries.add(Pair.of(MANIFEST_ENTRY_NAME, manifest.contents));
        return signatureJarEntries;
    }

    public static Set<String> getOutputEntryNames(List<SignerConfig> signerConfigs) {
        HashSet<String> result = new HashSet<String>(2 * signerConfigs.size() + 1);
        for (SignerConfig signerConfig : signerConfigs) {
            String signerName = signerConfig.name;
            result.add("META-INF/" + signerName + ".SF");
            PublicKey publicKey = signerConfig.certificates.get(0).getPublicKey();
            String signatureBlockFileName = "META-INF/" + signerName + "." + publicKey.getAlgorithm().toUpperCase(Locale.US);
            result.add(signatureBlockFileName);
        }
        result.add(MANIFEST_ENTRY_NAME);
        return result;
    }

    public static OutputManifestFile generateManifestFile(DigestAlgorithm jarEntryDigestAlgorithm, Map<String, byte[]> jarEntryDigests, byte[] sourceManifestBytes) {
        Manifest sourceManifest = null;
        if (sourceManifestBytes != null) {
            try {
                sourceManifest = new Manifest(new ByteArrayInputStream(sourceManifestBytes));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to parse source MANIFEST.MF", e);
            }
        }
        ByteArrayOutputStream manifestOut = new ByteArrayOutputStream();
        Attributes mainAttrs = new Attributes();
        if (sourceManifest != null) {
            mainAttrs.putAll((Map<?, ?>)sourceManifest.getMainAttributes());
        } else {
            mainAttrs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
            mainAttrs.put(ATTRIBUTE_NAME_CREATED_BY, ATTRIBUTE_DEFALT_VALUE_CREATED_BY);
        }
        try {
            ManifestWriter.writeMainSection(manifestOut, mainAttrs);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write in-memory MANIFEST.MF", e);
        }
        ArrayList<String> sortedEntryNames = new ArrayList<String>(jarEntryDigests.keySet());
        Collections.sort(sortedEntryNames);
        TreeMap<String, byte[]> invidualSectionsContents = new TreeMap<String, byte[]>();
        String entryDigestAttributeName = V1SchemeSigner.getEntryDigestAttributeName(jarEntryDigestAlgorithm);
        for (String entryName : sortedEntryNames) {
            byte[] sectionBytes;
            byte[] entryDigest = jarEntryDigests.get(entryName);
            Attributes entryAttrs = new Attributes();
            entryAttrs.putValue(entryDigestAttributeName, Base64.getEncoder().encodeToString(entryDigest));
            ByteArrayOutputStream sectionOut = new ByteArrayOutputStream();
            try {
                ManifestWriter.writeIndividualSection(sectionOut, entryName, entryAttrs);
                sectionBytes = sectionOut.toByteArray();
                manifestOut.write(sectionBytes);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write in-memory MANIFEST.MF", e);
            }
            invidualSectionsContents.put(entryName, sectionBytes);
        }
        OutputManifestFile result = new OutputManifestFile();
        result.contents = manifestOut.toByteArray();
        result.mainSectionAttributes = mainAttrs;
        result.individualSectionsContents = invidualSectionsContents;
        return result;
    }

    private static byte[] generateSignatureFile(List<Integer> apkSignatureSchemeIds, DigestAlgorithm manifestDigestAlgorithm, OutputManifestFile manifest) {
        Manifest sf = new Manifest();
        Attributes mainAttrs = sf.getMainAttributes();
        mainAttrs.put(Attributes.Name.SIGNATURE_VERSION, "1.0");
        mainAttrs.put(ATTRIBUTE_NAME_CREATED_BY, ATTRIBUTE_DEFALT_VALUE_CREATED_BY);
        if (!apkSignatureSchemeIds.isEmpty()) {
            StringBuilder attrValue = new StringBuilder();
            for (int id : apkSignatureSchemeIds) {
                if (attrValue.length() > 0) {
                    attrValue.append(", ");
                }
                attrValue.append(String.valueOf(id));
            }
            mainAttrs.put(SF_ATTRIBUTE_NAME_ANDROID_APK_SIGNED_NAME, attrValue.toString());
        }
        MessageDigest md = V1SchemeSigner.getMessageDigestInstance(manifestDigestAlgorithm);
        mainAttrs.putValue(V1SchemeSigner.getManifestDigestAttributeName(manifestDigestAlgorithm), Base64.getEncoder().encodeToString(md.digest(manifest.contents)));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            SignatureFileWriter.writeMainSection(out, mainAttrs);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write in-memory .SF file", e);
        }
        String entryDigestAttributeName = V1SchemeSigner.getEntryDigestAttributeName(manifestDigestAlgorithm);
        for (Map.Entry<String, byte[]> manifestSection : manifest.individualSectionsContents.entrySet()) {
            String sectionName = manifestSection.getKey();
            byte[] sectionContents = manifestSection.getValue();
            byte[] sectionDigest = md.digest(sectionContents);
            Attributes attrs = new Attributes();
            attrs.putValue(entryDigestAttributeName, Base64.getEncoder().encodeToString(sectionDigest));
            try {
                SignatureFileWriter.writeIndividualSection(out, sectionName, attrs);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write in-memory .SF file", e);
            }
        }
        if (out.size() > 0 && out.size() % 1024 == 0) {
            try {
                SignatureFileWriter.writeSectionDelimiter(out);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write to ByteArrayOutputStream", e);
            }
        }
        return out.toByteArray();
    }

    private static byte[] generateSignatureBlock(SignerConfig signerConfig, byte[] signatureFileBytes) throws InvalidKeyException, CertificateEncodingException, SignatureException {
        JcaCertStore certs = new JcaCertStore(signerConfig.certificates);
        X509Certificate signerCert = signerConfig.certificates.get(0);
        String jcaSignatureAlgorithm = V1SchemeSigner.getJcaSignatureAlgorithm(signerCert.getPublicKey(), signerConfig.signatureDigestAlgorithm);
        try {
            ContentSigner signer = new JcaContentSignerBuilder(jcaSignatureAlgorithm).build(signerConfig.privateKey);
            CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
            gen.addSignerInfoGenerator(new SignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().build(), (CMSSignatureEncryptionAlgorithmFinder)SignerInfoSignatureAlgorithmFinder.INSTANCE).setDirectSignature(true).build(signer, (X509CertificateHolder)new JcaX509CertificateHolder(signerCert)));
            gen.addCertificates((Store)certs);
            CMSSignedData sigData = gen.generate((CMSTypedData)new CMSProcessableByteArray(signatureFileBytes), false);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (ASN1InputStream asn1 = new ASN1InputStream(sigData.getEncoded());){
                ASN1OutputStream dos = ASN1OutputStream.create((OutputStream)out, (String)"DER");
                dos.writeObject(asn1.readObject());
            }
            return out.toByteArray();
        }
        catch (IOException | CMSException | OperatorCreationException e) {
            throw new SignatureException("Failed to generate signature", e);
        }
    }

    private static String getEntryDigestAttributeName(DigestAlgorithm digestAlgorithm) {
        switch (digestAlgorithm) {
            case SHA1: {
                return "SHA1-Digest";
            }
            case SHA256: {
                return "SHA-256-Digest";
            }
        }
        throw new IllegalArgumentException("Unexpected content digest algorithm: " + digestAlgorithm);
    }

    private static String getManifestDigestAttributeName(DigestAlgorithm digestAlgorithm) {
        switch (digestAlgorithm) {
            case SHA1: {
                return "SHA1-Digest-Manifest";
            }
            case SHA256: {
                return "SHA-256-Digest-Manifest";
            }
        }
        throw new IllegalArgumentException("Unexpected content digest algorithm: " + digestAlgorithm);
    }

    private static String getJcaSignatureAlgorithm(PublicKey publicKey, DigestAlgorithm digestAlgorithm) throws InvalidKeyException {
        String digestPrefixForSigAlg;
        String keyAlgorithm = publicKey.getAlgorithm();
        switch (digestAlgorithm) {
            case SHA1: {
                digestPrefixForSigAlg = "SHA1";
                break;
            }
            case SHA256: {
                digestPrefixForSigAlg = "SHA256";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected digest algorithm: " + digestAlgorithm);
            }
        }
        if ("RSA".equalsIgnoreCase(keyAlgorithm)) {
            return digestPrefixForSigAlg + "withRSA";
        }
        if ("DSA".equalsIgnoreCase(keyAlgorithm)) {
            return digestPrefixForSigAlg + "withDSA";
        }
        if ("EC".equalsIgnoreCase(keyAlgorithm)) {
            return digestPrefixForSigAlg + "withECDSA";
        }
        throw new InvalidKeyException("Unsupported key algorithm: " + keyAlgorithm);
    }

    private static class SignerInfoSignatureAlgorithmFinder
    implements CMSSignatureEncryptionAlgorithmFinder {
        private static final SignerInfoSignatureAlgorithmFinder INSTANCE = new SignerInfoSignatureAlgorithmFinder();
        private final CMSSignatureEncryptionAlgorithmFinder mDefault = new DefaultCMSSignatureEncryptionAlgorithmFinder();

        private SignerInfoSignatureAlgorithmFinder() {
        }

        public AlgorithmIdentifier findEncryptionAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
            return this.mDefault.findEncryptionAlgorithm(algorithmIdentifier);
        }
    }

    public static class OutputManifestFile {
        public byte[] contents;
        public SortedMap<String, byte[]> individualSectionsContents;
        public Attributes mainSectionAttributes;
    }

    public static class SignerConfig {
        public String name;
        public PrivateKey privateKey;
        public List<X509Certificate> certificates;
        public DigestAlgorithm signatureDigestAlgorithm;
        public DigestAlgorithm contentDigestAlgorithm;
    }
}

