/*
 * Decompiled with CFR 0.152.
 */
package com.othershe.cornerlabelview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.othershe.cornerlabelview.R;

public class CornerLabelView
extends View {
    private int mHalfWidth;
    private Paint mPaint;
    private TextPaint mTextPaint;
    private Path mPath;
    private int position;
    private int sideLength = (int)TypedValue.applyDimension((int)1, (float)40.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
    private int textSize = (int)TypedValue.applyDimension((int)2, (float)14.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
    private int textColor = -1;
    private String text;
    private int bgColor = -65536;
    private int marginLeanSide = -1;

    public CornerLabelView(Context context) {
        this(context, null);
    }

    public CornerLabelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(context, attrs);
        this.init();
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.CornerLabelView, 0, 0);
        for (int i = 0; i < ta.getIndexCount(); ++i) {
            int attr = ta.getIndex(i);
            if (attr == R.styleable.CornerLabelView_position) {
                this.position = ta.getInt(attr, 0);
                continue;
            }
            if (attr == R.styleable.CornerLabelView_side_length) {
                this.sideLength = ta.getDimensionPixelSize(attr, this.sideLength);
                continue;
            }
            if (attr == R.styleable.CornerLabelView_text_size) {
                this.textSize = ta.getDimensionPixelSize(attr, this.textSize);
                continue;
            }
            if (attr == R.styleable.CornerLabelView_text_color) {
                this.textColor = ta.getColor(attr, this.textColor);
                continue;
            }
            if (attr == R.styleable.CornerLabelView_text) {
                this.text = ta.getString(attr);
                continue;
            }
            if (attr == R.styleable.CornerLabelView_bg_color) {
                this.bgColor = ta.getColor(attr, this.bgColor);
                continue;
            }
            if (attr != R.styleable.CornerLabelView_margin_lean_side) continue;
            this.marginLeanSide = ta.getDimensionPixelSize(attr, this.marginLeanSide);
        }
        ta.recycle();
    }

    private void init() {
        this.mPath = new Path();
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setColor(this.bgColor);
        this.mTextPaint = new TextPaint();
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setColor(this.textColor);
        this.mTextPaint.setTextSize((float)this.textSize);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (widthSpecMode == Integer.MIN_VALUE && heightSpecMode == Integer.MIN_VALUE) {
            this.setMeasuredDimension(this.sideLength * 2, this.sideLength * 2);
        } else if (widthSpecMode == Integer.MIN_VALUE) {
            this.setMeasuredDimension(heightSpecSize, heightSpecSize);
        } else if (heightSpecMode == Integer.MIN_VALUE) {
            this.setMeasuredDimension(widthSpecSize, widthSpecSize);
        } else if (widthSpecSize != heightSpecSize) {
            int size = Math.min(widthSpecSize, heightSpecSize);
            this.setMeasuredDimension(size, size);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mHalfWidth = Math.min(w, h) / 2;
    }

    protected void onDraw(Canvas canvas) {
        int y;
        super.onDraw(canvas);
        canvas.translate((float)this.mHalfWidth, (float)this.mHalfWidth);
        canvas.rotate((float)(this.position * 90));
        if (this.sideLength > this.mHalfWidth * 2) {
            this.sideLength = this.mHalfWidth * 2;
        }
        this.mPath.moveTo((float)(-this.mHalfWidth), (float)(-this.mHalfWidth));
        this.mPath.lineTo((float)(this.sideLength - this.mHalfWidth), (float)(-this.mHalfWidth));
        this.mPath.lineTo((float)this.mHalfWidth, (float)(this.mHalfWidth - this.sideLength));
        this.mPath.lineTo((float)this.mHalfWidth, (float)this.mHalfWidth);
        this.mPath.close();
        canvas.drawPath(this.mPath, this.mPaint);
        canvas.rotate(45.0f);
        int h1 = (int)(Math.sqrt(2.0) / 2.0 * (double)this.sideLength);
        int h2 = (int)(-(this.mTextPaint.ascent() + this.mTextPaint.descent()));
        int x = (int)(-this.mTextPaint.measureText(this.text)) / 2;
        if (this.marginLeanSide >= 0) {
            if (this.position == 1 || this.position == 2) {
                y = (float)h1 - ((float)this.marginLeanSide - this.mTextPaint.ascent()) < (float)((h1 - h2) / 2) ? -(h1 - h2) / 2 : (int)(-((float)h1 - ((float)this.marginLeanSide - this.mTextPaint.ascent())));
            } else {
                if ((float)this.marginLeanSide < this.mTextPaint.descent()) {
                    this.marginLeanSide = (int)this.mTextPaint.descent();
                }
                if (this.marginLeanSide > (h1 - h2) / 2) {
                    this.marginLeanSide = (h1 - h2) / 2;
                }
                y = -this.marginLeanSide;
            }
        } else {
            if (this.sideLength > this.mHalfWidth) {
                this.sideLength = this.mHalfWidth;
            }
            y = (int)(-Math.sqrt(2.0) / 2.0 * (double)this.sideLength + (double)h2) / 2;
        }
        if (this.position == 1 || this.position == 2) {
            canvas.translate(0.0f, (float)(-Math.sqrt(2.0) / 2.0 * (double)this.sideLength));
            canvas.scale(-1.0f, -1.0f);
        }
        canvas.drawText(this.text, (float)x, (float)y, (Paint)this.mTextPaint);
    }

    public CornerLabelView setBgColorId(int bgColorId) {
        this.bgColor = this.getResources().getColor(bgColorId);
        this.mPaint.setColor(this.bgColor);
        this.invalidate();
        return this;
    }

    public CornerLabelView setBgColor(int bgColor) {
        this.mPaint.setColor(bgColor);
        this.invalidate();
        return this;
    }

    public CornerLabelView setTextColorId(int colorId) {
        this.textColor = this.getResources().getColor(colorId);
        this.mTextPaint.setColor(this.textColor);
        this.invalidate();
        return this;
    }

    public CornerLabelView setTextColor(int color) {
        this.mTextPaint.setColor(color);
        this.invalidate();
        return this;
    }

    public CornerLabelView setText(int textId) {
        this.text = this.getResources().getString(textId);
        this.invalidate();
        return this;
    }

    public CornerLabelView setText(String text) {
        this.text = text;
        this.invalidate();
        return this;
    }
}

