/*
 * Decompiled with CFR 0.152.
 */
package com.othershe.calendarview.weiget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.othershe.calendarview.R;
import com.othershe.calendarview.utils.CalendarUtil;

public class WeekView
extends View {
    private String[] weekArray = new String[]{"\u65e5", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d"};
    private int weekSize = 12;
    private int weekColor = -16777216;
    private Paint mPaint;
    private Context context;

    public WeekView(Context context) {
        this(context, null);
    }

    public WeekView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WeekView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        this.initAttrs(attrs);
        this.initPaint();
        this.setBackgroundColor(-1);
    }

    private void initAttrs(AttributeSet attrs) {
        String weekStr = null;
        TypedArray ta = this.context.obtainStyledAttributes(attrs, R.styleable.WeekView);
        for (int i = 0; i < ta.getIndexCount(); ++i) {
            int attr = ta.getIndex(i);
            if (attr == R.styleable.WeekView_week_color) {
                this.weekColor = ta.getColor(R.styleable.WeekView_week_color, this.weekColor);
                continue;
            }
            if (attr == R.styleable.WeekView_week_size) {
                this.weekSize = ta.getInteger(R.styleable.WeekView_week_size, this.weekSize);
                continue;
            }
            if (attr != R.styleable.WeekView_week_str) continue;
            weekStr = ta.getString(R.styleable.WeekView_week_str);
        }
        ta.recycle();
        if (!TextUtils.isEmpty(weekStr)) {
            String[] weeks = weekStr.split("\\.");
            if (weeks.length != 7) {
                return;
            }
            System.arraycopy(weeks, 0, this.weekArray, 0, 7);
        }
        this.weekSize = CalendarUtil.getTextSize1(this.context, this.weekSize);
    }

    private void initPaint() {
        this.mPaint = new Paint();
        this.mPaint.setColor(this.weekColor);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setTextSize((float)this.weekSize);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (heightMode == Integer.MIN_VALUE) {
            heightSize = CalendarUtil.getPxSize(this.context, 35);
        }
        if (widthMode == Integer.MIN_VALUE) {
            widthSize = CalendarUtil.getPxSize(this.context, 300);
        }
        this.setMeasuredDimension(widthSize, heightSize);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int width = this.getWidth();
        int height = this.getHeight();
        int itemWidth = width / 7;
        for (int i = 0; i < this.weekArray.length; ++i) {
            String text = this.weekArray[i];
            int textWidth = (int)this.mPaint.measureText(text);
            int startX = itemWidth * i + (itemWidth - textWidth) / 2;
            int startY = (int)((float)(height / 2) - (this.mPaint.ascent() + this.mPaint.descent()) / 2.0f);
            canvas.drawText(text, (float)startX, (float)startY, this.mPaint);
        }
    }
}

