/*
 * Decompiled with CFR 0.152.
 */
package com.othershe.calendarview.weiget;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.othershe.calendarview.R;
import com.othershe.calendarview.bean.AttrsBean;
import com.othershe.calendarview.bean.DateBean;
import com.othershe.calendarview.listener.CalendarViewAdapter;
import com.othershe.calendarview.listener.OnMultiChooseListener;
import com.othershe.calendarview.listener.OnSingleChooseListener;
import com.othershe.calendarview.utils.CalendarUtil;
import com.othershe.calendarview.weiget.CalendarView;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MonthView
extends ViewGroup {
    private static final int ROW = 6;
    private static final int COLUMN = 7;
    private static final int COLOR_RESET = 0;
    private static final int COLOR_SET = 1;
    private Context mContext;
    private View lastClickedView;
    private int currentMonthDays;
    private int lastMonthDays;
    private int nextMonthDays;
    private int item_layout;
    private CalendarViewAdapter calendarViewAdapter;
    private Set<Integer> chooseDays = new HashSet<Integer>();
    private AttrsBean mAttrsBean;

    public MonthView(Context context) {
        this(context, null);
    }

    public MonthView(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
        this.mContext = context;
        this.setBackgroundColor(-1);
    }

    public void setDateList(List<DateBean> dates, int currentMonthDays) {
        if (this.getChildCount() > 0) {
            this.removeAllViews();
        }
        this.lastMonthDays = 0;
        this.nextMonthDays = 0;
        boolean findSingleDate = false;
        this.chooseDays.clear();
        this.currentMonthDays = currentMonthDays;
        for (int i = 0; i < dates.size(); ++i) {
            TextView lunarDay;
            TextView solarDay;
            View view;
            final DateBean date = dates.get(i);
            if (date.getType() == 0) {
                ++this.lastMonthDays;
                if (!this.mAttrsBean.isShowLastNext()) {
                    this.addView(new View(this.mContext), i);
                    continue;
                }
            }
            if (date.getType() == 2) {
                ++this.nextMonthDays;
                if (!this.mAttrsBean.isShowLastNext()) {
                    this.addView(new View(this.mContext), i);
                    continue;
                }
            }
            if (this.item_layout != 0 && this.calendarViewAdapter != null) {
                view = LayoutInflater.from((Context)this.mContext).inflate(this.item_layout, null);
                TextView[] views = this.calendarViewAdapter.convertView(view, date);
                solarDay = views[0];
                lunarDay = views[1];
            } else {
                view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_month_layout, null);
                solarDay = (TextView)view.findViewById(R.id.solar_day);
                lunarDay = (TextView)view.findViewById(R.id.lunar_day);
            }
            solarDay.setTextColor(this.mAttrsBean.getColorSolar());
            solarDay.setTextSize((float)this.mAttrsBean.getSizeSolar());
            lunarDay.setTextColor(this.mAttrsBean.getColorLunar());
            lunarDay.setTextSize((float)this.mAttrsBean.getSizeLunar());
            if (date.getType() == 0 || date.getType() == 2) {
                solarDay.setTextColor(this.mAttrsBean.getColorLunar());
            }
            solarDay.setText((CharSequence)String.valueOf(date.getSolar()[2]));
            if (this.mAttrsBean.isShowLunar()) {
                if ("\u521d\u4e00".equals(date.getLunar()[1])) {
                    lunarDay.setText((CharSequence)date.getLunar()[0]);
                    if ("\u6b63\u6708".equals(date.getLunar()[0]) && this.mAttrsBean.isShowHoliday()) {
                        lunarDay.setTextColor(this.mAttrsBean.getColorHoliday());
                        lunarDay.setText((CharSequence)"\u6625\u8282");
                    }
                } else if (!TextUtils.isEmpty((CharSequence)date.getSolarHoliday()) && this.mAttrsBean.isShowHoliday()) {
                    this.setLunarText(date.getSolarHoliday(), lunarDay, date.getType());
                } else if (!TextUtils.isEmpty((CharSequence)date.getLunarHoliday()) && this.mAttrsBean.isShowHoliday()) {
                    this.setLunarText(date.getLunarHoliday(), lunarDay, date.getType());
                } else if (!TextUtils.isEmpty((CharSequence)date.getTerm()) && this.mAttrsBean.isShowTerm()) {
                    this.setLunarText(date.getTerm(), lunarDay, date.getType());
                } else if (TextUtils.isEmpty((CharSequence)date.getLunar()[1])) {
                    lunarDay.setVisibility(8);
                } else {
                    lunarDay.setText((CharSequence)date.getLunar()[1]);
                }
            } else {
                lunarDay.setVisibility(8);
            }
            if (this.mAttrsBean.getChooseType() == 0 && this.mAttrsBean.getSingleDate() != null && !findSingleDate && date.getType() == 1 && this.mAttrsBean.getSingleDate()[0] == date.getSolar()[0] && this.mAttrsBean.getSingleDate()[1] == date.getSolar()[1] && this.mAttrsBean.getSingleDate()[2] == date.getSolar()[2]) {
                this.lastClickedView = view;
                this.setDayColor(view, 1);
                findSingleDate = true;
            }
            if (this.mAttrsBean.getChooseType() == 1 && this.mAttrsBean.getMultiDates() != null) {
                for (int[] d : this.mAttrsBean.getMultiDates()) {
                    if (date.getType() != 1 || d[0] != date.getSolar()[0] || d[1] != date.getSolar()[1] || d[2] != date.getSolar()[2]) continue;
                    this.setDayColor(view, 1);
                    this.chooseDays.add(d[2]);
                    break;
                }
            }
            if (date.getType() == 1) {
                view.setTag((Object)date.getSolar()[2]);
                if (this.mAttrsBean.getDisableStartDate() != null && CalendarUtil.dateToMillis(this.mAttrsBean.getDisableStartDate()) > CalendarUtil.dateToMillis(date.getSolar())) {
                    solarDay.setTextColor(this.mAttrsBean.getColorLunar());
                    lunarDay.setTextColor(this.mAttrsBean.getColorLunar());
                    view.setTag((Object)-1);
                    this.addView(view, i);
                    continue;
                }
                if (this.mAttrsBean.getDisableEndDate() != null && CalendarUtil.dateToMillis(this.mAttrsBean.getDisableEndDate()) < CalendarUtil.dateToMillis(date.getSolar())) {
                    solarDay.setTextColor(this.mAttrsBean.getColorLunar());
                    lunarDay.setTextColor(this.mAttrsBean.getColorLunar());
                    view.setTag((Object)-1);
                    this.addView(view, i);
                    continue;
                }
            }
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int day = date.getSolar()[2];
                    CalendarView calendarView = (CalendarView)MonthView.this.getParent();
                    OnSingleChooseListener clickListener = calendarView.getSingleChooseListener();
                    OnMultiChooseListener chooseListener = calendarView.getMultiChooseListener();
                    if (date.getType() == 1) {
                        if (MonthView.this.mAttrsBean.getChooseType() == 1 && chooseListener != null) {
                            boolean flag;
                            if (MonthView.this.chooseDays.contains(day)) {
                                MonthView.this.setDayColor(v, 0);
                                MonthView.this.chooseDays.remove(day);
                                flag = false;
                            } else {
                                MonthView.this.setDayColor(v, 1);
                                MonthView.this.chooseDays.add(day);
                                flag = true;
                            }
                            calendarView.setChooseDate(day, flag, -1);
                            chooseListener.onMultiChoose(v, date, flag);
                        } else {
                            calendarView.setLastClickDay(day);
                            if (MonthView.this.lastClickedView != null) {
                                MonthView.this.setDayColor(MonthView.this.lastClickedView, 0);
                            }
                            MonthView.this.setDayColor(v, 1);
                            MonthView.this.lastClickedView = v;
                            if (clickListener != null) {
                                clickListener.onSingleChoose(v, date);
                            }
                        }
                    } else if (date.getType() == 0) {
                        if (MonthView.this.mAttrsBean.isSwitchChoose()) {
                            calendarView.setLastClickDay(day);
                        }
                        calendarView.lastMonth();
                        if (clickListener != null) {
                            clickListener.onSingleChoose(v, date);
                        }
                    } else if (date.getType() == 2) {
                        if (MonthView.this.mAttrsBean.isSwitchChoose()) {
                            calendarView.setLastClickDay(day);
                        }
                        calendarView.nextMonth();
                        if (clickListener != null) {
                            clickListener.onSingleChoose(v, date);
                        }
                    }
                }
            });
            this.addView(view, i);
        }
        this.requestLayout();
    }

    private void setLunarText(String str, TextView text, int type) {
        text.setText((CharSequence)str);
        if (type == 1) {
            text.setTextColor(this.mAttrsBean.getColorHoliday());
        }
        text.setTag((Object)"holiday");
    }

    private void setDayColor(View v, int type) {
        TextView solarDay = (TextView)v.findViewById(R.id.solar_day);
        TextView lunarDay = (TextView)v.findViewById(R.id.lunar_day);
        solarDay.setTextSize((float)this.mAttrsBean.getSizeSolar());
        lunarDay.setTextSize((float)this.mAttrsBean.getSizeLunar());
        if (type == 0) {
            v.setBackgroundResource(0);
            solarDay.setTextColor(this.mAttrsBean.getColorSolar());
            if ("holiday".equals(lunarDay.getTag())) {
                lunarDay.setTextColor(this.mAttrsBean.getColorHoliday());
            } else {
                lunarDay.setTextColor(this.mAttrsBean.getColorLunar());
            }
        } else if (type == 1) {
            v.setBackgroundResource(this.mAttrsBean.getDayBg());
            solarDay.setTextColor(this.mAttrsBean.getColorChoose());
            lunarDay.setTextColor(this.mAttrsBean.getColorChoose());
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int itemWidth = widthSpecSize / 7;
        if (heightSpecSize > itemWidth * 6) {
            heightSpecSize = itemWidth * 6;
        }
        this.setMeasuredDimension(widthSpecSize, heightSpecSize);
        int itemHeight = heightSpecSize / 6;
        int itemSize = Math.min(itemWidth, itemHeight);
        for (int i = 0; i < this.getChildCount(); ++i) {
            View childView = this.getChildAt(i);
            childView.measure(View.MeasureSpec.makeMeasureSpec((int)itemSize, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)itemSize, (int)0x40000000));
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.getChildCount() == 0) {
            return;
        }
        View childView = this.getChildAt(0);
        int itemWidth = childView.getMeasuredWidth();
        int itemHeight = childView.getMeasuredHeight();
        int dx = (this.getMeasuredWidth() - itemWidth * 7) / 14;
        int dy = 0;
        if (this.getChildCount() == 35) {
            dy = itemHeight / 5;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            int left = i % 7 * itemWidth + (2 * (i % 7) + 1) * dx;
            int top = i / 7 * (itemHeight + dy);
            int right = left + itemWidth;
            int bottom = top + itemHeight;
            view.layout(left, top, right, bottom);
        }
    }

    public void refresh(int day, boolean flag) {
        if (this.lastClickedView != null) {
            this.setDayColor(this.lastClickedView, 0);
        }
        if (!flag) {
            return;
        }
        View destView = this.findDestView(day);
        if (destView == null) {
            return;
        }
        this.setDayColor(destView, 1);
        this.lastClickedView = destView;
        this.invalidate();
    }

    public void multiChooseRefresh(HashSet<Integer> set) {
        for (Integer day : set) {
            this.setDayColor(this.findDestView(day), 1);
            this.chooseDays.add(day);
        }
        this.invalidate();
    }

    private View findDestView(int day) {
        View view = null;
        for (int i = this.lastMonthDays; i < this.getChildCount() - this.nextMonthDays; ++i) {
            if ((Integer)this.getChildAt(i).getTag() != day) continue;
            view = this.getChildAt(i);
            break;
        }
        if (view == null) {
            view = this.getChildAt(this.currentMonthDays + this.lastMonthDays - 1);
        }
        if ((Integer)view.getTag() == -1) {
            view = null;
        }
        return view;
    }

    public void setAttrsBean(AttrsBean attrsBean) {
        this.mAttrsBean = attrsBean;
    }

    public void setOnCalendarViewAdapter(int item_layout, CalendarViewAdapter calendarViewAdapter) {
        this.item_layout = item_layout;
        this.calendarViewAdapter = calendarViewAdapter;
    }
}

