/*
 * Decompiled with CFR 0.152.
 */
package com.othershe.calendarview.weiget;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.View;
import com.othershe.calendarview.R;
import com.othershe.calendarview.bean.AttrsBean;
import com.othershe.calendarview.bean.DateBean;
import com.othershe.calendarview.listener.CalendarViewAdapter;
import com.othershe.calendarview.listener.OnMultiChooseListener;
import com.othershe.calendarview.listener.OnPagerChangeListener;
import com.othershe.calendarview.listener.OnSingleChooseListener;
import com.othershe.calendarview.utils.CalendarUtil;
import com.othershe.calendarview.utils.SolarUtil;
import com.othershe.calendarview.weiget.CalendarPagerAdapter;
import com.othershe.calendarview.weiget.MonthView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CalendarView
extends ViewPager {
    private int currentPosition;
    private OnPagerChangeListener pagerChangeListener;
    private OnSingleChooseListener singleChooseListener;
    private OnMultiChooseListener multiChooseListener;
    private CalendarViewAdapter calendarViewAdapter;
    private int item_layout;
    private int[] initDate;
    private int[] startDate;
    private int[] endDate;
    private int count;
    private int[] lastClickDate = new int[2];
    private SparseArray<HashSet<Integer>> chooseDate;
    private Set<Integer> positions;
    private CalendarPagerAdapter calendarPagerAdapter;
    private AttrsBean mAttrsBean = new AttrsBean();

    public CalendarView(Context context) {
        this(context, null);
    }

    public CalendarView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttr(context, attrs);
    }

    private void initAttr(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.CalendarView);
        for (int i = 0; i < ta.getIndexCount(); ++i) {
            int attr = ta.getIndex(i);
            if (attr == R.styleable.CalendarView_show_last_next) {
                this.mAttrsBean.setShowLastNext(ta.getBoolean(attr, true));
                continue;
            }
            if (attr == R.styleable.CalendarView_show_lunar) {
                this.mAttrsBean.setShowLunar(ta.getBoolean(attr, true));
                continue;
            }
            if (attr == R.styleable.CalendarView_show_holiday) {
                this.mAttrsBean.setShowHoliday(ta.getBoolean(attr, true));
                continue;
            }
            if (attr == R.styleable.CalendarView_show_term) {
                this.mAttrsBean.setShowTerm(ta.getBoolean(attr, true));
                continue;
            }
            if (attr == R.styleable.CalendarView_switch_choose) {
                this.mAttrsBean.setSwitchChoose(ta.getBoolean(attr, true));
                continue;
            }
            if (attr == R.styleable.CalendarView_solar_color) {
                this.mAttrsBean.setColorSolar(ta.getColor(attr, this.mAttrsBean.getColorSolar()));
                continue;
            }
            if (attr == R.styleable.CalendarView_solar_size) {
                this.mAttrsBean.setSizeSolar(CalendarUtil.getTextSize(context, ta.getInteger(attr, this.mAttrsBean.getSizeSolar())));
                continue;
            }
            if (attr == R.styleable.CalendarView_lunar_color) {
                this.mAttrsBean.setColorLunar(ta.getColor(attr, this.mAttrsBean.getColorLunar()));
                continue;
            }
            if (attr == R.styleable.CalendarView_lunar_size) {
                this.mAttrsBean.setSizeLunar(CalendarUtil.getTextSize(context, ta.getInt(attr, this.mAttrsBean.getSizeLunar())));
                continue;
            }
            if (attr == R.styleable.CalendarView_holiday_color) {
                this.mAttrsBean.setColorHoliday(ta.getColor(attr, this.mAttrsBean.getColorHoliday()));
                continue;
            }
            if (attr == R.styleable.CalendarView_choose_color) {
                this.mAttrsBean.setColorChoose(ta.getColor(attr, this.mAttrsBean.getColorChoose()));
                continue;
            }
            if (attr == R.styleable.CalendarView_day_bg) {
                this.mAttrsBean.setDayBg(ta.getResourceId(attr, this.mAttrsBean.getDayBg()));
                continue;
            }
            if (attr != R.styleable.CalendarView_choose_type) continue;
            this.mAttrsBean.setChooseType(ta.getInt(attr, 0));
        }
        ta.recycle();
        this.startDate = new int[]{1900, 1};
        this.endDate = new int[]{2049, 12};
        this.mAttrsBean.setStartDate(this.startDate);
        this.mAttrsBean.setEndDate(this.endDate);
    }

    public void init() {
        int[] singleDate;
        this.count = (this.endDate[0] - this.startDate[0]) * 12 + this.endDate[1] - this.startDate[1] + 1;
        this.calendarPagerAdapter = new CalendarPagerAdapter(this.count);
        this.calendarPagerAdapter.setAttrsBean(this.mAttrsBean);
        this.calendarPagerAdapter.setOnCalendarViewAdapter(this.item_layout, this.calendarViewAdapter);
        this.setAdapter(this.calendarPagerAdapter);
        this.currentPosition = CalendarUtil.dateToPosition(this.initDate[0], this.initDate[1], this.startDate[0], this.startDate[1]);
        if (this.mAttrsBean.getChooseType() == 0 && (singleDate = this.mAttrsBean.getSingleDate()) != null) {
            this.lastClickDate[0] = CalendarUtil.dateToPosition(singleDate[0], singleDate[1], this.startDate[0], this.startDate[1]);
            this.lastClickDate[1] = singleDate[2];
        }
        if (this.mAttrsBean.getChooseType() == 1) {
            this.positions = new HashSet<Integer>();
            this.chooseDate = new SparseArray();
            if (this.mAttrsBean.getMultiDates() != null) {
                for (int[] date : this.mAttrsBean.getMultiDates()) {
                    if (!this.isIllegal(date)) continue;
                    int datePosition = CalendarUtil.dateToPosition(date[0], date[1], this.startDate[0], this.startDate[1]);
                    this.positions.add(datePosition);
                    this.setChooseDate(date[2], true, datePosition);
                }
            }
        }
        this.setCurrentItem(this.currentPosition, false);
        this.addOnPageChangeListener((ViewPager.OnPageChangeListener)new ViewPager.SimpleOnPageChangeListener(){

            public void onPageSelected(int position) {
                CalendarView.this.refreshMonthView(position);
                CalendarView.this.currentPosition = position;
                if (CalendarView.this.pagerChangeListener != null) {
                    int[] date = CalendarUtil.positionToDate(position, CalendarView.this.startDate[0], CalendarView.this.startDate[1]);
                    CalendarView.this.pagerChangeListener.onPagerChanged(new int[]{date[0], date[1], CalendarView.this.lastClickDate[1]});
                }
            }
        });
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        MonthView view;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.getAdapter() != null && (view = (MonthView)this.getChildAt(0)) != null) {
            int calendarHeight = view.getMeasuredHeight();
            this.setMeasuredDimension(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)calendarHeight, (int)0x40000000));
        }
    }

    private void refreshMonthView(int position) {
        MonthView monthView = (MonthView)((Object)this.calendarPagerAdapter.getViews().get(position));
        if (this.mAttrsBean.getChooseType() == 1) {
            if (this.chooseDate.get(position) != null) {
                monthView.multiChooseRefresh((HashSet)this.chooseDate.get(position));
            }
        } else {
            boolean flag = !this.mAttrsBean.isSwitchChoose() && this.lastClickDate[0] == position || this.mAttrsBean.isSwitchChoose();
            monthView.refresh(this.lastClickDate[1], flag);
        }
    }

    public void setLastClickDay(int day) {
        this.lastClickDate[0] = this.currentPosition;
        this.lastClickDate[1] = day;
    }

    public void setChooseDate(int day, boolean flag, int position) {
        if (position == -1) {
            position = this.currentPosition;
        }
        HashSet<Integer> days = (HashSet<Integer>)this.chooseDate.get(position);
        if (flag) {
            if (days == null) {
                days = new HashSet<Integer>();
                this.chooseDate.put(position, days);
            }
            days.add(day);
            this.positions.add(position);
        } else {
            days.remove(day);
        }
    }

    private boolean isIllegal(int[] destDate) {
        if (destDate[1] > 12 || destDate[1] < 1) {
            return false;
        }
        if (CalendarUtil.dateToMillis(destDate) < CalendarUtil.dateToMillis(this.startDate)) {
            return false;
        }
        if (CalendarUtil.dateToMillis(destDate) > CalendarUtil.dateToMillis(this.endDate)) {
            return false;
        }
        if (destDate[2] > SolarUtil.getMonthDays(destDate[0], destDate[1]) || destDate[2] < 1) {
            return false;
        }
        if (this.mAttrsBean.getDisableStartDate() != null && CalendarUtil.dateToMillis(destDate) < CalendarUtil.dateToMillis(this.mAttrsBean.getDisableStartDate())) {
            return false;
        }
        return this.mAttrsBean.getDisableEndDate() == null || CalendarUtil.dateToMillis(destDate) <= CalendarUtil.dateToMillis(this.mAttrsBean.getDisableEndDate());
    }

    public void setOnSingleChooseListener(OnSingleChooseListener singleChooseListener) {
        this.singleChooseListener = singleChooseListener;
    }

    public OnMultiChooseListener getMultiChooseListener() {
        return this.multiChooseListener;
    }

    public void setOnMultiChooseListener(OnMultiChooseListener multiChooseListener) {
        this.multiChooseListener = multiChooseListener;
    }

    public OnSingleChooseListener getSingleChooseListener() {
        return this.singleChooseListener;
    }

    public void setOnPagerChangeListener(OnPagerChangeListener pagerChangeListener) {
        this.pagerChangeListener = pagerChangeListener;
    }

    public CalendarView setOnCalendarViewAdapter(int item_layout, CalendarViewAdapter calendarViewAdapter) {
        this.item_layout = item_layout;
        this.calendarViewAdapter = calendarViewAdapter;
        return this;
    }

    public void today() {
        int destPosition;
        this.lastClickDate[0] = destPosition = CalendarUtil.dateToPosition(CalendarUtil.getCurrentDate()[0], CalendarUtil.getCurrentDate()[1], this.startDate[0], this.startDate[1]);
        this.lastClickDate[1] = CalendarUtil.getCurrentDate()[2];
        if (destPosition == this.currentPosition) {
            this.refreshMonthView(destPosition);
        } else {
            this.setCurrentItem(destPosition, false);
        }
    }

    public boolean toSpecifyDate(int year, int month, int day) {
        if (!this.isIllegal(new int[]{year, month, day})) {
            return false;
        }
        this.toDestDate(year, month, day);
        return true;
    }

    private void toDestDate(int year, int month, int day) {
        int destPosition = CalendarUtil.dateToPosition(year, month, this.startDate[0], this.startDate[1]);
        if (!this.mAttrsBean.isSwitchChoose() && day != 0) {
            this.lastClickDate[0] = destPosition;
        }
        int n = this.lastClickDate[1] = day != 0 ? day : this.lastClickDate[1];
        if (destPosition == this.currentPosition) {
            this.refreshMonthView(destPosition);
        } else {
            this.setCurrentItem(destPosition, false);
        }
    }

    public void nextMonth() {
        if (this.currentPosition < this.count - 1) {
            this.setCurrentItem(++this.currentPosition, false);
        }
    }

    public void lastMonth() {
        if (this.currentPosition > 0) {
            this.setCurrentItem(--this.currentPosition, false);
        }
    }

    public void lastYear() {
        if (this.currentPosition - 12 >= 0) {
            this.setCurrentItem(this.currentPosition -= 12, false);
        }
    }

    public void nextYear() {
        if (this.currentPosition + 12 <= this.count) {
            this.setCurrentItem(this.currentPosition += 12, false);
        }
    }

    public void toStart() {
        this.toDestDate(this.startDate[0], this.startDate[1], 0);
    }

    public void toEnd() {
        this.toDestDate(this.endDate[0], this.endDate[1], 0);
    }

    public CalendarView setSpecifyMap(HashMap<String, String> map) {
        this.mAttrsBean.setSpecifyMap(map);
        return this;
    }

    public CalendarView setInitDate(String date) {
        this.initDate = CalendarUtil.strToArray(date);
        return this;
    }

    public CalendarView setStartEndDate(String startDate, String endDate) {
        this.startDate = CalendarUtil.strToArray(startDate);
        if (startDate == null) {
            this.startDate = new int[]{1900, 1};
        }
        this.endDate = CalendarUtil.strToArray(endDate);
        if (endDate == null) {
            this.endDate = new int[]{2049, 12};
        }
        this.mAttrsBean.setStartDate(this.startDate);
        this.mAttrsBean.setEndDate(this.endDate);
        return this;
    }

    public CalendarView setMultiDate(List<String> dates) {
        ArrayList<int[]> multiDates = new ArrayList<int[]>();
        for (String date : dates) {
            int[] d = CalendarUtil.strToArray(date);
            if (!this.isIllegal(d)) continue;
            multiDates.add(d);
        }
        this.mAttrsBean.setMultiDates(multiDates);
        return this;
    }

    public CalendarView setSingleDate(String date) {
        int[] singleDate = CalendarUtil.strToArray(date);
        if (!this.isIllegal(singleDate)) {
            singleDate = null;
        }
        this.mAttrsBean.setSingleDate(singleDate);
        return this;
    }

    public CalendarView setDisableStartEndDate(String startDate, String endDate) {
        this.mAttrsBean.setDisableStartDate(CalendarUtil.strToArray(startDate));
        this.mAttrsBean.setDisableEndDate(CalendarUtil.strToArray(endDate));
        return this;
    }

    public DateBean getSingleDate() {
        int[] date = CalendarUtil.positionToDate(this.lastClickDate[0], this.startDate[0], this.startDate[1]);
        return CalendarUtil.getDateBean(date[0], date[1], this.lastClickDate[1]);
    }

    public List<DateBean> getMultiDate() {
        ArrayList<DateBean> list = new ArrayList<DateBean>();
        for (Integer position : this.positions) {
            HashSet days = (HashSet)this.chooseDate.get(position.intValue());
            if (days.size() <= 0) continue;
            int[] date = CalendarUtil.positionToDate(position, this.startDate[0], this.startDate[1]);
            for (Integer day : days) {
                list.add(CalendarUtil.getDateBean(date[0], date[1], day));
            }
        }
        return list;
    }
}

