/*
 * Decompiled with CFR 0.152.
 */
package com.othershe.calendarview.weiget;

import android.support.v4.view.PagerAdapter;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import com.othershe.calendarview.bean.AttrsBean;
import com.othershe.calendarview.listener.CalendarViewAdapter;
import com.othershe.calendarview.utils.CalendarUtil;
import com.othershe.calendarview.utils.SolarUtil;
import com.othershe.calendarview.weiget.MonthView;
import java.util.LinkedList;

public class CalendarPagerAdapter
extends PagerAdapter {
    private LinkedList<MonthView> cache = new LinkedList();
    private SparseArray<MonthView> mViews = new SparseArray();
    private int count;
    private int item_layout;
    private CalendarViewAdapter calendarViewAdapter;
    private AttrsBean mAttrsBean;

    public CalendarPagerAdapter(int count) {
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public Object instantiateItem(ViewGroup container, int position) {
        MonthView view = !this.cache.isEmpty() ? this.cache.removeFirst() : new MonthView(container.getContext());
        int[] date = CalendarUtil.positionToDate(position, this.mAttrsBean.getStartDate()[0], this.mAttrsBean.getStartDate()[1]);
        view.setAttrsBean(this.mAttrsBean);
        view.setOnCalendarViewAdapter(this.item_layout, this.calendarViewAdapter);
        view.setDateList(CalendarUtil.getMonthDate(date[0], date[1], this.mAttrsBean.getSpecifyMap()), SolarUtil.getMonthDays(date[0], date[1]));
        this.mViews.put(position, (Object)view);
        container.addView((View)view);
        return view;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)((MonthView)((Object)object)));
        this.cache.addLast((MonthView)((Object)object));
        this.mViews.remove(position);
    }

    public SparseArray<MonthView> getViews() {
        return this.mViews;
    }

    public void setAttrsBean(AttrsBean attrsBean) {
        this.mAttrsBean = attrsBean;
    }

    public void setOnCalendarViewAdapter(int item_layout, CalendarViewAdapter calendarViewAdapter) {
        this.item_layout = item_layout;
        this.calendarViewAdapter = calendarViewAdapter;
    }
}

