/*
 * Decompiled with CFR 0.152.
 */
package com.othershe.calendarview.utils;

import android.text.TextUtils;
import java.util.Calendar;

public class SolarUtil {
    public static String getSolarHoliday(int year, int month, int day) {
        int md = (int)((double)month * Math.pow(10.0, day >= 10 ? 2.0 : 1.0) + (double)day);
        String holiday = "";
        switch (md) {
            case 11: {
                holiday = "\u5143\u65e6";
                break;
            }
            case 214: {
                holiday = "\u60c5\u4eba\u8282";
                break;
            }
            case 38: {
                holiday = "\u5987\u5973\u8282";
                break;
            }
            case 312: {
                holiday = "\u690d\u6811\u8282";
                break;
            }
            case 41: {
                holiday = "\u611a\u4eba\u8282";
                break;
            }
            case 51: {
                holiday = "\u52b3\u52a8\u8282";
                break;
            }
            case 54: {
                holiday = "\u9752\u5e74\u8282";
                break;
            }
            case 512: {
                holiday = "\u62a4\u58eb\u8282";
                break;
            }
            case 61: {
                holiday = "\u513f\u7ae5\u8282";
                break;
            }
            case 71: {
                holiday = "\u5efa\u515a\u8282";
                break;
            }
            case 81: {
                holiday = "\u5efa\u519b\u8282";
                break;
            }
            case 910: {
                holiday = "\u6559\u5e08\u8282";
                break;
            }
            case 101: {
                holiday = "\u56fd\u5e86\u8282";
                break;
            }
            case 1111: {
                holiday = "\u5149\u68cd\u8282";
                break;
            }
            case 1224: {
                holiday = "\u5e73\u5b89\u591c";
                break;
            }
            case 1225: {
                holiday = "\u5723\u8bde\u8282";
            }
        }
        if (!TextUtils.isEmpty((CharSequence)holiday)) {
            return holiday;
        }
        if (month == 4) {
            holiday = SolarUtil.chingMingDay(year, day);
        } else if (month == 5) {
            if (day == SolarUtil.motherFatherDay(year, month, 1)) {
                holiday = "\u6bcd\u4eb2\u8282";
            }
        } else if (month == 6 && day == SolarUtil.motherFatherDay(year, month, 2)) {
            holiday = "\u7236\u4eb2\u8282";
        }
        return holiday;
    }

    private static int motherFatherDay(int year, int month, int delta) {
        int f = SolarUtil.getFirstWeekOfMonth(year, month - 1);
        f = f == 0 ? 7 : f;
        return 7 - f + 1 + 7 * delta;
    }

    public static String chingMingDay(int year, int day) {
        String holiday = "";
        if (day >= 4 && day <= 6) {
            if (year <= 1999) {
                int compare = (int)((double)(year - 1900) * 0.2422 + 5.59 - (double)((year - 1900) / 4));
                if (compare == day) {
                    holiday = "\u6e05\u660e\u8282";
                }
            } else {
                int compare = (int)((double)(year - 2000) * 0.2422 + 4.81 - (double)((year - 2000) / 4));
                if (compare == day) {
                    holiday = "\u6e05\u660e\u8282";
                }
            }
        }
        return holiday;
    }

    public static int getMonthDays(int year, int month) {
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
            case 2: {
                if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
                    return 29;
                }
                return 28;
            }
        }
        return -1;
    }

    public static int getFirstWeekOfMonth(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, 1);
        return calendar.get(7) - 1;
    }
}

