/*
 * Decompiled with CFR 0.152.
 */
package com.othershe.calendarview.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class LunarUtil {
    private static final int[] LUNAR_INFO = new int[]{19416, 19168, 42352, 21717, 53856, 55632, 91476, 22176, 39632, 21970, 19168, 42422, 42192, 53840, 119381, 46400, 54944, 44450, 38320, 84343, 18800, 42160, 46261, 27216, 27968, 109396, 11104, 38256, 21234, 18800, 25958, 54432, 59984, 28309, 23248, 11104, 100067, 37600, 116951, 51536, 54432, 120998, 46416, 22176, 107956, 9680, 37584, 53938, 43344, 46423, 27808, 46416, 86869, 19872, 42448, 83315, 21200, 43432, 59728, 27296, 44710, 43856, 19296, 43748, 42352, 21088, 62051, 55632, 23383, 22176, 38608, 19925, 19152, 42192, 54484, 53840, 54616, 46400, 46496, 103846, 38320, 18864, 43380, 42160, 45690, 27216, 27968, 44870, 43872, 38256, 19189, 18800, 25776, 29859, 59984, 27480, 21952, 43872, 38613, 37600, 51552, 55636, 54432, 55888, 30034, 22176, 43959, 9680, 37584, 51893, 43344, 46240, 47780, 44368, 21977, 19360, 42416, 86390, 21168, 43312, 31060, 27296, 44368, 23378, 19296, 42726, 42208, 53856, 60005, 54576, 23200, 30371, 38608, 19415, 19152, 42192, 118966, 53840, 54560, 56645, 46496, 22224, 21938, 18864, 42359, 42160, 43600, 111189, 27936, 44448};
    private static final int[] solarTermInfo = new int[]{0, 21208, 42467, 63836, 85337, 107014, 128867, 150921, 173149, 195551, 218072, 240693, 263343, 285989, 308563, 331033, 353350, 375494, 397447, 419210, 440795, 462224, 483532, 504758};
    private static final String[] solarTerm = new String[]{"\u5c0f\u5bd2", "\u5927\u5bd2", "\u7acb\u6625", "\u96e8\u6c34", "\u60ca\u86f0", "\u6625\u5206", "\u6e05\u660e", "\u8c37\u96e8", "\u7acb\u590f", "\u5c0f\u6ee1", "\u8292\u79cd", "\u590f\u81f3", "\u5c0f\u6691", "\u5927\u6691", "\u7acb\u79cb", "\u5904\u6691", "\u767d\u9732", "\u79cb\u5206", "\u5bd2\u9732", "\u971c\u964d", "\u7acb\u51ac", "\u5c0f\u96ea", "\u5927\u96ea", "\u51ac\u81f3"};
    private static final String[] monthInfo = new String[]{"", "\u6b63\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u5341\u6708", "\u51ac\u6708", "\u814a\u6708"};
    private static final String[] dayInfo = new String[]{"", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    private static final int MIN_YEAR = 1900;
    private static final int MAX_YEAR = 2049;
    private static final String START_DATE = "19000130";
    private static GregorianCalendar utcCal = null;

    public static String[] solarToLunar(int year, int month, int day) {
        int i;
        int temp = 0;
        boolean leapMonthFlag = false;
        String solarDate = "" + year;
        solarDate = month < 10 ? solarDate + "0" + month : solarDate + month;
        solarDate = day < 10 ? solarDate + "0" + day : solarDate + day;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        Date myDate = null;
        Date startDate = null;
        try {
            myDate = formatter.parse(solarDate);
            startDate = formatter.parse(START_DATE);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        int offset = LunarUtil.daysBetween(startDate, myDate);
        for (i = 1900; i <= 2049 && offset - (temp = LunarUtil.getYearDays(i)) >= 1; ++i) {
            offset -= temp;
        }
        int lunarYear = i;
        int leapMonth = LunarUtil.getLeapMonth(lunarYear);
        boolean isLeapYear = leapMonth > 0;
        for (i = 1; i <= 12; ++i) {
            if (i == leapMonth + 1 && isLeapYear) {
                temp = LunarUtil.getLeapMonthDays(lunarYear);
                isLeapYear = false;
                leapMonthFlag = true;
                --i;
            } else {
                try {
                    temp = LunarUtil.getMonthDays(lunarYear, i);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((offset -= temp) <= 0) break;
        }
        int lunarMonth = i;
        int lunarDay = offset += temp;
        return new String[]{(leapMonthFlag & lunarMonth == leapMonth ? "\u95f0" : "") + LunarUtil.getLunarMonth(lunarMonth), LunarUtil.getLunarDay(lunarDay), LunarUtil.getLunarHoliday(lunarYear, lunarMonth, lunarDay)};
    }

    private static int getMonthDays(int lunarYear, int month) throws Exception {
        if (month > 31 || month < 0) {
            throw new Exception("\u6708\u4efd\u6709\u9519\uff01");
        }
        int bit = 1 << 16 - month;
        if ((LUNAR_INFO[lunarYear - 1900] & 0xFFFF & bit) == 0) {
            return 29;
        }
        return 30;
    }

    private static int daysBetween(Date startDate, Date endDate) {
        int days = 0;
        Calendar can1 = Calendar.getInstance();
        can1.setTime(startDate);
        Calendar can2 = Calendar.getInstance();
        can2.setTime(endDate);
        int year1 = can1.get(1);
        int year2 = can2.get(1);
        Calendar can = null;
        if (can1.before(can2)) {
            days -= can1.get(6);
            days += can2.get(6);
            can = can1;
        } else {
            days -= can2.get(6);
            days += can1.get(6);
            can = can2;
        }
        for (int i = 0; i < Math.abs(year2 - year1); ++i) {
            days += can.getActualMaximum(6);
            can.add(1, 1);
        }
        return days;
    }

    private static int getYearDays(int year) {
        int sum = 348;
        for (int i = 32768; i >= 8; i >>= 1) {
            if ((LUNAR_INFO[year - 1900] & 0xFFF0 & i) == 0) continue;
            ++sum;
        }
        return sum + LunarUtil.getLeapMonthDays(year);
    }

    private static int getLeapMonthDays(int year) {
        if (LunarUtil.getLeapMonth(year) != 0) {
            if ((LUNAR_INFO[year - 1900] & 0xF0000) == 0) {
                return 29;
            }
            return 30;
        }
        return 0;
    }

    private static int getLeapMonth(int year) {
        return LUNAR_INFO[year - 1900] & 0xF;
    }

    private static String getLunarMonth(int month) {
        return monthInfo[month];
    }

    private static String getLunarDay(int day) {
        if (day == 10) {
            return "\u521d\u5341";
        }
        if (day == 20) {
            return "\u4e8c\u5341";
        }
        if (day == 30) {
            return "\u4e09\u5341";
        }
        String str1 = "";
        int d1 = day / 10;
        if (d1 == 0) {
            str1 = "\u521d";
        } else if (d1 == 1) {
            str1 = "\u5341";
        } else if (d1 == 2) {
            str1 = "\u5eff";
        } else if (d1 == 3) {
            str1 = "\u5345";
        }
        return str1 + dayInfo[day % 10];
    }

    private static String getLunarHoliday(int year, int month, int day) {
        String holiday = "";
        if (month == 1 && day == 1) {
            holiday = "\u6625\u8282";
        } else if (month == 1 && day == 15) {
            holiday = "\u5143\u5bb5\u8282";
        } else if (month == 2 && day == 2) {
            holiday = "\u9f99\u62ac\u5934";
        } else if (month == 5 && day == 5) {
            holiday = "\u7aef\u5348\u8282";
        } else if (month == 7 && day == 7) {
            holiday = "\u4e03\u5915";
        } else if (month == 8 && day == 15) {
            holiday = "\u4e2d\u79cb\u8282";
        } else if (month == 9 && day == 9) {
            holiday = "\u91cd\u9633\u8282";
        } else if (month == 12 && day == 8) {
            holiday = "\u814a\u516b";
        } else if (month == 12 && day == 23) {
            holiday = "\u5c0f\u5e74";
        } else if (month == 12 && (LunarUtil.daysInLunarMonth(year, month) == 29 && day == 29 || LunarUtil.daysInLunarMonth(year, month) == 30 && day == 30)) {
            holiday = "\u9664\u5915";
        }
        return holiday;
    }

    public static int daysInLunarMonth(int year, int month) {
        if ((LUNAR_INFO[year - 1900] & 65536 >> month) == 0) {
            return 29;
        }
        return 30;
    }

    public static String getTermString(int solarYear, int solarMonth, int solarDay) {
        String termString = "";
        if (LunarUtil.getSolarTermDay(solarYear, solarMonth * 2) == solarDay) {
            termString = solarTerm[solarMonth * 2];
        } else if (LunarUtil.getSolarTermDay(solarYear, solarMonth * 2 + 1) == solarDay) {
            termString = solarTerm[solarMonth * 2 + 1];
        }
        return termString;
    }

    private static int getSolarTermDay(int solarYear, int index) {
        return LunarUtil.getUTCDay(LunarUtil.getSolarTermCalendar(solarYear, index));
    }

    private static Date getSolarTermCalendar(int solarYear, int index) {
        long l = 31556925974L * (long)(solarYear - 1900) + (long)solarTermInfo[index] * 60000L;
        return new Date(l += LunarUtil.UTC(1900, 0, 6, 2, 5, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized int getUTCDay(Date date) {
        LunarUtil.makeUTCCalendar();
        GregorianCalendar gregorianCalendar = utcCal;
        synchronized (gregorianCalendar) {
            utcCal.clear();
            utcCal.setTimeInMillis(date.getTime());
            return utcCal.get(5);
        }
    }

    private static void makeUTCCalendar() {
        if (utcCal == null) {
            utcCal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized long UTC(int y, int m, int d, int h, int min, int sec) {
        LunarUtil.makeUTCCalendar();
        GregorianCalendar gregorianCalendar = utcCal;
        synchronized (gregorianCalendar) {
            utcCal.clear();
            utcCal.set(y, m, d, h, min, sec);
            return utcCal.getTimeInMillis();
        }
    }
}

